/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.server;

import java.net.InetSocketAddress;
import org.spark_project.jetty.http.HttpFields;
import org.spark_project.jetty.http.HttpHeader;
import org.spark_project.jetty.http.HttpScheme;
import org.spark_project.jetty.server.Connector;
import org.spark_project.jetty.server.HttpConfiguration;
import org.spark_project.jetty.server.Request;

public class ForwardedRequestCustomizer
implements HttpConfiguration.Customizer {
    private String _hostHeader;
    private String _forwardedHostHeader = HttpHeader.X_FORWARDED_HOST.toString();
    private String _forwardedServerHeader = HttpHeader.X_FORWARDED_SERVER.toString();
    private String _forwardedForHeader = HttpHeader.X_FORWARDED_FOR.toString();
    private String _forwardedProtoHeader = HttpHeader.X_FORWARDED_PROTO.toString();
    private String _forwardedCipherSuiteHeader;
    private String _forwardedSslSessionIdHeader;

    public String getHostHeader() {
        return this._hostHeader;
    }

    public void setHostHeader(String hostHeader) {
        this._hostHeader = hostHeader;
    }

    public String getForwardedHostHeader() {
        return this._forwardedHostHeader;
    }

    public void setForwardedHostHeader(String forwardedHostHeader) {
        this._forwardedHostHeader = forwardedHostHeader;
    }

    public String getForwardedServerHeader() {
        return this._forwardedServerHeader;
    }

    public void setForwardedServerHeader(String forwardedServerHeader) {
        this._forwardedServerHeader = forwardedServerHeader;
    }

    public String getForwardedForHeader() {
        return this._forwardedForHeader;
    }

    public void setForwardedForHeader(String forwardedRemoteAddressHeader) {
        this._forwardedForHeader = forwardedRemoteAddressHeader;
    }

    public String getForwardedProtoHeader() {
        return this._forwardedProtoHeader;
    }

    public void setForwardedProtoHeader(String forwardedProtoHeader) {
        this._forwardedProtoHeader = forwardedProtoHeader;
    }

    public String getForwardedCipherSuiteHeader() {
        return this._forwardedCipherSuiteHeader;
    }

    public void setForwardedCipherSuiteHeader(String forwardedCipherSuite) {
        this._forwardedCipherSuiteHeader = forwardedCipherSuite;
    }

    public String getForwardedSslSessionIdHeader() {
        return this._forwardedSslSessionIdHeader;
    }

    public void setForwardedSslSessionIdHeader(String forwardedSslSessionId) {
        this._forwardedSslSessionIdHeader = forwardedSslSessionId;
    }

    @Override
    public void customize(Connector connector, HttpConfiguration config, Request request) {
        String ssl_session_id;
        String cipher_suite;
        HttpFields httpFields = request.getHttpFields();
        if (this.getForwardedCipherSuiteHeader() != null && (cipher_suite = httpFields.getStringField(this.getForwardedCipherSuiteHeader())) != null) {
            request.setAttribute("javax.servlet.request.cipher_suite", cipher_suite);
        }
        if (this.getForwardedSslSessionIdHeader() != null && (ssl_session_id = httpFields.getStringField(this.getForwardedSslSessionIdHeader())) != null) {
            request.setAttribute("javax.servlet.request.ssl_session_id", ssl_session_id);
            request.setScheme(HttpScheme.HTTPS.asString());
        }
        String forwardedHost = this.getLeftMostFieldValue(httpFields, this.getForwardedHostHeader());
        String forwardedServer = this.getLeftMostFieldValue(httpFields, this.getForwardedServerHeader());
        String forwardedFor = this.getLeftMostFieldValue(httpFields, this.getForwardedForHeader());
        String forwardedProto = this.getLeftMostFieldValue(httpFields, this.getForwardedProtoHeader());
        if (this._hostHeader != null) {
            httpFields.put(HttpHeader.HOST.toString(), this._hostHeader);
            request.setServerName(null);
            request.setServerPort(-1);
            request.getServerName();
        } else if (forwardedHost != null) {
            httpFields.put(HttpHeader.HOST.toString(), forwardedHost);
            request.setServerName(null);
            request.setServerPort(-1);
            request.getServerName();
        } else if (forwardedServer != null) {
            request.setServerName(forwardedServer);
        }
        if (forwardedFor != null) {
            request.setRemoteAddr(InetSocketAddress.createUnresolved(forwardedFor, request.getRemotePort()));
        }
        if (forwardedProto != null) {
            request.setScheme(forwardedProto);
            if (forwardedProto.equals(config.getSecureScheme())) {
                request.setSecure(true);
            }
        }
    }

    protected String getLeftMostFieldValue(HttpFields fields, String header) {
        if (header == null) {
            return null;
        }
        String headerValue = fields.getStringField(header);
        if (headerValue == null) {
            return null;
        }
        int commaIndex = headerValue.indexOf(44);
        if (commaIndex == -1) {
            return headerValue;
        }
        return headerValue.substring(0, commaIndex);
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

