/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingle;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupValue;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;

public class ColGroupSDCZeros
extends ColGroupValue {
    private static final long serialVersionUID = -32143916423465004L;
    protected AOffset _indexes;
    protected AMapToData _data;

    protected ColGroupSDCZeros(int numRows) {
        super(numRows);
    }

    protected ColGroupSDCZeros(int[] colIndices, int numRows, ADictionary dict, int[] indexes, AMapToData data, int[] cachedCounts) {
        super(colIndices, numRows, dict, cachedCounts);
        this._indexes = OffsetFactory.create(indexes, numRows);
        this._data = data;
        this._zeros = true;
    }

    protected ColGroupSDCZeros(int[] colIndices, int numRows, ADictionary dict, AOffset offsets, AMapToData data, int[] cachedCounts) {
        super(colIndices, numRows, dict, cachedCounts);
        this._indexes = offsets;
        this._data = data;
        this._zeros = true;
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.SDC;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.SDCZeros;
    }

    @Override
    protected void decompressToBlockUnSafeDenseDictionary(MatrixBlock target, int rl, int ru, int offT, double[] values) {
        int nCol = this._colIndexes.length;
        int tCol = target.getNumColumns();
        int offTCorrected = offT - rl;
        double[] c = target.getDenseBlockValues();
        AIterator it = this._indexes.getIterator(rl);
        offT *= tCol;
        while (it.hasNext() && it.value() < ru) {
            int rc = (offTCorrected + it.value()) * tCol;
            int offC = this.getIndex(it.getDataIndexAndIncrement()) * nCol;
            for (int j = 0; j < nCol; ++j) {
                int n = rc + this._colIndexes[j];
                c[n] = c[n] + values[offC + j];
            }
        }
    }

    @Override
    protected void decompressToBlockUnSafeSparseDictionary(MatrixBlock target, int rl, int ru, int offT, SparseBlock sb) {
        int tCol = target.getNumColumns();
        int offTCorrected = offT - rl;
        double[] c = target.getDenseBlockValues();
        AIterator it = this._indexes.getIterator(rl);
        while (it.hasNext() && it.value() < ru) {
            int rc = (offTCorrected + it.value()) * tCol;
            int dictIndex = this.getIndex(it.getDataIndexAndIncrement());
            if (sb.isEmpty(dictIndex)) continue;
            int apos = sb.pos(dictIndex);
            int alen = sb.size(dictIndex) + apos;
            double[] avals = sb.values(dictIndex);
            int[] aix = sb.indexes(dictIndex);
            for (int j = apos; j < alen; ++j) {
                int n = rc + this._colIndexes[aix[j]];
                c[n] = c[n] + avals[j];
            }
        }
    }

    @Override
    public double get(int r, int c) {
        int ix = Arrays.binarySearch(this._colIndexes, c);
        if (ix < 0) {
            throw new RuntimeException("Column index " + c + " not in group.");
        }
        AIterator it = this._indexes.getIterator(r);
        if (it.value() == r) {
            return this._dict.getValue(this.getIndex(it.getDataIndex()) * this._colIndexes.length + ix);
        }
        return 0.0;
    }

    @Override
    public void countNonZerosPerRow(int[] rnnz, int rl, int ru) {
        int nCol = this._colIndexes.length;
        AIterator it = this._indexes.getIterator(rl);
        while (it.hasNext() && it.value() < ru) {
            int n = it.value() - rl;
            rnnz[n] = rnnz[n] + nCol;
            it.next();
        }
    }

    @Override
    protected void computeRowSums(double[] c, boolean square, int rl, int ru) {
        double[] vals = this._dict.sumAllRowsToDouble(square, this._colIndexes.length);
        AIterator it = this._indexes.getIterator(rl);
        while (it.hasNext() && it.value() < ru) {
            int n = it.value();
            c[n] = c[n] + vals[this.getIndex(it.getDataIndexAndIncrement())];
        }
    }

    @Override
    protected void computeRowMxx(double[] c, Builtin builtin, int rl, int ru) {
        int rix;
        double[] vals = this._dict.aggregateTuples(builtin, this._colIndexes.length);
        AIterator it = this._indexes.getIterator(rl);
        for (rix = rl; rix < ru && it.hasNext(); ++rix) {
            c[rix] = it.value() != rix ? builtin.execute(c[rix], 0.0) : builtin.execute(c[rix], vals[this._data.getIndex(it.getDataIndexAndIncrement())]);
        }
        while (rix < ru) {
            c[rix] = builtin.execute(c[rix], 0.0);
            ++rix;
        }
    }

    @Override
    public int[] getCounts(int[] counts) {
        return this.getCounts(0, this._numRows, counts);
    }

    @Override
    public int[] getCounts(int rl, int ru, int[] counts) {
        int i = rl;
        AIterator it = this._indexes.getIterator(rl);
        int zeros = 0;
        while (it.hasNext() && it.value() < ru) {
            int oldI = i;
            i = it.value();
            zeros += i - oldI - 1;
            int n = this._data.getIndex(it.getDataIndexAndIncrement());
            counts[n] = counts[n] + 1;
        }
        int n = counts.length - 1;
        counts[n] = counts[n] + (zeros + ru - i);
        return counts;
    }

    public int getIndex(int r) {
        return this._data.getIndex(r);
    }

    @Override
    protected void preAggregate(MatrixBlock m, MatrixBlock preAgg, int rl, int ru) {
        if (m.isInSparseFormat()) {
            this.preAggregateSparse(m.getSparseBlock(), preAgg, rl, ru);
        } else {
            this.preAggregateDense(m, preAgg, rl, ru);
        }
    }

    private void preAggregateDense(MatrixBlock m, MatrixBlock preAgg, int rl, int ru) {
        double[] preAV = preAgg.getDenseBlockValues();
        double[] mV = m.getDenseBlockValues();
        int numVals = this.getNumValues();
        int rowLeft = rl;
        int offOut = 0;
        while (rowLeft < ru) {
            AIterator it = this._indexes.getIterator();
            int offLeft = rowLeft * this._numRows;
            while (it.hasNext()) {
                int i = it.value();
                int n = offOut + this.getIndex(it.getDataIndexAndIncrement());
                preAV[n] = preAV[n] + mV[offLeft + i];
            }
            ++rowLeft;
            offOut += numVals;
        }
    }

    private void preAggregateSparse(SparseBlock sb, MatrixBlock preAgg, int rl, int ru) {
        double[] preAV = preAgg.getDenseBlockValues();
        int numVals = this.getNumValues();
        int rowLeft = rl;
        int offOut = 0;
        while (rowLeft < ru) {
            if (!sb.isEmpty(rowLeft)) {
                AIterator it = this._indexes.getIterator();
                int apos = sb.pos(rowLeft);
                int alen = sb.size(rowLeft) + apos;
                int[] aix = sb.indexes(rowLeft);
                double[] avals = sb.values(rowLeft);
                int j = apos;
                while (it.hasNext() && j < alen) {
                    int index = aix[j];
                    int val = it.value();
                    if (index < val) {
                        ++j;
                        continue;
                    }
                    if (index == val) {
                        int n = offOut + this._data.getIndex(it.getDataIndexAndIncrement());
                        preAV[n] = preAV[n] + avals[j++];
                        continue;
                    }
                    it.next();
                }
            }
            ++rowLeft;
            offOut += numVals;
        }
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        size += this._indexes.getInMemorySize();
        return size += this._data.getInMemorySize();
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        boolean isSparseSafeOp;
        double val0 = op.executeScalar(0.0);
        boolean bl = isSparseSafeOp = op.sparseSafe || val0 == 0.0;
        if (isSparseSafeOp) {
            return new ColGroupSDCZeros(this._colIndexes, this._numRows, this.applyScalarOp(op), this._indexes, this._data, this.getCachedCounts());
        }
        ADictionary rValues = this.applyScalarOp(op, val0, this.getNumCols());
        return new ColGroupSDC(this._colIndexes, this._numRows, rValues, this._indexes, this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup binaryRowOp(BinaryOperator op, double[] v, boolean sparseSafe, boolean left) {
        if (sparseSafe) {
            return new ColGroupSDCZeros(this._colIndexes, this._numRows, this.applyBinaryRowOp(op, v, sparseSafe, left), this._indexes, this._data, this.getCachedCounts());
        }
        return new ColGroupSDC(this._colIndexes, this._numRows, this.applyBinaryRowOp(op, v, sparseSafe, left), this._indexes, this._data, this.getCachedCounts());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this._indexes.write(out);
        this._data.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this._indexes = OffsetFactory.readIn(in);
        this._data = MapToFactory.readIn(in);
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = super.getExactSizeOnDisk();
        ret += this._indexes.getExactSizeOnDisk();
        return ret += this._data.getInMemorySize();
    }

    @Override
    public boolean sameIndexStructure(ColGroupCompressed that) {
        return that instanceof ColGroupSDCZeros && ((ColGroupSDCZeros)that)._indexes == this._indexes && ((ColGroupSDCZeros)that)._data == this._data;
    }

    @Override
    public int getIndexStructureHash() {
        return this._indexes.hashCode() + this._data.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%15s ", "Indexes: "));
        sb.append(this._indexes.toString());
        sb.append(String.format("\n%15s ", "Data: "));
        sb.append(this._data);
        return sb.toString();
    }

    @Override
    public Dictionary preAggregateThatDDCStructure(ColGroupDDC that, Dictionary ret) {
        AIterator itThis = this._indexes.getIterator();
        int nCol = that._colIndexes.length;
        while (itThis.hasNext()) {
            int fr = that._data.getIndex(itThis.value());
            int to = this.getIndex(itThis.getDataIndexAndIncrement());
            that._dict.addToEntry(ret, fr, to, nCol);
        }
        return ret;
    }

    @Override
    public Dictionary preAggregateThatSDCStructure(ColGroupSDC that, Dictionary ret, boolean preModified) {
        throw new NotImplementedException();
    }

    @Override
    public Dictionary preAggregateThatSDCZerosStructure(ColGroupSDCZeros that, Dictionary ret) {
        AIterator itThat = that._indexes.getIterator();
        AIterator itThis = this._indexes.getIterator();
        int nCol = that._colIndexes.length;
        while (itThat.hasNext() && itThis.hasNext()) {
            if (itThat.value() == itThis.value()) {
                int fr = that.getIndex(itThat.getDataIndexAndIncrement());
                int to = this.getIndex(itThis.getDataIndexAndIncrement());
                that._dict.addToEntry(ret, fr, to, nCol);
                continue;
            }
            if (itThat.value() < itThis.value()) {
                itThat.next();
                continue;
            }
            itThis.next();
        }
        return ret;
    }

    @Override
    public Dictionary preAggregateThatSDCSingleZerosStructure(ColGroupSDCSingleZeros that, Dictionary ret) {
        AIterator itThat = that._indexes.getIterator();
        AIterator itThis = this._indexes.getIterator();
        int nCol = that._colIndexes.length;
        while (itThat.hasNext() && itThis.hasNext()) {
            if (itThat.value() == itThis.value()) {
                int to = this.getIndex(itThis.getDataIndexAndIncrement());
                that._dict.addToEntry(ret, 0, to, nCol);
                itThat.next();
                continue;
            }
            if (itThat.value() < itThis.value()) {
                itThat.next();
                continue;
            }
            itThis.next();
        }
        return ret;
    }

    @Override
    public Dictionary preAggregateThatSDCSingleStructure(ColGroupSDCSingle that, Dictionary re, boolean preModified) {
        throw new NotImplementedException();
    }
}

