/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.timeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;

@XmlRootElement(name="entity")
@XmlAccessorType(value=XmlAccessType.NONE)
@InterfaceAudience.Public
@InterfaceStability.Unstable
public class TimelineEntity
implements Comparable<TimelineEntity> {
    private String entityType;
    private String entityId;
    private Long startTime;
    private List<TimelineEvent> events = new ArrayList<TimelineEvent>();
    private HashMap<String, Set<String>> relatedEntities = new HashMap();
    private HashMap<String, Set<Object>> primaryFilters = new HashMap();
    private HashMap<String, Object> otherInfo = new HashMap();
    private String domainId;

    @XmlElement(name="entitytype")
    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    @XmlElement(name="entity")
    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @XmlElement(name="starttime")
    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    @XmlElement(name="events")
    public List<TimelineEvent> getEvents() {
        return this.events;
    }

    public void addEvent(TimelineEvent event) {
        this.events.add(event);
    }

    public void addEvents(List<TimelineEvent> events) {
        this.events.addAll(events);
    }

    public void setEvents(List<TimelineEvent> events) {
        this.events = events;
    }

    public Map<String, Set<String>> getRelatedEntities() {
        return this.relatedEntities;
    }

    @InterfaceAudience.Private
    @XmlElement(name="relatedentities")
    public HashMap<String, Set<String>> getRelatedEntitiesJAXB() {
        return this.relatedEntities;
    }

    public void addRelatedEntity(String entityType, String entityId) {
        Set<String> thisRelatedEntity = this.relatedEntities.get(entityType);
        if (thisRelatedEntity == null) {
            thisRelatedEntity = new HashSet<String>();
            this.relatedEntities.put(entityType, thisRelatedEntity);
        }
        thisRelatedEntity.add(entityId);
    }

    public void addRelatedEntities(Map<String, Set<String>> relatedEntities) {
        for (Map.Entry<String, Set<String>> relatedEntity : relatedEntities.entrySet()) {
            Set<String> thisRelatedEntity = this.relatedEntities.get(relatedEntity.getKey());
            if (thisRelatedEntity == null) {
                this.relatedEntities.put(relatedEntity.getKey(), relatedEntity.getValue());
                continue;
            }
            thisRelatedEntity.addAll((Collection<String>)relatedEntity.getValue());
        }
    }

    public void setRelatedEntities(Map<String, Set<String>> relatedEntities) {
        this.relatedEntities = relatedEntities != null && !(relatedEntities instanceof HashMap) ? new HashMap<String, Set<String>>(relatedEntities) : (HashMap)relatedEntities;
    }

    public Map<String, Set<Object>> getPrimaryFilters() {
        return this.primaryFilters;
    }

    @InterfaceAudience.Private
    @XmlElement(name="primaryfilters")
    public HashMap<String, Set<Object>> getPrimaryFiltersJAXB() {
        return this.primaryFilters;
    }

    public void addPrimaryFilter(String key, Object value) {
        Set<Object> thisPrimaryFilter = this.primaryFilters.get(key);
        if (thisPrimaryFilter == null) {
            thisPrimaryFilter = new HashSet<Object>();
            this.primaryFilters.put(key, thisPrimaryFilter);
        }
        thisPrimaryFilter.add(value);
    }

    public void addPrimaryFilters(Map<String, Set<Object>> primaryFilters) {
        for (Map.Entry<String, Set<Object>> primaryFilter : primaryFilters.entrySet()) {
            Set<Object> thisPrimaryFilter = this.primaryFilters.get(primaryFilter.getKey());
            if (thisPrimaryFilter == null) {
                this.primaryFilters.put(primaryFilter.getKey(), primaryFilter.getValue());
                continue;
            }
            thisPrimaryFilter.addAll((Collection<Object>)primaryFilter.getValue());
        }
    }

    public void setPrimaryFilters(Map<String, Set<Object>> primaryFilters) {
        this.primaryFilters = primaryFilters != null && !(primaryFilters instanceof HashMap) ? new HashMap<String, Set<Object>>(primaryFilters) : (HashMap)primaryFilters;
    }

    public Map<String, Object> getOtherInfo() {
        return this.otherInfo;
    }

    @InterfaceAudience.Private
    @XmlElement(name="otherinfo")
    public HashMap<String, Object> getOtherInfoJAXB() {
        return this.otherInfo;
    }

    public void addOtherInfo(String key, Object value) {
        this.otherInfo.put(key, value);
    }

    public void addOtherInfo(Map<String, Object> otherInfo) {
        this.otherInfo.putAll(otherInfo);
    }

    public void setOtherInfo(Map<String, Object> otherInfo) {
        this.otherInfo = otherInfo != null && !(otherInfo instanceof HashMap) ? new HashMap<String, Object>(otherInfo) : (HashMap)otherInfo;
    }

    @XmlElement(name="domain")
    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entityId == null ? 0 : this.entityId.hashCode());
        result = 31 * result + (this.entityType == null ? 0 : this.entityType.hashCode());
        result = 31 * result + (this.events == null ? 0 : ((Object)this.events).hashCode());
        result = 31 * result + (this.otherInfo == null ? 0 : this.otherInfo.hashCode());
        result = 31 * result + (this.primaryFilters == null ? 0 : this.primaryFilters.hashCode());
        result = 31 * result + (this.relatedEntities == null ? 0 : this.relatedEntities.hashCode());
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimelineEntity other = (TimelineEntity)obj;
        if (this.entityId == null ? other.entityId != null : !this.entityId.equals(other.entityId)) {
            return false;
        }
        if (this.entityType == null ? other.entityType != null : !this.entityType.equals(other.entityType)) {
            return false;
        }
        if (this.events == null ? other.events != null : !((Object)this.events).equals(other.events)) {
            return false;
        }
        if (this.otherInfo == null ? other.otherInfo != null : !this.otherInfo.equals(other.otherInfo)) {
            return false;
        }
        if (this.primaryFilters == null ? other.primaryFilters != null : !this.primaryFilters.equals(other.primaryFilters)) {
            return false;
        }
        if (this.relatedEntities == null ? other.relatedEntities != null : !this.relatedEntities.equals(other.relatedEntities)) {
            return false;
        }
        return !(this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime));
    }

    @Override
    public int compareTo(TimelineEntity other) {
        int comparison = this.entityType.compareTo(other.entityType);
        if (comparison == 0) {
            long otherStartTime;
            long thisStartTime = this.startTime == null ? Long.MIN_VALUE : this.startTime;
            long l = otherStartTime = other.startTime == null ? Long.MIN_VALUE : other.startTime;
            if (thisStartTime > otherStartTime) {
                return -1;
            }
            if (thisStartTime < otherStartTime) {
                return 1;
            }
            return this.entityId.compareTo(other.entityId);
        }
        return comparison;
    }
}

