/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark.data;

import java.lang.ref.SoftReference;
import org.apache.spark.broadcast.Broadcast;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.instructions.spark.data.LineageObject;
import org.apache.sysds.runtime.instructions.spark.data.PartitionedBlock;
import org.apache.sysds.runtime.instructions.spark.data.PartitionedBroadcast;

public class BroadcastObject<T extends CacheBlock>
extends LineageObject {
    private SoftReference<PartitionedBroadcast<T>> _pbcRef;
    private SoftReference<Broadcast<T>> _npbcRef;
    private long _pbcSize;
    private long _npbcSize;

    public void setNonPartitionedBroadcast(Broadcast<T> bvar, long size) {
        this._npbcRef = new SoftReference<Broadcast<Broadcast<T>>>(bvar);
        this._npbcSize = size;
        this._pbcSize = -1L;
    }

    public void setPartitionedBroadcast(PartitionedBroadcast<T> bvar, long size) {
        this._pbcRef = new SoftReference<PartitionedBroadcast<PartitionedBroadcast<T>>>(bvar);
        this._pbcSize = size;
        this._npbcSize = -1L;
    }

    public PartitionedBroadcast getPartitionedBroadcast() {
        return this._pbcRef.get();
    }

    public Broadcast<T> getNonPartitionedBroadcast() {
        return this._npbcRef.get();
    }

    public long getSize() {
        return Math.max(this._pbcSize, this._npbcSize);
    }

    public boolean isPartitionedBroadcastValid() {
        return this._pbcRef != null && this.checkPartitionedBroadcastValid();
    }

    public boolean isNonPartitionedBroadcastValid() {
        return this._npbcRef != null && this.checkNonPartitionedBroadcastValid();
    }

    private boolean checkNonPartitionedBroadcastValid() {
        return this._npbcRef.get() != null;
    }

    private boolean checkPartitionedBroadcastValid() {
        Broadcast<PartitionedBlock<T>>[] tmp;
        PartitionedBroadcast<T> pbm = this._pbcRef.get();
        if (pbm == null) {
            return false;
        }
        for (Broadcast<PartitionedBlock<T>> bc : tmp = pbm.getBroadcasts()) {
            if (bc.isValid()) continue;
            return false;
        }
        return true;
    }
}

