/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class QuantileSortCPInstruction
extends UnaryCPInstruction {
    int _numThreads;

    private QuantileSortCPInstruction(CPOperand in, CPOperand out, String opcode, String istr, int k) {
        this(in, null, out, opcode, istr, k);
    }

    private QuantileSortCPInstruction(CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr, int k) {
        super(CPInstruction.CPType.QSort, null, in1, in2, out, opcode, istr);
        this._numThreads = k;
    }

    private static void parseInstruction(String instr, CPOperand in1, CPOperand in2, CPOperand out) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(instr);
        out.split(parts[parts.length - 2]);
        switch (parts.length) {
            case 4: {
                in1.split(parts[1]);
                in2 = null;
                break;
            }
            case 5: {
                in1.split(parts[1]);
                in2.split(parts[2]);
                break;
            }
            default: {
                throw new DMLRuntimeException("Unexpected number of operands in the instruction: " + instr);
            }
        }
    }

    public static QuantileSortCPInstruction parseInstruction(String str) {
        CPOperand in1 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        CPOperand in2 = null;
        CPOperand out = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("qsort")) {
            int k = Integer.parseInt(parts[parts.length - 1]);
            if (parts.length == 4) {
                InstructionUtils.checkNumFields(str, 3);
                QuantileSortCPInstruction.parseInstruction(str, in1, null, out);
                return new QuantileSortCPInstruction(in1, out, opcode, str, k);
            }
            if (parts.length == 5) {
                InstructionUtils.checkNumFields(str, 4);
                in2 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
                QuantileSortCPInstruction.parseInstruction(str, in1, in2, out);
                return new QuantileSortCPInstruction(in1, in2, out, opcode, str, k);
            }
            throw new DMLRuntimeException("Invalid number of operands in instruction: " + str);
        }
        throw new DMLRuntimeException("Unknown opcode while parsing a QuantileSortCPInstruction: " + str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixBlock matBlock = ec.getMatrixInput(this.input1.getName());
        MatrixBlock wtBlock = null;
        if (this.input2 != null) {
            wtBlock = ec.getMatrixInput(this.input2.getName());
        }
        MatrixBlock resultBlock = matBlock.sortOperations(wtBlock, new MatrixBlock(), this._numThreads);
        ec.releaseMatrixInput(this.input1.getName());
        if (this.input2 != null) {
            ec.releaseMatrixInput(this.input2.getName());
        }
        ec.setMatrixOutput(this.output.getName(), resultBlock);
    }

    public int getNumThreads() {
        return this._numThreads;
    }
}

