/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen.codegen;

import org.apache.sysds.runtime.iogen.ColIndexStructure;
import org.apache.sysds.runtime.iogen.CustomProperties;
import org.apache.sysds.runtime.iogen.FormatIdentifyer;
import org.apache.sysds.runtime.iogen.RowIndexStructure;
import org.apache.sysds.runtime.iogen.codegen.CodeGenTrie;
import org.apache.sysds.runtime.iogen.template.TemplateCodeGenBase;

public class MatrixCodeGen
extends TemplateCodeGenBase {
    public MatrixCodeGen(CustomProperties properties, String className) {
        super(properties, className);
        String javaBaseClass = !properties.isParallel() ? "MatrixGenerateReader" : "MatrixGenerateReaderParallel";
        this.javaTemplate = "import org.apache.hadoop.io.LongWritable;\nimport org.apache.hadoop.io.Text;\nimport org.apache.hadoop.mapred.RecordReader;\nimport org.apache.sysds.runtime.iogen.CustomProperties;\nimport org.apache.sysds.runtime.iogen.template." + javaBaseClass + ";\nimport org.apache.sysds.runtime.matrix.data.MatrixBlock;\nimport java.io.IOException;\nimport java.util.HashSet;\nimport org.apache.sysds.runtime.io.IOUtilFunctions; \nimport org.apache.sysds.runtime.util.UtilFunctions; \nimport org.apache.commons.lang3.mutable.MutableInt; \nimport org.apache.sysds.runtime.iogen.template.TemplateUtil; \npublic class " + className + " extends " + javaBaseClass + " {\npublic " + className + "(CustomProperties _props) {\nsuper(_props);} \n@Override \nprotected long readMatrixFromHDFS(RecordReader<LongWritable, Text> reader, LongWritable key, Text value, MatrixBlock dest, MutableInt rowPos, TemplateUtil.SplitInfo splitInfo) throws IOException {\n" + this.code + "}} \n";
    }

    @Override
    public String generateCodeJava(FormatIdentifyer formatIdentifyer) {
        StringBuilder src = new StringBuilder();
        CodeGenTrie trie = new CodeGenTrie(this.properties, "dest.appendValue", true, formatIdentifyer);
        src.append("String str=\"\"; \n");
        src.append("String remainStr = \"\"; \n");
        src.append("int col = -1; \n");
        src.append("String[] parts; \n");
        src.append("int row = rowPos.intValue(); \n");
        src.append("long lnnz = 0; \n");
        src.append("int index, endPos, strLen; \n");
        boolean flag1 = false;
        boolean flag2 = false;
        if (this.properties.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.RowWiseExist || this.properties.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.CellWiseExist) {
            src.append("HashSet<String> endWithValueStringRow = _props.getRowIndexStructure().endWithValueStrings(); \n");
            flag1 = true;
        }
        if (this.properties.getColIndexStructure().getProperties() == ColIndexStructure.IndexProperties.CellWiseExist) {
            src.append("HashSet<String> endWithValueStringCol = _props.getColIndexStructure().endWithValueStrings(); \n");
            flag2 = true;
        }
        if (flag1 && flag2) {
            src.append("HashSet<String> endWithValueStringVal = _props.endWithValueStrings()[0]; \n");
        } else {
            src.append("HashSet<String>[] endWithValueString = _props.endWithValueStrings(); \n");
        }
        src.append("try { \n");
        if (this.properties.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.SeqScatter) {
            src.append("int ri = -1; \n");
            src.append("int beginPosStr, endPosStr; \n");
            src.append("StringBuilder sb = new StringBuilder(); \n");
            src.append("long beginIndex = splitInfo.getRecordIndexBegin(0); \n");
            src.append("long endIndex = splitInfo.getRecordIndexEnd(0); \n");
            src.append("boolean flag = true; \n");
            src.append("while(flag || sb.length() > 0) { \n");
            src.append("flag = reader.next(key, value); \n");
            src.append("if(flag) { \n");
            src.append("ri++; \n");
            src.append("String valStr = value.toString(); \n");
            src.append("beginPosStr = ri == beginIndex ? splitInfo.getRecordPositionBegin(row) : 0; \n");
            src.append("endPosStr = ri == endIndex ? splitInfo.getRecordPositionEnd(row): valStr.length(); \n");
            src.append("if(ri >= beginIndex && ri <= endIndex){ \n");
            src.append("sb.append(valStr.substring(beginPosStr, endPosStr)); \n");
            src.append("remainStr = valStr.substring(endPosStr); \n");
            src.append("continue; \n");
            src.append("} \n");
            src.append("else { \n");
            src.append("str = sb.toString(); \n");
            src.append("sb = new StringBuilder(); \n");
            src.append("sb.append(remainStr).append(valStr); \n");
            src.append("beginIndex = splitInfo.getRecordIndexBegin(row+1); \n");
            src.append("endIndex = splitInfo.getRecordIndexEnd(row+1); \n");
            src.append("} \n");
            src.append("} \n");
            src.append("else {\n");
            src.append("str = sb.toString(); \n");
            src.append("sb = new StringBuilder();\n");
            src.append("}");
        } else {
            src.append("while(reader.next(key, value)) { \n");
            src.append("str = value.toString(); \n");
        }
        src.append("strLen = str.length(); \n");
        src.append(trie.getJavaCode());
        src.append("} \n");
        src.append("} \n");
        src.append("catch(Exception ex){ \n");
        src.append("} \n");
        src.append("rowPos.setValue(row); \n");
        src.append("return lnnz; \n");
        return this.javaTemplate.replace(this.code, src.toString());
    }

    @Override
    public String generateCodeCPP() {
        return null;
    }
}

