/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jcuda.Pointer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.InstructionType;
import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.lops.MMTSJ;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.MatrixObjectFuture;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederatedStatistics;
import org.apache.sysds.runtime.controlprogram.federated.FederatedUDF;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.MMTSJCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MultiReturnBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ParameterizedBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.PrefetchCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.fed.ComputationFEDInstruction;
import org.apache.sysds.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysds.runtime.instructions.gpu.context.GPUObject;
import org.apache.sysds.runtime.instructions.spark.ComputationSPInstruction;
import org.apache.sysds.runtime.instructions.spark.data.RDDObject;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageCacheEntry;
import org.apache.sysds.runtime.lineage.LineageCacheEviction;
import org.apache.sysds.runtime.lineage.LineageCacheStatistics;
import org.apache.sysds.runtime.lineage.LineageEstimator;
import org.apache.sysds.runtime.lineage.LineageGPUCacheEviction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.lineage.LineageRewriteReuse;
import org.apache.sysds.runtime.lineage.LineageSparkCacheEviction;
import org.apache.sysds.runtime.lineage.LineageTraceable;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.meta.MetaDataFormat;

public class LineageCache {
    private static final Map<LineageItem, LineageCacheEntry> _cache = new HashMap<LineageItem, LineageCacheEntry>();
    protected static final boolean DEBUG = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reuse(Instruction inst, ExecutionContext ec) {
        if (LineageCacheConfig.ReuseCacheType.isNone()) {
            return false;
        }
        boolean reuse = false;
        if (LineageCacheConfig.isReusable(inst, ec)) {
            List<MutablePair<LineageItem, LineageCacheEntry>> liList = LineageCache.getLineageItems(inst, ec);
            LineageCacheEntry e = null;
            boolean reuseAll = true;
            Map<LineageItem, LineageCacheEntry> map = _cache;
            synchronized (map) {
                for (MutablePair<LineageItem, LineageCacheEntry> item : liList) {
                    if (LineageCacheConfig.getCacheType().isFullReuse()) {
                        e = LineageCache.getIntern((LineageItem)item.getKey());
                    }
                    if (e == null && LineageCacheConfig.getCacheType().isPartialReuse() && !(inst instanceof ComputationSPInstruction) && !DMLScript.USE_ACCELERATOR && LineageRewriteReuse.executeRewrites(inst, ec)) {
                        e = LineageCache.getIntern((LineageItem)item.getKey());
                    }
                    reuseAll &= e != null;
                    item.setValue((Object)e);
                    if (e != null || !LineageCache.isMarkedForCaching(inst, ec)) continue;
                    LineageCache.putInternPlaceholder(inst, (LineageItem)item.getKey());
                }
            }
            reuse = reuseAll;
            if (reuse) {
                for (MutablePair mutablePair : liList) {
                    e = (LineageCacheEntry)mutablePair.getValue();
                    String outName = LineageCache.getOutputName(inst, (LineageItem)mutablePair.getKey());
                    if (e.isMatrixValue() && !e.isGPUObject()) {
                        MatrixBlock mb = e.getMBValue();
                        if (mb == null && e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.NOTCACHED) {
                            return false;
                        }
                        if (e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.TOCACHE) {
                            ec.replaceLineageItem(outName, e._key);
                            return false;
                        }
                        ec.setMatrixOutput(outName, mb);
                    } else if (e.isScalarValue()) {
                        ScalarObject so = e.getSOValue();
                        if (so == null && e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.NOTCACHED) {
                            return false;
                        }
                        if (e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.TOCACHE) {
                            ec.replaceLineageItem(outName, e._key);
                            return false;
                        }
                        ec.setScalarOutput(outName, so);
                    } else if (e.isRDDPersist()) {
                        RDDObject rdd = e.getRDDObject();
                        if (rdd == null && e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.NOTCACHED) {
                            return false;
                        }
                        if (e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.TOPERSISTRDD) {
                            if (DMLScript.STATISTICS) {
                                LineageCacheStatistics.incrementDelHitsRdd();
                            }
                            ec.replaceLineageItem(outName, e._key);
                            return false;
                        }
                        ((SparkExecutionContext)ec).setRDDHandleForVariable(outName, rdd);
                        ec.getMatrixObject(outName).updateDataCharacteristics(rdd.getDataCharacteristics());
                        if (LineageCache.probeRDDDistributed(e)) {
                            LineageSparkCacheEviction.cleanupChildRDDs(e);
                        } else {
                            LineageSparkCacheEviction.moveToSpark(e);
                        }
                    } else {
                        Pointer gpuPtr = e.getGPUPointer();
                        if (gpuPtr == null && e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.NOTCACHED) {
                            return false;
                        }
                        if (e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.TOCACHEGPU) {
                            if (DMLScript.STATISTICS) {
                                LineageCacheStatistics.incrementDelHitsGpu();
                            }
                            ec.replaceLineageItem(outName, e._key);
                            return false;
                        }
                        GPUObject gpuObj = new GPUObject(ec.getGPUContext(0), ec.getMatrixObject(outName), gpuPtr);
                        ec.getMatrixObject(outName).setGPUObject(ec.getGPUContext(0), gpuObj);
                        ec.getMatrixObject(outName).getGPUObject(ec.getGPUContext(0)).setDirty(true);
                        ec.getMatrixObject(outName).updateDataCharacteristics(e.getDataCharacteristics());
                        LineageGPUCacheEviction.incrementLiveCount(gpuPtr);
                        LineageGPUCacheEviction.maintainOrder(e);
                    }
                    ec.replaceLineageItem(outName, e._key);
                }
                LineageCache.maintainReuseStatistics(ec, inst, (LineageCacheEntry)liList.get(0).getValue());
            }
        }
        return reuse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reuse(List<String> outNames, List<DataIdentifier> outParams, int numOutputs, LineageItem[] liInputs, String name, ExecutionContext ec) {
        if (DMLScript.LINEAGE_ESTIMATE && !name.startsWith("SB")) {
            LineageEstimator.stopEstimator(outParams, liInputs, name);
        }
        if (!LineageCacheConfig.isMultiLevelReuse()) {
            return false;
        }
        boolean reuse = outParams.size() != 0;
        long savedComputeTime = 0L;
        HashMap<String, Data> funcOutputs = new HashMap<String, Data>();
        HashMap<String, LineageItem> funcLIs = new HashMap<String, LineageItem>();
        ArrayList<LineageCacheEntry> funcOutLIs = new ArrayList<LineageCacheEntry>();
        for (int i = 0; i < numOutputs; ++i) {
            String opcode = name + String.valueOf(i + 1);
            LineageItem li2 = new LineageItem(opcode, liInputs);
            li2.setHeight(1L);
            LineageCacheEntry e = null;
            Map<LineageItem, LineageCacheEntry> map = _cache;
            synchronized (map) {
                if (LineageCache.probe(li2)) {
                    e = LineageCache.getIntern(li2);
                    funcOutLIs.add(e);
                } else {
                    LineageCache.putIntern(li2, outParams.get(i).getDataType(), null, null, 0L);
                }
            }
            if (e != null) {
                MetaDataFormat md;
                String boundVarName = outNames.get(i);
                Data boundValue = null;
                if (e.isMatrixValue()) {
                    MatrixBlock mb = e.getMBValue();
                    if (mb == null && e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.NOTCACHED) {
                        return false;
                    }
                    if (e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.TOCACHE) {
                        return false;
                    }
                    md = new MetaDataFormat(e.getMBValue().getDataCharacteristics(), Types.FileFormat.BINARY);
                    md.getDataCharacteristics().setBlocksize(ConfigurationManager.getBlocksize());
                    boundValue = new MatrixObject(Types.ValueType.FP64, boundVarName, md);
                    ((MatrixObject)boundValue).acquireModify(e.getMBValue());
                    ((MatrixObject)boundValue).release();
                } else if (e.isGPUObject()) {
                    Pointer gpuPtr = e.getGPUPointer();
                    if (gpuPtr == null && e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.NOTCACHED) {
                        return false;
                    }
                    md = new MetaDataFormat(e.getDataCharacteristics(), Types.FileFormat.BINARY);
                    boundValue = new MatrixObject(Types.ValueType.FP64, boundVarName, md);
                    GPUObject gpuObj = new GPUObject(ec.getGPUContext(0), (MatrixObject)boundValue, gpuPtr);
                    gpuObj.setDirty(true);
                    ((MatrixObject)boundValue).setGPUObject(ec.getGPUContext(0), gpuObj);
                } else if (e.isRDDPersist()) {
                    RDDObject rdd = e.getRDDObject();
                    if (rdd == null && e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.NOTCACHED) {
                        return false;
                    }
                    md = new MetaDataFormat(rdd.getDataCharacteristics(), Types.FileFormat.BINARY);
                    String filename = rdd.getHDFSFilename() != null ? rdd.getHDFSFilename() : boundVarName;
                    boundValue = new MatrixObject(Types.ValueType.FP64, filename, md);
                    ((MatrixObject)boundValue).setRDDHandle(rdd);
                } else if (e.isScalarValue()) {
                    boundValue = e.getSOValue();
                    if (boundValue == null && e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.NOTCACHED) {
                        return false;
                    }
                    if (e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.TOCACHE) {
                        return false;
                    }
                }
                funcOutputs.put(boundVarName, boundValue);
                LineageItem orig = e._origItem;
                funcLIs.put(boundVarName, orig);
                savedComputeTime = e._computeTime;
                continue;
            }
            reuse = false;
        }
        if (reuse) {
            block12: for (LineageCacheEntry e : funcOutLIs) {
                if (e.isGPUObject()) {
                    switch (e.getCacheStatus()) {
                        case TOCACHEGPU: {
                            if (DMLScript.STATISTICS) {
                                LineageCacheStatistics.incrementDelHitsGpu();
                            }
                            return false;
                        }
                        case GPUCACHED: {
                            LineageGPUCacheEviction.incrementLiveCount(e.getGPUPointer());
                            LineageGPUCacheEviction.maintainOrder(e);
                            if (!DMLScript.STATISTICS) continue block12;
                            LineageCacheStatistics.incrementGpuHits();
                            continue block12;
                        }
                    }
                    return false;
                }
                if (!e.isRDDPersist()) continue;
                switch (e.getCacheStatus()) {
                    case TOPERSISTRDD: {
                        if (DMLScript.STATISTICS) {
                            LineageCacheStatistics.incrementDelHitsRdd();
                        }
                        return false;
                    }
                    case PERSISTEDRDD: {
                        if (LineageCache.probeRDDDistributed(e)) {
                            LineageSparkCacheEviction.cleanupChildRDDs(e);
                            if (!DMLScript.STATISTICS) continue block12;
                            LineageCacheStatistics.incrementRDDPersistHits();
                            continue block12;
                        }
                        LineageSparkCacheEviction.moveToSpark(e);
                        if (!DMLScript.STATISTICS) continue block12;
                        LineageCacheStatistics.incrementRDDHits();
                        continue block12;
                    }
                }
                return false;
            }
            funcOutputs.forEach((var, val) -> {
                Data exdata = ec.removeVariable((String)var);
                if (exdata != val) {
                    ec.cleanupDataObject(exdata);
                }
                ec.setVariable((String)var, (Data)val);
            });
            funcLIs.forEach((var, li) -> ec.getLineage().set((String)var, (LineageItem)li));
            if (DMLScript.STATISTICS) {
                LineageCacheStatistics.incrementSavedComputeTime(savedComputeTime);
            }
        }
        return reuse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FederatedResponse reuse(FederatedUDF udf, ExecutionContext ec) {
        if (LineageCacheConfig.ReuseCacheType.isNone() || udf.getOutputIds() == null) {
            return new FederatedResponse(FederatedResponse.ResponseType.ERROR);
        }
        boolean reuse = false;
        List<Long> outIds = udf.getOutputIds();
        HashMap<String, ScalarObject> udfOutputs = new HashMap<String, ScalarObject>();
        long savedComputeTime = 0L;
        if (udf.getLineageItem(ec) == null) {
            return new FederatedResponse(FederatedResponse.ResponseType.ERROR);
        }
        LineageItem li = (LineageItem)udf.getLineageItem(ec).getValue();
        li.setHeight(1L);
        LineageCacheEntry e = null;
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            if (LineageCache.probe(li)) {
                e = LineageCache.getIntern(li);
            } else {
                LineageCache.putIntern(li, Types.DataType.MATRIX, null, null, 0L);
            }
        }
        if (e != null) {
            String outName = String.valueOf(outIds.get(0));
            Data outValue = null;
            if (e.isMatrixValue()) {
                MatrixBlock mb = e.getMBValue();
                if (mb == null && e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.NOTCACHED) {
                    return new FederatedResponse(FederatedResponse.ResponseType.ERROR);
                }
                MetaDataFormat md = new MetaDataFormat(e.getMBValue().getDataCharacteristics(), Types.FileFormat.BINARY);
                md.getDataCharacteristics().setBlocksize(ConfigurationManager.getBlocksize());
                outValue = new MatrixObject(Types.ValueType.FP64, outName, md);
                ((MatrixObject)outValue).acquireModify(e.getMBValue());
                ((MatrixObject)outValue).release();
            } else {
                outValue = e.getSOValue();
                if (outValue == null && e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.NOTCACHED) {
                    return new FederatedResponse(FederatedResponse.ResponseType.ERROR);
                }
            }
            udfOutputs.put(outName, (ScalarObject)outValue);
            savedComputeTime = e._computeTime;
            reuse = true;
        } else {
            reuse = false;
        }
        if (reuse) {
            FederatedResponse res = null;
            for (Map.Entry entry : udfOutputs.entrySet()) {
                String var = (String)entry.getKey();
                Data val = (Data)entry.getValue();
                Data exdata = ec.removeVariable(var);
                if (exdata != val) {
                    ec.cleanupDataObject(exdata);
                }
                ec.setVariable(var, val);
                res = LineageItemUtils.setUDFResponse(udf, (MatrixObject)val);
            }
            if (DMLScript.STATISTICS) {
                LineageCacheStatistics.incrementInstHits();
                LineageCacheStatistics.incrementSavedComputeTime(savedComputeTime);
            }
            return res;
        }
        return new FederatedResponse(FederatedResponse.ResponseType.ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reuseFedRead(String outName, Types.DataType dataType, LineageItem li, ExecutionContext ec) {
        if (LineageCacheConfig.ReuseCacheType.isNone() || dataType != Types.DataType.MATRIX) {
            return false;
        }
        LineageCacheEntry e = null;
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            if (!LineageCache.probe(li)) {
                LineageCache.putIntern(li, dataType, null, null, 0L);
                return false;
            }
            e = LineageCache.getIntern(li);
        }
        if (e != null && e.isMatrixValue()) {
            MatrixBlock mb = e.getMBValue();
            if (mb == null || e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.NOTCACHED) {
                return false;
            }
            ec.setMatrixOutput(outName, e.getMBValue());
            if (DMLScript.STATISTICS) {
                FederatedStatistics.incFedReuseReadHitCount();
                FederatedStatistics.incFedReuseReadBytesCount(mb);
                LineageCacheStatistics.incrementSavedComputeTime(e._computeTime);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] reuseSerialization(LineageItem objLI) {
        if (LineageCacheConfig.ReuseCacheType.isNone() || objLI == null) {
            return null;
        }
        LineageItem li = LineageItemUtils.getSerializedFedResponseLineageItem(objLI);
        LineageCacheEntry e = null;
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            if (!LineageCache.probe(li)) {
                LineageCache.putIntern(li, Types.DataType.UNKNOWN, null, null, 0L);
                return null;
            }
            e = LineageCache.getIntern(li);
        }
        if (e != null && e.isSerializedBytes()) {
            byte[] sBytes = e.getSerializedBytes();
            if (sBytes == null && e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.NOTCACHED) {
                return null;
            }
            if (DMLScript.STATISTICS) {
                LineageCacheStatistics.incrementSavedComputeTime(e._computeTime);
                FederatedStatistics.aggFedSerializationReuse(sBytes.length);
            }
            return sBytes;
        }
        return null;
    }

    public static boolean probe(LineageItem key) {
        return _cache.containsKey(key);
    }

    private static boolean probeRDDDistributed(LineageItem key) {
        if (!_cache.containsKey(key)) {
            return false;
        }
        return LineageCache.probeRDDDistributed(_cache.get(key));
    }

    protected static boolean probeRDDDistributed(LineageCacheEntry e) {
        if (!e.isRDDPersist()) {
            return false;
        }
        return SparkExecutionContext.isRDDCached(e.getRDDObject().getRDD().id());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeEntry(LineageItem key) {
        boolean p = _cache.containsKey(key);
        if (!p) {
            return;
        }
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            LineageCacheEntry e = LineageCache.getEntry(key);
            if (e.isRDDPersist()) {
                e.getRDDObject().getRDD().unpersist(false);
                e.getRDDObject().setCheckpointRDD(false);
                return;
            }
            long size = e.getSize();
            if (e._origItem == null) {
                _cache.remove(e._key);
            } else {
                LineageCacheEntry h = _cache.get(e._origItem);
                while (h != null) {
                    LineageCacheEntry tmp = h;
                    h = h._nextEntry;
                    _cache.remove(tmp._key);
                }
            }
            if (e.isRDDPersist()) {
                LineageSparkCacheEviction.updateSize(e.getSize(), false);
            } else {
                LineageCacheEviction.updateSize(size, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MatrixBlock getMatrix(LineageItem key) {
        LineageCacheEntry e = null;
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            e = LineageCache.getIntern(key);
        }
        return e.getMBValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LineageCacheEntry getEntry(LineageItem key) {
        LineageCacheEntry e = null;
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            e = LineageCache.getIntern(key);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putMatrix(Instruction inst, ExecutionContext ec, long computetime) {
        if (LineageCacheConfig.isReusable(inst, ec)) {
            LineageItem item = (LineageItem)((LineageTraceable)((Object)inst)).getLineageItem(ec).getValue();
            MatrixObject mo = null;
            if (inst instanceof ComputationCPInstruction) {
                mo = ec.getMatrixObject(((ComputationCPInstruction)inst).output);
            } else if (inst instanceof ComputationFEDInstruction) {
                mo = ec.getMatrixObject(((ComputationFEDInstruction)inst).output);
            } else if (inst instanceof ComputationSPInstruction) {
                mo = ec.getMatrixObject(((ComputationSPInstruction)inst).output);
            }
            Map<LineageItem, LineageCacheEntry> map = _cache;
            synchronized (map) {
                LineageCache.putIntern(item, Types.DataType.MATRIX, (MatrixBlock)mo.acquireReadAndRelease(), null, computetime);
            }
        }
    }

    public static void putValue(Instruction inst, ExecutionContext ec, long starttime) {
        if (DMLScript.LINEAGE_ESTIMATE) {
            LineageEstimator.processSingleInst(inst, ec, starttime);
        }
        if (LineageCacheConfig.ReuseCacheType.isNone()) {
            return;
        }
        long computetime = System.nanoTime() - starttime;
        if (LineageCacheConfig.isReusable(inst, ec)) {
            List<Object> liData = null;
            GPUObject liGPUObj = null;
            LineageItem instLI = null;
            if (inst instanceof MultiReturnBuiltinCPInstruction) {
                liData = new ArrayList<Pair<LineageItem, Data>>();
                instLI = (LineageItem)((LineageTraceable)((Object)inst)).getLineageItem(ec).getValue();
                MultiReturnBuiltinCPInstruction mrInst = (MultiReturnBuiltinCPInstruction)inst;
                for (int i = 0; i < mrInst.getNumOutputs(); ++i) {
                    String opcode = instLI.getOpcode() + String.valueOf(i);
                    LineageItem li = new LineageItem(opcode, instLI.getInputs());
                    Data value = ec.getVariable(mrInst.getOutput(i));
                    liData.add((Pair<LineageItem, Data>)Pair.of((Object)li, (Object)value));
                }
            } else if (inst instanceof GPUInstruction) {
                if (!LineageCacheConfig.isMultiBackendReuse()) {
                    instLI = ec.getLineageItem(((GPUInstruction)inst)._output);
                    LineageCache.removePlaceholder(instLI);
                    return;
                }
                Data gpudata = ec.getVariable(((GPUInstruction)inst)._output);
                liGPUObj = gpudata instanceof MatrixObject ? ec.getMatrixObject(((GPUInstruction)inst)._output).getGPUObject(ec.getGPUContext(0)) : null;
                instLI = ec.getLineageItem(((GPUInstruction)inst)._output);
                if (liGPUObj == null) {
                    liData = Arrays.asList(Pair.of((Object)instLI, (Object)ec.getVariable(((GPUInstruction)inst)._output)));
                }
            } else {
                if (inst instanceof ComputationSPInstruction && ec.getVariable(((ComputationSPInstruction)inst).output) instanceof MatrixObject && ec.getCacheableData(((ComputationSPInstruction)inst).output.getName()).hasRDDHandle()) {
                    instLI = ec.getLineageItem(((ComputationSPInstruction)inst).output);
                    if (!LineageCacheConfig.isMultiBackendReuse()) {
                        LineageCache.removePlaceholder(instLI);
                        return;
                    }
                    LineageCache.putValueRDD(inst, instLI, ec, computetime);
                    return;
                }
                if (inst instanceof ComputationCPInstruction) {
                    instLI = ec.getLineageItem(((ComputationCPInstruction)inst).output);
                    liData = Arrays.asList(Pair.of((Object)instLI, (Object)ec.getVariable(((ComputationCPInstruction)inst).output)));
                } else if (inst instanceof ComputationFEDInstruction) {
                    instLI = ec.getLineageItem(((ComputationFEDInstruction)inst).output);
                    liData = Arrays.asList(Pair.of((Object)instLI, (Object)ec.getVariable(((ComputationFEDInstruction)inst).output)));
                } else if (inst instanceof ComputationSPInstruction) {
                    instLI = ec.getLineageItem(((ComputationSPInstruction)inst).output);
                    if (!LineageCacheConfig.isMultiBackendReuse()) {
                        LineageCache.removePlaceholder(instLI);
                        return;
                    }
                    liData = Arrays.asList(Pair.of((Object)instLI, (Object)ec.getVariable(((ComputationSPInstruction)inst).output)));
                }
            }
            if (liGPUObj == null) {
                LineageCache.putValueCPU(inst, liData, computetime);
            } else {
                LineageCache.putValueGPU(liGPUObj, instLI, computetime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putValueCPU(Instruction inst, List<Pair<LineageItem, Data>> liData, long computetime) {
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            for (Pair<LineageItem, Data> entry : liData) {
                long size;
                LineageItem item = (LineageItem)entry.getKey();
                Data data = (Data)entry.getValue();
                if (!LineageCache.probe(item)) continue;
                LineageCacheEntry centry = _cache.get(item);
                if (!(data instanceof MatrixObject) && !(data instanceof ScalarObject)) {
                    LineageCache.removePlaceholder(item);
                    continue;
                }
                if (data instanceof MatrixObjectFuture || inst instanceof PrefetchCPInstruction) {
                    LineageCache.removePlaceholder(item);
                    continue;
                }
                if (data instanceof MatrixObject && ((MatrixObject)data).hasRDDHandle()) {
                    LineageCache.removePlaceholder(item);
                    continue;
                }
                if (LineageCacheConfig.isOutputFederated(inst, data)) {
                    LineageCache.removePlaceholder(item);
                    continue;
                }
                MatrixBlock mb = data instanceof MatrixObject ? (MatrixBlock)((MatrixObject)data).acquireReadAndRelease() : null;
                long l = size = mb != null ? mb.getInMemorySize() : (long)((ScalarObject)data).getSize();
                if (size > LineageCacheEviction.getCacheLimit()) {
                    LineageCache.removePlaceholder(item);
                    continue;
                }
                if (centry.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.EMPTY && LineageCacheConfig.isDelayedCaching() && data instanceof MatrixObject && !LineageCacheEviction._removelist.containsKey(centry._key) && (double)size > 0.05 * (double)LineageCacheEviction.getAvailableSpace()) {
                    centry.setCacheStatus(LineageCacheConfig.LineageCacheStatus.TOCACHE);
                    continue;
                }
                if (!LineageCacheEviction.isBelowThreshold(size)) {
                    LineageCacheEviction.makeSpace(_cache, size);
                }
                LineageCacheEviction.updateSize(size, true);
                if (data instanceof MatrixObject) {
                    centry.setValue(mb, computetime);
                } else if (data instanceof ScalarObject) {
                    centry.setValue((ScalarObject)data, computetime);
                }
                centry.setCacheStatus(LineageCacheConfig.LineageCacheStatus.CACHED);
                if (DMLScript.STATISTICS && LineageCacheEviction._removelist.containsKey(centry._key)) {
                    LineageCacheStatistics.incrementMissedComputeTime(centry._computeTime);
                }
                LineageCacheEviction.addEntry(centry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putValueGPU(GPUObject gpuObj, LineageItem instLI, long computetime) {
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            LineageCacheEntry centry = _cache.get(instLI);
            if (gpuObj.isSparse()) {
                LineageCache.removePlaceholder(instLI);
                return;
            }
            if (DMLScript.STATISTICS && LineageCacheEviction._removelist.containsKey(centry._key)) {
                LineageCacheStatistics.incrementDelHitsGpu();
            }
            switch (centry.getCacheStatus()) {
                case EMPTY: {
                    if (LineageCacheConfig.isDelayedCachingGPU() && !LineageCacheEviction._removelist.containsKey(centry._key) && !LineageCacheConfig.isComputeGPUOps(centry._key.getOpcode())) {
                        centry.setGPUValue(gpuObj.getDensePointer(), gpuObj.getAllocatedSize(), gpuObj.getMatrixObject().getMetaData(), computetime);
                        centry.setCacheStatus(LineageCacheConfig.LineageCacheStatus.TOCACHEGPU);
                        break;
                    }
                }
                case TOCACHEGPU: {
                    centry.setGPUValue(gpuObj.getDensePointer(), gpuObj.getAllocatedSize(), gpuObj.getMatrixObject().getMetaData(), computetime);
                    centry.setCacheStatus(LineageCacheConfig.LineageCacheStatus.GPUCACHED);
                    LineageGPUCacheEviction.addEntry(centry);
                    break;
                }
                default: {
                    throw new DMLRuntimeException("Execution should not reach here: " + centry._key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putValueRDD(Instruction inst, LineageItem instLI, ExecutionContext ec, long computetime) {
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            if (!LineageCache.probe(instLI)) {
                return;
            }
            LineageCacheEntry centry = _cache.get(instLI);
            if (inst.getOpcode().equalsIgnoreCase("chkpoint")) {
                LineageCache.removePlaceholder(instLI);
                return;
            }
            boolean opToPersist = LineageCacheConfig.isReusableRDDType(inst);
            if (!opToPersist) {
                LineageCache.removePlaceholder(instLI);
                return;
            }
            CacheableData<?> cd = ec.getCacheableData(((ComputationSPInstruction)inst).output.getName());
            RDDObject rddObj = cd.getRDDHandle();
            rddObj.setDataCharacteristics(cd.getDataCharacteristics());
            rddObj.setHDFSFilename(cd.getFileName());
            switch (centry.getCacheStatus()) {
                case EMPTY: {
                    if (LineageCacheConfig.isDelayedCachingRDD()) {
                        centry.setRDDValue(rddObj, computetime);
                        break;
                    }
                }
                case TOPERSISTRDD: {
                    centry.setRDDValue(rddObj);
                    centry.setCacheStatus(LineageCacheConfig.LineageCacheStatus.PERSISTEDRDD);
                    LineageCache.persistRDD(inst, centry, ec);
                    centry.getRDDObject().setLineageCached();
                    break;
                }
                default: {
                    throw new DMLRuntimeException("Execution should not reach here: " + centry._key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putValueAsyncOp(LineageItem instLI, Data data, MatrixBlock mb, long starttime) {
        if (LineageCacheConfig.ReuseCacheType.isNone()) {
            return;
        }
        if (!ArrayUtils.contains((Object[])LineageCacheConfig.getReusableOpcodes(), (Object)instLI.getOpcode())) {
            return;
        }
        if (!(data instanceof MatrixObject) && !(data instanceof ScalarObject)) {
            return;
        }
        if (!LineageCacheConfig.isMultiBackendReuse()) {
            return;
        }
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            LineageCacheEntry e;
            if (instLI.getOpcode().equals(Opcodes.PREFETCH.toString()) && LineageCache.probeRDDDistributed(instLI.getInputs()[0]) && (e = _cache.get(instLI.getInputs()[0])).getRDDObject().getNumReferences() < 1) {
                e.updateScore(false);
            }
            long computetime = System.nanoTime() - starttime;
            LineageCache.putIntern(instLI, Types.DataType.MATRIX, mb, null, computetime);
            if (DMLScript.STATISTICS && LineageCacheEviction._removelist.containsKey(instLI)) {
                LineageCacheStatistics.incrementMissedComputeTime(computetime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putValue(List<DataIdentifier> outputs, LineageItem[] liInputs, String name, ExecutionContext ec, long computetime) {
        if (LineageCacheConfig.isEstimator()) {
            LineageEstimator.processFunc(outputs, liInputs, name, ec, computetime);
        }
        if (!LineageCacheConfig.isMultiLevelReuse()) {
            return;
        }
        HashMap<LineageItem, LineageItem> FuncLIMap = new HashMap<LineageItem, LineageItem>();
        boolean AllOutputsCacheable = true;
        for (int i = 0; i < outputs.size(); ++i) {
            String opcode = name + String.valueOf(i + 1);
            LineageItem li = new LineageItem(opcode, liInputs);
            String boundVarName = outputs.get(i).getName();
            LineageItem boundLI2 = ec.getLineage().get(boundVarName);
            if (boundLI2 != null) {
                boundLI2.resetVisitStatusNR();
            }
            if (boundLI2 == null || !LineageCache.probe(li) || !LineageCache.probe(boundLI2)) {
                AllOutputsCacheable = false;
            }
            FuncLIMap.put(li, boundLI2);
        }
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            if (AllOutputsCacheable) {
                FuncLIMap.forEach((Li, boundLI) -> LineageCache.mvIntern(Li, boundLI, computetime));
            } else {
                FuncLIMap.forEach((Li, boundLI) -> LineageCache.removePlaceholder(Li));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putValue(FederatedUDF udf, ExecutionContext ec, long computetime) {
        if (LineageCacheConfig.ReuseCacheType.isNone() || udf.getOutputIds() == null) {
            return;
        }
        List<Long> outIds = udf.getOutputIds();
        if (udf.getLineageItem(ec) == null) {
            return;
        }
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            long size;
            LineageItem item = (LineageItem)udf.getLineageItem(ec).getValue();
            if (!LineageCache.probe(item)) {
                return;
            }
            LineageCacheEntry entry = _cache.get(item);
            Data data = ec.getVariable(String.valueOf(outIds.get(0)));
            if (!(data instanceof MatrixObject) && !(data instanceof ScalarObject)) {
                LineageCache.removePlaceholder(item);
                return;
            }
            MatrixBlock mb = data instanceof MatrixObject ? (MatrixBlock)((MatrixObject)data).acquireReadAndRelease() : null;
            long l = size = mb != null ? mb.getInMemorySize() : (long)((ScalarObject)data).getSize();
            if (size > LineageCacheEviction.getCacheLimit()) {
                LineageCache.removePlaceholder(item);
                return;
            }
            if (!LineageCacheEviction.isBelowThreshold(size)) {
                LineageCacheEviction.makeSpace(_cache, size);
            }
            LineageCacheEviction.updateSize(size, true);
            if (data instanceof MatrixObject) {
                entry.setValue(mb, computetime);
            } else if (data instanceof ScalarObject) {
                entry.setValue((ScalarObject)data, computetime);
            }
            LineageCacheEviction.addEntry(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putFedReadObject(Data data, LineageItem li, ExecutionContext ec) {
        if (LineageCacheConfig.ReuseCacheType.isNone()) {
            return;
        }
        LineageCacheEntry entry = _cache.get(li);
        if (entry != null && data instanceof MatrixObject) {
            long t0 = System.nanoTime();
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data).acquireRead();
            long t1 = System.nanoTime();
            Map<LineageItem, LineageCacheEntry> map = _cache;
            synchronized (map) {
                long size;
                long l = size = mb != null ? mb.getInMemorySize() : 0L;
                if (size > LineageCacheEviction.getCacheLimit()) {
                    LineageCache.removePlaceholder(li);
                }
                if (!LineageCacheEviction.isBelowThreshold(size)) {
                    LineageCacheEviction.makeSpace(_cache, size);
                }
                LineageCacheEviction.updateSize(size, true);
                entry.setValue(mb, t1 - t0);
            }
        }
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            LineageCache.removePlaceholder(li);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putSerializedObject(byte[] serialBytes, LineageItem objLI, long computetime) {
        if (LineageCacheConfig.ReuseCacheType.isNone()) {
            return;
        }
        LineageItem li = LineageItemUtils.getSerializedFedResponseLineageItem(objLI);
        LineageCacheEntry entry = LineageCache.getIntern(li);
        if (entry != null && serialBytes != null) {
            Map<LineageItem, LineageCacheEntry> map = _cache;
            synchronized (map) {
                long size = serialBytes.length;
                if (size > LineageCacheEviction.getCacheLimit()) {
                    LineageCache.removePlaceholder(li);
                }
                if (!LineageCacheEviction.isBelowThreshold(size)) {
                    LineageCacheEviction.makeSpace(_cache, size);
                }
                LineageCacheEviction.updateSize(size, true);
                entry.setValue(serialBytes, computetime);
            }
        }
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            LineageCache.removePlaceholder(li);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetCache() {
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            _cache.clear();
            LineageCacheEviction.resetEviction();
            LineageGPUCacheEviction.resetEviction();
            LineageSparkCacheEviction.resetEviction();
        }
    }

    public static Map<LineageItem, LineageCacheEntry> getLineageCache() {
        return _cache;
    }

    private static void putInternPlaceholder(Instruction inst, LineageItem key) {
        GPUInstruction gpuinst;
        ComputationCPInstruction cinst = inst instanceof ComputationCPInstruction ? (ComputationCPInstruction)inst : null;
        ComputationFEDInstruction cfinst = inst instanceof ComputationFEDInstruction ? (ComputationFEDInstruction)inst : null;
        ComputationSPInstruction cspinst = inst instanceof ComputationSPInstruction ? (ComputationSPInstruction)inst : null;
        GPUInstruction gPUInstruction = gpuinst = inst instanceof GPUInstruction ? (GPUInstruction)inst : null;
        if (cinst != null) {
            LineageCache.putIntern(key, cinst.output.getDataType(), null, null, 0L);
        } else if (cfinst != null) {
            LineageCache.putIntern(key, cfinst.output.getDataType(), null, null, 0L);
        } else if (cspinst != null) {
            LineageCache.putIntern(key, cspinst.output.getDataType(), null, null, 0L);
        } else if (gpuinst != null) {
            LineageCache.putIntern(key, gpuinst._output.getDataType(), null, null, 0L);
        }
    }

    private static void putIntern(LineageItem key, Types.DataType dt, MatrixBlock Mval, ScalarObject Sval, long computetime) {
        if (_cache.containsKey(key)) {
            return;
        }
        LineageCacheEntry newItem = new LineageCacheEntry(key, dt, Mval, Sval, computetime);
        if (Mval != null || Sval != null) {
            long size = newItem.getSize();
            if (size > LineageCacheEviction.getCacheLimit()) {
                return;
            }
            if (!LineageCacheEviction.isBelowThreshold(size)) {
                LineageCacheEviction.makeSpace(_cache, size);
            }
            LineageCacheEviction.updateSize(size, true);
        }
        LineageCacheEviction.addEntry(newItem);
        _cache.put(key, newItem);
    }

    private static LineageCacheEntry getIntern(LineageItem key) {
        LineageCacheEntry e = _cache.get(key);
        if (e == null) {
            if (DMLScript.STATISTICS && LineageCacheEviction._removelist.containsKey(key)) {
                LineageCacheStatistics.incrementDelHits();
            }
            return null;
        }
        if (e.getCacheStatus() != LineageCacheConfig.LineageCacheStatus.SPILLED) {
            if (DMLScript.STATISTICS) {
                LineageCacheStatistics.incrementMemHits();
            }
            if (e.isRDDPersist()) {
                LineageSparkCacheEviction.maintainOrder(e);
            } else if (!e.isGPUObject()) {
                LineageCacheEviction.getEntry(e);
            }
            return e;
        }
        return LineageCacheEviction.readFromLocalFS(_cache, key);
    }

    private static void mvIntern(LineageItem item, LineageItem probeItem, long computetime) {
        if (LineageCacheConfig.ReuseCacheType.isNone()) {
            return;
        }
        if (LineageCache.probe(probeItem)) {
            LineageCacheEntry oe = _cache.get(probeItem);
            LineageCacheEntry e = _cache.get(item);
            boolean exists = !e.isNullVal();
            e.copyValueFrom(oe, computetime);
            e._origItem = probeItem;
            oe._origItem = probeItem;
            if (!exists) {
                e._nextEntry = oe._nextEntry;
                oe._nextEntry = e;
            }
            if (DMLScript.STATISTICS && LineageCacheEviction._removelist.containsKey(e._key)) {
                LineageCacheStatistics.incrementMissedComputeTime(e._computeTime);
            }
            if (!e.isRDDPersist() && !e.isGPUObject()) {
                LineageCacheEviction.addEntry(e);
            }
        } else {
            LineageCache.removePlaceholder(item);
        }
    }

    private static void removePlaceholder(LineageItem item) {
        if (!_cache.containsKey(item)) {
            return;
        }
        LineageCacheEntry centry = _cache.get(item);
        centry.removeAndNotify();
        _cache.remove(item);
    }

    private static boolean isMarkedForCaching(Instruction inst, ExecutionContext ec) {
        CPOperand output;
        if (!LineageCacheConfig.getCompAssRW()) {
            return true;
        }
        CPOperand cPOperand = inst instanceof ComputationCPInstruction ? ((ComputationCPInstruction)inst).output : (inst instanceof ComputationFEDInstruction ? ((ComputationFEDInstruction)inst).output : (output = inst instanceof ComputationSPInstruction ? ((ComputationSPInstruction)inst).output : ((GPUInstruction)inst)._output));
        if (output.isMatrix()) {
            MatrixObject mo = inst instanceof ComputationCPInstruction ? ec.getMatrixObject(((ComputationCPInstruction)inst).output) : (inst instanceof ComputationFEDInstruction ? ec.getMatrixObject(((ComputationFEDInstruction)inst).output) : (inst instanceof ComputationSPInstruction ? ec.getMatrixObject(((ComputationSPInstruction)inst).output) : ec.getMatrixObject(((GPUInstruction)inst)._output)));
            return LineageCacheConfig.getCacheType() != LineageCacheConfig.ReuseCacheType.REUSE_FULL || mo.isMarked();
        }
        return true;
    }

    private static boolean persistRDD(Instruction inst, LineageCacheEntry centry, ExecutionContext ec) {
        if (LineageCache.probeRDDDistributed(centry)) {
            centry.setCacheStatus(LineageCacheConfig.LineageCacheStatus.PERSISTEDRDD);
            return true;
        }
        CacheableData<?> cd = ec.getCacheableData(((ComputationSPInstruction)inst).output.getName());
        long estimatedSize = MatrixBlock.estimateSizeInMemory(cd.getDataCharacteristics());
        if ((double)estimatedSize > LineageSparkCacheEviction.getSparkStorageLimit()) {
            return false;
        }
        LineageCache.persistRDDIntern(centry, estimatedSize);
        centry.setCacheStatus(LineageCacheConfig.LineageCacheStatus.PERSISTEDRDD);
        return false;
    }

    private static boolean persistRDD(LineageCacheEntry centry, long estimatedSize) {
        if (LineageCache.probeRDDDistributed(centry)) {
            centry.setCacheStatus(LineageCacheConfig.LineageCacheStatus.PERSISTEDRDD);
            return true;
        }
        LineageCache.persistRDDIntern(centry, estimatedSize);
        centry.setCacheStatus(LineageCacheConfig.LineageCacheStatus.PERSISTEDRDD);
        return false;
    }

    private static void persistRDDIntern(LineageCacheEntry centry, long estimatedSize) {
        RDDObject rddObj = centry.getRDDObject();
        JavaPairRDD rdd = rddObj.getRDD();
        rdd = rdd.persist(StorageLevel.MEMORY_AND_DISK());
        rdd.rdd().localCheckpoint();
        rddObj.setRDD(rdd);
        rddObj.setCheckpointRDD(true);
        if (!LineageSparkCacheEviction.isBelowThreshold(estimatedSize)) {
            LineageSparkCacheEviction.makeSpace(_cache, estimatedSize);
        }
        LineageSparkCacheEviction.updateSize(estimatedSize, true);
        LineageSparkCacheEviction.addEntry(centry, estimatedSize);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementRDDPersists();
        }
    }

    @Deprecated
    private static double getRecomputeEstimate(Instruction inst, ExecutionContext ec) {
        if (!((ComputationCPInstruction)inst).output.isMatrix() || ((ComputationCPInstruction)inst).input1 != null && !((ComputationCPInstruction)inst).input1.isMatrix()) {
            return 0.0;
        }
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        double nflops = 0.0;
        String instop = inst.getOpcode().contains(Opcodes.SPOOF.toString()) ? "spoof" : inst.getOpcode();
        InstructionType cptype = Opcodes.getTypeByOpcode(instop, Types.ExecType.CP);
        switch (cptype) {
            case MMTSJ: {
                MatrixObject mo = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                long r = mo.getNumRows();
                long c = mo.getNumColumns();
                long nnz = mo.getNnz();
                double s = OptimizerUtils.getSparsity(r, c, nnz);
                boolean sparse = MatrixBlock.evalSparseFormatInMemory(r, c, nnz);
                MMTSJ.MMTSJType type = ((MMTSJCPInstruction)inst).getMMTSJType();
                if (type.isLeft()) {
                    nflops = !sparse ? (double)(r * c) * s * (double)c / 2.0 : (double)(r * c) * s * (double)c * s / 2.0;
                    break;
                }
                nflops = !sparse ? (double)r * (double)c * (double)r / 2.0 : (double)(r * c) * s + (double)(r * c) * s * (double)c * s / 2.0;
                break;
            }
            case AggregateBinary: {
                MatrixObject mo1 = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                MatrixObject mo2 = ec.getMatrixObject(((ComputationCPInstruction)inst).input2);
                long r1 = mo1.getNumRows();
                long c1 = mo1.getNumColumns();
                long nnz1 = mo1.getNnz();
                double s1 = OptimizerUtils.getSparsity(r1, c1, nnz1);
                boolean lsparse = MatrixBlock.evalSparseFormatInMemory(r1, c1, nnz1);
                long r2 = mo2.getNumRows();
                long c2 = mo2.getNumColumns();
                long nnz2 = mo2.getNnz();
                double s2 = OptimizerUtils.getSparsity(r2, c2, nnz2);
                boolean rsparse = MatrixBlock.evalSparseFormatInMemory(r2, c2, nnz2);
                if (!lsparse && !rsparse) {
                    nflops = 2.0 * ((double)(r1 * c1) * (c2 > 1L ? s1 : 1.0) * (double)c2) / 2.0;
                    break;
                }
                if (!lsparse && rsparse) {
                    nflops = 2.0 * ((double)(r1 * c1) * s1 * (double)c2 * s2) / 2.0;
                    break;
                }
                if (lsparse && !rsparse) {
                    nflops = 2.0 * ((double)(r1 * c1) * s1 * (double)c2) / 2.0;
                    break;
                }
                nflops = 2.0 * ((double)(r1 * c1) * s1 * (double)c2 * s2) / 2.0;
                break;
            }
            case Binary: {
                MatrixObject mo1 = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                long r1 = mo1.getNumRows();
                long c1 = mo1.getNumColumns();
                if (inst.getOpcode().equalsIgnoreCase(Opcodes.MULT.toString()) || inst.getOpcode().equalsIgnoreCase(Opcodes.DIV.toString())) {
                    nflops = r1 * c1;
                    break;
                }
                if (!inst.getOpcode().equalsIgnoreCase(Opcodes.SOLVE.toString())) break;
                nflops = r1 * c1 * c1;
                break;
            }
            case MatrixIndexing: {
                MatrixObject mo1 = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                long r1 = mo1.getNumRows();
                long c1 = mo1.getNumColumns();
                long nnz1 = mo1.getNnz();
                double s1 = OptimizerUtils.getSparsity(r1, c1, nnz1);
                boolean lsparse = MatrixBlock.evalSparseFormatInMemory(r1, c1, nnz1);
                nflops = 1.0 * (lsparse ? (double)(r1 * c1) * s1 : (double)(r1 * c1));
                break;
            }
            case ParameterizedBuiltin: {
                String opcode = ((ParameterizedBuiltinCPInstruction)inst).getOpcode();
                HashMap<String, String> params = ((ParameterizedBuiltinCPInstruction)inst).getParameterMap();
                long r1 = ec.getMatrixObject(params.get("target")).getNumRows();
                String fn = params.get("fn");
                double xga = 0.0;
                if (opcode.equalsIgnoreCase(Opcodes.GROUPEDAGG.toString())) {
                    if (fn.equalsIgnoreCase("sum")) {
                        xga = 4.0;
                    } else if (fn.equalsIgnoreCase("count")) {
                        xga = 1.0;
                    }
                }
                nflops = (double)(2L * r1) + xga * (double)r1;
                break;
            }
            case Reorg: {
                MatrixObject mo = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                long r = mo.getNumRows();
                long c = mo.getNumColumns();
                long nnz = mo.getNnz();
                double s = OptimizerUtils.getSparsity(r, c, nnz);
                boolean sparse = MatrixBlock.evalSparseFormatInMemory(r, c, nnz);
                nflops = sparse ? (double)(r * c) * s : (double)(r * c);
                break;
            }
            case Append: {
                MatrixObject mo1 = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                MatrixObject mo2 = ec.getMatrixObject(((ComputationCPInstruction)inst).input2);
                long r1 = mo1.getNumRows();
                long c1 = mo1.getNumColumns();
                long nnz1 = mo1.getNnz();
                double s1 = OptimizerUtils.getSparsity(r1, c1, nnz1);
                boolean lsparse = MatrixBlock.evalSparseFormatInMemory(r1, c1, nnz1);
                long r2 = mo2.getNumRows();
                long c2 = mo2.getNumColumns();
                long nnz2 = mo2.getNnz();
                double s2 = OptimizerUtils.getSparsity(r2, c2, nnz2);
                boolean rsparse = MatrixBlock.evalSparseFormatInMemory(r2, c2, nnz2);
                nflops = 1.0 * ((lsparse ? (double)(r1 * c1) * s1 : (double)(r1 * c1)) + (rsparse ? (double)(r2 * c2) * s2 : (double)(r2 * c2)));
                break;
            }
            case SpoofFused: {
                nflops = 0.0;
                break;
            }
            default: {
                throw new DMLRuntimeException("Lineage Cache: unsupported instruction: " + inst.getOpcode());
            }
        }
        return nflops / 2.147483648E9;
    }

    private static List<MutablePair<LineageItem, LineageCacheEntry>> getLineageItems(Instruction inst, ExecutionContext ec) {
        LineageItem instLI;
        ComputationCPInstruction cinst = inst instanceof ComputationCPInstruction ? (ComputationCPInstruction)inst : null;
        ComputationFEDInstruction cfinst = inst instanceof ComputationFEDInstruction ? (ComputationFEDInstruction)inst : null;
        ComputationSPInstruction cspinst = inst instanceof ComputationSPInstruction ? (ComputationSPInstruction)inst : null;
        GPUInstruction gpuinst = inst instanceof GPUInstruction ? (GPUInstruction)inst : null;
        ArrayList<MutablePair<LineageItem, LineageCacheEntry>> liList = null;
        LineageItem lineageItem = cinst != null ? ec.getLineageItem(cinst.output) : (cfinst != null ? ec.getLineageItem(cfinst.output) : (instLI = cspinst != null ? ec.getLineageItem(cspinst.output) : ec.getLineageItem(gpuinst._output)));
        if (inst instanceof MultiReturnBuiltinCPInstruction) {
            liList = new ArrayList();
            MultiReturnBuiltinCPInstruction mrInst = (MultiReturnBuiltinCPInstruction)inst;
            for (int i = 0; i < mrInst.getNumOutputs(); ++i) {
                String opcode = instLI.getOpcode() + String.valueOf(i);
                liList.add((MutablePair<LineageItem, LineageCacheEntry>)MutablePair.of((Object)new LineageItem(opcode, instLI.getInputs()), null));
            }
        } else {
            liList = List.of(MutablePair.of((Object)instLI, null));
        }
        return liList;
    }

    private static String getOutputName(Instruction inst, LineageItem li) {
        ComputationCPInstruction cinst = inst instanceof ComputationCPInstruction ? (ComputationCPInstruction)inst : null;
        ComputationFEDInstruction cfinst = inst instanceof ComputationFEDInstruction ? (ComputationFEDInstruction)inst : null;
        ComputationSPInstruction cspinst = inst instanceof ComputationSPInstruction ? (ComputationSPInstruction)inst : null;
        GPUInstruction gpuinst = inst instanceof GPUInstruction ? (GPUInstruction)inst : null;
        String outName = null;
        if (inst instanceof MultiReturnBuiltinCPInstruction) {
            outName = ((MultiReturnBuiltinCPInstruction)inst).getOutput(li.getOpcode().charAt(li.getOpcode().length() - 1) - 48).getName();
        } else if (inst instanceof ComputationCPInstruction) {
            outName = cinst.output.getName();
        } else if (inst instanceof ComputationFEDInstruction) {
            outName = cfinst.output.getName();
        } else if (inst instanceof ComputationSPInstruction) {
            outName = cspinst.output.getName();
        } else if (inst instanceof GPUInstruction) {
            outName = gpuinst._output.getName();
        }
        return outName;
    }

    private static boolean allInputsSpark(Instruction inst, ExecutionContext ec) {
        CPOperand in1 = ((ComputationSPInstruction)inst).input1;
        CPOperand in2 = ((ComputationSPInstruction)inst).input2;
        CPOperand in3 = ((ComputationSPInstruction)inst).input3;
        if (in1 != null && !in1.isMatrix() || in2 != null && !in2.isMatrix() || in3 != null && !in3.isMatrix()) {
            return false;
        }
        if (in1 != null && (!ec.getMatrixObject(in1.getName()).hasRDDHandle() || ec.getMatrixObject(in1.getName()).hasBroadcastHandle())) {
            return false;
        }
        if (in2 != null && (!ec.getMatrixObject(in2.getName()).hasRDDHandle() || ec.getMatrixObject(in2.getName()).hasBroadcastHandle())) {
            return false;
        }
        return in3 == null || ec.getMatrixObject(in3.getName()).hasRDDHandle() && !ec.getMatrixObject(in3.getName()).hasBroadcastHandle();
    }

    private static void maintainReuseStatistics(ExecutionContext ec, Instruction inst, LineageCacheEntry e) {
        if (!DMLScript.STATISTICS) {
            return;
        }
        LineageCacheStatistics.incrementSavedComputeTime(e._computeTime);
        if (e.isGPUObject()) {
            LineageCacheStatistics.incrementGpuHits();
        }
        if (inst.getOpcode().equals(Opcodes.PREFETCH.toString()) && DMLScript.USE_ACCELERATOR) {
            LineageCacheStatistics.incrementGpuPrefetch();
        }
        if (e.isRDDPersist()) {
            if (SparkExecutionContext.isRDDCached(e.getRDDObject().getRDD().id())) {
                LineageCacheStatistics.incrementRDDPersistHits();
            } else {
                LineageCacheStatistics.incrementRDDHits();
            }
        }
        if (e.isMatrixValue() || e.isScalarValue()) {
            if (inst instanceof ComputationSPInstruction || inst.getOpcode().equals(Opcodes.PREFETCH.toString()) && !DMLScript.USE_ACCELERATOR) {
                LineageCacheStatistics.incrementSparkCollectHits();
            } else {
                LineageCacheStatistics.incrementInstHits();
            }
        }
    }

    static {
        LineageCacheEviction.setCacheLimit(0.05);
        LineageCacheEviction.setStartTimestamp();
    }
}

