/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.random;

import java.util.Random;
import org.apache.spark.util.random.GapSampling$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001-4QAE\n\u0001/uA\u0001b\n\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\tY\u0001\u0011\t\u0011)A\u0005[!AA\u0007\u0001B\u0001B\u0003%\u0011\u0006C\u00036\u0001\u0011\u0005a\u0007C\u0004=\u0001\t\u0007I\u0011B\u001f\t\ry\u0002\u0001\u0015!\u0003*\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u001d!\u0005\u00011A\u0005\n\u0015CqA\u0012\u0001A\u0002\u0013%q\t\u0003\u0004N\u0001\u0001\u0006K!\u0011\u0005\u0006\u001d\u0002!IaT\u0004\t!N\t\t\u0011#\u0001\u0018#\u001aA!cEA\u0001\u0012\u00039\"\u000bC\u00036\u001b\u0011\u00051\u000bC\u0004U\u001bE\u0005I\u0011A+\t\u000f\u0001l\u0011\u0013!C\u0001C\"91-DA\u0001\n\u0013!'aC$baN\u000bW\u000e\u001d7j]\u001eT!\u0001F\u000b\u0002\rI\fg\u000eZ8n\u0015\t1r#\u0001\u0003vi&d'B\u0001\r\u001a\u0003\u0015\u0019\b/\u0019:l\u0015\tQ2$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00029\u0005\u0019qN]4\u0014\u0007\u0001qB\u0005\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VM\u001a\t\u0003?\u0015J!A\n\u0011\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0003\u0019\u001c\u0001\u0001\u0005\u0002 U%\u00111\u0006\t\u0002\u0007\t>,(\r\\3\u0002\u0007Itw\r\u0005\u0002/e5\tqF\u0003\u0002\u0017a)\t\u0011'\u0001\u0003kCZ\f\u0017BA\u001a0\u0005\u0019\u0011\u0016M\u001c3p[\u00069Q\r]:jY>t\u0017A\u0002\u001fj]&$h\b\u0006\u00038siZ\u0004C\u0001\u001d\u0001\u001b\u0005\u0019\u0002\"B\u0014\u0005\u0001\u0004I\u0003b\u0002\u0017\u0005!\u0003\u0005\r!\f\u0005\bi\u0011\u0001\n\u00111\u0001*\u0003\rag.]\u000b\u0002S\u0005!AN\\9!\u0003\u0019\u0019\u0018-\u001c9mKR\t\u0011\t\u0005\u0002 \u0005&\u00111\t\t\u0002\u0004\u0013:$\u0018\u0001E2pk:$hi\u001c:Ee>\u0004\b/\u001b8h+\u0005\t\u0015\u0001F2pk:$hi\u001c:Ee>\u0004\b/\u001b8h?\u0012*\u0017\u000f\u0006\u0002I\u0017B\u0011q$S\u0005\u0003\u0015\u0002\u0012A!\u00168ji\"9A*CA\u0001\u0002\u0004\t\u0015a\u0001=%c\u0005\t2m\\;oi\u001a{'\u000f\u0012:paBLgn\u001a\u0011\u0002\u000f\u0005$g/\u00198dKR\t\u0001*A\u0006HCB\u001c\u0016-\u001c9mS:<\u0007C\u0001\u001d\u000e'\ria\u0004\n\u000b\u0002#\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\u0012A\u0016\u0016\u0003[][\u0013\u0001\u0017\t\u00033zk\u0011A\u0017\u0006\u00037r\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005u\u0003\u0013AC1o]>$\u0018\r^5p]&\u0011qL\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'F\u0001cU\tIs+A\u0006sK\u0006$'+Z:pYZ,G#A3\u0011\u0005\u0019LW\"A4\u000b\u0005!\u0004\u0014\u0001\u00027b]\u001eL!A[4\u0003\r=\u0013'.Z2u\u0001")
public class GapSampling
implements Serializable {
    private final double f;
    private final Random rng;
    private final double epsilon;
    private final double lnq;
    private int countForDropping;

    public static double $lessinit$greater$default$3() {
        return GapSampling$.MODULE$.$lessinit$greater$default$3();
    }

    public static Random $lessinit$greater$default$2() {
        return GapSampling$.MODULE$.$lessinit$greater$default$2();
    }

    private double lnq() {
        return this.lnq;
    }

    public int sample() {
        if (this.countForDropping() > 0) {
            this.countForDropping_$eq(this.countForDropping() - 1);
            return 0;
        }
        this.advance();
        return 1;
    }

    private int countForDropping() {
        return this.countForDropping;
    }

    private void countForDropping_$eq(int x$1) {
        this.countForDropping = x$1;
    }

    private void advance() {
        double u = package$.MODULE$.max(this.rng.nextDouble(), this.epsilon);
        this.countForDropping_$eq((int)(package$.MODULE$.log(u) / this.lnq()));
    }

    public GapSampling(double f, Random rng, double epsilon) {
        this.f = f;
        this.rng = rng;
        this.epsilon = epsilon;
        Predef$.MODULE$.require(f > 0.0 && f < 1.0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(56).append("Sampling fraction (").append($this.f).append(") must reside on open interval (0, 1)").toString());
        Predef$.MODULE$.require(epsilon > 0.0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(22).append("epsilon (").append($this.epsilon).append(") must be > 0").toString());
        this.lnq = package$.MODULE$.log1p(-f);
        this.countForDropping = 0;
        this.advance();
    }
}

