/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.BitSetArray;
import org.apache.sysds.runtime.frame.data.columns.DoubleArray;
import org.apache.sysds.runtime.frame.data.columns.FloatArray;
import org.apache.sysds.runtime.frame.data.columns.HashMapToInt;
import org.apache.sysds.runtime.frame.data.lib.FrameUtil;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderRecode;
import org.apache.sysds.utils.MemoryEstimates;

public class StringArray
extends Array<String> {
    private String[] _data;
    private long materializedSize = -1L;

    private StringArray(int nRow) {
        this(new String[nRow]);
    }

    public StringArray(String[] data) {
        super(data.length);
        this._data = data;
    }

    private StringArray(String[] data, long materializedSize) {
        this(data);
        this.materializedSize = materializedSize;
    }

    public String[] get() {
        return this._data;
    }

    @Override
    public String get(int index) {
        return this._data[index];
    }

    @Override
    public void set(int index, String value) {
        this._data[index] = value;
        this.materializedSize = -1L;
    }

    @Override
    public void set(int index, double value) {
        this._data[index] = Double.toString(value);
        this.materializedSize = -1L;
    }

    @Override
    public void setFromOtherType(int rl, int ru, Array<?> value) {
        for (int i = rl; i <= ru; ++i) {
            Object v = value.get(i);
            this._data[i] = v != null ? v.toString() : null;
        }
        this.materializedSize = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(int rl, int ru, Array<String> value, int rlSrc) {
        try {
            System.arraycopy(value.get(), rlSrc, this._data, rl, ru - rl + 1);
        }
        catch (Exception e) {
            super.set(rl, ru, value, rlSrc);
        }
        finally {
            this.materializedSize = -1L;
        }
    }

    @Override
    public void setNz(int rl, int ru, Array<String> value) {
        String[] data2 = ((StringArray)value)._data;
        for (int i = rl; i <= ru; ++i) {
            if (data2[i] == null) continue;
            this._data[i] = data2[i];
        }
        this.materializedSize = -1L;
    }

    @Override
    public void setFromOtherTypeNz(int rl, int ru, Array<?> value) {
        for (int i = rl; i <= ru; ++i) {
            Object v = value.get(i);
            if (v == null) continue;
            this._data[i] = v.toString();
        }
        this.materializedSize = -1L;
    }

    @Override
    public void append(String value) {
        if (this._data.length <= this._size) {
            this._data = Arrays.copyOf(this._data, this.newSize());
        }
        this._data[this._size++] = value;
        this.materializedSize = -1L;
    }

    @Override
    public Array<String> append(Array<String> other) {
        int endSize = this._size + other.size();
        String[] ret = new String[endSize];
        System.arraycopy(this._data, 0, ret, 0, this._size);
        System.arraycopy(other.get(), 0, ret, this._size, other.size());
        return new StringArray(ret);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(ArrayFactory.FrameArrayType.STRING.ordinal());
        out.writeLong(this.getInMemorySize());
        for (int i = 0; i < this._size; ++i) {
            out.writeUTF(this._data[i] != null ? this._data[i] : "");
        }
    }

    public void readFields(DataInput in) throws IOException {
        this._size = this._data.length;
        this.materializedSize = in.readLong();
        for (int i = 0; i < this._size; ++i) {
            String tmp = in.readUTF();
            this._data[i] = tmp.isEmpty() ? null : tmp;
        }
    }

    protected static StringArray read(DataInput in, int nRow) throws IOException {
        StringArray arr = new StringArray(nRow);
        arr.readFields(in);
        return arr;
    }

    @Override
    public Array<String> clone() {
        return new StringArray(Arrays.copyOf(this._data, this._size), this.materializedSize);
    }

    @Override
    public Array<String> slice(int rl, int ru) {
        return new StringArray(Arrays.copyOfRange(this._data, rl, ru));
    }

    @Override
    public void reset(int size) {
        if (this._data.length < size || this._data.length > 2 * size) {
            this._data = new String[size];
        } else {
            for (int i = 0; i < size; ++i) {
                this._data[i] = null;
            }
        }
        this._size = size;
        this.materializedSize = -1L;
    }

    @Override
    public byte[] getAsByteArray() {
        throw new NotImplementedException("Not Implemented getAsByte for string");
    }

    public byte[] getIndexAsBytes(int r) {
        if (this._data[r] != null) {
            return this._data[r].getBytes();
        }
        return null;
    }

    @Override
    public Types.ValueType getValueType() {
        return Types.ValueType.STRING;
    }

    @Override
    public Pair<Types.ValueType, Boolean> analyzeValueType(int maxCells) {
        Types.ValueType state = Types.ValueType.UNKNOWN;
        boolean nulls = false;
        for (int i = 0; i < Math.min(maxCells, this._size); ++i) {
            Types.ValueType c = FrameUtil.isType(this._data[i], state);
            if (c == Types.ValueType.STRING) {
                return new Pair<Types.ValueType, Boolean>(Types.ValueType.STRING, false);
            }
            if (c == Types.ValueType.UNKNOWN) {
                nulls = true;
                continue;
            }
            state = Types.ValueType.getHighestCommonTypeSafe(state, c);
        }
        return new Pair<Types.ValueType, Boolean>(state, nulls);
    }

    @Override
    public ArrayFactory.FrameArrayType getFrameArrayType() {
        return ArrayFactory.FrameArrayType.STRING;
    }

    @Override
    public BitSetArray getNulls() {
        BitSetArray n = new BitSetArray(this._size);
        for (int i = 0; i < this._size; ++i) {
            if (this._data[i] == null) continue;
            n.set(i, true);
        }
        return n;
    }

    @Override
    public long getInMemorySize() {
        if (this.materializedSize != -1L) {
            return this.materializedSize;
        }
        long size = super.getInMemorySize();
        size = (long)((double)size + MemoryEstimates.stringArrayCost(this._data));
        this.materializedSize = size += 8L;
        return this.materializedSize;
    }

    @Override
    public long getExactSerializedSize() {
        long si = 9L;
        for (String s : this._data) {
            si += (long)IOUtilFunctions.getUTFSize(s);
        }
        return si;
    }

    @Override
    protected Array<Boolean> changeTypeBitSet(Array<Boolean> ret, int rl, int ru) {
        String firstNN = this._data[rl];
        int i = rl + 1;
        while (firstNN == null && i < ru) {
            firstNN = this._data[i++];
        }
        if (firstNN == null) {
            return ret;
        }
        if (firstNN.toLowerCase().equals("true") || firstNN.toLowerCase().equals("false")) {
            return this.changeTypeBooleanStandardBitSet(ret, rl, ru);
        }
        if (firstNN.equals("0") || firstNN.equals("1") || firstNN.equals("1.0") || firstNN.equals("0.0")) {
            return this.changeTypeBooleanNumericBitSet(ret, rl, ru);
        }
        if (firstNN.toLowerCase().equals("t") || firstNN.toLowerCase().equals("f")) {
            return this.changeTypeBooleanCharacterBitSet(ret, rl, ru);
        }
        throw new DMLRuntimeException("Not supported type of Strings to change to Booleans value: " + firstNN);
    }

    @Override
    protected Array<Boolean> changeTypeBoolean(Array<Boolean> ret, int rl, int ru) {
        String firstNN = this._data[rl];
        int i = rl + 1;
        while (firstNN == null && i < ru) {
            firstNN = this._data[i++];
        }
        if (firstNN == null) {
            return ret;
        }
        if (firstNN.toLowerCase().equals("true") || firstNN.toLowerCase().equals("false")) {
            return this.changeTypeBooleanStandardArray(ret, rl, ru);
        }
        if (firstNN.equals("0") || firstNN.equals("1") || firstNN.equals("1.0") || firstNN.equals("0.0")) {
            return this.changeTypeBooleanNumericArray(ret, rl, ru);
        }
        if (firstNN.toLowerCase().equals("t") || firstNN.toLowerCase().equals("f")) {
            return this.changeTypeBooleanCharacterArray(ret, rl, ru);
        }
        throw new DMLRuntimeException("Not supported type of Strings to change to Booleans value: " + firstNN);
    }

    protected Array<Boolean> changeTypeBooleanStandardBitSet(Array<Boolean> ret, int rl, int ru) {
        for (int i = rl; i < ru; ++i) {
            String s = this._data[i];
            if (s == null) continue;
            ret.set(i, Boolean.parseBoolean(s));
        }
        return ret;
    }

    protected Array<Boolean> changeTypeBooleanStandardArray(Array<Boolean> retA, int rl, int ru) {
        for (int i = rl; i < ru; ++i) {
            String s = this._data[i];
            if (s == null) continue;
            retA.set(i, Boolean.parseBoolean(s));
        }
        return retA;
    }

    protected Array<Boolean> changeTypeBooleanCharacterBitSet(Array<Boolean> ret, int rl, int ru) {
        for (int i = rl; i < ru; ++i) {
            String s = this._data[i];
            if (s == null) continue;
            if (this.isTrueCharacter(s.charAt(0))) {
                ret.set(i, true);
                continue;
            }
            if (this.isFalseCharacter(s.charAt(0))) {
                ret.set(i, false);
                continue;
            }
            throw new DMLRuntimeException("Unable to change to Boolean from String array, value: " + s);
        }
        return ret;
    }

    protected Array<Boolean> changeTypeBooleanCharacterArray(Array<Boolean> retA, int rl, int ru) {
        for (int i = rl; i < ru; ++i) {
            String s = this._data[i];
            if (s == null) continue;
            if (this.isTrueCharacter(s.charAt(0))) {
                retA.set(i, true);
                continue;
            }
            if (this.isFalseCharacter(s.charAt(0))) {
                retA.set(i, false);
                continue;
            }
            throw new DMLRuntimeException("Unable to change to Boolean from String array, value: " + s);
        }
        return retA;
    }

    private boolean isTrueCharacter(char a) {
        return a == 'T' || a == 't';
    }

    private boolean isFalseCharacter(char a) {
        return a == 'F' || a == 'f';
    }

    protected Array<Boolean> changeTypeBooleanNumericBitSet(Array<Boolean> ret, int rl, int ru) {
        for (int i = rl; i < ru; ++i) {
            boolean one;
            boolean zero;
            String s = this._data[i];
            if (s == null) continue;
            if (s.length() > 1) {
                zero = s.equals("0.0");
                if (zero | (one = s.equals("1.0"))) {
                    ret.set(i, one);
                    continue;
                }
                throw new DMLRuntimeException("Unable to change to Boolean from String array, value: " + s);
            }
            zero = s.charAt(0) == '0';
            boolean bl = one = s.charAt(0) == '1';
            if (zero | one) {
                ret.set(i, one);
                continue;
            }
            throw new DMLRuntimeException("Unable to change to Boolean from String array, value: " + s);
        }
        return ret;
    }

    protected Array<Boolean> changeTypeBooleanNumericArray(Array<Boolean> retA, int rl, int ru) {
        for (int i = rl; i < ru; ++i) {
            boolean one;
            boolean zero;
            String s = this._data[i];
            if (s == null) continue;
            if (s.length() > 1) {
                zero = s.equals("0.0");
                if (zero | (one = s.equals("1.0"))) {
                    retA.set(i, one);
                    continue;
                }
                throw new DMLRuntimeException("Unable to change to Boolean from String array, value: " + s);
            }
            zero = s.charAt(0) == '0';
            boolean bl = one = s.charAt(0) == '1';
            if (zero | one) {
                retA.set(i, one);
                continue;
            }
            throw new DMLRuntimeException("Unable to change to Boolean from String array, value: " + s);
        }
        return retA;
    }

    @Override
    protected Array<Double> changeTypeDouble(Array<Double> retA, int l, int u) {
        try {
            for (int i = l; i < u; ++i) {
                retA.set(i, DoubleArray.parseDouble(this._data[i]));
            }
            return retA;
        }
        catch (Exception e) {
            Pair<Types.ValueType, Boolean> t = this.analyzeValueType();
            if (t.getKey() != Types.ValueType.BOOLEAN) {
                throw e;
            }
            this.changeType(Types.ValueType.BOOLEAN).changeType(retA, l, u);
            return retA;
        }
    }

    @Override
    protected Array<Float> changeTypeFloat(Array<Float> retA, int l, int u) {
        for (int i = l; i < u; ++i) {
            retA.set(i, (double)FloatArray.parseFloat(this._data[i]));
        }
        return retA;
    }

    @Override
    protected Array<Integer> changeTypeInteger(Array<Integer> retA, int l, int u) {
        String firstNN = this._data[l];
        int i = l + 1;
        while (firstNN == null && i < u) {
            firstNN = this._data[i++];
        }
        if (firstNN == null) {
            return retA;
        }
        if (firstNN.contains(".")) {
            this.changeTypeIntegerFloatString(retA, l, u);
        } else {
            this.changeTypeIntegerNormal(retA, l, u);
        }
        return retA;
    }

    protected void changeTypeIntegerFloatString(Array<Integer> ret, int l, int u) {
        for (int i = l; i < u; ++i) {
            String s = this._data[i];
            if (s == null) continue;
            ret.set(i, (double)this.parseSignificantFloat(s));
        }
    }

    protected int parseSignificantFloat(String s) {
        boolean isNegative;
        int len = s.length();
        int v = 0;
        if (len == 0) {
            return v;
        }
        int c = 0;
        char ch = s.charAt(c);
        boolean bl = isNegative = ch == '-';
        if (isNegative || ch == '+') {
            // empty if block
        }
        do {
            int n = ++c;
            ++c;
            ch = s.charAt(n);
            int cc = ch - 48;
            if (ch == '.') break;
            if (cc >= 10) {
                throw new NumberFormatException(s);
            }
            v = 10 * v + cc;
        } while (c < len);
        while (c < len) {
            if (s.charAt(c) != '0') {
                throw new NumberFormatException(s);
            }
            ++c;
        }
        return isNegative ? -v : v;
    }

    protected void changeTypeIntegerNormal(Array<Integer> ret, int l, int u) {
        for (int i = l; i < u; ++i) {
            String s = this._data[i];
            if (s == null) continue;
            ret.set(i, (double)this.parseInt(s));
        }
    }

    protected int parseInt(String s) {
        boolean isNegative;
        int len = s.length();
        int v = 0;
        if (len == 0) {
            return v;
        }
        int c = 0;
        char ch = s.charAt(c);
        boolean bl = isNegative = ch == '-';
        if (isNegative || ch == '+') {
            // empty if block
        }
        do {
            int n = ++c;
            ++c;
            ch = s.charAt(n);
            int cc = ch - 48;
            if (cc >= 10) {
                throw new NumberFormatException(s);
            }
            v = 10 * v + cc;
        } while (c < len);
        return isNegative ? -v : v;
    }

    @Override
    protected Array<Long> changeTypeLong(Array<Long> retA, int l, int u) {
        for (int i = l; i < u; ++i) {
            String s = this._data[i];
            if (s == null) continue;
            retA.set(i, (double)Long.parseLong(s));
        }
        return retA;
    }

    @Override
    protected Array<Object> changeTypeHash64(Array<Object> retA, int l, int u) {
        for (int i = l; i < u; ++i) {
            retA.set(i, this._data[i]);
        }
        return retA;
    }

    @Override
    protected Array<Object> changeTypeHash32(Array<Object> retA, int l, int u) {
        for (int i = l; i < u; ++i) {
            retA.set(i, this._data[i]);
        }
        return retA;
    }

    @Override
    public Array<Character> changeTypeCharacter(Array<Character> retA, int l, int u) {
        for (int i = l; i < u; ++i) {
            String s = this._data[i];
            if (s == null) continue;
            retA.set(i, (double)s.charAt(0));
        }
        return retA;
    }

    @Override
    public Array<String> changeTypeString(Array<String> retA, int l, int u) {
        String[] ret = (String[])retA.get();
        for (int i = l; i < u; ++i) {
            ret[i] = this._data[i];
        }
        return retA;
    }

    @Override
    public Pair<Integer, Integer> getMinMaxLength() {
        int minLength = Integer.MAX_VALUE;
        int maxLength = 0;
        for (int i = 0; i < this._size; ++i) {
            if (this._data[i] == null) continue;
            int l = this._data[i].length();
            minLength = minLength < l ? minLength : l;
            maxLength = maxLength > l ? maxLength : l;
        }
        return new Pair<Integer, Integer>(minLength, maxLength);
    }

    @Override
    public void fill(String value) {
        Arrays.fill(this._data, value);
        this.materializedSize = -1L;
    }

    @Override
    public double getAsDouble(int i) {
        if (this._data[i] != null && !this._data[i].isEmpty()) {
            return StringArray.getAsDouble(this._data[i]);
        }
        return 0.0;
    }

    @Override
    public double getAsNaNDouble(int i) {
        if (this._data[i] != null && !this._data[i].isEmpty()) {
            return StringArray.getAsDouble(this._data[i]);
        }
        return Double.NaN;
    }

    private static double getAsDouble(String s) {
        try {
            return DoubleArray.parseDouble(s);
        }
        catch (Exception e) {
            String ls = s.toLowerCase();
            if (ls.equals("true") || ls.equals("t")) {
                return 1.0;
            }
            if (ls.equals("false") || ls.equals("f")) {
                return 0.0;
            }
            throw new DMLRuntimeException("Unable to change to double: " + s, e);
        }
    }

    @Override
    public boolean isShallowSerialize() {
        long s = this.getInMemorySize();
        return this._size < 100 || s / (long)this._size < 256L;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this._size; ++i) {
            if (this._data[i] == null || this._data[i].equals("0")) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsNull() {
        for (int i = 0; i < this._size; ++i) {
            if (this._data[i] != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Array<String> select(int[] indices) {
        String[] ret = new String[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            ret[i] = this._data[indices[i]];
        }
        return new StringArray(ret);
    }

    @Override
    public Array<String> select(boolean[] select, int nTrue) {
        String[] ret = new String[nTrue];
        int k = 0;
        for (int i = 0; i < select.length; ++i) {
            if (!select[i]) continue;
            ret[k++] = this._data[i];
        }
        return new StringArray(ret);
    }

    @Override
    public final boolean isNotEmpty(int i) {
        return this._data[i] != null && !this._data[i].equals("0");
    }

    @Override
    protected HashMapToInt<String> createRecodeMap(int estimate, ExecutorService pool, int k) throws InterruptedException, ExecutionException {
        try {
            HashMapToInt<String> map = new HashMapToInt<String>((int)Math.min((long)estimate * 2L, (long)this.size()));
            for (int i = 0; i < this.size(); ++i) {
                String val = this.get(i);
                if (val == null) continue;
                String[] tmp = ColumnEncoderRecode.splitRecodeMapEntry(val.toString());
                map.put(tmp[0], Integer.parseInt(tmp[1]));
            }
            return map;
        }
        catch (Exception e) {
            return super.createRecodeMap(estimate, pool, k);
        }
    }

    @Override
    public double hashDouble(int idx) {
        if (this._data[idx] != null) {
            return this._data[idx].hashCode();
        }
        return Double.NaN;
    }

    @Override
    public boolean equals(Array<String> other) {
        if (other instanceof StringArray) {
            return Arrays.equals(this._data, ((StringArray)other)._data);
        }
        return false;
    }

    @Override
    public boolean possiblyContainsNaN() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this._size * 5 + 2);
        sb.append(super.toString() + ":[");
        for (int i = 0; i < this._size - 1; ++i) {
            sb.append(this._data[i] + ",");
        }
        sb.append(this._data[this._size - 1]);
        sb.append("]");
        return sb.toString();
    }
}

