/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.renderers;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Set;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.annotations.Scope;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.ObjectRenderer;

@Scope(value="perthread")
public class LocationRenderer
implements ObjectRenderer<Location> {
    private static final int RANGE = 5;
    private final Set<Location> rendered = CollectionFactory.newSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Location location, MarkupWriter writer) {
        writer.write(location.toString());
        if (this.rendered.contains(location)) {
            return;
        }
        this.rendered.add(location);
        Resource r = location.getResource();
        int line = location.getLine();
        if (line <= 0) {
            return;
        }
        if (!r.exists()) {
            return;
        }
        int start = line - 5;
        int end = line + 5;
        writer.element("table", "class", "t-location-outer");
        LineNumberReader reader = null;
        try {
            String input;
            InputStream is = r.openStream();
            InputStreamReader isr = new InputStreamReader(is);
            reader = new LineNumberReader(new BufferedReader(isr));
            while ((input = reader.readLine()) != null) {
                int current = reader.getLineNumber();
                if (current < start) continue;
                if (current > end) break;
                writer.element("tr", new Object[0]);
                writer.element("td", "class", "t-location-line");
                if (line == current) {
                    writer.getElement().attribute("class", "t-location-current");
                }
                writer.write(Integer.toString(current));
                writer.end();
                Element td = writer.element("td", "class", "t-location-content");
                if (line == current) {
                    td.attribute("class", "t-location-current");
                }
                if (start == current) {
                    td.attribute("class", "t-location-content-first");
                }
                writer.write(input);
                writer.end();
                writer.end();
            }
            reader.close();
            reader = null;
            InternalUtils.close((Closeable)reader);
        }
        catch (IOException ex) {
            writer.write(ex.toString());
        }
        finally {
            InternalUtils.close(reader);
        }
        writer.end();
    }
}

