/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import org.apache.tapestry5.ioc.IOOperation;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.ComponentRequestFilter;
import org.apache.tapestry5.services.ComponentRequestHandler;
import org.apache.tapestry5.services.PageRenderRequestParameters;
import org.apache.tapestry5.services.Request;

public class DeferredResponseRenderer
implements ComponentRequestFilter {
    private final Request request;
    private final OperationTracker tracker;

    public DeferredResponseRenderer(Request request, OperationTracker tracker) {
        this.request = request;
        this.tracker = tracker;
    }

    @Override
    public void handleComponentEvent(ComponentEventRequestParameters parameters, ComponentRequestHandler handler) throws IOException {
        handler.handleComponentEvent(parameters);
        this.invokeQueuedRenderer();
    }

    @Override
    public void handlePageRender(PageRenderRequestParameters parameters, ComponentRequestHandler handler) throws IOException {
        handler.handlePageRender(parameters);
        this.invokeQueuedRenderer();
    }

    private void invokeQueuedRenderer() throws IOException {
        IOOperation responseRenderer;
        while ((responseRenderer = (IOOperation)this.request.getAttribute("tapestry.response-renderer")) != null) {
            this.request.setAttribute("tapestry.response-renderer", null);
            this.tracker.perform("Executing deferred response renderer.", responseRenderer);
        }
    }
}

