/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import org.apache.tapestry5.services.ComponentEventLinkEncoder;
import org.apache.tapestry5.services.ComponentRequestHandler;
import org.apache.tapestry5.services.Dispatcher;
import org.apache.tapestry5.services.PageRenderRequestParameters;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Response;

public class PageRenderDispatcher
implements Dispatcher {
    private final ComponentRequestHandler componentRequestHandler;
    private final ComponentEventLinkEncoder linkEncoder;

    public PageRenderDispatcher(ComponentRequestHandler componentRequestHandler, ComponentEventLinkEncoder linkEncoder) {
        this.componentRequestHandler = componentRequestHandler;
        this.linkEncoder = linkEncoder;
    }

    @Override
    public boolean dispatch(Request request, Response response) throws IOException {
        if (request.getAttribute("tapestry.referenced-component-not-found") != null) {
            request.setAttribute("tapestry.referenced-component-not-found", null);
            return false;
        }
        PageRenderRequestParameters parameters = this.linkEncoder.decodePageRenderRequest(request);
        if (parameters == null) {
            return false;
        }
        this.componentRequestHandler.handlePageRender(parameters);
        return true;
    }
}

