/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.electric.database

import com.sun.electric.database.id.PortProtoId
import com.sun.electric.tool.Job
import com.sun.electric.util.collections.ArrayIterator
import com.sun.electric.util.collections.ImmutableArrayList
import java.lang.ref.SoftReference
import java.util.Arrays
import java.util.Collections
import scala.collection.JavaConverters._

object CellRevisionS {
  val LOW_BITS = 6
  val LOW_SIZE = 1 << LOW_BITS
  val LOW_MASK = LOW_SIZE - 1
  val emptyBlock = new Array[AnyRef](LOW_SIZE)
  val emptyBlocks = Array.empty[Array[AnyRef]]

  private[database] class BlockBuffer {
    var hasKilledObjs = false
    val newObjs = new Array[List[ImmutableElectricObject]](LOW_SIZE)
    var i = 0
    while (i < newObjs.size) {
      newObjs(i) = List.empty[ImmutableElectricObject]
      i += 1
    }
  }
}

private[database] class CellRevisionS(
  d : ImmutableCell,
  nodes : ImmutableNodeInst.Iterable,
  nodeIndex : Array[Int],
  arcs : ImmutableArcInst.Iterable,
  arcIndex : Array[Int],
  exports : ImmutableExport.Iterable,
  exportIndex : Array[Int],
  techUsages : java.util.BitSet,
  cellUsages : Array[CellUsageInfo],
  definedExports : java.util.BitSet,
  definedExportsLength : Int,
  deletedExports : java.util.BitSet) extends
CellRevision(
  d,
  nodes, nodeIndex,
  arcs, arcIndex,
  exports, exportIndex,
  techUsages, cellUsages,
  definedExports, definedExportsLength, deletedExports) {

  @volatile var nodeConnectionsRef = new SoftReference[Array[Array[AnyRef]]](null)
  
  def this(d: ImmutableCell) {
    this(d, CellRevision.getProvider().createNodeList(ImmutableNodeInst.NULL_ARRAY, null), CellRevision.NULL_INT_ARRAY,
         CellRevision.getProvider().createArcList(ImmutableArcInst.NULL_ARRAY, null), CellRevision.NULL_INT_ARRAY,
         CellRevision.getProvider().createExportList(ImmutableExport.NULL_ARRAY, null), CellRevision.NULL_INT_ARRAY,
         CellRevision.makeTechUsages(d.techId), CellRevision.NULL_CELL_USAGE_INFO_ARRAY, CellRevision.EMPTY_BITSET, 0, CellRevision.EMPTY_BITSET);
    if (d.techId == null) {
      throw new NullPointerException("techId");
    }
  }
  import CellRevisionS._
  
  /**
   * Method to return a list of arcs connected to speciefed or all ports of
   * specified ImmutableNodeInst.
   * @param headEnds true if i-th arc connects by head end
   * @param n specified ImmutableNodeInst
   * @param portId specified port or null
   * @return a List of connected ImmutableArcInsts
   */
  def getConnections(headEnds: java.util.BitSet, n: ImmutableNodeInst, portId: PortProtoId): java.util.List[ImmutableArcInst] = {
    if (portId == null) return getConnections(headEnds, n)
    getNodeInfo(n.nodeId) match {
      case nc: NodeConnections => nc.getConnections(headEnds, portId) 
      case a: ImmutableArcInst =>
        if (portId.externalId.isEmpty) {
          if (headEnds != null) {
            headEnds.clear()
            if (a.headNodeId == n.nodeId && a.headPortId == portId) headEnds.set(0)
          }
          Collections.singletonList[ImmutableArcInst](a)
        } else {
          if (headEnds != null) headEnds.clear(); Collections.emptyList[ImmutableArcInst]
        }
      case pc: PortConns =>
        if (portId.externalId.isEmpty) {
          pc.getConnections(headEnds, n.nodeId, portId)
        } else {
          if (headEnds != null) headEnds.clear(); Collections.emptyList[ImmutableArcInst]
        }
      case _ => if (headEnds != null) headEnds.clear(); Collections.emptyList[ImmutableArcInst]
    }
  }
  
  def getConnections(headEnds: java.util.BitSet, n: ImmutableNodeInst): java.util.List[ImmutableArcInst] = {
    getNodeInfo(n.nodeId) match {
      case nc: NodeConnections => nc.getConnections(headEnds)
      case a: ImmutableArcInst =>
        if (headEnds != null) {
          headEnds.clear()
          if (a.headNodeId == n.nodeId && a.headPortId.externalId.isEmpty) headEnds.set(0)
        }
        Collections.singletonList[ImmutableArcInst](a)
      case pc: PortConns => pc.getConnections(headEnds, n.nodeId, n.protoId.newPortId(""))
      case _ => if (headEnds != null) headEnds.clear(); Collections.emptyList[ImmutableArcInst]
    }
  }

  /**
   * Returns true of there are Connections on specified ImmutableNodeInst
   * connected either to specified port or to all ports
   * @param n specified ImmutableNodeInst
   * @param portId specified port or null
   * @return true if there are Connections on specified ImmutableNodeInst amd specified port.
   */
  def hasConnections(n: ImmutableNodeInst, portId: PortProtoId): Boolean = {
    if (portId == null) return hasConnections(n)
    getNodeInfo(n.nodeId) match {
      case nc: NodeConnections => nc.hasConnections(portId)
      case a: ImmutableArcInst => portId.externalId.isEmpty
      case pc: PortConns => portId.externalId.isEmpty && pc.hasConnections
      case _ => false
    }
  }

  def hasConnections(n: ImmutableNodeInst): Boolean = {
    getNodeInfo(n.nodeId) match {
      case nc: NodeConnections => nc.hasConnections
      case a: ImmutableArcInst => true
      case pc: PortConns => pc.hasConnections
      case _ => false
    }
  }

  /**
   * Method to return the number of Connections on specified ImmutableNodeInst.
   * @param n specified ImmutableNodeInst
   * @return the number of Connections on specified ImmutableNodeInst.
   */
  def getNumConnections(n: ImmutableNodeInst): Int = {
    getNodeInfo(n.nodeId) match {
      case nc: NodeConnections => nc.getNumConnections
      case a: ImmutableArcInst => 1
      case pc: PortConns => pc.getNumConnections
      case _ => 0
    }
  }

  /**
   * Returns true of there are Exports on specified NodeInst.
   * @param originalNode specified NodeInst.
   * @return true if there are Exports on specified NodeInst.
   */
  def hasExportsOnNode(originalNode: ImmutableNodeInst): Boolean = {
    getNodeInfo(originalNode.nodeId) match {
      case nc: NodeConnections => nc.hasExportsOnNode
      case e: ImmutableExport => true
      case pc: PortConns => pc.hasExportsOnPort
      case _ => false
    }
  }

  /**
   * Method to return the number of Exports on specified NodeInst.
   * @param originalNodeId nodeId of specified NodeInst.
   * @return the number of Exports on specified NodeInst.
   */
  def getNumExportsOnNode(originalNodeId: Int): Int = {
    getNodeInfo(originalNodeId) match {
      case nc: NodeConnections => nc.getNumExportsOnNode
      case e: ImmutableExport => 1
      case pc: PortConns => pc.getNumExportsOnPort
      case _ => 0
    }
  }

  /**
   * Method to return an Iterator over all ImmutableExports on specified NodeInst.
   * @param originalNodeId nodeId of specified NodeInst.
   * @return an Iterator over all ImmutableExports on specified NodeInst.
   */
  def getExportsOnNode(originalNodeId: Int): java.util.Iterator[ImmutableExport] = {
    getNodeInfo(originalNodeId) match {
      case nc: NodeConnections => nc.getExportsOnNode
      case e: ImmutableExport => java.util.Collections.singletonList(e).iterator
      case pc: PortConns => pc.getExportsOnPort
      case _ => ArrayIterator.emptyIterator[ImmutableExport]
    }
  }

  private def getNodeInfo(nodeId: Int): AnyRef = {
    require(if (nodeIndex != null) nodeIndex(nodeId) >= 0 else nodeId < nodes.size)
    val connections = nodeConnectionsRef.get
    if (connections != null)
      connections(nodeId >> LOW_BITS)(nodeId & LOW_MASK)
    else
      makeNodeInfo(nodeId)
  }
  
  private def makeNodeInfo(nodeId: Int): AnyRef = {
    val numBlocks = (getMaxNodeId >> LOW_BITS) + 1
    val blockBuffers = allocBlockBuffers(getMaxNodeId)
    val ita = arcs.iterator
    while (ita.hasNext) {
      newArc(blockBuffers, ita.next)
    }
    val ite = exports.iterator
    while (ite.hasNext) {
      newExport(blockBuffers, ite.next)
    }
    updateBlocks(null, blockBuffers, emptyBlocks)(nodeId >> LOW_BITS)(nodeId & LOW_MASK)
  }
  
  def lowLevelWith (
    d: ImmutableCell,
    nodes: ImmutableNodeInst.Iterable, nodeIndex: Array[Int],
    arcs: ImmutableArcInst.Iterable, arcIndex: Array[Int],
    exports: ImmutableExport.Iterable, exportIndex: Array[Int],
    techUsages: java.util.BitSet,
    cellUsages: Array[CellUsageInfo],
    definedExports: java.util.BitSet, definedExportsLength: Int, deletedExports: java.util.BitSet)
  : CellRevision = {
    val newCellRevision = new CellRevisionS(
      d,
      nodes, nodeIndex,
      arcs, arcIndex,
      exports, exportIndex,
      techUsages, cellUsages,
      definedExports, definedExportsLength, deletedExports)
    val oldBlocks = nodeConnectionsRef.get
    if (oldBlocks != null && d.cellId == this.d.cellId) { // Don't reuse connectivity after rename after rename
      val killedConnectivity = scala.collection.mutable.Map[Int,List[ImmutableElectricObject]]()
      val maxNodeId = newCellRevision.getMaxNodeId
      val blockBuffers = allocBlockBuffers(maxNodeId)
      def putKilled(nodeId: Int, obj: ImmutableElectricObject) {
        val buf = getBuffer(blockBuffers, nodeId)
        if (newCellRevision.getNodeById(nodeId) != null) {
          val list = killedConnectivity.getOrElse(nodeId, List[ImmutableElectricObject]())
          killedConnectivity.put(nodeId, obj :: list)
          buf.hasKilledObjs = true
        }
      }
      val maxArcId = this.getMaxArcId max newCellRevision.getMaxArcId
      var arcId = 0
      while (arcId <= maxArcId) {
        val oldA = this.getArcById(arcId)
        val newA = newCellRevision.getArcById(arcId)
        if (oldA != newA) {
          if (oldA != null) {
            putKilled(oldA.tailNodeId, oldA)
            if (oldA.headNodeId != oldA.tailNodeId) putKilled(oldA.headNodeId, oldA)
          }
          newArc(blockBuffers, newA)
        }
        arcId += 1
      }
      val maxChronIndex = this.getMaxExportChronIndex max newCellRevision.getMaxExportChronIndex
      val cellId = d.cellId
      assert(newCellRevision.d.cellId == cellId)
      var chronIndex = 0
      while (chronIndex <= maxChronIndex) {
        val exportId = cellId.getPortId(chronIndex)
        val oldE = this.getExport(exportId)
        val newE = newCellRevision.getExport(exportId)
        if (oldE != newE) {
          if (oldE != null) putKilled(oldE.originalNodeId, oldE)
          newExport(blockBuffers, newE)
        }
        chronIndex += 1
      }
      newCellRevision.updateBlocks(killedConnectivity, blockBuffers, oldBlocks)
    }
    newCellRevision
  }
  
  private def updateBlocks(
    killedConnectivity: scala.collection.Map[Int,List[ImmutableElectricObject]],
    blockBuffers: Array[BlockBuffer],
    oldBlocks: Array[Array[AnyRef]]): Array[Array[AnyRef]] = {
    val newBlocks = new Array[Array[AnyRef]](blockBuffers.length)
    val conComparator = new java.util.Comparator[Int] {
      def compare(con1: Int, con2: Int): Int = {
        val a1 = getArcById(con1 >> 1)
        val a2 = getArcById(con2 >> 1)
        val end1 = (con1 & 1) != 0
        val end2 = (con2 & 1) != 0
        val nodeId1 = if (end1) a1.headNodeId else a1.tailNodeId
        val nodeId2 = if (end2) a2.headNodeId else a2.tailNodeId
        assert(nodeId1 == nodeId2)
        val portId1 = if (end1) a1.headPortId else a1.tailPortId
        val portId2 = if (end2) a2.headPortId else a2.tailPortId
        if (portId1.chronIndex < portId2.chronIndex) return -1
        if (portId1.chronIndex > portId2.chronIndex) return +1
        if (con1 < con2) return -1
        if (con1 > con2) return +1
        return 0
      }
    }
    val expComparator = new java.util.Comparator[ImmutableExport] {
      def compare(e1: ImmutableExport, e2: ImmutableExport) = {
        assert(e1.originalNodeId == e2.originalNodeId)
        if (e1.originalPortId.chronIndex < e2.originalPortId.chronIndex) -1
        else if (e1.originalPortId.chronIndex > e2.originalPortId.chronIndex) +1
        else if (e1.exportId.chronIndex < e2.exportId.chronIndex) -1
        else if (e1.exportId.chronIndex > e2.exportId.chronIndex) +1
        else 0
      }
    }
//    val killedArcsC = new Array[Int](CellRevisionS.LOW_SIZE)
//    var killedArcs = new Array[ImmutableArcInst](4)
//    var killedExports = new Array[ImmutableExport](4)
//    var newArcs = new Array[ImmutableArcInst](CellRevisionS.LOW_SIZE)
//    var newExports = new Array[ImmutableExport](CellRevisionS.LOW_SIZE)
//    var changed = newBlocks.length != oldBlocks.length
    for (bi <- 0 until newBlocks.length) {
      val oldBlock = if (bi < oldBlocks.size) oldBlocks(bi) else emptyBlock
      val bb = blockBuffers(bi)
      newBlocks(bi) = if (bb == null) oldBlock else {
        val newBlock = new Array[AnyRef](LOW_SIZE)
        var newBlockIsEmpty = true
        for (i <- 0 until LOW_SIZE) {
          val nodeId = (bi << LOW_BITS) + i
          val nodeInfo = oldBlock(i)
          val newObjs = bb.newObjs(i)
          val killedList = if (bb.hasKilledObjs) killedConnectivity.getOrElse(nodeId, null) else null
          val n = getNodeById(nodeId)
          newBlock(i) =
            if (n == null) {
              null
            } else if (newObjs.isEmpty && killedList == null) {
              if (nodeInfo != null) newBlockIsEmpty = false
              nodeInfo
            } else {
              val newCons = new java.util.ArrayList[Int]
              val newExports = new java.util.ArrayList[ImmutableExport]
              val killed: Set[AnyRef] = if (killedList != null) killedList.toSet else Set.empty
              nodeInfo match {
                case nc: NodeConnections =>
                  val arcs = nc.getArcs
                  val arcEnds = nc.getArcEnds
                  var connIndex = 0
                  while (connIndex < arcs.size) {
                    val a = arcs(connIndex)
                    if (!killed(a)) {
                      val arcId = a.arcId
                      newCons.add(if (arcEnds.get(connIndex)) (arcId << 1) | 1 else (arcId << 1))
                    }
                    connIndex += 1
                  }
                  for (e <- nc.getExports) {
                    if (!killed(e))
                      newExports.add(e)
                  }
                case a: ImmutableArcInst =>
                  if (killed.isEmpty) {
                    val end = a.headNodeId == nodeId && a.headPortId.externalId.isEmpty
                    newCons.add(if (end) (a.arcId << 1) | 1 else (a.arcId << 1))
                  } else {
                    assert(killed(a) && killed.size == 1)
                  }
                case e: ImmutableExport =>
                  if (killed.isEmpty) {
                    newExports.add(e)
                  } else {
                    assert(killed(e) && killed.size == 1)
                  }
                case pc: PortConns =>
                  if (pc.hasConnections) {
                    val arcHeads = new java.util.BitSet
                    val arcs = pc.getConnections(arcHeads, nodeId, n.protoId.newPortId(""))
                    var connIndex = 0
                    while (connIndex < arcs.size) {
                      val a = arcs.get(connIndex)
                      if (!killed(a)) {
                        val arcId = a.arcId
                        newCons.add(if (arcHeads.get(connIndex)) (arcId << 1) | 1 else (arcId << 1))
                      }
                      connIndex += 1
                    }
                  }
                  if (pc.hasExportsOnPort) {
                    val eit = pc.getExportsOnPort
                    while (eit.hasNext) {
                      val e = eit.next()
                      if (!killed(e)) {
                        newExports.add(e)
                      }
                    }
                  }
                case null =>
              }
              if (!newObjs.isEmpty) {
                for (o <- newObjs) {
                  o match {
                    case a: ImmutableArcInst =>
                      if (a.tailNodeId == nodeId)
                        newCons.add(a.arcId << 1)
                      if (a.headNodeId  == nodeId)
                        newCons.add((a.arcId << 1) | 1)
                    case e: ImmutableExport =>
                      newExports.add(e)
                  }
                }
              }
              var onEmptyPort = true
              var withoutLoops = true
              if (newCons.isEmpty && newExports.isEmpty) null else {
                val (bArcs: Array[ImmutableArcInst], bArcHeads: java.util.BitSet) =
                  if (newCons.isEmpty) {
                    (ImmutableArcInst.NULL_ARRAY, CellRevision.EMPTY_BITSET)
                  } else if (newCons.size == 1) {
                    val con = newCons.get(0)
                    val a = getArcById(con >> 1)
                    withoutLoops = withoutLoops && (a.tailNodeId != a.headNodeId || a.tailPortId != a.headPortId)
                    if ((con & 1) != 0) {
                      onEmptyPort = onEmptyPort && a.headPortId.externalId.isEmpty
                      val bs = new java.util.BitSet
                      bs.set(0)
                      (Array[ImmutableArcInst](a), bs)
                    } else {
                      onEmptyPort = onEmptyPort && a.tailPortId.externalId.isEmpty
                      (Array[ImmutableArcInst](a), CellRevision.EMPTY_BITSET)
                    }
                  } else {
                    java.util.Collections.sort(newCons, conComparator)
                    val arr = new Array[ImmutableArcInst](newCons.size)
                    val bs = new java.util.BitSet
                    var j = 0
                    while (j < newCons.size) {
                      val con = newCons.get(j)
                      val a = getArcById(con >> 1)
                      arr(j) = a
                      withoutLoops = withoutLoops && (a.tailNodeId != a.headNodeId || a.tailPortId != a.headPortId)
                      if ((con & 1) != 0) {
                        bs.set(j)
                        onEmptyPort = onEmptyPort && a.headPortId.externalId.isEmpty
                      } else {
                        onEmptyPort = onEmptyPort && a.tailPortId.externalId.isEmpty
                      }
                      j += 1
                    }
                    (arr, if (bs.isEmpty) CellRevision.EMPTY_BITSET else bs)
                  }
                val bExports =
                  if (newExports.isEmpty) { ImmutableExport.NULL_ARRAY
                  } else if (newExports.size == 1) {
                    val e = newExports.get(0)
                    onEmptyPort = onEmptyPort && e.originalPortId.externalId.isEmpty
                    Array[ImmutableExport](e)
                  } else {
                    java.util.Collections.sort(newExports, expComparator)
                    onEmptyPort = onEmptyPort && newExports.asScala.forall(_.originalPortId.externalId.isEmpty)
                    newExports.toArray(ImmutableExport.NULL_ARRAY)
                  }
                newBlockIsEmpty = false
                if (!onEmptyPort) {
                  new NodeConnections(bArcs, bArcHeads, bExports)
                } else if (withoutLoops) {
                  bExports.length match {
                    case 0 => 
                      bArcs.length match {
                        case 1 => bArcs(0)
                        case 2 => new PortConA2E0(bArcs(0), bArcs(1))
                        case 3 => new PortConA3E0(bArcs(0), bArcs(1), bArcs(2))
                        case _ => new PortConANE0(bArcs)
                      }
                    case 1 =>
                      bArcs.length match {
                        case 0 => bExports(0)
                        case 1 => new PortConA1E1(bArcs(0), bExports(0))
                        case 2 => new PortConA2E1(bArcs(0), bArcs(1), bExports(0))
                        case 3 => new PortConA3E1(bArcs(0), bArcs(1), bArcs(2), bExports(0))
                        case _ => new PortConANE1(bArcs, bExports(0))
                      }
                    case _ =>
                      new PortConANEN(bArcs, bExports)
                  }
                } else {
                  new PortConALEN(bArcs, bArcHeads, bExports)
                }
              }
            }
        }
        if (newBlockIsEmpty) emptyBlock else newBlock
      } 
    }
    nodeConnectionsRef = new SoftReference(newBlocks)
    if (Job.getDebug) check()
    newBlocks
  }
  
  private def allocBlockBuffers(maxNodeId: Int) = new Array[BlockBuffer]((maxNodeId >> LOW_BITS) + 1)

  private def newArc(blockBuffers: Array[BlockBuffer], newA: ImmutableArcInst) {
    if (newA != null) {
      val tb = getBuffer(blockBuffers, newA.tailNodeId)
      val ti = newA.tailNodeId & LOW_MASK
      tb.newObjs(ti) = newA :: tb.newObjs(ti) 
      if (newA.headNodeId != newA.tailNodeId) {
        val hb = getBuffer(blockBuffers, newA.headNodeId)
        val hi = newA.headNodeId & LOW_MASK
        hb.newObjs(hi) = newA :: hb.newObjs(hi) 
      }
    }
  }
  
  private def newExport(blockBuffers: Array[BlockBuffer], newE: ImmutableExport) {
    if (newE != null) {
      val ob = getBuffer(blockBuffers, newE.originalNodeId)
      val oi = newE.originalNodeId & LOW_MASK
      ob.newObjs(oi) = newE :: ob.newObjs(oi) 
    }
  }
  
  private def getBuffer(blockBuffers: Array[BlockBuffer], nodeId: Int): BlockBuffer = {
    val bi = nodeId >> LOW_BITS
    val b = blockBuffers(bi)
    if (b != null) b else {
      val newB = new BlockBuffer
      blockBuffers(bi) = newB
      newB
    }
  }
  
  override def check {
    super.check
    val blocks = nodeConnectionsRef.get
    if (blocks != null) {
      assert(blocks.size == (getMaxNodeId >> LOW_BITS) + 1)
      for (bi <- 0 until blocks.size) {
        val b = blocks(bi)
        if (!(b eq emptyBlock)) {
          var nonNull = false
          var i = 0
          while (i < LOW_SIZE) {
            if (b(i) != null) {
              assert(getNodeById((bi << LOW_BITS) + i) != null)
              nonNull = true
            }
            i += 1
          }
          assert(nonNull)
        }
      }
      assert(blocks.forall(b => (b eq emptyBlock) || b.exists(_ != null)))
      val maxConnectedPortInst = new Array[Int](getMaxNodeId + 1)
      def updatePortInst(nodeId: Int, protoId: PortProtoId) {
        maxConnectedPortInst(nodeId) = maxConnectedPortInst(nodeId) max (protoId.chronIndex + 1)
      }
      for (a <- arcs.asScala) {
        updatePortInst(a.tailNodeId, a.tailPortId)
        updatePortInst(a.headNodeId, a.headPortId)
      }
      for (e <- exports.asScala) {
        updatePortInst(e.originalNodeId, e.originalPortId)
      }
      case class Conn(a: ImmutableArcInst, end: Boolean)
      val conns = new Array[Array[List[Conn]]](getMaxNodeId + 1)
      val exps = new Array[Array[List[ImmutableExport]]](getMaxNodeId + 1)
      for (nodeId <- 0 to getMaxNodeId) {
        val m = maxConnectedPortInst(nodeId)
        if (m > 0) {
          conns(nodeId) = Array.fill(m)(List.empty)
          exps(nodeId) = Array.fill(m)(List.empty)
        }
      }
      for (arcId <- 0 to getMaxArcId) {
        val a = getArcById(arcId)
        if (a != null) {
          val tc = conns(a.tailNodeId)
          val ti = a.tailPortId.chronIndex
          tc(ti) = Conn(a, false) :: tc(ti)
          val hc = conns(a.headNodeId)
          val hi = a.headPortId.chronIndex
          hc(hi) = Conn(a, true) :: hc(hi)
        }
      }
      val cellId = d.cellId
      for (chronIndex <- 0 to getMaxExportChronIndex) {
        val e = getExport(cellId.getPortId(chronIndex))
        if (e != null) {
          val ec = exps(e.originalNodeId)
          val ei = e.originalPortId.chronIndex
          ec(ei) = e :: ec(ei)
        }
      }
      for (n <- nodes.asScala) {
        val nodeId = n.nodeId
//        if (getNodeInfo(nodeId).isInstanceOf[PortConALEN]) {
//          System.err.println("PortConALEN " + nodeId + " " + n.name)
//          System.err.println("getNumExports="+getNumExportsOnNode(n.nodeId))
//          System.err.println("hasExportsOnNode="+hasExportsOnNode(n))
//          val exports = getExportsOnNode(n.nodeId)
//          while (exports.hasNext) {
//            val e = exports.next
//            System.err.println(" "+e.name)
//          } 
//        }
        val cn = conns(nodeId)
        val ex = exps(nodeId)
        val maxChronIndex = if (cn != null) cn.length - 1 else -1
        val arcHeads = new java.util.BitSet
        val arcs = getConnections(arcHeads, n)
        assert(arcs == getConnections(null, n))
        assert(arcHeads.length <= arcs.size)
        assert(getNumConnections(n) == arcs.size)
        assert(hasConnections(n) == !arcs.isEmpty)
        val exports = getExportsOnNode(n.nodeId)
        assert(hasExportsOnNode(n) == exports.hasNext)
        assert(maxChronIndex == (if (ex != null) ex.length - 1 else -1))
        var ci = 0
        var ei = 0
        for (chronIndex <- 0 to maxChronIndex) {
          val portProtoId = n.protoId.getPortId(chronIndex)
          val arcHeadsP = new java.util.BitSet
          val arcsP = getConnections(arcHeadsP, n, portProtoId)
          assert(arcsP == getConnections(null, n, portProtoId))
          assert(arcHeadsP.length <= arcsP.size)
          assert(hasConnections(n, portProtoId) == !arcsP.isEmpty)
          var ciP = 0
          for (Conn(a, end) <- cn(chronIndex).reverse) {
            assert(a == arcs.get(ci) && end == arcHeads.get(ci))
            assert(a == arcsP.get(ciP) && end == arcHeadsP.get(ciP))
            ci += 1
            ciP += 1
          }
          for (e <- ex(chronIndex).reverse) {
            assert(e == exports.next())
            ei += 1
          }
        }
        assert(ci == arcs.size)
        assert(!exports.hasNext)
        assert(getNumExportsOnNode(n.nodeId) == ei)
      }
    }
  }
}

private[database] class NodeConnections(arcs: Array[ImmutableArcInst], arcEnds: java.util.BitSet, exports: Array[ImmutableExport]) {

  private[database] def getArcs = arcs
  private[database] def getArcEnds = arcEnds
  private[database] def getExports = exports
  
  def getConnections(headEnds: java.util.BitSet): java.util.List[ImmutableArcInst] = {
    if (headEnds != null) {
      headEnds.clear()
      headEnds.or(arcEnds)
    }
    if (!arcs.isEmpty) new ImmutableArrayList(arcs) else java.util.Collections.emptyList[ImmutableArcInst]
  }
    
  def getConnections(headEnds: java.util.BitSet, portId: PortProtoId): java.util.List[ImmutableArcInst] = {
    val chronIndex = portId.chronIndex
    val i = searchConnectionByPort(chronIndex)
    var j = i;
    while (j < arcs.length && portId == (if (arcEnds.get(j)) arcs(j).headPortId else arcs(j).tailPortId)) {
      j += 1
    }
    if (headEnds != null) {
      headEnds.clear()
      var k = i
      while (k < j) {
        if (arcEnds.get(k)) headEnds.set(k - i)
        k += 1
      }
    }
    if (i < j) new ImmutableArrayList(arcs, i, j) else java.util.Collections.emptyList[ImmutableArcInst]
  }
    
  /**
   * Returns true of there are Connections on specified ImmutableNodeInst
   * connected to all ports
   * @return true if there are Connections on specified ImmutableNodeInst amd specified port.
   */
  def hasConnections: Boolean = !arcs.isEmpty
    
  /**
   * Returns true of there are Connections on specified ImmutableNodeInst
   * connected either to specified port
   * @param portId specified port
   * @return true if there are Connections on specified ImmutableNodeInst amd specified port.
   */
  def hasConnections(portId: PortProtoId): Boolean = {
    val i = searchConnectionByPort(portId.chronIndex)
    i < arcs.length && {
      val a = arcs(i)
      val end = arcEnds.get(i)
      portId == (if (end) a.headPortId else a.tailPortId)
    } 
  }
    
  /**
   * Method to return the number of Connections on specified ImmutableNodeInst.
   * @return the number of Connections on specified ImmutableNodeInst.
   */
  def getNumConnections: Int = arcs.size

  private def searchConnectionByPort(chronIndex: Int): Int = {
    var low = 0
    var high = arcs.length - 1
    while (low <= high) {
      val mid = (low + high) >> 1 // try in a middle
      val a = arcs(mid)
      val end = arcEnds.get(mid)
      val portId = if (end) a.headPortId else a.tailPortId
      val cmp = portId.getChronIndex() - chronIndex

      if (cmp < 0) {
        low = mid + 1
      } else {
        high = mid - 1
      }
    }
    low
  }
    
  /**
   * Returns true of there are Exports on specified NodeInst.
   * @param originalNode specified NodeInst.
   * @return true if there are Exports on specified NodeInst.
   */
  def hasExportsOnNode: Boolean = !exports.isEmpty

  /**
   * Method to return the number of Exports on specified NodeInst.
   * @return the number of Exports on specified NodeInst.
   */
  def getNumExportsOnNode: Int = exports.size

  /**
   * Method to return an Iterator over all ImmutableExports on specified NodeInst.
   * @return an Iterator over all ImmutableExports on specified NodeInst.
   */
  def getExportsOnNode: java.util.Iterator[ImmutableExport] = ArrayIterator.iterator(exports)

}

private[database] abstract class PortConns {
  def getConnections(headEnds: java.util.BitSet, nodeId: Int, portId: PortProtoId): java.util.List[ImmutableArcInst] = {
    val list = getConnections
    if (headEnds != null) {
      headEnds.clear()
      var i = 0
      while (i < list.size) {
        val a = list.get(i)
        if (a.headNodeId == nodeId && a.headPortId == portId) {
          headEnds.set(i)
          assert(a.tailNodeId != nodeId || a.tailPortId != portId)
        }
        i += 1
      }
    }
    list
  }
  
  def getConnections: java.util.List[ImmutableArcInst]
  /**
   * Returns true of there are Connections on specified PortInst
   * @return true if there are Connections on specified PortInst
   */
  def hasConnections: Boolean
  /**
   * Method to return the number of Connections on specified PortInst.
   * @return the number of Connections on specified ImmutableNodeInst.
   */
  def getNumConnections: Int
  /**
   * Returns true of there are Exports on specified PortInst.
   * @return true if there are Exports on specified PorteInst.
   */
  def hasExportsOnPort: Boolean

  /**
   * Method to return the number of Exports on specified PortInst.
   * @return the number of Exports on specified NodeInst.
   */
  def getNumExportsOnPort: Int

  /**
   * Method to return an Iterator over all ImmutableExports on specified NodeInst.
   * @return an Iterator over all ImmutableExports on specified NodeInst.
   */
  def getExportsOnPort: java.util.Iterator[ImmutableExport]
}

private[database] trait PortConA0 extends PortConns {
  def hasConnections = false
  def getNumConnections = 0
  def getConnections = Collections.emptyList[ImmutableArcInst]
}

private[database] trait PortConA1 extends PortConns {
  val a0: ImmutableArcInst
  def hasConnections = true
  def getNumConnections = 1
  def getConnections = Collections.singletonList[ImmutableArcInst](a0)
}

private[database] trait PortConA2 extends PortConns {
  val a0: ImmutableArcInst
  val a1: ImmutableArcInst
  def hasConnections = true
  def getNumConnections = 2
  def getConnections = Arrays.asList[ImmutableArcInst](a0, a1)
}

private[database] trait PortConA3 extends PortConns {
  val a0: ImmutableArcInst
  val a1: ImmutableArcInst
  val a2: ImmutableArcInst
  def hasConnections = true
  def getNumConnections = 3
  def getConnections = Arrays.asList[ImmutableArcInst](a0, a1, a2)
}

private[database] trait PortConAN extends PortConns {
  val arcs: Array[ImmutableArcInst]
  def hasConnections = true
  def getNumConnections = arcs.length
  def getConnections = new ImmutableArrayList[ImmutableArcInst](arcs)
}

private[database] trait PortConAL extends PortConAN {
  val arcEnds: java.util.BitSet
  override def getConnections(headEnds: java.util.BitSet, nodeId: Int, portId: PortProtoId) = {
    if (headEnds != null) { headEnds.clear(); headEnds.or(arcEnds) }
    getConnections
  }
}

private[database] trait PortConE0 extends PortConns {
  def hasExportsOnPort = false
  def getNumExportsOnPort = 0
  def getExportsOnPort = ArrayIterator.emptyIterator[ImmutableExport]
}

private[database] trait PortConE1 extends PortConns {
  val e: ImmutableExport
  def hasExportsOnPort = true
  def getNumExportsOnPort = 1
  def getExportsOnPort = java.util.Collections.singleton(e).iterator
}

private[database] trait PortConEN extends PortConns {
  val exports: Array[ImmutableExport]
  def hasExportsOnPort = true
  def getNumExportsOnPort = exports.size
  def getExportsOnPort = ArrayIterator.iterator(exports)
}

private[database] class PortConA2E0(
  val a0: ImmutableArcInst,
  val a1: ImmutableArcInst
) extends PortConns with PortConA2 with PortConE0

private[database] class PortConA3E0(
  val a0: ImmutableArcInst,
  val a1: ImmutableArcInst,
  val a2: ImmutableArcInst
) extends PortConns with PortConA3 with PortConE0

private[database] class PortConANE0(
  val arcs: Array[ImmutableArcInst]
) extends PortConns with PortConAN with PortConE0

private[database] class PortConA1E1(
  val a0: ImmutableArcInst,
  val e: ImmutableExport
) extends PortConns with PortConA1 with PortConE1

private[database] class PortConA2E1(
  val a0: ImmutableArcInst,
  val a1: ImmutableArcInst,
  val e: ImmutableExport
) extends PortConns with PortConA2 with PortConE1

private[database] class PortConA3E1(
  val a0: ImmutableArcInst,
  val a1: ImmutableArcInst,
  val a2: ImmutableArcInst,
  val e: ImmutableExport
) extends PortConns with PortConA3 with PortConE1

private[database] class PortConANE1(
  val arcs: Array[ImmutableArcInst],
  val e: ImmutableExport
) extends PortConns with PortConAN with PortConE1

private[database] class PortConANEN(
  val arcs: Array[ImmutableArcInst],
  val exports: Array[ImmutableExport]
) extends PortConns with PortConAN with PortConEN

private[database] class PortConALEN (
  val arcs: Array[ImmutableArcInst],
  val arcEnds: java.util.BitSet,
  val exports: Array[ImmutableExport]
) extends PortConns with PortConAL with PortConEN {
  override def hasExportsOnPort = !exports.isEmpty
}
