/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import java.awt.geom.AffineTransform;
import java.util.HashMap;

public class Orientation {
    private final short jAngle;
    private final short jOctant;
    private final boolean jMirrorX;
    private final boolean jMirrorY;
    private final String jString;
    private final short cAngle;
    private final boolean cTranspose;
    private final Orientation inverse;
    private final AffineTransform trans;
    private static final HashMap map;
    private static final Orientation[] map45;
    private static final int OCTANT = 7;
    private static final int XMIRROR45 = 8;
    private static final int YMIRROR45 = 16;
    public static final Orientation IDENT;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Orientation(int jAngle, boolean jMirrorX, boolean jMirrorY, Orientation inverse) {
        if (!($assertionsDisabled || 0 <= jAngle && jAngle < 3600)) {
            throw new AssertionError();
        }
        this.jAngle = (short)jAngle;
        this.jOctant = (short)(jAngle % 450 == 0 ? jAngle / 450 : -1);
        this.jMirrorX = jMirrorX;
        this.jMirrorY = jMirrorY;
        int cAngle = jAngle;
        boolean cTranspose = false;
        if (jMirrorX) {
            if (jMirrorY) {
                cAngle = (cAngle + 1800) % 3600;
            } else {
                cAngle = (cAngle + 900) % 3600;
                cTranspose = true;
            }
        } else if (jMirrorY) {
            cAngle = (cAngle + 2700) % 3600;
            cTranspose = true;
        }
        this.cAngle = (short)cAngle;
        this.cTranspose = cTranspose;
        if (inverse == null) {
            inverse = cTranspose || jAngle == 0 || jAngle == 1800 ? this : new Orientation(3600 - jAngle, jMirrorX, jMirrorY, this);
        }
        this.inverse = inverse;
        double[] matrix = new double[4];
        double alpha = (double)jAngle * Math.PI / 1800.0;
        matrix[0] = Math.cos(alpha) * (double)(jMirrorX ? -1 : 1);
        matrix[1] = Math.sin(alpha) * (double)(jMirrorY ? -1 : 1);
        matrix[2] = Math.sin(alpha) * (double)(jMirrorX ? 1 : -1);
        matrix[3] = Math.cos(alpha) * (double)(jMirrorX ? -1 : 1);
        if (jAngle % 900 == 0) {
            for (int i = 0; i < matrix.length; ++i) {
                matrix[i] = Math.round(matrix[i]);
            }
        }
        this.trans = new AffineTransform(matrix);
        String s = "";
        if (jMirrorX) {
            s = s + 'X';
        }
        if (jMirrorY) {
            s = s + 'Y';
        }
        while (jAngle >= 900) {
            s = s + 'R';
            jAngle -= 900;
        }
        if (jAngle != 0) {
            s = s + jAngle;
        }
        this.jString = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Orientation fromJava(int jAngle, boolean jMirrorX, boolean jMirrorY) {
        Orientation orient;
        if (jAngle % 450 == 0) {
            int index = jAngle / 450 & 7;
            if (jMirrorX) {
                index |= 8;
            }
            if (jMirrorY) {
                index |= 0x10;
            }
            return map45[index];
        }
        if ((jAngle %= 3600) < 0) {
            jAngle += 3600;
        }
        int index = 0;
        if (jMirrorX) {
            index += 3600;
        }
        if (jMirrorY) {
            index += 7200;
        }
        Integer key = new Integer(index + jAngle);
        HashMap hashMap = map;
        synchronized (hashMap) {
            orient = (Orientation)map.get(key);
            if (orient == null) {
                orient = new Orientation(jAngle, jMirrorX, jMirrorY, null);
                map.put(key, orient);
                if (orient.inverse != orient) {
                    key = new Integer(index + 3600 - jAngle);
                    map.put(key, orient);
                }
            }
        }
        return orient;
    }

    public static Orientation fromC(int cAngle, boolean cTranspose) {
        return Orientation.fromJava(cTranspose ? cAngle % 3600 + 900 : cAngle, false, cTranspose);
    }

    public Orientation getConcatenate(Orientation that) {
        boolean mirrorX = this.jMirrorX ^ that.jMirrorX;
        boolean mirrorY = this.jMirrorX ^ that.jMirrorX;
        int angle = mirrorX ^ mirrorY ? that.jAngle - this.jAngle : this.jAngle + that.jAngle;
        return Orientation.fromJava(angle, mirrorX, mirrorY);
    }

    public Orientation getPreConcatenate(Orientation that) {
        boolean mirrorX = this.jMirrorX ^ that.jMirrorX;
        boolean mirrorY = this.jMirrorX ^ that.jMirrorX;
        int angle = mirrorX ^ mirrorY ? this.jAngle - that.jAngle : this.jAngle + that.jAngle;
        return Orientation.fromJava(angle, mirrorX, mirrorY);
    }

    public int getCAngle() {
        return this.cAngle;
    }

    public boolean isCTranspose() {
        return this.cTranspose;
    }

    public int getAngle() {
        return this.jAngle;
    }

    public boolean isXMirrored() {
        return this.jMirrorX;
    }

    public boolean isYMirrored() {
        return this.jMirrorY;
    }

    public String toJelibString() {
        return this.jString;
    }

    public String toString() {
        return this.toJelibString();
    }

    static {
        $assertionsDisabled = !Orientation.class.desiredAssertionStatus();
        map = new HashMap();
        Orientation[] m = new Orientation[32];
        for (int i = 0; i < m.length; ++i) {
            Orientation orient;
            int octant = i & 7;
            boolean jMirrorX = (i & 8) != 0;
            boolean jMirrorY = (i & 0x10) != 0;
            m[i] = orient = new Orientation(octant * 450, jMirrorX, jMirrorY, null);
            if (orient.inverse == orient) continue;
            m[i + 8 - octant * 2] = orient.inverse;
        }
        map45 = m;
        IDENT = Orientation.fromJava(0, false, false);
    }
}

