/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.EModelessDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class Change
extends EModelessDialog
implements HighlightListener {
    private static final int CHANGE_SELECTED = 1;
    private static final int CHANGE_CONNECTED = 2;
    private static final int CHANGE_CELL = 3;
    private static final int CHANGE_LIBRARY = 4;
    private static final int CHANGE_EVERYWHERE = 5;
    private static Change theDialog = null;
    private static boolean lastChangeNodesWithArcs = false;
    private static boolean lastIgnorePortNames = false;
    private static boolean lastAllowMissingPorts = false;
    private static int whatToChange = 1;
    private static String libSelected = null;
    private List<Geometric> geomsToChange;
    private JList changeList;
    private DefaultListModel changeListModel;
    private List<NodeProto> changeNodeProtoList;
    private EditWindow wnd;
    private static final Pattern dummyName = Pattern.compile("(.*?)FROM(.*?)\\{(.*)");
    private boolean dontReload = false;
    private JCheckBox allowMissingPorts;
    private JButton apply;
    private JRadioButton changeConnected;
    private JRadioButton changeEverywhere;
    private JRadioButton changeInCell;
    private JRadioButton changeInLibrary;
    private JCheckBox changeNodesWithArcs;
    private ButtonGroup changeOption;
    private JRadioButton changeSelected;
    private JButton done;
    private JCheckBox ignorePortNames;
    private JLabel jLabel1;
    private JComboBox librariesPopup;
    private JScrollPane listPane;
    private JCheckBox showCells;
    private JCheckBox showPrimitives;

    public static void showChangeDialog() {
        if (Client.getOperatingSystem() == Client.OS.UNIX && theDialog != null) {
            theDialog.closeDialog(null);
        }
        if (theDialog == null) {
            TopLevel jf = null;
            if (TopLevel.isMDIMode()) {
                jf = TopLevel.getCurrentJFrame();
            }
            theDialog = new Change(jf);
        }
        theDialog.loadInfo(true);
        theDialog.setVisible(true);
        theDialog.toFront();
    }

    private Change(Frame parent) {
        super(parent, false);
        this.initComponents();
        this.changeListModel = new DefaultListModel();
        this.changeList = new JList(this.changeListModel);
        this.changeList.setSelectionMode(0);
        this.listPane.setViewportView(this.changeList);
        this.changeNodeProtoList = new ArrayList<NodeProto>();
        this.changeList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Change.this.apply(null);
                }
            }
        });
        List<Library> libList = Library.getVisibleLibraries();
        int curIndex = libList.indexOf(Library.getCurrent());
        for (Library lib : libList) {
            this.librariesPopup.addItem(lib.getName());
            if (!lib.getName().equals(libSelected)) continue;
            curIndex = -1;
            this.librariesPopup.setSelectedItem(libSelected);
        }
        if (curIndex >= 0) {
            this.librariesPopup.setSelectedIndex(curIndex);
        }
        this.librariesPopup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.reload(false);
            }
        });
        this.ignorePortNames.setSelected(lastIgnorePortNames);
        this.allowMissingPorts.setSelected(lastAllowMissingPorts);
        this.ignorePortNames.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.rememberState();
            }
        });
        this.allowMissingPorts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.rememberState();
            }
        });
        this.showPrimitives.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.reload(false);
            }
        });
        this.showCells.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.reload(false);
            }
        });
        this.changeNodesWithArcs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.reload(false);
            }
        });
        this.changeSelected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        this.changeConnected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        this.changeInCell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        this.changeInLibrary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        this.changeEverywhere.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        switch (whatToChange) {
            case 1: {
                this.changeSelected.setSelected(true);
                break;
            }
            case 2: {
                this.changeConnected.setSelected(true);
                break;
            }
            case 3: {
                this.changeInCell.setSelected(true);
                break;
            }
            case 4: {
                this.changeInLibrary.setSelected(true);
                break;
            }
            case 5: {
                this.changeEverywhere.setSelected(true);
            }
        }
        this.finishInitialization();
        Highlighter.addHighlightListener(this);
    }

    public void highlightChanged(Highlighter which) {
        if (!this.isVisible()) {
            return;
        }
        this.loadInfo(true);
    }

    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
        if (!this.isVisible()) {
            return;
        }
        this.loadInfo(false);
    }

    protected void escapePressed() {
        this.done(null);
    }

    private void whatToChangeChanged(ActionEvent evt) {
        JRadioButton src = (JRadioButton)evt.getSource();
        if (src == this.changeSelected) {
            whatToChange = 1;
        } else if (src == this.changeConnected) {
            whatToChange = 2;
        } else if (src == this.changeInCell) {
            whatToChange = 3;
        } else if (src == this.changeInLibrary) {
            whatToChange = 4;
        } else if (src == this.changeEverywhere) {
            whatToChange = 5;
        }
        Geometric geomToChange = this.geomsToChange.get(0);
        if (whatToChange == 5) {
            if (geomToChange instanceof ArcInst) {
                if (this.changeNodesWithArcs.isSelected()) {
                    this.changeNodesWithArcs.setSelected(false);
                    this.reload(false);
                }
                this.changeNodesWithArcs.setEnabled(false);
            }
        } else if (geomToChange instanceof ArcInst) {
            this.changeNodesWithArcs.setEnabled(true);
        }
    }

    private void loadInfo(boolean showHighlighted) {
        EditWindow curWnd = EditWindow.getCurrent();
        if (curWnd != null) {
            this.wnd = curWnd;
        }
        this.geomsToChange = new ArrayList<Geometric>();
        if (this.wnd != null) {
            List<Geometric> highs = this.wnd.getHighlighter().getHighlightedEObjs(true, true);
            for (Geometric geom : highs) {
                this.geomsToChange.add(geom);
            }
        }
        if (this.geomsToChange.size() == 0) {
            this.librariesPopup.setEnabled(false);
            this.ignorePortNames.setEnabled(false);
            this.allowMissingPorts.setEnabled(false);
            this.showPrimitives.setEnabled(false);
            this.showCells.setEnabled(false);
            this.changeNodesWithArcs.setEnabled(false);
            this.apply.setEnabled(false);
            this.changeSelected.setEnabled(false);
            this.changeConnected.setEnabled(false);
            this.changeInCell.setEnabled(false);
            this.changeInLibrary.setEnabled(false);
            this.changeEverywhere.setEnabled(false);
            return;
        }
        this.apply.setEnabled(true);
        this.changeSelected.setEnabled(true);
        this.changeConnected.setEnabled(true);
        this.changeInCell.setEnabled(true);
        this.changeInLibrary.setEnabled(true);
        this.changeEverywhere.setEnabled(true);
        Geometric geomToChange = this.geomsToChange.get(0);
        if (geomToChange instanceof NodeInst) {
            this.librariesPopup.setEnabled(true);
            this.ignorePortNames.setEnabled(true);
            this.allowMissingPorts.setEnabled(true);
            this.showPrimitives.setEnabled(true);
            this.showCells.setEnabled(true);
            NodeInst ni = (NodeInst)geomToChange;
            if (ni.isCellInstance()) {
                this.showCells.setSelected(true);
            } else {
                this.showPrimitives.setSelected(true);
            }
            this.changeNodesWithArcs.setSelected(false);
            this.changeNodesWithArcs.setEnabled(false);
        } else {
            this.librariesPopup.setEnabled(false);
            this.ignorePortNames.setEnabled(false);
            this.allowMissingPorts.setEnabled(false);
            this.showPrimitives.setEnabled(false);
            this.showCells.setEnabled(false);
            this.changeNodesWithArcs.setEnabled(true);
            this.changeNodesWithArcs.setSelected(lastChangeNodesWithArcs);
        }
        this.reload(true);
    }

    private void rememberState() {
        lastIgnorePortNames = this.ignorePortNames.isSelected();
        lastAllowMissingPorts = this.allowMissingPorts.isSelected();
    }

    private void reload(boolean canSwitchLibraries) {
        lastChangeNodesWithArcs = this.changeNodesWithArcs.isSelected();
        if (this.dontReload) {
            return;
        }
        this.changeListModel.clear();
        this.changeNodeProtoList.clear();
        if (this.geomsToChange.size() == 0) {
            return;
        }
        Technology curTech = Technology.getCurrent();
        Geometric geomToChange = this.geomsToChange.get(0);
        if (geomToChange instanceof NodeInst) {
            NodeInst ni = (NodeInst)geomToChange;
            if (this.showCells.isSelected()) {
                Library lib;
                if (ni.isCellInstance() && canSwitchLibraries) {
                    Cell parent = (Cell)ni.getProto();
                    lib = parent.getLibrary();
                    this.dontReload = true;
                    this.librariesPopup.setSelectedItem(lib.getName());
                    this.dontReload = false;
                }
                String libName = (String)this.librariesPopup.getSelectedItem();
                lib = Library.findLibrary(libName);
                Iterator<Cell> it = lib.getCells();
                while (it.hasNext()) {
                    Cell cell = it.next();
                    this.changeListModel.addElement(cell.noLibDescribe());
                    this.changeNodeProtoList.add(cell);
                }
            }
            if (this.showPrimitives.isSelected()) {
                for (PrimitiveNode np : curTech.getNodesSortedByName()) {
                    this.changeListModel.addElement(np.describe(false));
                    this.changeNodeProtoList.add(np);
                }
                if (curTech != Generic.tech) {
                    this.changeListModel.addElement("Generic:Universal-Pin");
                    this.changeNodeProtoList.add(Generic.tech.universalPinNode);
                    this.changeListModel.addElement("Generic:Invisible-Pin");
                    this.changeNodeProtoList.add(Generic.tech.invisiblePinNode);
                    this.changeListModel.addElement("Generic:Unrouted-Pin");
                    this.changeNodeProtoList.add(Generic.tech.unroutedPinNode);
                }
            }
            this.changeList.setSelectedIndex(0);
            if (ni.isCellInstance()) {
                Cell c = (Cell)ni.getProto();
                for (int i = 0; i < this.changeListModel.getSize(); ++i) {
                    String str = (String)this.changeListModel.get(i);
                    if (!str.equals(c.noLibDescribe())) continue;
                    this.changeList.setSelectedIndex(i);
                    break;
                }
            } else {
                for (int i = 0; i < this.changeListModel.getSize(); ++i) {
                    String str = (String)this.changeListModel.get(i);
                    if (!str.equals(ni.getProto().describe(false))) continue;
                    this.changeList.setSelectedIndex(i);
                    break;
                }
            }
            if (this.showCells.isSelected()) {
                String geomName = ((NodeInst)geomToChange).getProto().describe(false);
                Matcher mat = dummyName.matcher(geomName);
                if (mat.matches()) {
                    this.changeList.setSelectedValue(mat.group(1) + "{" + mat.group(3), true);
                    this.librariesPopup.setSelectedItem(mat.group(2));
                } else {
                    this.changeList.setSelectedValue(geomName, true);
                }
            }
        } else {
            Technology arcTech;
            ArcProto ap;
            ArcInst ai = (ArcInst)geomToChange;
            PortProto pp1 = ai.getHeadPortInst().getPortProto();
            PortProto pp2 = ai.getTailPortInst().getPortProto();
            Iterator<ArcProto> it = curTech.getArcs();
            while (it.hasNext()) {
                ap = it.next();
                if (!this.changeNodesWithArcs.isSelected() && (!pp1.connectsTo(ap) || !pp2.connectsTo(ap))) continue;
                this.changeListModel.addElement(ap.describe());
            }
            if (curTech != Generic.tech) {
                it = Generic.tech.getArcs();
                while (it.hasNext()) {
                    ap = it.next();
                    if (!this.changeNodesWithArcs.isSelected() && (!pp1.connectsTo(ap) || !pp2.connectsTo(ap))) continue;
                    this.changeListModel.addElement(ap.describe());
                }
            }
            if ((arcTech = ai.getProto().getTechnology()) != curTech && arcTech != Generic.tech) {
                Iterator<ArcProto> it2 = arcTech.getArcs();
                while (it2.hasNext()) {
                    ArcProto ap2 = it2.next();
                    if (!this.changeNodesWithArcs.isSelected() && (!pp1.connectsTo(ap2) || !pp2.connectsTo(ap2))) continue;
                    this.changeListModel.addElement(ap2.describe());
                }
            }
            this.changeList.setSelectedIndex(0);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EDialog.centerSelection(Change.this.changeList);
            }
        });
    }

    private void doTheChange() {
        NodeProto np = null;
        ArcProto ap = null;
        Geometric geomToChange = this.geomsToChange.get(0);
        if (geomToChange instanceof NodeInst) {
            int index = this.changeList.getSelectedIndex();
            np = this.changeNodeProtoList.get(index);
        } else {
            String line = (String)this.changeList.getSelectedValue();
            ap = ArcProto.findArcProto(line);
            if (ap == null) {
                System.out.println("Nothing called '" + line + "'");
                return;
            }
        }
        List<Geometric> highs = this.wnd.getHighlighter().getHighlightedEObjs(true, true);
        new ChangeObject(this.geomsToChange, highs, this.getLibSelected(), np, ap, this.ignorePortNames.isSelected(), this.allowMissingPorts.isSelected(), this.changeNodesWithArcs.isSelected(), this.changeInCell.isSelected(), this.changeInLibrary.isSelected(), this.changeEverywhere.isSelected(), this.changeConnected.isSelected());
    }

    private String getLibSelected() {
        return (String)this.librariesPopup.getSelectedItem();
    }

    private void initComponents() {
        this.changeOption = new ButtonGroup();
        this.done = new JButton();
        this.apply = new JButton();
        this.listPane = new JScrollPane();
        this.changeSelected = new JRadioButton();
        this.changeConnected = new JRadioButton();
        this.changeInCell = new JRadioButton();
        this.changeInLibrary = new JRadioButton();
        this.changeEverywhere = new JRadioButton();
        this.changeNodesWithArcs = new JCheckBox();
        this.showPrimitives = new JCheckBox();
        this.showCells = new JCheckBox();
        this.ignorePortNames = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.librariesPopup = new JComboBox();
        this.allowMissingPorts = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Change");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Change.this.closeDialog(evt);
            }
        });
        this.done.setText("Done");
        this.done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.done(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.done, gridBagConstraints);
        this.apply.setText("Apply");
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.apply(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.apply, gridBagConstraints);
        this.listPane.setMinimumSize(new Dimension(150, 22));
        this.listPane.setPreferredSize(new Dimension(150, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.listPane, gridBagConstraints);
        this.changeSelected.setText("Change selected ones only");
        this.changeOption.add(this.changeSelected);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.getContentPane().add((Component)this.changeSelected, gridBagConstraints);
        this.changeConnected.setText("Change all connected to this");
        this.changeOption.add(this.changeConnected);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.changeConnected, gridBagConstraints);
        this.changeInCell.setText("Change all in this cell");
        this.changeOption.add(this.changeInCell);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.changeInCell, gridBagConstraints);
        this.changeInLibrary.setText("Change all in this library");
        this.changeOption.add(this.changeInLibrary);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.changeInLibrary, gridBagConstraints);
        this.changeEverywhere.setText("Change all in all libraries");
        this.changeOption.add(this.changeEverywhere);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 10, 4);
        this.getContentPane().add((Component)this.changeEverywhere, gridBagConstraints);
        this.changeNodesWithArcs.setText("Change nodes with arcs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 4, 4, 4);
        this.getContentPane().add((Component)this.changeNodesWithArcs, gridBagConstraints);
        this.showPrimitives.setText("Show primitives");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.showPrimitives, gridBagConstraints);
        this.showCells.setText("Show cells");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.showCells, gridBagConstraints);
        this.ignorePortNames.setText("Ignore port names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ignorePortNames, gridBagConstraints);
        this.jLabel1.setText("Library:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.librariesPopup, gridBagConstraints);
        this.allowMissingPorts.setText("Allow missing ports");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.allowMissingPorts, gridBagConstraints);
        this.pack();
    }

    private void done(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void apply(ActionEvent evt) {
        this.doTheChange();
        libSelected = (String)this.librariesPopup.getSelectedItem();
    }

    private void closeDialog(WindowEvent evt) {
        Highlighter.removeHighlightListener(this);
        this.setVisible(false);
        this.dispose();
        theDialog = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChangeObject
    extends Job {
        private List<Geometric> geomsToChange;
        private List<Geometric> highs;
        private String libName;
        private NodeProto np;
        private ArcProto ap;
        private boolean ignorePortNames;
        private boolean allowMissingPorts;
        private boolean changeNodesWithArcs;
        private boolean changeInCell;
        private boolean changeInLibrary;
        private boolean changeEverywhere;
        private boolean changeConnected;
        private List<Geometric> highlightThese;
        private NodeProto[] contactStack = new NodeProto[100];
        private ArcProto[] contactStackArc = new ArcProto[100];

        private ChangeObject(List<Geometric> geomsToChange, List<Geometric> highs, String libName, NodeProto np, ArcProto ap, boolean ignorePortNames, boolean allowMissingPorts, boolean changeNodesWithArcs, boolean changeInCell, boolean changeInLibrary, boolean changeEverywhere, boolean changeConnected) {
            super("Change type", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.geomsToChange = geomsToChange;
            this.highs = highs;
            this.libName = libName;
            this.np = np;
            this.ap = ap;
            this.ignorePortNames = ignorePortNames;
            this.allowMissingPorts = allowMissingPorts;
            this.changeNodesWithArcs = changeNodesWithArcs;
            this.changeInCell = changeInCell;
            this.changeInLibrary = changeInLibrary;
            this.changeEverywhere = changeEverywhere;
            this.changeConnected = changeConnected;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.highlightThese = new ArrayList<Geometric>();
            this.fieldVariableChanged("highlightThese");
            HashSet<NodeInst> changedAlready = new HashSet<NodeInst>();
            for (Geometric geomToChange : this.geomsToChange) {
                ArcInst newAi;
                Iterator<Geometric> nIt;
                Cell cell;
                Cell cell2;
                Library lib;
                Iterator<Geometric> nIt2;
                Iterator<Cell> cIt;
                Iterator<Library> it;
                int total;
                if (geomToChange instanceof NodeInst) {
                    NodeInst lNi4;
                    NodeInst ni = (NodeInst)geomToChange;
                    if (CircuitChangeJobs.cantEdit(ni.getParent(), ni, true, false, true) != 0) {
                        return false;
                    }
                    Library library = Library.findLibrary(this.libName);
                    if (library == null) {
                        return false;
                    }
                    if (this.np == null) {
                        return false;
                    }
                    NodeProto oldNType = ni.getProto();
                    if (oldNType == this.np) {
                        System.out.println("Node already of type " + this.np.describe(true));
                        continue;
                    }
                    if (!changedAlready.contains(ni)) {
                        changedAlready.add(ni);
                        NodeInst onlyNewNi = CircuitChangeJobs.replaceNodeInst(ni, this.np, this.ignorePortNames, this.allowMissingPorts);
                        if (onlyNewNi == null) {
                            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), this.np + " does not fit in the place of " + oldNType, "Change failed", 0);
                            return false;
                        }
                        this.highlightThese.add(onlyNewNi);
                    }
                    total = 1;
                    if (this.changeEverywhere) {
                        it = Library.getLibraries();
                        while (it.hasNext()) {
                            Library lib2 = it.next();
                            cIt = lib2.getCells();
                            while (cIt.hasNext()) {
                                Cell cell3 = cIt.next();
                                boolean found = true;
                                block3: while (found) {
                                    found = false;
                                    nIt2 = cell3.getNodes();
                                    while (nIt2.hasNext()) {
                                        NodeInst newNi;
                                        NodeInst lNi2 = (NodeInst)nIt2.next();
                                        if (lNi2.getProto() != oldNType || changedAlready.contains(lNi2)) continue;
                                        changedAlready.add(lNi2);
                                        if (lNi2.isIconOfParent()) {
                                            System.out.println("Example icon in " + cell3 + " not replaced");
                                            continue;
                                        }
                                        int errorCode = CircuitChangeJobs.cantEdit(cell3, lNi2, true, false, true);
                                        if (errorCode < 0) {
                                            return false;
                                        }
                                        if (errorCode > 0 || (newNi = CircuitChangeJobs.replaceNodeInst(lNi2, this.np, this.ignorePortNames, this.allowMissingPorts)) == null) continue;
                                        ++total;
                                        found = true;
                                        continue block3;
                                    }
                                }
                            }
                        }
                        System.out.println("All " + total + " " + oldNType.describe(true) + " nodes in all libraries replaced with " + this.np);
                        continue;
                    }
                    if (this.changeInLibrary) {
                        lib = WindowFrame.getCurrentCell().getLibrary();
                        Iterator<Cell> cIt2 = lib.getCells();
                        while (cIt2.hasNext()) {
                            cell2 = cIt2.next();
                            boolean found = true;
                            block6: while (found) {
                                found = false;
                                Iterator<NodeInst> nIt3 = cell2.getNodes();
                                while (nIt3.hasNext()) {
                                    NodeInst newNi;
                                    lNi4 = nIt3.next();
                                    if (lNi4.getProto() != oldNType || changedAlready.contains(lNi4)) continue;
                                    changedAlready.add(lNi4);
                                    int errorCode = CircuitChangeJobs.cantEdit(cell2, lNi4, true, false, true);
                                    if (errorCode < 0) {
                                        return false;
                                    }
                                    if (errorCode > 0 || (newNi = CircuitChangeJobs.replaceNodeInst(lNi4, this.np, this.ignorePortNames, this.allowMissingPorts)) == null) continue;
                                    ++total;
                                    found = true;
                                    continue block6;
                                }
                            }
                        }
                        System.out.println("All " + total + " " + oldNType.describe(true) + " nodes in " + lib + " replaced with " + this.np);
                        continue;
                    }
                    if (this.changeInCell) {
                        cell = WindowFrame.getCurrentCell();
                        boolean found = true;
                        block8: while (found) {
                            found = false;
                            nIt = cell.getNodes();
                            while (nIt.hasNext()) {
                                NodeInst newNi;
                                NodeInst lNi3 = (NodeInst)nIt.next();
                                if (lNi3.getProto() != oldNType || changedAlready.contains(lNi3)) continue;
                                changedAlready.add(lNi3);
                                int errorCode = CircuitChangeJobs.cantEdit(cell, lNi3, true, false, true);
                                if (errorCode < 0) {
                                    return false;
                                }
                                if (errorCode > 0 || (newNi = CircuitChangeJobs.replaceNodeInst(lNi3, this.np, this.ignorePortNames, this.allowMissingPorts)) == null) continue;
                                ++total;
                                found = true;
                                continue block8;
                            }
                        }
                        System.out.println("All " + total + " " + oldNType.describe(true) + " nodes in " + cell + " replaced with " + this.np);
                        continue;
                    }
                    if (this.changeConnected) {
                        Cell curCell = WindowFrame.getCurrentCell();
                        Netlist netlist = curCell.getUserNetlist();
                        ArrayList<NodeInst> others = new ArrayList<NodeInst>();
                        NodeInst onlyNewNi = null;
                        if (this.highlightThese.size() == 1 && this.highlightThese.get(0) instanceof NodeInst) {
                            onlyNewNi = (NodeInst)this.highlightThese.get(0);
                        }
                        Iterator<NodeInst> it2 = curCell.getNodes();
                        while (it2.hasNext()) {
                            lNi4 = it2.next();
                            if (lNi4.getProto() != oldNType || lNi4 == onlyNewNi) continue;
                            boolean found = false;
                            Iterator<PortInst> pIt = onlyNewNi.getPortInsts();
                            while (pIt.hasNext()) {
                                PortInst pi = pIt.next();
                                Iterator<PortInst> lPIt = lNi4.getPortInsts();
                                while (lPIt.hasNext()) {
                                    PortInst lPi = lPIt.next();
                                    if (!netlist.sameNetwork(pi.getNodeInst(), pi.getPortProto(), lPi.getNodeInst(), lPi.getPortProto())) continue;
                                    found = true;
                                    break;
                                }
                                if (!found) continue;
                                break;
                            }
                            if (!found) continue;
                            others.add(lNi4);
                        }
                        for (NodeInst lNi4 : others) {
                            NodeInst newNi;
                            if (changedAlready.contains(lNi4)) continue;
                            changedAlready.add(lNi4);
                            int errorCode = CircuitChangeJobs.cantEdit(curCell, lNi4, true, false, true);
                            if (errorCode < 0) {
                                return false;
                            }
                            if (errorCode > 0 || (newNi = CircuitChangeJobs.replaceNodeInst(lNi4, this.np, this.ignorePortNames, this.allowMissingPorts)) == null) continue;
                            ++total;
                        }
                        System.out.println("All " + total + " " + oldNType.describe(true) + " nodes connected to this replaced with " + this.np);
                        continue;
                    }
                    System.out.println(oldNType + " replaced with " + this.np);
                    continue;
                }
                ArcInst ai = (ArcInst)geomToChange;
                if (CircuitChangeJobs.cantEdit(ai.getParent(), null, true, false, true) != 0) {
                    return false;
                }
                ArcProto oldAType = ai.getProto();
                if (oldAType == this.ap) {
                    System.out.println("Arc already of type " + this.ap.describe());
                    return false;
                }
                if (this.changeNodesWithArcs) {
                    if (this.changeInLibrary) {
                        Iterator<Cell> it3 = Library.getCurrent().getCells();
                        while (it3.hasNext()) {
                            Cell cell4 = it3.next();
                            this.replaceAllArcs(cell4, this.highs, ai, this.ap, false, true);
                        }
                    } else {
                        this.replaceAllArcs(ai.getParent(), this.highs, ai, this.ap, this.changeConnected, this.changeInCell);
                    }
                    return true;
                }
                ArcInst onlyNewAi = ai.replace(this.ap);
                if (onlyNewAi == null) {
                    System.out.println(this.ap + " does not fit in the place of " + oldAType);
                    return false;
                }
                this.highlightThese.add(onlyNewAi);
                total = 1;
                if (this.changeEverywhere) {
                    it = Library.getLibraries();
                    while (it.hasNext()) {
                        Library lib3 = it.next();
                        cIt = lib3.getCells();
                        while (cIt.hasNext()) {
                            Cell cell5 = cIt.next();
                            boolean found = true;
                            block17: while (found) {
                                found = false;
                                nIt2 = cell5.getArcs();
                                while (nIt2.hasNext()) {
                                    ArcInst newAi2;
                                    ArcInst lAi = (ArcInst)nIt2.next();
                                    if (lAi.getProto() != oldAType) continue;
                                    int errorCode = CircuitChangeJobs.cantEdit(cell5, null, true, false, true);
                                    if (errorCode < 0) {
                                        return false;
                                    }
                                    if (errorCode > 0 || (newAi2 = lAi.replace(this.ap)) == null) continue;
                                    ++total;
                                    found = true;
                                    continue block17;
                                }
                            }
                        }
                    }
                    System.out.println("All " + total + " " + oldAType.describe() + " arcs in the library replaced with " + this.ap);
                    continue;
                }
                if (this.changeInLibrary) {
                    lib = Library.getCurrent();
                    Iterator<Cell> cIt3 = lib.getCells();
                    while (cIt3.hasNext()) {
                        cell2 = cIt3.next();
                        boolean found = true;
                        block20: while (found) {
                            found = false;
                            Iterator<ArcInst> nIt4 = cell2.getArcs();
                            while (nIt4.hasNext()) {
                                ArcInst newAi3;
                                ArcInst lAi = nIt4.next();
                                if (lAi.getProto() != oldAType) continue;
                                int errorCode = CircuitChangeJobs.cantEdit(cell2, null, true, false, true);
                                if (errorCode < 0) {
                                    return false;
                                }
                                if (errorCode > 0 || (newAi3 = lAi.replace(this.ap)) == null) continue;
                                ++total;
                                found = true;
                                continue block20;
                            }
                        }
                    }
                    System.out.println("All " + total + " " + oldAType.describe() + " arcs in " + lib + " replaced with " + this.ap);
                    continue;
                }
                if (this.changeInCell) {
                    cell = WindowFrame.getCurrentCell();
                    boolean found = true;
                    block22: while (found) {
                        found = false;
                        nIt = cell.getArcs();
                        while (nIt.hasNext()) {
                            ArcInst lAi = (ArcInst)nIt.next();
                            if (lAi.getProto() != oldAType) continue;
                            int errorCode = CircuitChangeJobs.cantEdit(cell, null, true, false, true);
                            if (errorCode < 0) {
                                return false;
                            }
                            if (errorCode > 0 || (newAi = lAi.replace(this.ap)) == null) continue;
                            ++total;
                            found = true;
                            continue block22;
                        }
                    }
                    System.out.println("All " + total + " " + oldAType.describe() + " arcs in " + cell + " replaced with " + this.ap);
                    continue;
                }
                if (this.changeConnected) {
                    ArrayList<ArcInst> others = new ArrayList<ArcInst>();
                    Cell cell6 = WindowFrame.getCurrentCell();
                    Netlist netlist = cell6.getUserNetlist();
                    Iterator<ArcInst> it4 = cell6.getArcs();
                    while (it4.hasNext()) {
                        ArcInst lAi = it4.next();
                        if (lAi == onlyNewAi || !netlist.sameNetwork(onlyNewAi, lAi)) continue;
                        others.add(lAi);
                    }
                    for (ArcInst lAi : others) {
                        newAi = lAi.replace(this.ap);
                        if (newAi == null) continue;
                        ++total;
                    }
                    System.out.println("All " + total + " " + oldAType.describe() + " arcs connected to this replaced with " + this.ap);
                    continue;
                }
                System.out.println(oldAType + " replaced with " + this.ap);
            }
            return true;
        }

        @Override
        public void terminateOK() {
            EditWindow wnd = EditWindow.getCurrent();
            if (wnd != null) {
                Highlighter highlighter = wnd.getHighlighter();
                for (Geometric geom : this.highlightThese) {
                    highlighter.addElectricObject(geom, geom.getParent());
                }
            }
        }

        private void replaceAllArcs(Cell cell, List<Geometric> highs, ArcInst oldAi, ArcProto ap, boolean connected, boolean thiscell) {
            ArcInst ai;
            Iterator<Geometric> it;
            ArcInst ai2;
            HashSet<Geometric> geomMarked = new HashSet<Geometric>();
            for (Geometric geom : highs) {
                if (!(geom instanceof ArcInst) || (ai2 = (ArcInst)geom).getProto() != oldAi.getProto()) continue;
                geomMarked.add(ai2);
            }
            if (connected) {
                Netlist netlist = cell.getUserNetlist();
                Iterator<ArcInst> it2 = cell.getArcs();
                while (it2.hasNext()) {
                    ai2 = it2.next();
                    if (ai2.getProto() != oldAi.getProto() || !netlist.sameNetwork(ai2, oldAi)) continue;
                    geomMarked.add(ai2);
                }
            }
            if (thiscell) {
                it = cell.getArcs();
                while (it.hasNext()) {
                    ArcInst ai3 = (ArcInst)it.next();
                    if (ai3.getProto() != oldAi.getProto()) continue;
                    geomMarked.add(ai3);
                }
            }
            it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                if (ni.isCellInstance() || ni.getFunction() != PrimitiveNode.Function.PIN) continue;
                boolean allArcs = true;
                Iterator<Connection> cIt = ni.getConnections();
                while (cIt.hasNext()) {
                    Connection con = cIt.next();
                    if (geomMarked.contains(con.getArc())) continue;
                    allArcs = false;
                    break;
                }
                if (!ni.hasConnections() || !allArcs) continue;
                geomMarked.add(ni);
            }
            PrimitiveNode pin = ap.findOverridablePinProto();
            double xS = pin.getDefWidth();
            double yS = pin.getDefHeight();
            ArrayList<NodeInst> dupPins = new ArrayList<NodeInst>();
            for (Geometric geom : geomMarked) {
                if (!(geom instanceof NodeInst)) continue;
                dupPins.add((NodeInst)geom);
            }
            HashMap<NodeInst, NodeInst> newNodes = new HashMap<NodeInst, NodeInst>();
            for (NodeInst ni : dupPins) {
                NodeInst newNi = NodeInst.makeInstance(pin, ni.getAnchorCenter(), xS, yS, cell);
                if (newNi == null) {
                    return;
                }
                newNodes.put(ni, newNi);
                Iterator<Export> eIt = ni.getExports();
                while (eIt.hasNext()) {
                    Export oldExport = eIt.next();
                    if (!oldExport.move(newNi.getOnlyPortInst())) continue;
                    System.out.println("Unable to move export " + oldExport.getName() + " from old pin " + ni.describe(true) + " to new pin " + newNi);
                }
            }
            for (Geometric geom : geomMarked) {
                ArcInst newAi;
                if (!(geom instanceof ArcInst)) continue;
                ai = (ArcInst)geom;
                PortInst pi0 = null;
                NodeInst newNi0 = (NodeInst)newNodes.get(ai.getHeadPortInst().getNodeInst());
                if (newNi0 != null) {
                    pi0 = newNi0.getOnlyPortInst();
                } else {
                    pi0 = this.makeContactStack(ai, 1, ap);
                    if (pi0 == null) {
                        return;
                    }
                }
                PortInst pi1 = null;
                NodeInst newNi1 = (NodeInst)newNodes.get(ai.getTailPortInst().getNodeInst());
                if (newNi1 != null) {
                    pi1 = newNi1.getOnlyPortInst();
                } else {
                    pi1 = this.makeContactStack(ai, 0, ap);
                    if (pi1 == null) {
                        return;
                    }
                }
                double wid = ap.getDefaultLambdaBaseWidth();
                if (ai.getLambdaBaseWidth() > wid) {
                    wid = ai.getLambdaBaseWidth();
                }
                if ((newAi = ArcInst.makeInstanceBase(ap, wid, pi0, pi1, ai.getHeadLocation(), ai.getTailLocation(), ai.getName())) == null) {
                    return;
                }
                newAi.copyPropertiesFrom(ai);
                geomMarked.remove(newAi);
            }
            for (Geometric geom : geomMarked) {
                if (!(geom instanceof ArcInst)) continue;
                ai = (ArcInst)geom;
                ai.kill();
            }
            for (NodeInst ni : dupPins) {
                if (ni.hasExports()) continue;
                String niName = ni.getName();
                ni.kill();
                NodeInst newNi = (NodeInst)newNodes.get(ni);
                newNi.setName(niName);
            }
        }

        private PortInst makeContactStack(ArcInst ai, int end, ArcProto ap) {
            NodeInst lastNi = ai.getPortInst(end).getNodeInst();
            PortProto lastPp = ai.getPortInst(end).getPortProto();
            PortInst lastPi = lastNi.findPortInstFromProto(lastPp);
            HashSet<ArcProto> markedArcs = new HashSet<ArcProto>();
            int depth = this.findPathToArc(lastPp, ap, 0, markedArcs);
            if (depth < 0) {
                return null;
            }
            Cell cell = ai.getParent();
            EPoint center = ai.getLocation(end);
            for (int i = 0; i < depth; ++i) {
                ArcProto typ = this.contactStackArc[i];
                double wid = ai.getLambdaBaseWidth();
                double xS = this.contactStack[i].getDefWidth();
                double yS = this.contactStack[i].getDefHeight();
                SizeOffset so = this.contactStack[i].getProtoSizeOffset();
                NodeInst newNi = NodeInst.makeInstance(this.contactStack[i], center, xS = Math.max(xS - so.getLowXOffset() - so.getHighXOffset(), wid) + so.getLowXOffset() + so.getHighXOffset(), yS = Math.max(yS - so.getLowYOffset() - so.getHighYOffset(), wid) + so.getLowYOffset() + so.getHighYOffset(), cell);
                if (newNi == null) {
                    return null;
                }
                PortInst thisPi = newNi.findPortInstFromProto(this.contactStack[i].getPort(0));
                ArcInst newAi = ArcInst.newInstanceBase(typ, wid, thisPi, lastPi, center, center, null, ai.getAngle());
                lastPi = thisPi;
                if (newAi == null) {
                    return null;
                }
                newAi.setFixedAngle(true);
            }
            return lastPi;
        }

        private int findPathToArc(PortProto pp, ArcProto ap, int depth, Set<ArcProto> markedArcs) {
            if (pp.connectsTo(ap)) {
                return depth;
            }
            PrimitiveNode bestNp = null;
            ArcProto bestAp = null;
            int bestDepth = 0;
            Technology tech = ap.getTechnology();
            Iterator<PrimitiveNode> it = tech.getNodes();
            while (it.hasNext()) {
                PrimitiveNode nextNp = it.next();
                PrimitiveNode.Function fun = nextNp.getFunction();
                if (fun != PrimitiveNode.Function.CONTACT) continue;
                PrimitivePort nextPp = nextNp.getPort(0);
                ArcProto[] connections = nextPp.getBasePort().getConnections();
                ArcProto found = null;
                for (int i = 0; i < connections.length; ++i) {
                    ArcProto thisAp = connections[i];
                    if (thisAp.getTechnology() != tech || markedArcs.contains(thisAp) || !pp.connectsTo(thisAp)) continue;
                    found = thisAp;
                    break;
                }
                if (found == null) continue;
                this.contactStack[depth] = nextNp;
                markedArcs.add(found);
                int newDepth = this.findPathToArc(nextPp, ap, depth + 1, markedArcs);
                markedArcs.remove(found);
                if (newDepth < 0 || bestNp != null && newDepth >= bestDepth) continue;
                bestDepth = newDepth;
                bestNp = nextNp;
                bestAp = found;
            }
            if (bestNp != null) {
                this.contactStack[depth] = bestNp;
                this.contactStackArc[depth] = bestAp;
                markedArcs.add(bestAp);
                int newDepth = this.findPathToArc(bestNp.getPort(0), ap, depth + 1, markedArcs);
                markedArcs.remove(bestAp);
                return newDepth;
            }
            return -1;
        }
    }
}

