/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.erc;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.text.PrefPackage;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.erc.ERC;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.dialogs.EModelessDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.util.concurrent.utils.ElapseTimer;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.GenMath;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

@Deprecated
public class ERCWellCheckOld {
    private Cell cell;
    private Set<Object> possiblePrimitives;
    private List<WellCon> wellCons = new ArrayList<WellCon>();
    private Iterator<WellCon>[] wellConIterator;
    private List<WellCon>[] wellConLists;
    private RTNode pWellRoot;
    private RTNode nWellRoot;
    private Layer pWellLayer;
    private Layer nWellLayer;
    private ErrorLogger errorLogger;
    private WellCheckJob job;
    private double worstPWellDist;
    private Point2D worstPWellCon;
    private Point2D worstPWellEdge;
    private double worstNWellDist;
    private Point2D worstNWellCon;
    private Point2D worstNWellEdge;
    private WellCheckPreferences wellPrefs;
    private Map<Integer, List<Transistor>> transistors;
    private Set<Integer> networkExportAvailable;
    private List<Transistor> alreadyHit;
    private Set<Integer> networkWithExportCache;
    public static boolean useFelixCode = true;
    private static final boolean GATHERSTATISTICS = false;
    private static final boolean DISTANTSEEDS = true;
    private static final boolean INCREMENTALGROWTH = false;
    Integer total;
    double ratio = 1.0;
    int cacheHits = 0;
    private static final int ERCPWell = 1;
    private static final int ERCNWell = 2;
    private static final int ERCPSEUDO = 0;
    private static final Layer.Function[] ercLayersArray = new Layer.Function[]{Layer.Function.WELLP, Layer.Function.WELL, Layer.Function.WELLN, Layer.Function.SUBSTRATE, Layer.Function.IMPLANTP, Layer.Function.IMPLANT, Layer.Function.IMPLANTN};
    private static final Layer.Function.Set ercLayers = new Layer.Function.Set(ercLayersArray);
    private GeometryHandler.GHMode mode;
    private Set<Cell> doneCells = new HashSet<Cell>();
    private Map<Cell, GeometryHandler> cellMerges = new HashMap<Cell, GeometryHandler>();
    private List<WellBoundRecord> wellBoundSearchOrder;
    private int numObjSearches;

    public static void analyzeCurCell(GeometryHandler.GHMode newAlgorithm) {
        UserInterface ui = Job.getUserInterface();
        Cell curCell = ui.needCurrentCell();
        if (curCell == null) {
            return;
        }
        View view = curCell.getView();
        if (view.isTextView() || view == View.SCHEMATIC || view == View.ICON) {
            System.out.println("Sorry, Well checking runs only on layout cells");
            return;
        }
        new WellCheckJob(curCell, newAlgorithm, new WellCheckPreferences(false));
    }

    public static int checkERCWell(Cell cell, GeometryHandler.GHMode newAlgorithm, WellCheckPreferences wellPrefs) {
        ERCWellCheckOld check2 = new ERCWellCheckOld(cell, null, newAlgorithm, wellPrefs);
        return check2.runNow();
    }

    private ERCWellCheckOld(Cell cell, WellCheckJob job, GeometryHandler.GHMode newAlgorithm, WellCheckPreferences wellPrefs) {
        this.job = job;
        this.mode = newAlgorithm;
        this.cell = cell;
        this.wellPrefs = wellPrefs;
        this.transistors = new HashMap<Integer, List<Transistor>>();
        this.networkWithExportCache = new HashSet<Integer>();
    }

    private int runNow() {
        System.out.println("Checking Wells and Substrates in '" + this.cell.libDescribe() + "' ...");
        ElapseTimer timer = ElapseTimer.createInstance().start();
        this.errorLogger = ErrorLogger.newInstance("ERC Well Check ");
        this.initStatistics();
        this.possiblePrimitives = new HashSet<Object>();
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            Iterator<Comparable<PrimitiveNode>> pIt = tech.getNodes();
            block1: while (pIt.hasNext()) {
                PrimitiveNode pn = pIt.next();
                Technology.NodeLayer[] nl = pn.getNodeLayers();
                for (int i = 0; i < nl.length; ++i) {
                    Layer lay = nl[i].getLayer();
                    if (!lay.getFunction().isSubstrate()) continue;
                    this.possiblePrimitives.add(pn);
                    continue block1;
                }
            }
            pIt = tech.getArcs();
            block3: while (pIt.hasNext()) {
                ArcProto ap = (ArcProto)pIt.next();
                for (int i = 0; i < ap.getNumArcLayers(); ++i) {
                    Layer lay = ap.getLayer(i);
                    if (!lay.getFunction().isSubstrate()) continue;
                    if (lay.getFunction().isWell()) {
                        this.pWellLayer = lay;
                    } else {
                        this.nWellLayer = lay;
                    }
                    this.possiblePrimitives.add(ap);
                    continue block3;
                }
            }
        }
        int errorCount = this.doNewWay();
        this.showStatistics();
        timer.end();
        if (errorCount == 0) {
            System.out.println("No Well errors found (took " + timer + ")");
        } else {
            System.out.println("FOUND " + errorCount + " WELL ERRORS (took " + timer + ")");
        }
        return errorCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WellCon getNextWellCon(int threadIndex) {
        List<WellCon> list2 = this.wellConLists[threadIndex];
        synchronized (list2) {
            while (this.wellConIterator[threadIndex].hasNext()) {
                WellCon wc = this.wellConIterator[threadIndex].next();
                if (wc.wellNum != null) continue;
                return wc;
            }
        }
        int numLists = this.wellConIterator.length;
        for (int i = 1; i < numLists; ++i) {
            int otherList = (threadIndex + i) % numLists;
            List<WellCon> list3 = this.wellConLists[otherList];
            synchronized (list3) {
                while (this.wellConIterator[otherList].hasNext()) {
                    WellCon wc = this.wellConIterator[otherList].next();
                    if (wc.wellNum != null) continue;
                    return wc;
                }
                continue;
            }
        }
        return null;
    }

    private void spreadSeeds(int threadIndex) {
        WellCon wc;
        while ((wc = this.getNextWellCon(threadIndex)) != null) {
            Rectangle2D.Double searchArea = new Rectangle2D.Double(wc.ctr.getX(), wc.ctr.getY(), 0.0, 0.0);
            RTNode topSearch = this.nWellRoot;
            if (ERCWellCheckOld.canBeSubstrateTap(wc.fun)) {
                topSearch = this.pWellRoot;
            }
            boolean geomFound = false;
            RTNode.Search sea = new RTNode.Search(searchArea, topSearch, true);
            while (sea.hasNext()) {
                WellBound wb = (WellBound)sea.next();
                geomFound = true;
                wc.wellNum = wb.netID;
                if (wc.wellNum == null) continue;
                break;
            }
            if (wc.wellNum != null) continue;
            wc.wellNum = new NetValues();
            if (!geomFound) {
                String errorMsg = "N-Well contact is floating";
                if (ERCWellCheckOld.canBeSubstrateTap(wc.fun)) {
                    errorMsg = "P-Well contact is floating";
                }
                this.errorLogger.logError(errorMsg, new EPoint(wc.ctr.getX(), wc.ctr.getY()), this.cell, 0);
                continue;
            }
            this.spreadWellSeed(wc.ctr.getX(), wc.ctr.getY(), wc.wellNum, topSearch, threadIndex);
        }
    }

    private int doNewWay() {
        int maxProc;
        this.pWellRoot = RTNode.makeTopLevel();
        this.nWellRoot = RTNode.makeTopLevel();
        ElapseTimer timer = ElapseTimer.createInstance().start();
        NewWellCheckVisitor wcVisitor = new NewWellCheckVisitor();
        HierarchyEnumerator.enumerateCell(this.cell, VarContext.globalContext, (HierarchyEnumerator.Visitor)wcVisitor);
        int numPRects = this.getTreeSize(this.pWellRoot);
        int numNRects = this.getTreeSize(this.nWellRoot);
        timer.end();
        System.out.println("   Geometry collection found " + (numPRects + numNRects) + " well pieces, took " + timer);
        timer.start();
        wcVisitor.clear();
        wcVisitor = null;
        int numberOfThreads = 1;
        if (this.wellPrefs.parallelWellAnalysis) {
            numberOfThreads = Runtime.getRuntime().availableProcessors();
        }
        if (numberOfThreads > 1 && (maxProc = this.wellPrefs.maxProc) > 0) {
            numberOfThreads = maxProc;
        }
        this.assignWellContacts(numberOfThreads);
        if (Job.getDebug()) {
            timer.end();
            System.out.println("   Assign well contacts took: " + timer);
            timer.start();
        }
        NetValues.reset();
        if (numberOfThreads <= 1) {
            this.spreadSeeds(0);
        } else {
            Semaphore outSem = new Semaphore(0);
            for (int i = 0; i < numberOfThreads; ++i) {
                new SpreadInThread("WellCheck propagate #" + (i + 1), outSem, i);
            }
            outSem.acquireUninterruptibly(numberOfThreads);
        }
        timer.end();
        String msg = "   Geometry analysis ";
        if (numberOfThreads > 1) {
            msg = msg + "used " + numberOfThreads + " threads and ";
        }
        msg = msg + "took ";
        System.out.println(msg + timer);
        timer.start();
        HashMap<Integer, WellCon> wellContacts = new HashMap<Integer, WellCon>();
        HashMap wellShorts = new HashMap();
        for (WellCon wc : this.wellCons) {
            Integer otherNetNum;
            HashSet<Integer> shortsInOther;
            Integer wellIndex = new Integer(wc.wellNum.getIndex());
            WellCon other = (WellCon)wellContacts.get(wellIndex);
            if (other == null) {
                wellContacts.put(wellIndex, wc);
                continue;
            }
            if (wc.netNum == other.netNum || wc.ni == other.ni) continue;
            Integer wcNetNum = new Integer(wc.netNum);
            HashSet<Integer> shortsInWC = (HashSet<Integer>)wellShorts.get(wcNetNum);
            if (shortsInWC == null) {
                shortsInWC = new HashSet<Integer>();
                wellShorts.put(wcNetNum, shortsInWC);
            }
            if ((shortsInOther = (HashSet<Integer>)wellShorts.get(otherNetNum = new Integer(other.netNum))) == null) {
                shortsInOther = new HashSet<Integer>();
                wellShorts.put(otherNetNum, shortsInOther);
            }
            if (shortsInWC.contains(otherNetNum)) continue;
            ArrayList<EPoint> pointList = new ArrayList<EPoint>();
            pointList.add(new EPoint(wc.ctr.getX(), wc.ctr.getY()));
            pointList.add(new EPoint(other.ctr.getX(), other.ctr.getY()));
            this.errorLogger.logMessage("Short circuit between well contacts", pointList, this.cell, 0, true);
            shortsInWC.add(otherNetNum);
            shortsInOther.add(wcNetNum);
        }
        this.cacheHits = 0;
        boolean hasPCon = false;
        boolean hasNCon = false;
        for (WellCon wc : this.wellCons) {
            if (ERCWellCheckOld.canBeSubstrateTap(wc.fun)) {
                hasPCon = true;
            } else {
                hasNCon = true;
            }
            if (!wc.onRail && useFelixCode) {
                if (this.networkExportAvailable.contains(wc.netNum)) {
                    wc.onRail = true;
                } else if (this.networkWithExportCache.contains(wc.netNum)) {
                    wc.onRail = true;
                    ++this.cacheHits;
                } else {
                    HashSet<Integer> startPath = new HashSet<Integer>();
                    List<Transistor> startTrans = this.transistors.get(wc.netNum);
                    if (startTrans != null && this.createTransistorChain(startPath, startTrans.get(0), false)) {
                        wc.onRail = true;
                        this.networkWithExportCache.addAll(startPath);
                    }
                }
            }
            if (wc.onRail || wc.onProperRail) continue;
            if (ERCWellCheckOld.canBeSubstrateTap(wc.fun)) {
                if (!this.wellPrefs.mustConnectPWellToGround) continue;
                this.errorLogger.logError("P-Well contact '" + wc.ni.getName() + "' not connected to ground", new EPoint(wc.ctr.getX(), wc.ctr.getY()), this.cell, 0);
                continue;
            }
            if (!this.wellPrefs.mustConnectNWellToPower) continue;
            this.errorLogger.logError("N-Well contact '" + wc.ni.getName() + "' not connected to power", new EPoint(wc.ctr.getX(), wc.ctr.getY()), this.cell, 0);
        }
        if (this.wellPrefs.pWellCheck != 2) {
            this.findUnconnected(this.pWellRoot, this.pWellRoot, "P");
        }
        if (this.wellPrefs.nWellCheck != 2) {
            this.findUnconnected(this.nWellRoot, this.nWellRoot, "N");
        }
        if (this.wellPrefs.pWellCheck == 1 && !hasPCon) {
            this.errorLogger.logError("No P-Well contact found in this cell", this.cell, 0);
        }
        if (this.wellPrefs.nWellCheck == 1 && !hasNCon) {
            this.errorLogger.logError("No N-Well contact found in this cell", this.cell, 0);
        }
        timer.end();
        System.out.println("   Additional analysis took " + timer);
        timer.start();
        if (this.wellPrefs.drcCheck) {
            DRCTemplate pRule = DRC.getSpacingRule(this.pWellLayer, null, this.pWellLayer, null, false, -1, 0.0, 0.0);
            DRCTemplate nRule = DRC.getSpacingRule(this.nWellLayer, null, this.nWellLayer, null, false, -1, 0.0, 0.0);
            if (pRule != null) {
                this.findDRCViolations(this.pWellRoot, pRule.getValue(0));
            }
            if (nRule != null) {
                this.findDRCViolations(this.nWellRoot, nRule.getValue(0));
            }
            timer.end();
            System.out.println("   Design rule check took " + timer);
            timer.start();
        }
        if (this.wellPrefs.findWorstCaseWell) {
            this.worstPWellDist = 0.0;
            this.worstPWellCon = null;
            this.worstPWellEdge = null;
            this.worstNWellDist = 0.0;
            this.worstNWellCon = null;
            this.worstNWellEdge = null;
            HashMap<Integer, WellNet> wellNets = new HashMap<Integer, WellNet>();
            for (WellCon wc : this.wellCons) {
                if (wc.wellNum == null) continue;
                Integer netNUM = new Integer(wc.wellNum.getIndex());
                WellNet wn = (WellNet)wellNets.get(netNUM);
                if (wn == null) {
                    wn = new WellNet();
                    wn.pointsOnNet = new ArrayList<Point2D>();
                    wn.contactsOnNet = new ArrayList<WellCon>();
                    wn.fun = wc.fun;
                    wellNets.put(netNUM, wn);
                }
                wn.contactsOnNet.add(wc);
            }
            this.findWellNetPoints(this.pWellRoot, wellNets);
            this.findWellNetPoints(this.nWellRoot, wellNets);
            for (Integer netNUM : wellNets.keySet()) {
                WellNet wn = (WellNet)wellNets.get(netNUM);
                for (Point2D pt : wn.pointsOnNet) {
                    double closestDist = Double.MAX_VALUE;
                    Point2D closestCon = null;
                    for (WellCon wc : wn.contactsOnNet) {
                        double dist = wc.ctr.distance(pt);
                        if (!(dist < closestDist)) continue;
                        closestDist = dist;
                        closestCon = wc.ctr;
                    }
                    if (ERCWellCheckOld.canBeSubstrateTap(wn.fun)) {
                        if (!(closestDist > this.worstPWellDist)) continue;
                        this.worstPWellDist = closestDist;
                        this.worstPWellCon = closestCon;
                        this.worstPWellEdge = pt;
                        continue;
                    }
                    if (!(closestDist > this.worstNWellDist)) continue;
                    this.worstNWellDist = closestDist;
                    this.worstNWellCon = closestCon;
                    this.worstNWellEdge = pt;
                }
            }
            timer.end();
            System.out.println("   Worst-case distance analysis took " + timer);
        }
        this.errorLogger.termLogging(true);
        int errorCount = this.errorLogger.getNumErrors();
        return errorCount;
    }

    private boolean createTransistorChain(Set<Integer> path, Transistor node, boolean result2) {
        this.alreadyHit = new LinkedList<Transistor>();
        if (!(result2 |= this.createTransistorRec(path, node, result2, node.drainNet.get()))) {
            result2 |= this.createTransistorRec(path, node, result2, node.sourceNet.get());
        }
        return result2;
    }

    private boolean createTransistorRec(Set<Integer> path, Transistor node, boolean result2, int num) {
        LinkedList<Transistor> transis = new LinkedList<Transistor>();
        transis.add(node);
        Transistor transis_old = null;
        Object transis_parent = null;
        this.alreadyHit.add(node);
        while (transis.size() > 0) {
            Transistor transistor;
            transis_old = transistor = (Transistor)transis.get(0);
            transis.remove(transistor);
            Integer neighbor = null;
            neighbor = transistor.drainNet.get() == num ? Integer.valueOf(transistor.sourceNet.get()) : Integer.valueOf(transistor.drainNet.get());
            path.add(neighbor);
            num = neighbor;
            if (!(result2 |= this.networkExportAvailable.contains(neighbor)) && (result2 |= this.networkWithExportCache.contains(neighbor))) {
                ++this.cacheHits;
            }
            if (result2) {
                return result2;
            }
            for (Transistor trans : this.transistors.get(neighbor)) {
                if (this.alreadyHit.contains(trans)) continue;
                transis.add(trans);
                this.alreadyHit.add(trans);
            }
        }
        return result2;
    }

    private void assignWellContacts(int numberOfThreads) {
        this.wellConIterator = new Iterator[numberOfThreads];
        this.wellConLists = new List[numberOfThreads];
        if (numberOfThreads == 1) {
            this.wellConLists[0] = this.wellCons;
        } else {
            for (int i = 0; i < numberOfThreads; ++i) {
                this.wellConLists[i] = new ArrayList<WellCon>();
            }
            ERectangle cellBounds = this.cell.getBounds();
            Point2D.Double ctr = new Point2D.Double(cellBounds.getCenterX(), cellBounds.getCenterY());
            Point2D[] farPoints = new Point2D[numberOfThreads];
            for (int i = 0; i < numberOfThreads; ++i) {
                double farthest = 0.0;
                farPoints[i] = new Point2D.Double(0.0, 0.0);
                for (WellCon wc : this.wellCons) {
                    double dist = 0.0;
                    if (i == 0) {
                        dist += wc.ctr.distance(ctr);
                    } else {
                        for (int j = 0; j < i; ++j) {
                            dist += wc.ctr.distance(farPoints[j]);
                        }
                    }
                    if (!(dist > farthest)) continue;
                    farthest = dist;
                    farPoints[i].setLocation(wc.ctr);
                }
            }
            for (WellCon wc : this.wellCons) {
                double minDist = Double.MAX_VALUE;
                int threadNum = 0;
                for (int j = 0; j < numberOfThreads; ++j) {
                    double dist = wc.ctr.distance(farPoints[j]);
                    if (!(dist < minDist)) continue;
                    minDist = dist;
                    threadNum = j;
                }
                this.wellConLists[threadNum].add(wc);
            }
        }
        for (int i = 0; i < numberOfThreads; ++i) {
            this.wellConIterator[i] = this.wellConLists[i].iterator();
        }
    }

    private void findDRCViolations(RTNode rtree, double minDist) {
        for (int j = 0; j < rtree.getTotal(); ++j) {
            Object child;
            if (rtree.getFlag()) {
                child = (WellBound)rtree.getChild(j);
                if (((WellBound)child).netID == null) continue;
                Rectangle2D.Double searchArea = new Rectangle2D.Double(((WellBound)child).bound.getMinX() - minDist, ((WellBound)child).bound.getMinY() - minDist, ((WellBound)child).bound.getWidth() + minDist * 2.0, ((WellBound)child).bound.getHeight() + minDist * 2.0);
                RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
                while (sea.hasNext()) {
                    PolyBase pb;
                    double trueDist;
                    WellBound other = (WellBound)sea.next();
                    if (other.netID.getIndex() <= ((WellBound)child).netID.getIndex() || ((WellBound)child).bound.getMinX() > other.bound.getMaxX() + minDist || other.bound.getMinX() > ((WellBound)child).bound.getMaxX() + minDist || ((WellBound)child).bound.getMinY() > other.bound.getMaxY() + minDist || other.bound.getMinY() > ((WellBound)child).bound.getMaxY() + minDist || !((trueDist = (pb = new PolyBase(((WellBound)child).bound)).polyDistance(other.bound)) < minDist)) continue;
                    ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
                    polyList.add(new PolyBase(((WellBound)child).bound));
                    polyList.add(new PolyBase(other.bound));
                    this.errorLogger.logMessage("Well areas too close (are " + TextUtils.formatDistance(trueDist) + " but should be " + TextUtils.formatDistance(minDist) + " apart)", polyList, this.cell, 0, true);
                }
                continue;
            }
            child = (RTNode)rtree.getChild(j);
            this.findDRCViolations((RTNode)child, minDist);
        }
    }

    private int getTreeSize(RTNode rtree) {
        int total = 0;
        if (rtree.getFlag()) {
            total += rtree.getTotal();
        } else {
            for (int j = 0; j < rtree.getTotal(); ++j) {
                RTNode child = (RTNode)rtree.getChild(j);
                total += this.getTreeSize(child);
            }
        }
        return total;
    }

    private void findWellNetPoints(RTNode rtree, Map<Integer, WellNet> wellNets) {
        for (int j = 0; j < rtree.getTotal(); ++j) {
            Object child;
            if (rtree.getFlag()) {
                Integer netNUM;
                WellNet wn;
                child = (WellBound)rtree.getChild(j);
                if (((WellBound)child).netID == null || (wn = wellNets.get(netNUM = new Integer(((WellBound)child).netID.getIndex()))) == null) continue;
                wn.pointsOnNet.add(new Point2D.Double(((WellBound)child).bound.getMinX(), ((WellBound)child).bound.getMinY()));
                wn.pointsOnNet.add(new Point2D.Double(((WellBound)child).bound.getMaxX(), ((WellBound)child).bound.getMinY()));
                wn.pointsOnNet.add(new Point2D.Double(((WellBound)child).bound.getMaxX(), ((WellBound)child).bound.getMaxY()));
                wn.pointsOnNet.add(new Point2D.Double(((WellBound)child).bound.getMinX(), ((WellBound)child).bound.getMaxY()));
                continue;
            }
            child = (RTNode)rtree.getChild(j);
            this.findWellNetPoints((RTNode)child, wellNets);
        }
    }

    private void findUnconnected(RTNode rtree, RTNode current, String title) {
        for (int j = 0; j < current.getTotal(); ++j) {
            Object child;
            if (current.getFlag()) {
                child = (WellBound)current.getChild(j);
                if (((WellBound)child).netID != null) continue;
                this.spreadWellSeed(((WellBound)child).bound.getCenterX(), ((WellBound)child).bound.getCenterY(), new NetValues(), rtree, 0);
                this.errorLogger.logError("No " + title + "-Well contact in this area", new EPoint(((WellBound)child).bound.getCenterX(), ((WellBound)child).bound.getCenterY()), this.cell, 0);
                continue;
            }
            child = (RTNode)current.getChild(j);
            this.findUnconnected(rtree, (RTNode)child, title);
        }
    }

    private void spreadWellSeed(double cX, double cY, NetValues wellNum, RTNode rtree, int threadIndex) {
        RTNode allFound = null;
        Point2D.Double ctr = new Point2D.Double(cX, cY);
        Rectangle2D.Double searchArea = new Rectangle2D.Double(cX, cY, 0.0, 0.0);
        GenMath.MutableBoolean keepSearching = new GenMath.MutableBoolean(true);
        Rectangle2D[] sides = new Rectangle2D[4];
        for (int i = 0; i < 4; ++i) {
            sides[i] = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        boolean numSides = true;
        sides[0].setRect(searchArea);
        while (keepSearching.booleanValue()) {
            allFound = this.searchInArea(searchArea, wellNum, rtree, allFound, ctr, keepSearching, threadIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RTNode searchInArea(Rectangle2D searchArea, NetValues wellNum, RTNode rtree, RTNode allFound, Point2D ctr, GenMath.MutableBoolean keepSearching, int threadIndex) {
        keepSearching.setValue(false);
        RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
        while (sea.hasNext()) {
            WellBound wb = (WellBound)sea.next();
            if (wb.netID != null && wb.netID.getIndex() == wellNum.getIndex()) continue;
            if (allFound == null) {
                if (!wb.bound.contains(ctr)) {
                    continue;
                }
            } else {
                boolean touches = false;
                RTNode.Search subSea = new RTNode.Search(wb.bound, allFound, true);
                while (subSea.hasNext()) {
                    WellBound subWB = (WellBound)subSea.next();
                    if (!DBMath.rectsIntersect(subWB.bound, wb.bound)) continue;
                    touches = true;
                    break;
                }
                if (!touches) continue;
            }
            WellBound wellBound = wb;
            synchronized (wellBound) {
                if (wb.netID != null) {
                    wellNum.merge(wb.netID);
                } else {
                    wb.netID = wellNum;
                }
            }
            Rectangle2D.union(searchArea, wb.bound, searchArea);
            if (allFound == null) {
                allFound = RTNode.makeTopLevel();
            }
            allFound = RTNode.linkGeom(null, allFound, wb);
            keepSearching.setValue(true);
        }
        return allFound;
    }

    private static int getWellLayerType(Layer layer) {
        Layer.Function fun = layer.getFunction();
        if (layer.isPseudoLayer()) {
            return 0;
        }
        if (fun == Layer.Function.WELLP) {
            return 1;
        }
        if (fun == Layer.Function.WELL || fun == Layer.Function.WELLN) {
            return 2;
        }
        return 0;
    }

    private int doOldWay() {
        PrimitiveNode.Function desiredContact;
        WellCheckVisitor wcVisitor = new WellCheckVisitor();
        HierarchyEnumerator.enumerateCell(this.cell, VarContext.globalContext, (HierarchyEnumerator.Visitor)wcVisitor);
        if (this.job != null && this.job.checkAbort()) {
            return 0;
        }
        ArrayList<WellArea> wellAreas = new ArrayList<WellArea>();
        int wellIndex = 0;
        GeometryHandler topMerge = this.cellMerges.get(this.cell);
        for (Layer layer : topMerge.getKeySet()) {
            Collection<PolyBase> set = topMerge.getObjects(layer, false, true);
            for (PolyBase poly : set) {
                WellArea wa = new WellArea();
                wa.poly = poly;
                wa.poly.setLayer(layer);
                wa.poly.setStyle(Poly.Type.FILLED);
                wa.index = wellIndex++;
                wellAreas.add(wa);
            }
        }
        boolean foundPWell = false;
        boolean foundNWell = false;
        for (WellArea wa : wellAreas) {
            int wellType = ERCWellCheckOld.getWellLayerType(wa.poly.getLayer());
            if (wellType != 1 && wellType != 2) continue;
            desiredContact = PrimitiveNode.Function.SUBSTRATE;
            String noContactError = "No N-Well contact found in this area";
            int contactAction = this.wellPrefs.nWellCheck;
            if (wellType == 1) {
                desiredContact = PrimitiveNode.Function.WELL;
                contactAction = this.wellPrefs.pWellCheck;
                noContactError = "No P-Well contact found in this area";
                foundPWell = true;
            } else {
                foundNWell = true;
            }
            boolean found = false;
            for (WellCon wc : this.wellCons) {
                if (wc.fun != desiredContact || !wa.poly.getBounds2D().contains(wc.ctr) || !wa.poly.contains(wc.ctr)) continue;
                wa.netNum = wc.netNum;
                found = true;
                break;
            }
            if (found || contactAction != 0) continue;
            this.errorLogger.logError(noContactError, wa.poly, this.cell, 0);
        }
        for (WellCon wc : this.wellCons) {
            if (wc.netNum == -1) {
                String errorMsg = "N-Well contact is floating";
                if (ERCWellCheckOld.canBeSubstrateTap(wc.fun)) {
                    errorMsg = "P-Well contact is floating";
                }
                this.errorLogger.logError(errorMsg, new EPoint(wc.ctr.getX(), wc.ctr.getY()), this.cell, 0);
                continue;
            }
            if (wc.onProperRail) continue;
            if (ERCWellCheckOld.canBeSubstrateTap(wc.fun)) {
                if (!this.wellPrefs.mustConnectPWellToGround) continue;
                this.errorLogger.logError("P-Well contact not connected to ground", new EPoint(wc.ctr.getX(), wc.ctr.getY()), this.cell, 0);
                continue;
            }
            if (!this.wellPrefs.mustConnectNWellToPower) continue;
            this.errorLogger.logError("N-Well contact not connected to power", new EPoint(wc.ctr.getX(), wc.ctr.getY()), this.cell, 0);
        }
        if (this.wellPrefs.nWellCheck == 1 && foundNWell) {
            boolean found = false;
            for (WellCon wc : this.wellCons) {
                if (!ERCWellCheckOld.canBeWellTap(wc.fun)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.errorLogger.logError("No N-Well contact found in this cell", this.cell, 0);
            }
        }
        if (this.wellPrefs.pWellCheck == 1 && foundPWell) {
            boolean found = false;
            for (WellCon wc : this.wellCons) {
                if (!ERCWellCheckOld.canBeSubstrateTap(wc.fun)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.errorLogger.logError("No P-Well contact found in this cell", this.cell, 0);
            }
        }
        if (this.wellPrefs.drcCheck) {
            HashMap<Layer, DRCTemplate> rulesCon = new HashMap<Layer, DRCTemplate>();
            HashMap<Layer, DRCTemplate> rulesNonCon = new HashMap<Layer, DRCTemplate>();
            for (WellArea wa : wellAreas) {
                for (WellArea oWa : wellAreas) {
                    int layertype;
                    double dist;
                    DRCTemplate rule;
                    Layer waLayer;
                    if (this.job != null && this.job.checkAbort()) {
                        return 0;
                    }
                    if (wa.index <= oWa.index || (waLayer = wa.poly.getLayer()) != oWa.poly.getLayer()) continue;
                    boolean con = false;
                    if (wa.netNum == oWa.netNum && wa.netNum >= 0) {
                        con = true;
                    }
                    DRCTemplate dRCTemplate = rule = con ? (DRCTemplate)rulesCon.get(waLayer) : (DRCTemplate)rulesNonCon.get(waLayer);
                    if (rule == null && (rule = DRC.getSpacingRule(waLayer, null, waLayer, null, con, -1, 0.0, 0.0)) != null) {
                        if (con) {
                            rulesCon.put(waLayer, rule);
                        } else {
                            rulesNonCon.put(waLayer, rule);
                        }
                    }
                    double ruleValue = -1.0;
                    if (rule != null) {
                        ruleValue = rule.getValue(0);
                    }
                    if (ruleValue < 0.0 || wa.poly.getBounds2D().getMinX() > oWa.poly.getBounds2D().getMaxX() + ruleValue || oWa.poly.getBounds2D().getMinX() > wa.poly.getBounds2D().getMaxX() + ruleValue || wa.poly.getBounds2D().getMinY() > oWa.poly.getBounds2D().getMaxY() + ruleValue || oWa.poly.getBounds2D().getMinY() > wa.poly.getBounds2D().getMaxY() + ruleValue || !((dist = wa.poly.separation(oWa.poly)) > 0.0) || !(dist < ruleValue) || (layertype = ERCWellCheckOld.getWellLayerType(waLayer)) == 0) continue;
                    ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
                    polyList.add(wa.poly);
                    polyList.add(oWa.poly);
                    this.errorLogger.logMessage(waLayer.getName() + " areas too close (are " + TextUtils.formatDistance(dist) + ", should be " + TextUtils.formatDistance(ruleValue) + ")", polyList, this.cell, 0, true);
                }
            }
        }
        if (this.wellPrefs.findWorstCaseWell) {
            this.worstPWellDist = 0.0;
            this.worstPWellCon = null;
            this.worstPWellEdge = null;
            this.worstNWellDist = 0.0;
            this.worstNWellCon = null;
            this.worstNWellEdge = null;
            for (WellArea wa : wellAreas) {
                int wellType = ERCWellCheckOld.getWellLayerType(wa.poly.getLayer());
                if (wellType == 0) continue;
                desiredContact = PrimitiveNode.Function.SUBSTRATE;
                if (wellType == 1) {
                    desiredContact = PrimitiveNode.Function.WELL;
                }
                Point2D[] points = wa.poly.getPoints();
                int count2 = points.length;
                for (int i = 0; i < count2 * 2; ++i) {
                    Point2D testPoint = null;
                    if (i < count2) {
                        int prev = i - 1;
                        if (i == 0) {
                            prev = count2 - 1;
                        }
                        testPoint = new Point2D.Double((points[prev].getX() + points[i].getX()) / 2.0, (points[prev].getY() + points[i].getY()) / 2.0);
                    } else {
                        testPoint = points[i - count2];
                    }
                    boolean first = true;
                    double bestDist = 0.0;
                    WellCon bestWc = null;
                    for (WellCon wc : this.wellCons) {
                        if (wc.fun != desiredContact || !wa.poly.getBounds2D().contains(wc.ctr) || !wa.poly.contains(wc.ctr)) continue;
                        double dist = testPoint.distance(wc.ctr);
                        if (first || dist < bestDist) {
                            bestDist = dist;
                            bestWc = wc;
                        }
                        first = false;
                    }
                    if (first) continue;
                    if (wellType == 1) {
                        if (!(bestDist > this.worstPWellDist)) continue;
                        this.worstPWellDist = bestDist;
                        this.worstPWellCon = bestWc.ctr;
                        this.worstPWellEdge = testPoint;
                        continue;
                    }
                    if (!(bestDist > this.worstNWellDist)) continue;
                    this.worstNWellDist = bestDist;
                    this.worstNWellCon = bestWc.ctr;
                    this.worstNWellEdge = testPoint;
                }
            }
        }
        this.wellCons.clear();
        this.doneCells.clear();
        this.cellMerges.clear();
        this.errorLogger.termLogging(true);
        int errorCount = this.errorLogger.getNumErrors();
        return errorCount;
    }

    private void initStatistics() {
    }

    private void showStatistics() {
    }

    private static boolean canBeSubstrateTap(PrimitiveNode.Function fun) {
        return fun == PrimitiveNode.Function.SUBSTRATE || fun == PrimitiveNode.Function.RESPWELL;
    }

    private static boolean canBeWellTap(PrimitiveNode.Function fun) {
        return fun == PrimitiveNode.Function.WELL || fun == PrimitiveNode.Function.RESNWELL;
    }

    private class ShowWellBoundOrder
    extends EModelessDialog {
        private Timer vcrTimer;
        private long vcrLastAdvance;
        private int wbIndex;
        private int speed;
        private JTextField tf;
        private Highlighter h;
        private Color[] hColors;

        public ShowWellBoundOrder() {
            super(TopLevel.isMDIMode() ? TopLevel.getCurrentJFrame() : null);
            this.hColors = new Color[]{Color.WHITE, Color.RED, Color.GREEN, Color.BLUE};
            this.initComponents();
            this.finishInitialization();
            this.setVisible(true);
            this.wbIndex = 0;
            EditWindow wnd = EditWindow.getCurrent();
            this.h = wnd.getHighlighter();
            this.h.clear();
        }

        private void initComponents() {
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Show ERC Progress");
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    ShowWellBoundOrder.this.closeDialog();
                }
            });
            JButton go = new JButton("Go");
            go.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ShowWellBoundOrder.this.goNow();
                }
            });
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)go, gridBagConstraints);
            JButton stop = new JButton("Stop");
            stop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ShowWellBoundOrder.this.stopNow();
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)stop, gridBagConstraints);
            JLabel lab = new JLabel("Speed:");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab, gridBagConstraints);
            this.speed = 1;
            this.tf = new JTextField(Integer.toString(this.speed));
            this.tf.getDocument().addDocumentListener(new BoundsPlayerDocumentListener());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.tf, gridBagConstraints);
            this.pack();
        }

        private void updateSpeed() {
            this.speed = TextUtils.atoi(this.tf.getText());
            if (this.vcrTimer != null) {
                this.vcrTimer.setDelay(this.speed);
            }
        }

        private void goNow() {
            if (this.vcrTimer == null) {
                ActionListener taskPerformer = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        ShowWellBoundOrder.this.tick();
                    }
                };
                this.vcrTimer = new Timer(this.speed, taskPerformer);
                this.vcrLastAdvance = System.currentTimeMillis();
                this.vcrTimer.start();
            }
        }

        private void stopNow() {
            if (this.vcrTimer == null) {
                return;
            }
            this.vcrTimer.stop();
            this.vcrTimer = null;
        }

        private void tick() {
            long curtime = System.currentTimeMillis();
            if (curtime - this.vcrLastAdvance < (long)this.speed) {
                return;
            }
            this.vcrLastAdvance = curtime;
            if (this.wbIndex >= ERCWellCheckOld.this.wellBoundSearchOrder.size()) {
                this.stopNow();
            } else {
                WellBoundRecord wbr = (WellBoundRecord)ERCWellCheckOld.this.wellBoundSearchOrder.get(this.wbIndex++);
                this.h.addPoly(new Poly(wbr.wb.bound), ERCWellCheckOld.this.cell, this.hColors[wbr.processor]);
                this.h.finished();
            }
        }

        private class BoundsPlayerDocumentListener
        implements DocumentListener {
            BoundsPlayerDocumentListener() {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ShowWellBoundOrder.this.updateSpeed();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ShowWellBoundOrder.this.updateSpeed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ShowWellBoundOrder.this.updateSpeed();
            }
        }
    }

    private static class WellBoundRecord {
        WellBound wb;
        int processor;

        private WellBoundRecord(WellBound w, int p) {
            this.wb = w;
            this.processor = p;
        }
    }

    private class WellCheckVisitor
    extends HierarchyEnumerator.Visitor {
        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            if (ERCWellCheckOld.this.job != null && ERCWellCheckOld.this.job.checkAbort()) {
                return false;
            }
            Cell cell = info.getCell();
            if (ERCWellCheckOld.this.cellMerges.get(cell) == null) {
                GeometryHandler thisMerge = GeometryHandler.createGeometryHandler(ERCWellCheckOld.this.mode, ercLayersArray.length);
                ERCWellCheckOld.this.cellMerges.put(cell, thisMerge);
            }
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            if (ERCWellCheckOld.this.job != null && ERCWellCheckOld.this.job.checkAbort()) {
                return;
            }
            Cell cell = info.getCell();
            GeometryHandler thisMerge = (GeometryHandler)ERCWellCheckOld.this.cellMerges.get(cell);
            if (thisMerge == null) {
                throw new Error("wrong condition in ERCWellCheck.enterCell()");
            }
            if (!ERCWellCheckOld.this.doneCells.contains(cell)) {
                Iterator<Geometric> it = cell.getArcs();
                while (it.hasNext()) {
                    ArcInst ai = it.next();
                    Technology tech = ai.getProto().getTechnology();
                    for (Poly poly : tech.getShapeOfArc(ai, ercLayers)) {
                        Layer layer = poly.getLayer();
                        Poly newElem = poly;
                        thisMerge.add(layer, newElem);
                    }
                }
                thisMerge.postProcess(true);
                it = cell.getNodes();
                while (it.hasNext()) {
                    GeometryHandler subMerge;
                    NodeInst ni = (NodeInst)it.next();
                    if (!ni.isCellInstance() || (subMerge = (GeometryHandler)ERCWellCheckOld.this.cellMerges.get(ni.getProto())) == null) continue;
                    AffineTransform tTrans = ni.translateOut(ni.rotateOut());
                    thisMerge.addAll(subMerge, tTrans);
                }
                ERCWellCheckOld.this.doneCells.add(cell);
            }
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            PrimitiveNode.Function fun;
            NodeInst ni = no.getNodeInst();
            if (NodeInst.isSpecialNode(ni)) {
                return false;
            }
            AffineTransform trans = null;
            Cell cell = info.getCell();
            if (!ERCWellCheckOld.this.doneCells.contains(cell) && !ni.isCellInstance()) {
                GeometryHandler thisMerge = (GeometryHandler)ERCWellCheckOld.this.cellMerges.get(cell);
                PrimitiveNode pNp = (PrimitiveNode)ni.getProto();
                Technology tech = pNp.getTechnology();
                for (Poly poly : tech.getShapeOfNode(ni, true, true, ercLayers)) {
                    Layer layer = poly.getLayer();
                    if (trans == null) {
                        trans = ni.rotateOut();
                    }
                    poly.transform(trans);
                    Poly newElem = poly;
                    thisMerge.add(layer, newElem);
                }
            }
            if (ERCWellCheckOld.canBeSubstrateTap(fun = ni.getFunction()) || ERCWellCheckOld.canBeWellTap(fun)) {
                WellCon wc = new WellCon();
                wc.ctr = ni.getTrueCenter();
                if (trans == null) {
                    trans = ni.rotateOut();
                }
                trans.transform(wc.ctr, wc.ctr);
                info.getTransformToRoot().transform(wc.ctr, wc.ctr);
                wc.fun = fun;
                PortInst pi = ni.getOnlyPortInst();
                Netlist netList = info.getNetlist();
                Network net = netList.getNetwork(pi);
                wc.netNum = info.getNetID(net);
                wc.onProperRail = false;
                if (net != null) {
                    boolean searchWell = ERCWellCheckOld.canBeSubstrateTap(fun);
                    Network parentNet = net;
                    HierarchyEnumerator.CellInfo cinfo = info;
                    while (cinfo.getParentInst() != null) {
                        parentNet = cinfo.getNetworkInParent(parentNet);
                        cinfo = cinfo.getParentInfo();
                    }
                    if (parentNet != null) {
                        Iterator<Export> it = parentNet.getExports();
                        while (!wc.onProperRail && it.hasNext()) {
                            Export exp = it.next();
                            if ((!searchWell || !exp.isGround()) && (searchWell || !exp.isPower())) continue;
                            wc.onProperRail = true;
                        }
                    }
                }
                ERCWellCheckOld.this.wellCons.add(wc);
            }
            return true;
        }
    }

    private static class WellArea {
        PolyBase poly;
        int netNum;
        int index;

        private WellArea() {
        }
    }

    private class NewWellCheckVisitor
    extends HierarchyEnumerator.Visitor {
        private Map<Cell, List<Rectangle2D>> essentialPWell = new HashMap<Cell, List<Rectangle2D>>();
        private Map<Cell, List<Rectangle2D>> essentialNWell = new HashMap<Cell, List<Rectangle2D>>();
        private Map<Network, NetRails> networkCache = new HashMap<Network, NetRails>();
        private Map<Integer, Transistor> neighborCache;

        public NewWellCheckVisitor() {
            ERCWellCheckOld.this.networkExportAvailable = new HashSet();
            this.neighborCache = new HashMap<Integer, Transistor>();
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            if (ERCWellCheckOld.this.job != null && ERCWellCheckOld.this.job.checkAbort()) {
                return false;
            }
            Cell cell = info.getCell();
            this.ensureCellCached(cell);
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Rectangle2D.Double bounds;
            if (ERCWellCheckOld.this.job != null && ERCWellCheckOld.this.job.checkAbort()) {
                return;
            }
            Cell cell = info.getCell();
            List<Rectangle2D> pWellsInCell = this.essentialPWell.get(cell);
            List<Rectangle2D> nWellsInCell = this.essentialNWell.get(cell);
            for (Rectangle2D b : pWellsInCell) {
                bounds = new Rectangle2D.Double(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
                DBMath.transformRect(bounds, info.getTransformToRoot());
                ERCWellCheckOld.this.pWellRoot = RTNode.linkGeom(null, ERCWellCheckOld.this.pWellRoot, new WellBound(bounds));
            }
            for (Rectangle2D b : nWellsInCell) {
                bounds = new Rectangle2D.Double(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
                DBMath.transformRect(bounds, info.getTransformToRoot());
                ERCWellCheckOld.this.nWellRoot = RTNode.linkGeom(null, ERCWellCheckOld.this.nWellRoot, new WellBound(bounds));
            }
        }

        private void addNetwork(Network net, AtomicInteger netNum, HierarchyEnumerator.CellInfo cinfo, Transistor trans) {
            if (net != null) {
                Integer num = cinfo.getNetID(net);
                netNum.set(num);
                if (!ERCWellCheckOld.this.transistors.containsKey(num)) {
                    LinkedList tmpList = new LinkedList();
                    ERCWellCheckOld.this.transistors.put(num, tmpList);
                }
                ((List)ERCWellCheckOld.this.transistors.get(num)).add(trans);
            }
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeInst ni = no.getNodeInst();
            PrimitiveNode.Function fun = ni.getFunction();
            Netlist netList = info.getNetlist();
            if ((fun.isNTypeTransistor() || fun.isPTypeTransistor()) && useFelixCode) {
                Transistor trans = new Transistor();
                this.addNetwork(netList.getNetwork(ni.getTransistorDrainPort()), trans.drainNet, info, trans);
                this.addNetwork(netList.getNetwork(ni.getTransistorSourcePort()), trans.sourceNet, info, trans);
            } else if (ERCWellCheckOld.canBeSubstrateTap(fun) || ERCWellCheckOld.canBeWellTap(fun)) {
                Iterator<PortInst> pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi = pIt.next();
                    WellCon wc = new WellCon();
                    wc.ctr = ni.getTrueCenter();
                    AffineTransform trans = ni.rotateOut();
                    trans.transform(wc.ctr, wc.ctr);
                    info.getTransformToRoot().transform(wc.ctr, wc.ctr);
                    wc.fun = fun;
                    Network net = netList.getNetwork(pi);
                    wc.onProperRail = false;
                    wc.onRail = false;
                    wc.wellNum = null;
                    wc.ni = ni;
                    if (net == null) {
                        wc.netNum = -1;
                    } else {
                        wc.netNum = info.getNetID(net);
                        Network parentNet = net;
                        HierarchyEnumerator.CellInfo cinfo = info;
                        while (cinfo.getParentInst() != null) {
                            parentNet = cinfo.getNetworkInParent(parentNet);
                            cinfo = cinfo.getParentInfo();
                        }
                        if (parentNet != null) {
                            boolean searchWell;
                            NetRails nr = this.networkCache.get(parentNet);
                            if (nr == null) {
                                nr = new NetRails();
                                this.networkCache.put(parentNet, nr);
                                Iterator<Export> it = parentNet.getExports();
                                while (it.hasNext()) {
                                    Export exp = it.next();
                                    ERCWellCheckOld.this.networkExportAvailable.add(parentNet.getNetIndex());
                                    if (exp.isGround()) {
                                        nr.onGround = true;
                                    }
                                    if (exp.isPower()) {
                                        nr.onPower = true;
                                    }
                                    nr.onExport = true;
                                }
                            }
                            if ((searchWell = ERCWellCheckOld.canBeSubstrateTap(fun)) && nr.onGround || !searchWell && nr.onPower) {
                                wc.onProperRail = true;
                            }
                            if (nr.onExport && useFelixCode) {
                                wc.onRail = true;
                            }
                        }
                    }
                    ERCWellCheckOld.this.wellCons.add(wc);
                }
            }
            return true;
        }

        private void ensureCellCached(Cell cell) {
            List<Rectangle2D> pWellsInCell = this.essentialPWell.get(cell);
            List<Rectangle2D> nWellsInCell = this.essentialNWell.get(cell);
            if (pWellsInCell == null) {
                Layer layer;
                pWellsInCell = new ArrayList<Rectangle2D>();
                nWellsInCell = new ArrayList<Rectangle2D>();
                Iterator<Geometric> it = cell.getNodes();
                while (it.hasNext()) {
                    NodeInst ni = it.next();
                    if (ni.isCellInstance()) continue;
                    PrimitiveNode pn = (PrimitiveNode)ni.getProto();
                    if (!ERCWellCheckOld.this.possiblePrimitives.contains(pn)) continue;
                    for (Poly poly : pn.getTechnology().getShapeOfNode(ni, true, true, ercLayers)) {
                        layer = poly.getLayer();
                        AffineTransform trans = ni.rotateOut();
                        poly.transform(trans);
                        Rectangle2D bound = poly.getBounds2D();
                        int wellType = ERCWellCheckOld.getWellLayerType(layer);
                        if (wellType == 1) {
                            pWellsInCell.add(bound);
                            continue;
                        }
                        if (wellType != 2) continue;
                        nWellsInCell.add(bound);
                    }
                }
                it = cell.getArcs();
                while (it.hasNext()) {
                    ArcInst ai = (ArcInst)it.next();
                    ArcProto ap = ai.getProto();
                    if (!ERCWellCheckOld.this.possiblePrimitives.contains(ap)) continue;
                    for (Poly poly : ap.getTechnology().getShapeOfArc(ai, ercLayers)) {
                        layer = poly.getLayer();
                        Rectangle2D bound = poly.getBounds2D();
                        int wellType = ERCWellCheckOld.getWellLayerType(layer);
                        if (wellType == 1) {
                            pWellsInCell.add(bound);
                            continue;
                        }
                        if (wellType != 2) continue;
                        nWellsInCell.add(bound);
                    }
                }
                this.eliminateDuplicates(pWellsInCell);
                this.eliminateDuplicates(nWellsInCell);
                this.essentialPWell.put(cell, pWellsInCell);
                this.essentialNWell.put(cell, nWellsInCell);
            }
        }

        private void eliminateDuplicates(List<Rectangle2D> wbList) {
            Collections.sort(wbList, new RectangleBySize());
            block0: for (int i = 0; i < wbList.size(); ++i) {
                Rectangle2D b = wbList.get(i);
                for (int j = 0; j < i; ++j) {
                    Rectangle2D prevB = wbList.get(j);
                    if (!prevB.contains(b)) continue;
                    wbList.remove(i);
                    --i;
                    continue block0;
                }
            }
        }

        public void clear() {
            this.neighborCache.clear();
            this.networkCache.clear();
            this.neighborCache = null;
            this.networkCache = null;
        }
    }

    private static class RectangleBySize
    implements Comparator<Rectangle2D> {
        private RectangleBySize() {
        }

        @Override
        public int compare(Rectangle2D b1, Rectangle2D b2) {
            double s2;
            double s1 = b1.getWidth() * b1.getHeight();
            if (s1 > (s2 = b2.getWidth() * b2.getHeight())) {
                return -1;
            }
            if (s1 < s2) {
                return 1;
            }
            return 0;
        }
    }

    private static class WellNet {
        List<Point2D> pointsOnNet;
        List<WellCon> contactsOnNet;
        PrimitiveNode.Function fun;

        private WellNet() {
        }
    }

    private static class NetRails {
        boolean onGround;
        boolean onPower;
        boolean onExport;

        private NetRails() {
        }
    }

    private static class WellBound
    implements RTBounds {
        private Rectangle2D bound;
        private NetValues netID;

        WellBound(Rectangle2D bound) {
            this.bound = bound;
            this.netID = null;
        }

        @Override
        public Rectangle2D getBounds() {
            return this.bound;
        }

        public NetValues getNetID() {
            return this.netID;
        }

        public String toString() {
            return "Well Bound on net " + this.netID.getIndex();
        }
    }

    private static class Transistor {
        AtomicInteger drainNet = new AtomicInteger();
        AtomicInteger sourceNet = new AtomicInteger();

        private Transistor() {
        }
    }

    private static class WellCon {
        Point2D ctr;
        int netNum;
        NetValues wellNum;
        boolean onProperRail;
        boolean onRail;
        PrimitiveNode.Function fun;
        NodeInst ni;

        private WellCon() {
        }
    }

    private static class NetValues {
        private int index = NetValues.getFreeIndex();
        private static int indexValues;

        static void reset() {
            indexValues = 0;
        }

        static synchronized int getFreeIndex() {
            return indexValues++;
        }

        public int getIndex() {
            return this.index;
        }

        public synchronized void merge(NetValues other) {
            if (this.index == other.index) {
                return;
            }
            other.index = this.index;
        }
    }

    private class SpreadInThread
    extends Thread {
        private Semaphore whenDone;
        private int threadIndex;

        public SpreadInThread(String name, Semaphore whenDone, int index) {
            super(name);
            this.whenDone = whenDone;
            this.threadIndex = index;
            this.start();
        }

        @Override
        public void run() {
            ERCWellCheckOld.this.spreadSeeds(this.threadIndex);
            this.whenDone.release();
        }
    }

    private static class WellCheckJob
    extends Job {
        private Cell cell;
        private GeometryHandler.GHMode newAlgorithm;
        private double worstPWellDist;
        private double worstNWellDist;
        private EPoint worstPWellCon;
        private EPoint worstPWellEdge;
        private EPoint worstNWellCon;
        private EPoint worstNWellEdge;
        private WellCheckPreferences wellPrefs;

        private WellCheckJob(Cell cell, GeometryHandler.GHMode newAlgorithm, WellCheckPreferences wellPrefs) {
            super("ERC Well Check on " + cell, ERC.tool, Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.newAlgorithm = newAlgorithm;
            this.wellPrefs = wellPrefs;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            ERCWellCheckOld check2 = new ERCWellCheckOld(this.cell, this, this.newAlgorithm, this.wellPrefs);
            check2.runNow();
            this.worstPWellDist = check2.worstPWellDist;
            this.fieldVariableChanged("worstPWellDist");
            this.worstNWellDist = check2.worstNWellDist;
            this.fieldVariableChanged("worstNWellDist");
            if (check2.worstPWellCon != null) {
                this.worstPWellCon = new EPoint(check2.worstPWellCon.getX(), check2.worstPWellCon.getY());
                this.fieldVariableChanged("worstPWellCon");
            }
            if (check2.worstPWellEdge != null) {
                this.worstPWellEdge = new EPoint(check2.worstPWellEdge.getX(), check2.worstPWellEdge.getY());
                this.fieldVariableChanged("worstPWellEdge");
            }
            if (check2.worstNWellCon != null) {
                this.worstNWellCon = new EPoint(check2.worstNWellCon.getX(), check2.worstNWellCon.getY());
                this.fieldVariableChanged("worstNWellCon");
            }
            if (check2.worstNWellEdge != null) {
                this.worstNWellEdge = new EPoint(check2.worstNWellEdge.getX(), check2.worstNWellEdge.getY());
                this.fieldVariableChanged("worstNWellEdge");
            }
            return true;
        }

        @Override
        public void terminateOK() {
            UserInterface ui = Job.getUserInterface();
            EditWindow_ wnd = ui.getCurrentEditWindow_();
            if (wnd != null && (this.worstPWellDist > 0.0 || this.worstNWellDist > 0.0)) {
                wnd.clearHighlighting();
                if (this.worstPWellDist > 0.0) {
                    wnd.addHighlightLine(this.worstPWellCon, this.worstPWellEdge, this.cell, false, false);
                    System.out.println("Farthest distance from a P-Well contact is " + this.worstPWellDist);
                }
                if (this.worstNWellDist > 0.0) {
                    wnd.addHighlightLine(this.worstNWellCon, this.worstNWellEdge, this.cell, false, false);
                    System.out.println("Farthest distance from an N-Well contact is " + this.worstNWellDist);
                }
                wnd.finishedHighlighting();
            }
        }
    }

    public static class WellCheckPreferences
    extends PrefPackage {
        private static final String PREF_NODE = "tool/erc";
        @PrefPackage.BooleanPref(node="tool/erc", key="ParallelWellAnalysis", factory=true)
        public boolean parallelWellAnalysis;
        @PrefPackage.IntegerPref(node="tool/erc", key="WellAnalysisNumProc", factory=0)
        public int maxProc;
        @PrefPackage.BooleanPref(node="tool/erc", key="MustConnectPWellToGround", factory=true)
        public boolean mustConnectPWellToGround;
        @PrefPackage.BooleanPref(node="tool/erc", key="MustConnectNWellToPower", factory=true)
        public boolean mustConnectNWellToPower;
        @PrefPackage.IntegerPref(node="tool/erc", key="PWellCheck", factory=0)
        public int pWellCheck;
        @PrefPackage.IntegerPref(node="tool/erc", key="NWellCheck", factory=0)
        public int nWellCheck;
        @PrefPackage.BooleanPref(node="tool/erc", key="DRCCheckInERC", factory=false)
        public boolean drcCheck;
        @PrefPackage.BooleanPref(node="tool/erc", key="FindWorstCaseWell", factory=false)
        public boolean findWorstCaseWell;

        public WellCheckPreferences(boolean factory) {
            super(factory);
        }
    }
}

