/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.util.TextUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LEFDEF
extends Input<Object> {
    protected static final boolean PLACELEFGEOMETRY = true;
    protected static final boolean PLACELEFEXPORTS = true;
    protected static List<ViaDef> viaDefsFromLEF;
    protected static HashMap<ArcProto, Double> widthsFromLEF;
    protected static Map<String, GetLayerInformation> knownLayers;
    protected static final double OVERALLSCALE = 1.0;
    protected static Variable.Key prXkey;
    protected static Variable.Key prYkey;
    protected Technology curTech;
    private boolean viaDigitsCombine;

    protected void initializeLEFDEF(Technology tech) {
        this.curTech = tech;
        this.viaDigitsCombine = false;
    }

    protected GetLayerInformation getLayerInformation(String name) {
        GetLayerInformation li;
        if (knownLayers != null && (li = knownLayers.get(name)) != null) {
            return li;
        }
        li = new GetLayerInformation(name);
        return li;
    }

    static {
        widthsFromLEF = new HashMap();
        prXkey = Variable.newKey("ATTR_LEFwidth");
        prYkey = Variable.newKey("ATTR_LEFheight");
    }

    protected class GetLayerInformation {
        NodeProto pin;
        NodeProto pure;
        ArcProto arc;
        ArcProto.Function arcFun;
        Layer.Function layerFun;
        ArcProto viaArc1;
        ArcProto viaArc2;

        private NodeProto getPureLayerNode() {
            Iterator<Layer> it = LEFDEF.this.curTech.getLayers();
            while (it.hasNext()) {
                Layer lay = it.next();
                if (lay.getFunction() != this.layerFun) continue;
                return lay.getPureLayerNode();
            }
            return null;
        }

        GetLayerInformation(String name) {
            this.initialize(name, null);
        }

        GetLayerInformation(String name, String type) {
            this.initialize(name, type);
        }

        private void initialize(String name, String type) {
            this.pin = null;
            this.pure = null;
            this.arc = null;
            this.arcFun = ArcProto.Function.UNKNOWN;
            this.layerFun = Layer.Function.UNKNOWN;
            this.viaArc2 = null;
            this.viaArc1 = null;
            if ((name = name.toUpperCase()).startsWith("POLY")) {
                this.setupPolyLayer(name.substring(4));
                return;
            }
            if (name.startsWith("PDIF")) {
                this.arcFun = ArcProto.Function.DIFFP;
                this.layerFun = Layer.Function.DIFFP;
                this.pure = this.getPureLayerNode();
                return;
            }
            if (name.startsWith("NDIF")) {
                this.arcFun = ArcProto.Function.DIFFN;
                this.layerFun = Layer.Function.DIFFN;
                this.pure = this.getPureLayerNode();
                return;
            }
            if (name.startsWith("PWEL")) {
                this.layerFun = Layer.Function.WELLP;
                this.pure = this.getPureLayerNode();
                return;
            }
            if (name.startsWith("NWEL")) {
                this.layerFun = Layer.Function.WELLN;
                this.pure = this.getPureLayerNode();
                return;
            }
            if (name.equals("DIFF")) {
                this.arcFun = ArcProto.Function.DIFF;
                this.layerFun = Layer.Function.DIFF;
                this.pure = this.getPureLayerNode();
                return;
            }
            if (name.equals("CONT") || name.equals("CON")) {
                this.layerFun = Layer.Function.CONTACT1;
                this.pure = this.getPureLayerNode();
                return;
            }
            int j = 0;
            if (name.startsWith("VIA")) {
                j = 3;
            } else if (name.startsWith("V")) {
                j = 1;
            }
            if (j != 0) {
                this.setupViaLayer(name.substring(j));
                return;
            }
            j = 0;
            if (name.startsWith("METAL")) {
                j = 5;
            } else if (name.startsWith("MET")) {
                j = 3;
            } else if (name.startsWith("M")) {
                j = 1;
            }
            if (j != 0) {
                this.setupMetalLayer(name.substring(j));
                return;
            }
            if (type != null) {
                if (type.equalsIgnoreCase("masterslice")) {
                    j = 0;
                    if ((name = name.toUpperCase()).startsWith("POLY")) {
                        j = 4;
                    } else if (name.startsWith("P")) {
                        j = 1;
                    }
                    this.setupPolyLayer(name.substring(j));
                    return;
                }
                if (type.equalsIgnoreCase("cut")) {
                    j = 0;
                    if ((name = name.toUpperCase()).startsWith("VIA")) {
                        j = 3;
                    } else if (name.startsWith("V")) {
                        j = 1;
                    }
                    this.setupViaLayer(name.substring(j));
                    return;
                }
                if (type.equalsIgnoreCase("routing")) {
                    j = 0;
                    if (name.startsWith("METAL")) {
                        j = 5;
                    } else if (name.startsWith("MET")) {
                        j = 3;
                    } else if (name.startsWith("M")) {
                        j = 1;
                    }
                    name = name.substring(j);
                    while (name.length() > 0 && !Character.isDigit(name.charAt(0))) {
                        name = name.substring(1);
                    }
                    this.setupMetalLayer(name);
                    return;
                }
            }
        }

        private void setupMetalLayer(String name) {
            int layNum = TextUtils.atoi(name);
            this.arcFun = ArcProto.Function.getMetal(layNum);
            this.layerFun = Layer.Function.getMetal(layNum);
            if (this.arcFun == null || this.layerFun == null) {
                return;
            }
            Iterator<ArcProto> it = LEFDEF.this.curTech.getArcs();
            while (it.hasNext()) {
                ArcProto ap = it.next();
                if (ap.getFunction() != this.arcFun) continue;
                this.arc = ap;
                this.pin = ap.findPinProto();
                break;
            }
            this.pure = this.getPureLayerNode();
        }

        private void setupPolyLayer(String name) {
            int layNum = TextUtils.atoi(name);
            if (layNum == 0) {
                layNum = 1;
            }
            this.arcFun = ArcProto.Function.getPoly(layNum);
            this.layerFun = Layer.Function.getPoly(layNum);
            if (this.arcFun == null || this.layerFun == null) {
                return;
            }
            Iterator<ArcProto> it = LEFDEF.this.curTech.getArcs();
            while (it.hasNext()) {
                ArcProto ap = it.next();
                if (ap.getFunction() != this.arcFun) continue;
                this.arc = ap;
                this.pin = ap.findPinProto();
                break;
            }
            this.pure = this.getPureLayerNode();
        }

        private void setupViaLayer(String name) {
            ArcProto.Function aFunc1 = ArcProto.Function.UNKNOWN;
            ArcProto.Function aFunc2 = ArcProto.Function.UNKNOWN;
            if (name.length() <= 0) {
                aFunc1 = ArcProto.Function.METAL1;
                aFunc2 = ArcProto.Function.METAL2;
            } else if (name.length() <= 1) {
                int level = name.charAt(0) - 48;
                aFunc1 = level == 0 ? ArcProto.Function.getPoly(1) : ArcProto.Function.getMetal(level);
                aFunc2 = ArcProto.Function.getMetal(level + 1);
            } else {
                int level1 = name.charAt(0) - 48;
                int level2 = name.charAt(1) - 48;
                if (!LEFDEF.this.viaDigitsCombine && level2 <= level1) {
                    LEFDEF.this.viaDigitsCombine = true;
                }
                if (LEFDEF.this.viaDigitsCombine) {
                    level1 = level1 * 10 + level2;
                    level2 = level1 + 1;
                }
                aFunc1 = level1 == 0 ? ArcProto.Function.getPoly(1) : ArcProto.Function.getMetal(level1);
                aFunc2 = ArcProto.Function.getMetal(level2);
            }
            Iterator<Comparable<ArcProto>> it = LEFDEF.this.curTech.getArcs();
            while (it.hasNext()) {
                ArcProto apTry = it.next();
                if (apTry.getFunction() == aFunc1) {
                    this.viaArc1 = apTry;
                }
                if (apTry.getFunction() != aFunc2) continue;
                this.viaArc2 = apTry;
            }
            if (this.viaArc1 == null || this.viaArc2 == null) {
                return;
            }
            it = LEFDEF.this.curTech.getNodes();
            while (it.hasNext()) {
                PrimitiveNode np = (PrimitiveNode)it.next();
                if (np.getNumPorts() != 1) continue;
                PrimitivePort pp = np.getPort(0);
                boolean ap1Found = pp.connectsTo(this.viaArc1);
                boolean ap2Found = pp.connectsTo(this.viaArc2);
                if (!ap1Found || !ap2Found) continue;
                this.pin = np;
                break;
            }
            if (this.pin != null) {
                PrimitiveNode pNp = (PrimitiveNode)this.pin;
                Technology.NodeLayer[] nl = pNp.getNodeLayers();
                Layer viaLayer = null;
                for (int i = 0; i < nl.length; ++i) {
                    Technology.NodeLayer nLay = nl[i];
                    Layer lay = nLay.getLayer();
                    Layer.Function fun = lay.getFunction();
                    if (!fun.isContact()) continue;
                    viaLayer = lay;
                    this.layerFun = fun;
                    break;
                }
                if (viaLayer == null) {
                    return;
                }
                this.pure = viaLayer.getPureLayerNode();
            }
        }
    }

    protected static class ViaDef {
        protected String viaName;
        protected NodeProto via;
        protected ArcProto lay1;
        protected ArcProto lay2;
        protected double sX;
        protected double sY;

        public ViaDef(String name, NodeProto np) {
            this.viaName = name;
            this.sY = 0.0;
            this.sX = 0.0;
            this.via = np;
            this.lay2 = null;
            this.lay1 = null;
        }
    }
}

