/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.simulatedAnnealing2;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;

final class ProxyNode
implements Comparable<ProxyNode> {
    private double x;
    private double y;
    private Orientation orientation = null;
    public double width = 0.0;
    public double height = 0.0;
    public boolean finalized = false;
    private PlacementFrame.PlacementNode node = null;
    private ArrayList<PlacementFrame.PlacementNetwork> nets = new ArrayList();
    private HashMap<PlacementFrame.PlacementNetwork, PlacementFrame.PlacementNetwork> netMap = null;

    public ProxyNode(PlacementFrame.PlacementNode node, ArrayList<PlacementFrame.PlacementNetwork> ignoredNets) {
        this.node = node;
        this.x = node.getPlacementX();
        this.y = node.getPlacementY();
        this.width = node.getWidth();
        this.height = node.getHeight();
        for (PlacementFrame.PlacementPort p : node.getPorts()) {
            if (this.nets.contains(p.getPlacementNetwork()) || p.getPlacementNetwork() == null || ignoredNets.contains(p.getPlacementNetwork())) continue;
            this.nets.add(p.getPlacementNetwork());
        }
        this.orientation = node.getPlacementOrientation();
    }

    private ProxyNode(PlacementFrame.PlacementNode node, double x2, double y, double width, double height, Orientation o, ArrayList<PlacementFrame.PlacementNetwork> nets) {
        this.node = node;
        this.x = x2;
        this.y = y;
        this.nets = nets;
        this.width = width;
        this.height = height;
        this.orientation = o;
    }

    public void apply() {
        this.node.setPlacement(this.x, this.y);
        this.node.setOrientation(this.orientation);
    }

    public void setPlacement(double x2, double y) {
        this.x = x2;
        this.y = y;
    }

    public PlacementFrame.PlacementNode getNode() {
        return this.node;
    }

    public ProxyNode clone() {
        return new ProxyNode(this.node, this.x, this.y, this.width, this.height, this.orientation, this.nets);
    }

    public ArrayList<PlacementFrame.PlacementNetwork> getNets() {
        return this.nets;
    }

    public double getPlacementX() {
        return this.x;
    }

    public double getPlacementY() {
        return this.y;
    }

    public Orientation getPlacementOrientation() {
        return this.orientation;
    }

    public PlacementFrame.PlacementNetwork getOriginalNet(PlacementFrame.PlacementNetwork alteredNet) {
        if (this.netMap == null) {
            return alteredNet;
        }
        return this.netMap.get(alteredNet);
    }

    public void setPlacementOrientation(Orientation o, boolean forDummy) {
        Orientation oldOrientation = this.orientation;
        this.orientation = o;
        if (forDummy) {
            this.netMap = new HashMap();
            ArrayList<PlacementFrame.PlacementNetwork> newNets = new ArrayList<PlacementFrame.PlacementNetwork>(this.nets.size());
            for (PlacementFrame.PlacementNetwork net : this.nets) {
                ArrayList<PlacementFrame.PlacementPort> newPortsOnNet = new ArrayList<PlacementFrame.PlacementPort>();
                for (PlacementFrame.PlacementPort port : net.getPortsOnNet()) {
                    if (port.getPlacementNode() == this.node) {
                        AffineTransform trans = oldOrientation.inverse().pureRotate();
                        Point2D.Double offset = new Point2D.Double(port.getRotatedOffX(), port.getRotatedOffY());
                        trans.transform(offset, offset);
                        ProxyPort pp = new ProxyPort(((Point2D)offset).getX(), ((Point2D)offset).getY(), this);
                        pp.computeRotatedOffset();
                        newPortsOnNet.add(pp);
                        continue;
                    }
                    newPortsOnNet.add(port);
                }
                PlacementFrame.PlacementNetwork newNet = new PlacementFrame.PlacementNetwork(newPortsOnNet, net.isOnRail());
                this.netMap.put(net, newNet);
                newNets.add(newNet);
            }
            this.nets = newNets;
        } else {
            this.node.setOrientation(o);
        }
        if (o == Orientation.R || o == Orientation.RRR || o == Orientation.XR || o == Orientation.XRRR || o == Orientation.XYR || o == Orientation.XYRRR || o == Orientation.YR || o == Orientation.YRRR) {
            this.width = this.node.getHeight();
            this.height = this.node.getWidth();
        } else {
            this.width = this.node.getWidth();
            this.height = this.node.getHeight();
        }
    }

    @Override
    public int compareTo(ProxyNode o) {
        double dist1 = this.x * this.x + this.y * this.y;
        double dist2 = o.x * o.x + o.y * o.y;
        if (dist1 > dist2) {
            return 1;
        }
        return -1;
    }

    private final class ProxyPort
    extends PlacementFrame.PlacementPort {
        private double rotatedOffX;
        private double rotatedOffY;
        private ProxyNode proxyNode;
        private double offX;
        private double offY;

        public ProxyPort(double x2, double y, ProxyNode p) {
            super(x2, y);
            this.offX = x2;
            this.offY = y;
            this.proxyNode = p;
            this.setPlacementNode(p.getNode());
        }

        @Override
        public double getRotatedOffX() {
            return this.rotatedOffX;
        }

        @Override
        public double getRotatedOffY() {
            return this.rotatedOffY;
        }

        @Override
        public void computeRotatedOffset() {
            Orientation orient = this.proxyNode.getPlacementOrientation();
            if (orient == Orientation.IDENT) {
                this.rotatedOffX = this.offX;
                this.rotatedOffY = this.offY;
                return;
            }
            AffineTransform trans = orient.pureRotate();
            Point2D.Double offset = new Point2D.Double(this.offX, this.offY);
            trans.transform(offset, offset);
            this.rotatedOffX = ((Point2D)offset).getX();
            this.rotatedOffY = ((Point2D)offset).getY();
        }
    }
}

