/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.MutableBoolean;
import com.sun.electric.util.math.MutableInteger;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ClockRouter {
    EditingPreferences ep;
    Cell cell;
    Technology tech;
    double horizScale;
    double vertScale;
    double stubLength;
    Cell repeaterCell;
    double repeaterDistance;
    ArcProto horizArc;
    ArcProto vertArc;
    double horizArcWidth;
    double vertArcWidth;
    PrimitiveNode cornerContact;
    List<SubTree> allGroups;
    private static final int LEFT_EDGE = 0;
    private static final int RIGHT_EDGE = 1;
    private static final int UP_EDGE = 2;
    private static final int DOWN_EDGE = 3;

    public ClockRouter(EditingPreferences ep, Cell cell) {
        this.ep = ep;
        this.cell = cell;
        this.allGroups = new ArrayList<SubTree>();
        this.tech = Technology.getCurrent();
        this.vertScale = 1.0;
        this.horizScale = 1.0;
        this.stubLength = 10.0;
    }

    public double getArcWidth(ArcProto ap) {
        double arcWidth = ap.getDefaultLambdaBaseWidth(this.ep) * this.horizScale;
        return arcWidth;
    }

    public double getStubLength(ArcProto ap) {
        return this.stubLength;
    }

    private Point2D getContactSize(PrimitiveNode pnp, ArcProto ap1, double width1, ArcProto ap2, double width2) {
        double extra1 = width1 - ap1.getDefaultLambdaBaseWidth(this.ep);
        double extra2 = width2 - ap2.getDefaultLambdaBaseWidth(this.ep);
        double sizeX = pnp.getDefWidth(this.ep) + extra1;
        double sizeY = pnp.getDefHeight(this.ep) + extra2;
        return new Point2D.Double(sizeX, sizeY);
    }

    private PrimitiveNode findContact(Technology tech, int l1, int l2) {
        Iterator<PrimitiveNode> it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode pn = it.next();
            if (pn.getFunction() != PrimitiveNode.Function.CONTACT) continue;
            Technology.NodeLayer[] layers = pn.getNodeLayers();
            boolean sourceFound = false;
            boolean destFound = false;
            for (int j = 0; j < layers.length; ++j) {
                Layer.Function fun = layers[j].getLayer().getFunction();
                if (!fun.isMetal()) continue;
                if (fun.getLevel() == l1) {
                    sourceFound = true;
                }
                if (fun.getLevel() != l2) continue;
                destFound = true;
            }
            if (!sourceFound || !destFound) continue;
            return pn;
        }
        return null;
    }

    public static void routeHTree() {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        EditWindow_ wnd = ui.getCurrentEditWindow_();
        if (wnd == null) {
            return;
        }
        ArrayList<NeededHTree> treesToRoute = new ArrayList<NeededHTree>();
        Set<Network> nets = wnd.getHighlightedNetworks();
        if (nets.size() == 0) {
            NeededHTree nht = new NeededHTree();
            treesToRoute.add(nht);
        } else {
            Netlist netList = cell.getNetlist();
            if (netList == null) {
                System.out.println("Sorry, a deadlock aborted routing (network information unavailable).  Please try again");
                return;
            }
            Map<Network, ArcInst[]> arcMap = netList.getArcInstsByNetwork();
            for (Network net : nets) {
                ArcInst ai;
                int i;
                ArcInst[] arcs = arcMap.get(net);
                if (arcs == null) {
                    System.out.println("WARNING: Network " + net.describe(false) + " has no arcs on it");
                    continue;
                }
                NeededHTree nht = new NeededHTree();
                for (i = 0; i < arcs.length; ++i) {
                    ai = arcs[i];
                    if (ai.getProto() != Generic.tech().unrouted_arc) continue;
                    for (int e = 0; e < 2; ++e) {
                        PortInst pi = ai.getPortInst(e);
                        NodeInst ni = pi.getNodeInst();
                        if (!ni.isCellInstance()) continue;
                        Export ex = (Export)pi.getPortProto();
                        PortCharacteristic pc = ex.getCharacteristic();
                        if (pc.isClock()) {
                            nht.addDestination(new SerializablePortInst(pi));
                            continue;
                        }
                        if (pc != PortCharacteristic.OUT) continue;
                        SerializablePortInst spiNew = new SerializablePortInst(pi);
                        if (nht.source != null) {
                            if (nht.source.equals(spiNew)) continue;
                            System.out.println("ERROR: Network " + net.describe(false) + " has multiple drivers: " + nht.source.ni.describe(false) + ", port " + nht.source.portName + " and " + ni.describe(false) + ", port " + ex.getName());
                            continue;
                        }
                        nht.source = spiNew;
                    }
                }
                if (nht.source == null) {
                    System.out.println("ERROR: Network " + net.describe(false) + " has no source (driver)");
                    continue;
                }
                for (i = 0; i < arcs.length; ++i) {
                    ai = arcs[i];
                    if (ai.getProto() != Generic.tech().unrouted_arc) continue;
                    nht.originalArcs.add(ai);
                }
                treesToRoute.add(nht);
            }
        }
        String fileName = OpenFile.chooseInputFile(FileType.TEXT, "Clock-Tree Routing Directive file:");
        if (fileName == null) {
            return;
        }
        new HTreeRouteJob(treesToRoute, fileName, cell);
    }

    private boolean routeAlgorithm2(NeededHTree nht, String fileName, Cell cell) {
        String destinationNodeName = "";
        String destinationPortName = "";
        double sourceStubX = 0.0;
        double sourceStubY = 0.0;
        String pnrOutputFile = null;
        double pnrOutputScale = 1.0;
        SerializablePortInst sourceSPI = null;
        URL url = TextUtils.makeURLToFile(fileName);
        try {
            String directive;
            URLConnection urlCon = url.openConnection();
            InputStreamReader is = new InputStreamReader(urlCon.getInputStream());
            LineNumberReader lineReader = new LineNumberReader(is);
            block2: while ((directive = lineReader.readLine()) != null) {
                Iterator<Comparable<NodeInst>> it;
                String firstPart;
                String[] splitParts = directive.split(" ");
                ArrayList<String> parts = new ArrayList<String>();
                for (int j = 0; j < splitParts.length; ++j) {
                    if (splitParts[j].length() <= 0) continue;
                    parts.add(splitParts[j]);
                }
                if (parts.size() == 0 || (firstPart = (String)parts.get(0)).startsWith("#")) continue;
                if (firstPart.equalsIgnoreCase("DESTINATION")) {
                    for (int j = 1; j < parts.size(); ++j) {
                        if (((String)parts.get(j)).toLowerCase().startsWith("node=")) {
                            destinationNodeName = ((String)parts.get(j)).substring(5);
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("port=")) {
                            destinationPortName = ((String)parts.get(j)).substring(5);
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("stub=")) {
                            this.stubLength = TextUtils.atof(((String)parts.get(j)).substring(5));
                            continue;
                        }
                        System.out.println("ERROR on line " + lineReader.getLineNumber() + " of DESTINATION directive: unknown keyword (" + (String)parts.get(j) + ")");
                        lineReader.close();
                        return false;
                    }
                    continue;
                }
                if (firstPart.equalsIgnoreCase("SOURCE")) {
                    String sourceNodeName = "";
                    String sourcePortName = "";
                    for (int j = 1; j < parts.size(); ++j) {
                        if (((String)parts.get(j)).toLowerCase().startsWith("node=")) {
                            sourceNodeName = ((String)parts.get(j)).substring(5);
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("port=")) {
                            sourcePortName = ((String)parts.get(j)).substring(5);
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("stubx=")) {
                            sourceStubX = TextUtils.atof(((String)parts.get(j)).substring(6));
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("stuby=")) {
                            sourceStubY = TextUtils.atof(((String)parts.get(j)).substring(6));
                            continue;
                        }
                        System.out.println("ERROR on line " + lineReader.getLineNumber() + " of SOURCE directive: unknown keyword (" + (String)parts.get(j) + ")");
                        lineReader.close();
                        return false;
                    }
                    it = cell.getNodes();
                    while (it.hasNext()) {
                        NodeInst ni = it.next();
                        if (!ni.isCellInstance() || !ni.getProto().getName().equals(sourceNodeName)) continue;
                        PortProto pp = ni.getProto().findPortProto(sourcePortName);
                        if (pp == null) {
                            System.out.println("ERROR on line " + lineReader.getLineNumber() + " of SOURCE directive: cannot find port " + sourcePortName + " on node " + ni.describe(false));
                            lineReader.close();
                            return false;
                        }
                        sourceSPI = new SerializablePortInst(ni.findPortInstFromProto(pp));
                        continue block2;
                    }
                    continue;
                }
                if (firstPart.equalsIgnoreCase("REPEATER")) {
                    for (int j = 1; j < parts.size(); ++j) {
                        if (((String)parts.get(j)).toLowerCase().startsWith("cell=")) {
                            String repeaterCellName = ((String)parts.get(j)).substring(5);
                            for (Library lib : Library.getVisibleLibraries()) {
                                this.repeaterCell = lib.findNodeProto(repeaterCellName);
                                if (this.repeaterCell == null) continue;
                                break;
                            }
                            if (this.repeaterCell != null) continue;
                            System.out.println("WARNING on line " + lineReader.getLineNumber() + " of REPEATER cell unknown (" + repeaterCellName + ").  Not placing repeaters.");
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("dist=")) {
                            this.repeaterDistance = TextUtils.atof(((String)parts.get(j)).substring(5));
                            continue;
                        }
                        System.out.println("ERROR on line " + lineReader.getLineNumber() + " of REPEATER directive: unknown keyword (" + (String)parts.get(j) + ")");
                        lineReader.close();
                        return false;
                    }
                    continue;
                }
                if (firstPart.equalsIgnoreCase("PNR-OUTPUT")) {
                    if (!IOTool.hasPnR()) {
                        System.out.println("WARNING: PNR-OUTPUT directive ignored because PNR module is not installed");
                        continue;
                    }
                    for (int j = 1; j < parts.size(); ++j) {
                        if (((String)parts.get(j)).toLowerCase().startsWith("file=")) {
                            pnrOutputFile = ((String)parts.get(j)).substring(5);
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("scale=")) {
                            pnrOutputScale = TextUtils.atof(((String)parts.get(j)).substring(6));
                            continue;
                        }
                        System.out.println("ERROR on line " + lineReader.getLineNumber() + " of PNR-OUTPUT directive: unknown keyword (" + (String)parts.get(j) + ")");
                        lineReader.close();
                        return false;
                    }
                    continue;
                }
                if (firstPart.equalsIgnoreCase("LAYERS")) {
                    for (int j = 1; j < parts.size(); ++j) {
                        ArcProto.Function fun;
                        ArcProto ap;
                        int level;
                        if (((String)parts.get(j)).toLowerCase().startsWith("horizontal=")) {
                            this.horizArc = null;
                            level = TextUtils.atoi(((String)parts.get(j)).substring(11));
                            it = this.tech.getArcs();
                            while (it.hasNext()) {
                                ap = (ArcProto)it.next();
                                fun = ap.getFunction();
                                if (!fun.isMetal() || fun.getLevel() != level) continue;
                                this.horizArc = ap;
                            }
                            if (this.horizArc == null) {
                                System.out.println("ERROR on line " + lineReader.getLineNumber() + " horizontal layer unknown (" + level + ")");
                                lineReader.close();
                                return false;
                            }
                            this.horizArcWidth = this.getArcWidth(this.horizArc);
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("vertical=")) {
                            this.vertArc = null;
                            level = TextUtils.atoi(((String)parts.get(j)).substring(9));
                            it = this.tech.getArcs();
                            while (it.hasNext()) {
                                ap = (ArcProto)it.next();
                                fun = ap.getFunction();
                                if (!fun.isMetal() || fun.getLevel() != level) continue;
                                this.vertArc = ap;
                            }
                            if (this.vertArc == null) {
                                System.out.println("ERROR on line " + lineReader.getLineNumber() + " vertical layer unknown (" + level + ")");
                                lineReader.close();
                                return false;
                            }
                            this.vertArcWidth = this.getArcWidth(this.vertArc);
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("horizontal-scale=")) {
                            this.horizScale = TextUtils.atof(((String)parts.get(j)).substring(17));
                            continue;
                        }
                        if (((String)parts.get(j)).toLowerCase().startsWith("vertical-scale=")) {
                            this.vertScale = TextUtils.atof(((String)parts.get(j)).substring(15));
                            continue;
                        }
                        System.out.println("ERROR on line " + lineReader.getLineNumber() + " of LAYERS directive: unknown keyword (" + (String)parts.get(j) + ")");
                        lineReader.close();
                        return false;
                    }
                    if (this.horizArc == null || this.vertArc == null) continue;
                    int l1 = this.horizArc.getFunction().getLevel();
                    int l2 = this.vertArc.getFunction().getLevel();
                    this.cornerContact = this.findContact(this.tech, l1, l2);
                    if (this.cornerContact != null) continue;
                    System.out.println("WARNING on line " + lineReader.getLineNumber() + " cannot find contact to join metals " + l1 + " and " + l2);
                    lineReader.close();
                    return false;
                }
                if (!firstPart.equalsIgnoreCase("CHANNEL")) continue;
                SubTree st = new SubTree();
                for (int j = 1; j < parts.size(); ++j) {
                    SubTree subST;
                    String part = (String)parts.get(j);
                    if (part.toLowerCase().startsWith("name=")) {
                        st.setTreeName(part.substring(5));
                        continue;
                    }
                    if (part.toLowerCase().startsWith("in=")) {
                        st.inEdge = this.getDirectionName(part.substring(3));
                        if (st.inEdge >= 0) continue;
                        System.out.println("ERROR on line " + lineReader.getLineNumber() + " of CHANNEL directive: unknown 'in' edge (" + part.substring(3) + ")");
                        lineReader.close();
                        return false;
                    }
                    if (part.toLowerCase().startsWith("out=")) {
                        st.outEdge = this.getDirectionName(part.substring(4));
                        if (st.outEdge >= 0) continue;
                        System.out.println("ERROR on line " + lineReader.getLineNumber() + " of CHANNEL directive: unknown 'out' edge (" + part.substring(4) + ")");
                        lineReader.close();
                        return false;
                    }
                    SerializablePortInst found = null;
                    Iterator<NodeInst> it2 = cell.getNodes();
                    while (it2.hasNext()) {
                        NodeInst ni = it2.next();
                        if (!ni.isCellInstance() || !ni.getProto().getName().equals(destinationNodeName) || !ni.getName().endsWith(part)) continue;
                        PortProto pp = ni.getProto().findPortProto(destinationPortName);
                        if (pp == null) {
                            System.out.println("ERROR on line " + lineReader.getLineNumber() + " of CHANNEL directive: cannot find port " + destinationPortName + " on node " + ni.describe(false));
                            lineReader.close();
                            return false;
                        }
                        found = new SerializablePortInst(ni.findPortInstFromProto(pp));
                        break;
                    }
                    if (found == null && (subST = this.findSubTree(part)) != null) {
                        found = subST.output;
                    }
                    if (found == null) {
                        System.out.println("ERROR on line " + lineReader.getLineNumber() + " of CHANNEL directive: unknown node name (" + part + ")");
                        lineReader.close();
                        return false;
                    }
                    st.connections.add(found);
                }
                for (int i = 0; i < 100 && !st.route(); ++i) {
                }
                this.allGroups.add(st);
            }
            lineReader.close();
        }
        catch (IOException e) {
            System.out.println("Error reading " + fileName);
            return false;
        }
        if (sourceSPI != null && this.allGroups.size() > 0) {
            SubTree st = new SubTree();
            if (sourceStubX != 0.0 || sourceStubY != 0.0) {
                PortInst sourcePI = sourceSPI.getPortInst();
                EPoint sourcePT = sourcePI.getCenter();
                MakePoint sourceMP = new MakePoint(sourceSPI);
                EPoint ctr = EPoint.fromLambda(sourcePT.getX() + sourceStubX, sourcePT.getY() + sourceStubY);
                Point2D mpSize = this.getContactSize(this.cornerContact, this.horizArc, this.horizArcWidth, this.vertArc, this.vertArcWidth);
                MakePoint mp = new MakePoint(this.cornerContact, ctr, mpSize.getX(), mpSize.getY(), this.ep, cell);
                st.allPoints.add(mp);
                st.allConnections.add(new MakeConnection(sourceMP, mp));
                sourceSPI = new SerializablePortInst(mp.ni.getOnlyPortInst());
            }
            st.connectToSource(sourceSPI);
            this.allGroups.add(st);
        }
        for (SubTree st : this.allGroups) {
            st.placeArcs(st.serpentineConnections);
        }
        if (pnrOutputFile != null && IOTool.hasPnR()) {
            String outFileName = TextUtils.getFilePath(url) + pnrOutputFile;
            ArrayList<Poly> allPolys = new ArrayList<Poly>();
            for (SubTree st : this.allGroups) {
                ArcInst ai;
                Poly[] polys;
                for (MakePoint mp : st.allPoints) {
                    NodeInst ni = mp.ni;
                    if (ni == null || ni.getFunction().isPin()) continue;
                    for (Poly poly : polys = ni.getProto().getTechnology().getShapeOfNode(ni)) {
                        allPolys.add(poly);
                    }
                }
                for (MakeConnection mc : st.allConnections) {
                    ai = mc.ai;
                    if (ai == null) continue;
                    for (Poly poly : polys = ai.getProto().getTechnology().getShapeOfArc(ai)) {
                        allPolys.add(poly);
                    }
                }
                for (MakeConnection mc : st.serpentineConnections) {
                    ai = mc.ai;
                    if (ai == null) continue;
                    for (Poly poly : polys = ai.getProto().getTechnology().getShapeOfArc(ai)) {
                        allPolys.add(poly);
                    }
                }
            }
            IOTool.PnRPreferences pnrp = new IOTool.PnRPreferences(true);
            pnrp.writePnR(allPolys, pnrOutputScale, outFileName);
        }
        return false;
    }

    private SubTree findSubTree(String name) {
        for (SubTree subST : this.allGroups) {
            if (!name.equalsIgnoreCase(subST.treeName)) continue;
            return subST;
        }
        return null;
    }

    public int getDirectionName(String name) {
        if (name.equalsIgnoreCase("left")) {
            return 0;
        }
        if (name.equalsIgnoreCase("right")) {
            return 1;
        }
        if (name.equalsIgnoreCase("up")) {
            return 2;
        }
        if (name.equalsIgnoreCase("down")) {
            return 3;
        }
        return -1;
    }

    private boolean routeAlgorithm1(NeededHTree nht, Cell cell) {
        double cY;
        double cX;
        int i;
        int numDests = nht.destinations.size();
        int numOnes = 0;
        for (int i2 = 0; i2 < 32; ++i2) {
            if ((numDests & 1 << i2) == 0) continue;
            ++numOnes;
        }
        if (numOnes != 1) {
            System.out.println("ERROR: Network " + nht + " has " + numDests + " destinations which is not a power of 2");
            return false;
        }
        HashSet<ArcProto> possibleArcs = null;
        for (SerializablePortInst spi : nht.destinations) {
            ArcProto[] arcs = spi.getPortProto().getBasePort().getConnections();
            if (possibleArcs == null) {
                possibleArcs = new HashSet<ArcProto>();
                for (i = 0; i < arcs.length; ++i) {
                    ArcProto ap = arcs[i];
                    if (ap.getTechnology() == Generic.tech()) continue;
                    possibleArcs.add(ap);
                }
                continue;
            }
            ArrayList<ArcProto> removeThese = new ArrayList<ArcProto>();
            for (ArcProto ap : possibleArcs) {
                boolean found = false;
                for (int i3 = 0; i3 < arcs.length; ++i3) {
                    if (ap != arcs[i3]) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                removeThese.add(ap);
            }
            for (ArcProto ap : removeThese) {
                possibleArcs.remove(ap);
            }
        }
        if (possibleArcs.size() == 0) {
            System.out.println("ERROR: Cannot find a common arc to connect all points");
            return false;
        }
        ArcProto connectingArc = (ArcProto)possibleArcs.iterator().next();
        System.out.println("Routing on arc " + connectingArc.describe());
        boolean found = false;
        ArcProto[] connections = nht.source.getPortProto().getBasePort().getConnections();
        for (i = 0; i < connections.length; ++i) {
            if (connections[i] != connectingArc) continue;
            found = true;
            break;
        }
        if (!found) {
            System.out.println("Must bring source up to layer " + connectingArc.describe());
        }
        MutableBoolean mb = new MutableBoolean(true);
        Boolean horizontal = Boolean.FALSE;
        double widthFactor = 50.0;
        while (nht.destinations.size() > 1) {
            List<NodeInst> niList = this.reduceTreeLevel(nht, cell, connectingArc, horizontal, mb, widthFactor);
            horizontal = horizontal == null ? Boolean.valueOf(!mb.booleanValue()) : Boolean.valueOf(horizontal == false);
            widthFactor *= 2.0;
            nht.destinations.clear();
            for (NodeInst ni : niList) {
                nht.destinations.add(new SerializablePortInst(ni.getOnlyPortInst()));
            }
        }
        PortInst sourcePi = nht.destinations.get(0).getPortInst();
        PortInst treePi = nht.source.getPortInst();
        EPoint sourcePt = sourcePi.getCenter();
        EPoint treePt = treePi.getCenter();
        if (horizontal.booleanValue()) {
            cX = treePt.getX();
            cY = sourcePt.getY();
        } else {
            cX = sourcePt.getX();
            cY = treePt.getY();
        }
        PrimitiveNode np = connectingArc.findPinProto();
        double width = np.getDefWidth(this.ep);
        double height = np.getDefHeight(this.ep);
        NodeInst ni = NodeInst.makeInstance(np, this.ep, EPoint.fromLambda(cX, cY), width, height, cell);
        double arcWidth = connectingArc.getDefaultLambdaBaseWidth(this.ep) * widthFactor;
        ArcInst ai1 = ArcInst.makeInstanceBase(connectingArc, this.ep, arcWidth, sourcePi, ni.getOnlyPortInst());
        ArcInst ai2 = ArcInst.makeInstanceBase(connectingArc, this.ep, arcWidth, treePi, ni.getOnlyPortInst());
        if (ai1 != null) {
            ai1.setHeadExtended(false);
        }
        if (ai2 != null) {
            ai2.setTailExtended(false);
        }
        return true;
    }

    private double nonEuclideanDistance(EPoint pt1, EPoint pt2) {
        return Math.abs(pt1.getX() - pt2.getX()) + Math.abs(pt1.getY() - pt2.getY());
    }

    private List<NodeInst> reduceTreeLevel(NeededHTree nht, Cell cell, ArcProto connectingArc, Boolean horizontal, MutableBoolean didHorizontal, double widthFactor) {
        TreeMap<Double, ArrayList<PortPair>> allConnections = new TreeMap<Double, ArrayList<PortPair>>();
        for (int i = 0; i < nht.destinations.size(); ++i) {
            SerializablePortInst spi1 = nht.destinations.get(i);
            PortInst pi1 = spi1.getPortInst();
            EPoint pt1 = pi1.getCenter();
            for (int j = i + 1; j < nht.destinations.size(); ++j) {
                Double dist;
                ArrayList<PortPair> pairsThisDist;
                SerializablePortInst spi2 = nht.destinations.get(j);
                PortInst pi2 = spi2.getPortInst();
                EPoint pt2 = pi2.getCenter();
                double distance = this.nonEuclideanDistance(pt1, pt2);
                if (horizontal != null) {
                    if (horizontal.booleanValue()) {
                        if (Math.abs(pt1.getY() - pt2.getY()) > Math.abs(pt1.getX() - pt2.getX())) {
                            distance += Math.abs(pt1.getY() - pt2.getY()) * 100.0;
                        }
                    } else if (Math.abs(pt1.getX() - pt2.getX()) > Math.abs(pt1.getY() - pt2.getY())) {
                        distance += Math.abs(pt1.getX() - pt2.getX()) * 100.0;
                    }
                }
                if ((pairsThisDist = (ArrayList<PortPair>)allConnections.get(dist = new Double(distance))) == null) {
                    pairsThisDist = new ArrayList<PortPair>();
                    allConnections.put(dist, pairsThisDist);
                }
                pairsThisDist.add(new PortPair(spi1, spi2));
            }
        }
        for (SerializablePortInst spi : nht.destinations) {
            spi.flag = false;
        }
        ArrayList<PortPair> lowestList = new ArrayList<PortPair>();
        int portsSelected = 0;
        for (Double d : allConnections.keySet()) {
            List pairsThisDist = (List)allConnections.get(d);
            HashMap<SerializablePortInst, MutableInteger> found = new HashMap<SerializablePortInst, MutableInteger>();
            int highestCount = 0;
            for (PortPair pp : pairsThisDist) {
                MutableInteger mi = (MutableInteger)found.get(pp.s1);
                if (mi == null) {
                    mi = new MutableInteger(0);
                    found.put(pp.s1, mi);
                }
                mi.increment();
                if (mi.intValue() > highestCount) {
                    highestCount = mi.intValue();
                }
                if ((mi = (MutableInteger)found.get(pp.s2)) == null) {
                    mi = new MutableInteger(0);
                    found.put(pp.s2, mi);
                }
                mi.increment();
                if (mi.intValue() <= highestCount) continue;
                highestCount = mi.intValue();
            }
            for (int i = 1; i <= highestCount; ++i) {
                for (PortPair pp : pairsThisDist) {
                    if (pp.s1.flag || pp.s2.flag || ((MutableInteger)found.get(pp.s1)).intValue() > i && ((MutableInteger)found.get(pp.s2)).intValue() > i) continue;
                    lowestList.add(pp);
                    pp.s2.flag = true;
                    pp.s1.flag = true;
                    portsSelected += 2;
                }
            }
            if (portsSelected != nht.destinations.size()) continue;
            break;
        }
        double biggestDist = 0.0;
        for (PortPair pp : lowestList) {
            double dist = this.nonEuclideanDistance(pp.s1.getPortInst().getCenter(), pp.s2.getPortInst().getCenter());
            if (dist > biggestDist) {
                biggestDist = dist;
            }
            PortInst pi1 = pp.s1.getPortInst();
            EPoint pt1 = pi1.getCenter();
            PortInst pi2 = pp.s2.getPortInst();
            EPoint pt2 = pi2.getCenter();
            didHorizontal.setValue(Math.abs(pt1.getX() - pt2.getX()) > Math.abs(pt1.getY() - pt2.getY()));
        }
        ArrayList<NodeInst> reducedPoints = new ArrayList<NodeInst>();
        PrimitiveNode np = connectingArc.findPinProto();
        double width = np.getDefWidth(this.ep);
        double height = np.getDefHeight(this.ep);
        double arcWidth = connectingArc.getDefaultLambdaBaseWidth(this.ep) * widthFactor;
        for (PortPair pp : lowestList) {
            double y2s;
            double x2s;
            double y1s;
            double x1s;
            double x2;
            double x1;
            double y2;
            double y1;
            double quarterDist;
            PortInst pi2;
            EPoint pt2;
            PortInst pi1 = pp.s1.getPortInst();
            EPoint pt1 = pi1.getCenter();
            double dist = this.nonEuclideanDistance(pt1, pt2 = (pi2 = pp.s2.getPortInst()).getCenter());
            if (dist == biggestDist) {
                double cX = (pt1.getX() + pt2.getX()) / 2.0;
                double cY = (pt1.getY() + pt2.getY()) / 2.0;
                NodeInst ni = NodeInst.makeInstance(np, this.ep, EPoint.fromLambda(cX, cY), width, height, cell);
                ArcInst ai1 = ArcInst.makeInstanceBase(connectingArc, this.ep, arcWidth, pi1, ni.getOnlyPortInst());
                ArcInst ai2 = ArcInst.makeInstanceBase(connectingArc, this.ep, arcWidth, pi2, ni.getOnlyPortInst());
                ai1.setHeadExtended(false);
                ai1.setTailExtended(false);
                ai2.setHeadExtended(false);
                ai2.setTailExtended(false);
                reducedPoints.add(ni);
                continue;
            }
            double extraAmount = (biggestDist - dist) / 2.0;
            if (Math.abs(pt1.getX() - pt2.getX()) > Math.abs(pt1.getY() - pt2.getY())) {
                quarterDist = Math.abs(pt1.getX() - pt2.getX()) / 4.0;
                y1 = pt1.getY();
                y2 = pt2.getY();
                if (pt1.getX() > pt2.getX()) {
                    x1 = pt1.getX() - quarterDist;
                    x2 = pt2.getX() + quarterDist;
                } else {
                    x1 = pt1.getX() + quarterDist;
                    x2 = pt2.getX() - quarterDist;
                }
                x1s = x1;
                y1s = y1 + extraAmount;
                x2s = x2;
                y2s = y2 + extraAmount;
            } else {
                quarterDist = Math.abs(pt1.getY() - pt2.getY()) / 4.0;
                x1 = pt1.getX();
                x2 = pt2.getX();
                if (pt1.getY() > pt2.getY()) {
                    y1 = pt1.getY() - quarterDist;
                    y2 = pt2.getY() + quarterDist;
                } else {
                    y1 = pt1.getY() + quarterDist;
                    y2 = pt2.getY() - quarterDist;
                }
                x1s = x1 + extraAmount;
                y1s = y1;
                x2s = x2 + extraAmount;
                y2s = y2;
            }
            NodeInst ni1 = NodeInst.makeInstance(np, this.ep, EPoint.fromLambda(x1, y1), width, height, cell);
            NodeInst ni2 = NodeInst.makeInstance(np, this.ep, EPoint.fromLambda(x2, y2), width, height, cell);
            NodeInst ni1s = NodeInst.makeInstance(np, this.ep, EPoint.fromLambda(x1s, y1s), width, height, cell);
            NodeInst ni2s = NodeInst.makeInstance(np, this.ep, EPoint.fromLambda(x2s, y2s), width, height, cell);
            ArcInst.makeInstanceBase(connectingArc, this.ep, arcWidth, pi1, ni1.getOnlyPortInst());
            ArcInst.makeInstanceBase(connectingArc, this.ep, arcWidth, pi2, ni2.getOnlyPortInst());
            ArcInst.makeInstanceBase(connectingArc, this.ep, arcWidth, ni1.getOnlyPortInst(), ni1s.getOnlyPortInst());
            ArcInst.makeInstanceBase(connectingArc, this.ep, arcWidth, ni2.getOnlyPortInst(), ni2s.getOnlyPortInst());
            double cX = (x1s + x2s) / 2.0;
            double cY = (y1s + y2s) / 2.0;
            NodeInst ni = NodeInst.makeInstance(np, this.ep, EPoint.fromLambda(cX, cY), width, height, cell);
            ArcInst ai1 = ArcInst.makeInstanceBase(connectingArc, this.ep, arcWidth, ni1s.getOnlyPortInst(), ni.getOnlyPortInst());
            ArcInst ai2 = ArcInst.makeInstanceBase(connectingArc, this.ep, arcWidth, ni2s.getOnlyPortInst(), ni.getOnlyPortInst());
            ai1.setHeadExtended(false);
            ai1.setTailExtended(false);
            ai2.setHeadExtended(false);
            ai2.setTailExtended(false);
            reducedPoints.add(ni);
        }
        return reducedPoints;
    }

    private static class PortPair {
        SerializablePortInst s1;
        SerializablePortInst s2;

        PortPair(SerializablePortInst s1, SerializablePortInst s2) {
            this.s1 = s1;
            this.s2 = s2;
        }
    }

    private class MakeConnection {
        ArcProto ap = null;
        ArcInst ai;
        double width = 0.0;
        MakePoint from;
        MakePoint to;

        MakeConnection(MakePoint from2, MakePoint to2) {
            if (from2.loc.getX() == to2.loc.getX()) {
                this.ap = ClockRouter.this.vertArc;
                this.width = ClockRouter.this.getArcWidth(this.ap);
            } else if (from2.loc.getY() == to2.loc.getY()) {
                this.ap = ClockRouter.this.horizArc;
                this.width = ClockRouter.this.getArcWidth(this.ap);
            }
            if (this.ap == null) {
                System.out.println("WARNING: Connection from (" + from2.loc.getX() + "," + from2.loc.getY() + ") to (" + to2.loc.getX() + "," + to2.loc.getY() + ") is nonManhattan");
                this.ap = ClockRouter.this.horizArc;
                this.width = ClockRouter.this.getArcWidth(this.ap);
            }
            this.from = from2;
            this.to = to2;
        }
    }

    private static class MakePoint {
        SerializablePortInst spi;
        NodeInst ni;
        EPoint loc;

        MakePoint(PrimitiveNode np, EPoint loc, double wid, double hei, EditingPreferences ep, Cell cell) {
            this.loc = loc;
            this.ni = NodeInst.makeInstance(np, ep, loc, wid, hei, cell);
        }

        MakePoint(SerializablePortInst spi) {
            this.loc = spi.getPortInst().getCenter();
            this.spi = spi;
        }
    }

    private static class SortConnections
    implements Comparator<SerializablePortInst> {
        private boolean horizontal;

        SortConnections(boolean horizontal) {
            this.horizontal = horizontal;
        }

        @Override
        public int compare(SerializablePortInst s1, SerializablePortInst s2) {
            EPoint p1 = s1.getPortInst().getCenter();
            EPoint p2 = s2.getPortInst().getCenter();
            if (this.horizontal) {
                return Double.compare(p1.getX(), p2.getX());
            }
            return Double.compare(p1.getY(), p2.getY());
        }
    }

    private class SubTree {
        private String treeName;
        List<SerializablePortInst> connections = new ArrayList<SerializablePortInst>();
        int inEdge;
        int outEdge;
        SerializablePortInst output;
        List<MakePoint> allPoints = new ArrayList<MakePoint>();
        List<MakeConnection> allConnections = new ArrayList<MakeConnection>();
        List<MakeConnection> serpentineConnections = new ArrayList<MakeConnection>();

        public void setTreeName(String name) {
            this.treeName = name;
        }

        public boolean route() {
            double chanHei;
            double chanWid;
            double lXPort = 0.0;
            double hXPort = 0.0;
            double lYPort = 0.0;
            double hYPort = 0.0;
            double lXNodes = 0.0;
            double hXNodes = 0.0;
            double lYNodes = 0.0;
            double hYNodes = 0.0;
            boolean first = true;
            for (SerializablePortInst spi : this.connections) {
                PortInst pi = spi.getPortInst();
                EPoint pt = pi.getCenter();
                ERectangle bound = spi.ni.getBounds();
                if (first) {
                    lXPort = hXPort = pt.getX();
                    lYPort = hYPort = pt.getY();
                    lXNodes = bound.getMinX();
                    hXNodes = bound.getMaxX();
                    lYNodes = bound.getMinY();
                    hYNodes = bound.getMaxY();
                    first = false;
                    continue;
                }
                if (pt.getX() < lXPort) {
                    lXPort = pt.getX();
                }
                if (pt.getX() > hXPort) {
                    hXPort = pt.getX();
                }
                if (pt.getY() < lYPort) {
                    lYPort = pt.getY();
                }
                if (pt.getY() > hYPort) {
                    hYPort = pt.getY();
                }
                if (bound.getMinX() < lXNodes) {
                    lXNodes = bound.getMinX();
                }
                if (bound.getMaxX() > hXNodes) {
                    hXNodes = bound.getMaxX();
                }
                if (bound.getMinY() < lYNodes) {
                    lYNodes = bound.getMinY();
                }
                if (!(bound.getMaxY() > hYNodes)) continue;
                hYNodes = bound.getMaxY();
            }
            if (hXPort - lXPort > hYPort - lYPort) {
                chanWid = hXNodes - lXNodes;
                chanHei = 10000.0;
            } else {
                chanWid = 10000.0;
                chanHei = hYNodes - lYNodes;
            }
            double lXChan = 0.0;
            double hXChan = 0.0;
            double lYChan = 0.0;
            double hYChan = 0.0;
            switch (this.outEdge) {
                case 0: {
                    lXChan = hXNodes;
                    hXChan = lXChan + chanWid;
                    lYChan = (lYNodes + hYNodes) / 2.0 - chanHei / 2.0;
                    hYChan = lYChan + chanHei;
                    break;
                }
                case 1: {
                    hXChan = lXNodes;
                    lXChan = hXChan - chanWid;
                    lYChan = (lYNodes + hYNodes) / 2.0 - chanHei / 2.0;
                    hYChan = lYChan + chanHei;
                    break;
                }
                case 2: {
                    lXChan = (lXNodes + hXNodes) / 2.0 - chanWid / 2.0;
                    hXChan = lXChan + chanWid;
                    hYChan = lYNodes;
                    lYChan = hYChan - chanHei;
                    break;
                }
                case 3: {
                    lXChan = (lXNodes + hXNodes) / 2.0 - chanWid / 2.0;
                    hXChan = lXChan + chanWid;
                    lYChan = hYNodes;
                    hYChan = lYChan + chanHei;
                }
            }
            Point2D mpSize = ClockRouter.this.getContactSize(ClockRouter.this.cornerContact, ClockRouter.this.horizArc, ClockRouter.this.horizArcWidth, ClockRouter.this.vertArc, ClockRouter.this.vertArcWidth);
            boolean horizontal = true;
            double stubX = 0.0;
            double stubY = 0.0;
            switch (this.outEdge) {
                case 0: {
                    horizontal = false;
                    stubX = ClockRouter.this.getStubLength(ClockRouter.this.horizArc);
                    break;
                }
                case 1: {
                    horizontal = false;
                    stubX = -ClockRouter.this.getStubLength(ClockRouter.this.horizArc);
                    break;
                }
                case 2: {
                    stubY = -ClockRouter.this.getStubLength(ClockRouter.this.vertArc);
                    break;
                }
                case 3: {
                    stubY = ClockRouter.this.getStubLength(ClockRouter.this.vertArc);
                }
            }
            Collections.sort(this.connections, new SortConnections(horizontal));
            List<SerializablePortInst> reducedConnections = this.connections;
            while (reducedConnections.size() > 1) {
                ArrayList<SerializablePortInst> newConnections = new ArrayList<SerializablePortInst>();
                for (int i = 0; i < reducedConnections.size() - 1; i += 2) {
                    SubTree subST;
                    SerializablePortInst sToLenghten;
                    double separation;
                    SerializablePortInst s1 = reducedConnections.get(i);
                    SerializablePortInst s2 = reducedConnections.get(i + 1);
                    PortInst pi1 = s1.getPortInst();
                    PortInst pi2 = s2.getPortInst();
                    EPoint p1 = pi1.getCenter();
                    EPoint p2 = pi2.getCenter();
                    double cX1 = p1.getX() + stubX;
                    double cY1 = p1.getY() + stubY;
                    double dist1 = s1.distanceTraversed + Math.abs(stubX) + Math.abs(stubY);
                    double cX2 = p2.getX() + stubX;
                    double cY2 = p2.getY() + stubY;
                    double dist2 = s2.distanceTraversed + Math.abs(stubX) + Math.abs(stubY);
                    if (horizontal) {
                        if (cY1 != cY2) {
                            if (this.outEdge == 3) {
                                if (cY1 < cY2) {
                                    dist1 += cY2 - cY1;
                                    cY1 = cY2;
                                } else {
                                    dist2 += cY1 - cY2;
                                    cY2 = cY1;
                                }
                            } else if (cY2 < cY1) {
                                dist1 += cY1 - cY2;
                                cY1 = cY2;
                            } else {
                                dist2 += cY2 - cY1;
                                cY2 = cY1;
                            }
                        }
                    } else if (cX1 != cX2) {
                        if (this.outEdge == 0) {
                            if (cX1 < cX2) {
                                dist1 += cX2 - cX1;
                                cX1 = cX2;
                            } else {
                                dist2 += cX1 - cX2;
                                cX2 = cX1;
                            }
                        } else if (cX2 < cX1) {
                            dist1 += cX1 - cX2;
                            cX1 = cX2;
                        } else {
                            dist2 += cX2 - cX1;
                            cX2 = cX1;
                        }
                    }
                    EPoint bend1 = EPoint.fromLambda(cX1, cY1);
                    EPoint bend2 = EPoint.fromLambda(cX2, cY2);
                    MakePoint mp1 = new MakePoint(ClockRouter.this.cornerContact, bend1, mpSize.getX(), mpSize.getY(), ClockRouter.this.ep, ClockRouter.this.cell);
                    this.allPoints.add(mp1);
                    MakePoint mp1a = new MakePoint(s1);
                    this.allConnections.add(new MakeConnection(mp1, mp1a));
                    MakePoint mp2 = new MakePoint(ClockRouter.this.cornerContact, bend2, mpSize.getX(), mpSize.getY(), ClockRouter.this.ep, ClockRouter.this.cell);
                    this.allPoints.add(mp2);
                    MakePoint mp2a = new MakePoint(s2);
                    this.allConnections.add(new MakeConnection(mp2, mp2a));
                    double pinX = 0.0;
                    double pinY = 0.0;
                    double lengthDifference = Math.abs(dist1 - dist2);
                    if (horizontal) {
                        pinY = cY1;
                        separation = Math.abs(cX1 - cX2);
                        if (lengthDifference <= separation) {
                            pinX = (cX1 + cX2) / 2.0;
                            pinX = cX1 > cX2 ? (pinX -= (dist1 - dist2) / 2.0) : (pinX -= (dist1 - dist2) / 2.0);
                        } else {
                            SerializablePortInst serializablePortInst = sToLenghten = dist1 < dist2 ? s1 : s2;
                            if (sToLenghten.subTreeName != null) {
                                subST = ClockRouter.this.findSubTree(sToLenghten.subTreeName);
                                if (subST != null) {
                                    SerializablePortInst newSPI = subST.addSerpentineAmount(lengthDifference);
                                    for (int j = 0; j < this.connections.size(); ++j) {
                                        if (this.connections.get(j) != sToLenghten) continue;
                                        this.connections.set(j, newSPI);
                                    }
                                    for (MakePoint mp : this.allPoints) {
                                        mp.ni.kill();
                                    }
                                    return false;
                                }
                                System.out.println("HORIZONTAL SUBTREE " + this.treeName + " NEEDS TO MAKE " + sToLenghten.subTreeName + " SERPENTINE BY " + lengthDifference + " WHICH DOESN'T FIT IN " + separation);
                            }
                        }
                    } else {
                        pinX = cX1;
                        separation = Math.abs(cY1 - cY2);
                        if (lengthDifference <= separation) {
                            pinY = (cY1 + cY2) / 2.0;
                            pinY = cY1 > cY2 ? (pinY -= (dist1 - dist2) / 2.0) : (pinY -= (dist1 - dist2) / 2.0);
                        } else {
                            SerializablePortInst serializablePortInst = sToLenghten = dist1 < dist2 ? s1 : s2;
                            if (sToLenghten.subTreeName != null) {
                                subST = ClockRouter.this.findSubTree(sToLenghten.subTreeName);
                                if (subST != null) {
                                    SerializablePortInst newSPI = subST.addSerpentineAmount(lengthDifference);
                                    for (int j = 0; j < this.connections.size(); ++j) {
                                        if (this.connections.get(j) != sToLenghten) continue;
                                        this.connections.set(j, newSPI);
                                    }
                                    for (MakePoint mp : this.allPoints) {
                                        mp.ni.kill();
                                    }
                                    return false;
                                }
                                System.out.println("VERTICAL SUBTREE " + this.treeName + " NEEDS TO MAKE " + sToLenghten.subTreeName + " SERPENTINE BY " + lengthDifference + " WHICH DOESN'T FIT IN " + separation);
                            }
                        }
                    }
                    EPoint pinLoc = EPoint.fromLambda(pinX, pinY);
                    if (dist1 + pinLoc.distance(bend1) != dist2 + pinLoc.distance(bend2)) {
                        System.out.println("HEY!!! " + dist1 + " + " + pinLoc.distance(bend1) + " NOT EQUAL TO " + dist2 + " + " + pinLoc.distance(bend2));
                    }
                    MakePoint mpPin = new MakePoint(ClockRouter.this.cornerContact, pinLoc, mpSize.getX(), mpSize.getY(), ClockRouter.this.ep, ClockRouter.this.cell);
                    this.allPoints.add(mpPin);
                    this.allConnections.add(new MakeConnection(mp1, mpPin));
                    this.allConnections.add(new MakeConnection(mp2, mpPin));
                    SerializablePortInst spiPin = new SerializablePortInst(mpPin.ni.getOnlyPortInst());
                    spiPin.distanceTraversed = dist1 + pinLoc.distance(bend1);
                    newConnections.add(spiPin);
                }
                if ((reducedConnections.size() & 1) != 0) {
                    newConnections.add(reducedConnections.get(reducedConnections.size() - 1));
                }
                reducedConnections = newConnections;
            }
            SerializablePortInst sTop = reducedConnections.get(0);
            PortInst piTop = sTop.getPortInst();
            EPoint pTop = piTop.getCenter();
            double outLocX = 0.0;
            double outLocY = 0.0;
            boolean outHorizontal = false;
            switch (this.inEdge) {
                case 0: {
                    outLocX = !horizontal ? pTop.getX() - ClockRouter.this.getStubLength(ClockRouter.this.horizArc) : lXChan;
                    outLocY = pTop.getY();
                    break;
                }
                case 1: {
                    outLocX = !horizontal ? pTop.getX() + ClockRouter.this.getStubLength(ClockRouter.this.horizArc) : hXChan;
                    outLocY = pTop.getY();
                    break;
                }
                case 2: {
                    outLocX = pTop.getX();
                    outLocY = horizontal ? pTop.getY() + ClockRouter.this.getStubLength(ClockRouter.this.vertArc) : hYChan;
                    outHorizontal = true;
                    break;
                }
                case 3: {
                    outLocX = pTop.getX();
                    outLocY = horizontal ? pTop.getY() - ClockRouter.this.getStubLength(ClockRouter.this.vertArc) : lYChan;
                    outHorizontal = true;
                }
            }
            MakePoint mpTop = new MakePoint(sTop);
            if (outHorizontal != horizontal) {
                EPoint pTopShift = EPoint.fromLambda(pTop.getX() + stubX, pTop.getY() + stubY);
                MakePoint mp = new MakePoint(ClockRouter.this.cornerContact, pTopShift, mpSize.getX(), mpSize.getY(), ClockRouter.this.ep, ClockRouter.this.cell);
                this.allPoints.add(mp);
                this.allConnections.add(new MakeConnection(mp, mpTop));
                outLocX += stubX;
                outLocY += stubY;
                sTop.distanceTraversed += Math.abs(stubX) + Math.abs(stubY);
                pTop = pTopShift;
                mpTop = mp;
            }
            EPoint finalPt = EPoint.fromLambda(outLocX, outLocY);
            PrimitiveNode stubNP = outHorizontal ? ClockRouter.this.vertArc.findPinProto() : ClockRouter.this.horizArc.findPinProto();
            MakePoint mp = new MakePoint(stubNP, finalPt, stubNP.getDefWidth(ClockRouter.this.ep), stubNP.getDefHeight(ClockRouter.this.ep), ClockRouter.this.ep, ClockRouter.this.cell);
            this.allPoints.add(mp);
            this.allConnections.add(new MakeConnection(mp, mpTop));
            this.output = new SerializablePortInst(mp.ni.getOnlyPortInst());
            this.output.distanceTraversed = sTop.distanceTraversed + finalPt.distance(pTop);
            this.output.subTreeName = this.treeName;
            this.placeArcs(this.allConnections);
            return true;
        }

        private MakePoint ensureArcConnectsToPort(MakeConnection mc, MakePoint mp) {
            PortInst pi;
            if (mc.ap == null) {
                return mp;
            }
            PortInst portInst = pi = mp.spi != null ? mp.spi.getPortInst() : mp.ni.getOnlyPortInst();
            if (pi.getPortProto().connectsTo(mc.ap)) {
                return mp;
            }
            EPoint stackLoc = pi.getCenter();
            int destinationLevel = mc.ap.getFunction().getLevel();
            int bestDist = Integer.MAX_VALUE;
            int sourceLevel = -1;
            ArcProto[] portConnections = pi.getPortProto().getBasePort().getConnections();
            for (int i = 0; i < portConnections.length; ++i) {
                int levelAlt;
                int dist;
                ArcProto apAlt = portConnections[i];
                if (apAlt.getTechnology() == Generic.tech() || (dist = Math.abs(destinationLevel - (levelAlt = apAlt.getFunction().getLevel()))) >= bestDist) continue;
                bestDist = dist;
                sourceLevel = levelAlt;
            }
            if (destinationLevel == sourceLevel) {
                return mp;
            }
            int dir = (destinationLevel - sourceLevel) / Math.abs(destinationLevel - sourceLevel);
            int sl = sourceLevel;
            int dl = destinationLevel;
            if (dir > 0) {
                ++sl;
                ++dl;
            }
            for (int i = sl; i != dl; i += dir) {
                PrimitiveNode connection = ClockRouter.this.findContact(ClockRouter.this.tech, i - 1, i);
                if (connection == null) {
                    System.out.println("Warning: Cannot bring source node " + pi.getNodeInst().describe(false) + " up to Metal-" + destinationLevel + " because there is no Metal-" + (i - 1) + "-to-Metal-" + i + " contact in technology " + ClockRouter.this.tech.getTechName());
                    return null;
                }
                ArcProto arcIn = null;
                ArcProto arcOut = null;
                ArcProto[] possibleCons = connection.getPort(0).getConnections();
                for (int j = 0; j < possibleCons.length; ++j) {
                    if (possibleCons[j].getTechnology() == Generic.tech()) continue;
                    if (possibleCons[j].getFunction().getLevel() == i - 1) {
                        arcIn = possibleCons[j];
                    }
                    if (possibleCons[j].getFunction().getLevel() != i) continue;
                    arcOut = possibleCons[j];
                }
                if (dir < 0) {
                    arcIn = arcOut;
                }
                Point2D mpSize = ClockRouter.this.getContactSize(connection, arcIn, ClockRouter.this.getArcWidth(arcIn), arcOut, ClockRouter.this.getArcWidth(arcOut));
                MakePoint mpNew = new MakePoint(connection, stackLoc, mpSize.getX(), mpSize.getY(), ClockRouter.this.ep, ClockRouter.this.cell);
                this.allPoints.add(mpNew);
                MakeConnection mcNew = new MakeConnection(mp, mpNew);
                mcNew.ap = arcIn;
                mcNew.width = ClockRouter.this.getArcWidth(arcIn);
                this.allConnections.add(mcNew);
                mp = mpNew;
            }
            return mp;
        }

        private void placeArcs(List<MakeConnection> connections) {
            for (int i = 0; i < connections.size(); ++i) {
                MakePoint mp2;
                MakePoint mp1;
                MakeConnection mc = connections.get(i);
                if (mc.ap == null || (mp1 = this.ensureArcConnectsToPort(mc, mc.from)) == null || (mp2 = this.ensureArcConnectsToPort(mc, mc.to)) == null) continue;
                PortInst pi1 = mp1.spi != null ? mp1.spi.getPortInst() : mp1.ni.getOnlyPortInst();
                PortInst pi2 = mp2.spi != null ? mp2.spi.getPortInst() : mp2.ni.getOnlyPortInst();
                mc.ai = ArcInst.makeInstanceBase(mc.ap, ClockRouter.this.ep, mc.width, pi1, pi2);
            }
        }

        public SerializablePortInst addSerpentineAmount(double amount) {
            double jogX = 0.0;
            double jogY = 0.0;
            switch (this.outEdge) {
                case 0: {
                    jogX = ClockRouter.this.getStubLength(ClockRouter.this.horizArc);
                    break;
                }
                case 1: {
                    jogX = -ClockRouter.this.getStubLength(ClockRouter.this.horizArc);
                    break;
                }
                case 2: {
                    jogY = -ClockRouter.this.getStubLength(ClockRouter.this.vertArc);
                    break;
                }
                case 3: {
                    jogY = ClockRouter.this.getStubLength(ClockRouter.this.vertArc);
                }
            }
            double awaydist = (amount - (jogX + jogY) * 2.0) / 2.0;
            double awayX = 0.0;
            double awayY = 0.0;
            switch (this.inEdge) {
                case 0: {
                    awayX = awaydist / 2.0;
                    break;
                }
                case 1: {
                    awayX = -awaydist / 2.0;
                    break;
                }
                case 2: {
                    awayY = -awaydist / 2.0;
                    break;
                }
                case 3: {
                    awayY = awaydist / 2.0;
                }
            }
            EPoint outLoc = this.output.getPortInst().getCenter();
            EPoint pin1Loc = EPoint.fromLambda(outLoc.getX() + jogX, outLoc.getY() + jogY);
            EPoint pin2Loc = EPoint.fromLambda(outLoc.getX() + jogX + awayX, outLoc.getY() + jogY + awayY);
            EPoint pin3Loc = EPoint.fromLambda(outLoc.getX() + jogX * 2.0 + awayX, outLoc.getY() + jogY * 2.0 + awayY);
            EPoint pin4Loc = EPoint.fromLambda(outLoc.getX() + jogX * 2.0, outLoc.getY() + jogY * 2.0);
            MakePoint mpOut = new MakePoint(this.output);
            Point2D mpSize = ClockRouter.this.getContactSize(ClockRouter.this.cornerContact, ClockRouter.this.horizArc, ClockRouter.this.horizArcWidth, ClockRouter.this.vertArc, ClockRouter.this.vertArcWidth);
            MakePoint mp1 = new MakePoint(ClockRouter.this.cornerContact, pin1Loc, mpSize.getX(), mpSize.getY(), ClockRouter.this.ep, ClockRouter.this.cell);
            MakePoint mp2 = new MakePoint(ClockRouter.this.cornerContact, pin2Loc, mpSize.getX(), mpSize.getY(), ClockRouter.this.ep, ClockRouter.this.cell);
            MakePoint mp3 = new MakePoint(ClockRouter.this.cornerContact, pin3Loc, mpSize.getX(), mpSize.getY(), ClockRouter.this.ep, ClockRouter.this.cell);
            MakePoint mp4 = new MakePoint(ClockRouter.this.cornerContact, pin4Loc, mpSize.getX(), mpSize.getY(), ClockRouter.this.ep, ClockRouter.this.cell);
            this.allPoints.add(mp1);
            this.allPoints.add(mp2);
            this.allPoints.add(mp3);
            this.allPoints.add(mp4);
            this.serpentineConnections.clear();
            this.serpentineConnections.add(new MakeConnection(mpOut, mp1));
            this.serpentineConnections.add(new MakeConnection(mp1, mp2));
            this.serpentineConnections.add(new MakeConnection(mp2, mp3));
            this.serpentineConnections.add(new MakeConnection(mp3, mp4));
            SerializablePortInst newOutput = new SerializablePortInst(mp4.ni.getOnlyPortInst());
            newOutput.distanceTraversed = this.output.distanceTraversed + amount;
            this.output = newOutput;
            return this.output;
        }

        public void connectToSource(SerializablePortInst sourceSPI) {
            PortInst sourcePI = sourceSPI.getPortInst();
            EPoint sourcePT = sourcePI.getCenter();
            SubTree topTree = ClockRouter.this.allGroups.get(ClockRouter.this.allGroups.size() - 1);
            SerializablePortInst destSPI = topTree.output;
            MakePoint sourceMP = new MakePoint(sourceSPI);
            MakePoint destMP = new MakePoint(destSPI);
            PortInst destPI = destSPI.getPortInst();
            EPoint destPT = destPI.getCenter();
            sourcePT = sourcePI.getCenter();
            if (destPT.getX() != sourcePT.getX() && destPT.getY() != sourcePT.getY()) {
                EPoint ctr = EPoint.fromLambda(sourcePT.getX(), destPT.getY());
                Point2D mpSize = ClockRouter.this.getContactSize(ClockRouter.this.cornerContact, ClockRouter.this.horizArc, ClockRouter.this.horizArcWidth, ClockRouter.this.vertArc, ClockRouter.this.vertArcWidth);
                MakePoint mp = new MakePoint(ClockRouter.this.cornerContact, ctr, mpSize.getX(), mpSize.getY(), ClockRouter.this.ep, ClockRouter.this.cell);
                this.allPoints.add(mp);
                this.allConnections.add(new MakeConnection(sourceMP, mp));
                this.allConnections.add(new MakeConnection(destMP, mp));
            } else {
                this.allConnections.add(new MakeConnection(destMP, sourceMP));
            }
            this.placeArcs(this.allConnections);
        }
    }

    private static class HTreeRouteJob
    extends Job {
        private List<NeededHTree> treesToRoute;
        private String fileName;
        private Cell cell;

        protected HTreeRouteJob(List<NeededHTree> treesToRoute, String fileName, Cell cell) {
            super("Clock-Tree Route", Routing.getRoutingTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.treesToRoute = treesToRoute;
            this.fileName = fileName;
            this.cell = cell;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            ClockRouter router = new ClockRouter(this.getEditingPreferences(), this.cell);
            for (NeededHTree nht : this.treesToRoute) {
                boolean good = router.routeAlgorithm2(nht, this.fileName, this.cell);
                if (!good) continue;
                for (ArcInst ai : nht.originalArcs) {
                    ai.kill();
                }
            }
            return true;
        }
    }

    private static class SerializablePortInst
    implements Serializable {
        NodeInst ni;
        String portName;
        double distanceTraversed;
        String subTreeName;
        transient boolean flag;

        public SerializablePortInst(PortInst pi) {
            this.ni = pi.getNodeInst();
            this.portName = pi.getPortProto().getName();
            this.distanceTraversed = 0.0;
            this.subTreeName = null;
        }

        public PortProto getPortProto() {
            return this.ni.getProto().findPortProto(this.portName);
        }

        public PortInst getPortInst() {
            return this.ni.findPortInstFromProto(this.getPortProto());
        }

        public boolean equals(SerializablePortInst spi) {
            return this.ni == spi.ni && this.portName.equals(spi.portName);
        }
    }

    private static class NeededHTree
    implements Serializable {
        SerializablePortInst source = null;
        List<SerializablePortInst> destinations = new ArrayList<SerializablePortInst>();
        List<ArcInst> originalArcs = new ArrayList<ArcInst>();

        public void addDestination(SerializablePortInst spi) {
            for (SerializablePortInst spiTest : this.destinations) {
                if (!spiTest.equals(spi)) continue;
                return;
            }
            this.destinations.add(spi);
        }
    }
}

