/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.seaOfGates;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.CellTree;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.TechPool;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.util.math.Orientation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

class SeaOfGatesCellBuilder {
    private final EditingPreferences ep;
    private final Snapshot oldSnapshot;
    private final Tool oldTool;
    private final Environment oldEnvironment;
    private final CellTree oldCellTree;
    private final CellBackup oldCellBackup;
    private final CellTree[] oldCellTrees;
    private final TechPool oldTechPool;
    private final CellRevision oldCellRevision;
    private final ImmutableCell oldCell;
    final CellId cellId;
    private Snapshot curSnapshot;
    private final CellBackup[] curCellBackups;
    private CellTree curCellTree;
    private CellBackup curCellBackup;
    private final BitSet curNodes = new BitSet();
    private int curNodesCount;
    private int lastNodeId;
    private final TreeMap<Name, MaxNodeSuffix> maxNodeSuffixesOrdered = new TreeMap();
    private final IdentityHashMap<PrimitiveNodeId, MaxNodeSuffix> maxNodeSuffixes = new IdentityHashMap();
    private final IdentityHashMap<SeaOfGatesEngine.RouteNode, ImmutableNodeInst> addedNodesToNodeInst = new IdentityHashMap();
    private final BitSet curArcs = new BitSet();
    private int curArcsCount;
    private int lastArcId;
    private int maxArcSuffix;
    private final int arcInsertionPoint;
    private final List<ImmutableArcInst> addedArcs = new ArrayList<ImmutableArcInst>();

    SeaOfGatesCellBuilder(Snapshot snapshot, CellId cellId, EditingPreferences ep) {
        Name name;
        this.ep = ep;
        this.oldSnapshot = snapshot;
        this.oldTool = this.oldSnapshot.tool;
        this.oldEnvironment = this.oldSnapshot.environment;
        this.oldCellTree = snapshot.getCellTree(cellId);
        this.oldCellBackup = this.oldCellTree.top;
        this.oldCellTrees = this.oldCellTree.getSubTrees();
        this.oldTechPool = this.oldCellTree.techPool;
        this.oldCellRevision = this.oldCellBackup.cellRevision;
        this.oldCell = this.oldCellRevision.d;
        this.cellId = cellId;
        int maxCellIndex = -1;
        for (CellTree cellTree : this.oldSnapshot.cellTrees) {
            if (cellTree == null) continue;
            maxCellIndex = Math.max(maxCellIndex, cellTree.top.cellRevision.d.cellId.cellIndex);
        }
        this.curCellBackups = new CellBackup[maxCellIndex + 1];
        for (CellTree cellTree : this.oldSnapshot.cellTrees) {
            if (cellTree == null) continue;
            this.curCellBackups[cellTree.top.cellRevision.d.cellId.cellIndex] = cellTree.top;
        }
        this.lastNodeId = -1;
        for (ImmutableNodeInst n : this.oldCellRevision.nodes) {
            int nodeId = n.nodeId;
            assert (!this.curNodes.get(nodeId));
            this.curNodes.set(nodeId);
            this.lastNodeId = Math.max(this.lastNodeId, nodeId);
        }
        this.curNodesCount = this.oldCellRevision.nodes.size();
        this.lastArcId = -1;
        this.maxArcSuffix = -1;
        for (ImmutableArcInst a : this.oldCellRevision.arcs) {
            int arcId = a.arcId;
            assert (!this.curArcs.get(arcId));
            this.curArcs.set(arcId);
            this.lastArcId = Math.max(this.lastArcId, arcId);
        }
        this.curArcsCount = this.oldCellRevision.arcs.size();
        this.arcInsertionPoint = this.searchArcInsertionPoint(ImmutableArcInst.BASENAME.toString());
        this.maxArcSuffix = -1;
        if (this.arcInsertionPoint > 0 && (name = this.oldCellRevision.arcs.get((int)(this.arcInsertionPoint - 1)).name).isTempname()) {
            assert (name.getBasename() == ImmutableArcInst.BASENAME);
            this.maxArcSuffix = name.getNumSuffix();
        }
        this.curSnapshot = this.oldSnapshot;
        this.curCellTree = this.oldCellTree;
        this.curCellBackup = this.oldCellBackup;
    }

    synchronized void instantiate(SeaOfGatesEngine.RouteResolution resolution) {
        Serializable protoId;
        assert (resolution.cellId == this.cellId);
        Iterator<Serializable> i$ = resolution.nodesIDsToKill.iterator();
        while (i$.hasNext()) {
            int nodeId = i$.next();
            assert (this.curNodes.get(nodeId));
            this.curNodes.clear(nodeId);
            --this.curNodesCount;
        }
        i$ = resolution.arcsIDsToKill.iterator();
        while (i$.hasNext()) {
            int arcId = i$.next();
            assert (this.curArcs.get(arcId));
            this.curArcs.clear(arcId);
            --this.curArcsCount;
        }
        for (SeaOfGatesEngine.RouteNode rn : resolution.nodesToRoute) {
            if (rn.exists()) continue;
            int nodeId = ++this.lastNodeId;
            protoId = (PrimitiveNodeId)rn.getProtoId();
            MaxNodeSuffix maxSuffix = this.maxNodeSuffixes.get(protoId);
            if (maxSuffix == null) {
                Name baseName = rn.getBaseName();
                maxSuffix = this.maxNodeSuffixesOrdered.get(baseName);
                if (maxSuffix == null) {
                    maxSuffix = new MaxNodeSuffix(this, baseName);
                    this.maxNodeSuffixesOrdered.put(baseName, maxSuffix);
                }
                this.maxNodeSuffixes.put((PrimitiveNodeId)protoId, maxSuffix);
            }
            Name name = maxSuffix.getNextName();
            TextDescriptor nameTd = this.ep.getNodeTextDescriptor();
            Orientation orient = rn.getOrient();
            EPoint anchor = rn.getLoc();
            EPoint size2 = rn.getSize();
            int flags = 0;
            int techBits = rn.getTechBits();
            TextDescriptor protoTd = this.ep.getInstanceTextDescriptor();
            ImmutableNodeInst n = ImmutableNodeInst.newInstance(nodeId, protoId, name, nameTd, orient, anchor, size2, flags, techBits, protoTd);
            maxSuffix.add(n);
            assert (!this.curNodes.get(nodeId));
            this.curNodes.set(nodeId);
            ++this.curNodesCount;
            this.addedNodesToNodeInst.put(rn, n);
        }
        for (SeaOfGatesEngine.RouteArc ra : resolution.arcsToRoute) {
            int arcId = ++this.lastArcId;
            protoId = ra.getProtoId();
            assert (this.maxArcSuffix < Integer.MAX_VALUE);
            Name name = ImmutableArcInst.BASENAME.findSuffixed(++this.maxArcSuffix);
            TextDescriptor nameTd = this.ep.getArcTextDescriptor();
            SeaOfGatesEngine.RouteNode tail = ra.getTail();
            int tailNodeId = tail.exists() ? tail.getNodeId() : this.addedNodesToNodeInst.get((Object)tail).nodeId;
            PortProtoId tailProtoId = tail.getPortProtoId();
            EPoint tailLocation = tail.getLoc();
            SeaOfGatesEngine.RouteNode head2 = ra.getHead();
            int headNodeId = head2.exists() ? head2.getNodeId() : this.addedNodesToNodeInst.get((Object)head2).nodeId;
            PortProtoId headProtoId = head2.getPortProtoId();
            EPoint headLocation = head2.getLoc();
            long gridExtendOverMin = ra.getGridExtendOverMin();
            int angle = -1;
            int flags = ra.getFlags(this.ep);
            ImmutableArcInst a = ImmutableArcInst.newInstance(arcId, (ArcProtoId)protoId, name, nameTd, tailNodeId, tailProtoId, tailLocation, headNodeId, headProtoId, headLocation, gridExtendOverMin, angle, flags);
            this.addedArcs.add(a);
            assert (!this.curArcs.get(arcId));
            this.curArcs.set(arcId);
            ++this.curArcsCount;
        }
        ArcProtoId unroutedId = this.oldTechPool.getGeneric().unrouted_arc.getId();
        long unroutedGridExtend = this.oldTechPool.getGeneric().unrouted_arc.getDefaultInst(this.ep).getGridExtendOverMin();
        int unroutedFlags = this.oldTechPool.getGeneric().unrouted_arc.getDefaultInst((EditingPreferences)this.ep).flags;
        for (SeaOfGatesEngine.RouteAddUnrouted rau : resolution.unroutedToAdd) {
            int arcId = ++this.lastArcId;
            ArcProtoId protoId2 = unroutedId;
            assert (this.maxArcSuffix < Integer.MAX_VALUE);
            Name name = ImmutableArcInst.BASENAME.findSuffixed(++this.maxArcSuffix);
            TextDescriptor nameTd = this.ep.getArcTextDescriptor();
            int tailNodeId = rau.getTailId();
            PortProtoId tailProtoId = rau.getTailPortProtoId();
            EPoint tailLocation = rau.getTailLocation();
            int headNodeId = rau.getHeadId();
            PortProtoId headProtoId = rau.getHeadPortProtoId();
            EPoint headLocation = rau.getHeadLocation();
            long gridExtendOverMin = unroutedGridExtend;
            int angle = -1;
            int flags = unroutedFlags;
            ImmutableArcInst a = ImmutableArcInst.newInstance(arcId, protoId2, name, nameTd, tailNodeId, tailProtoId, tailLocation, headNodeId, headProtoId, headLocation, gridExtendOverMin, angle, flags);
            this.addedArcs.add(a);
            assert (!this.curArcs.get(arcId));
            this.curArcs.set(arcId);
            ++this.curArcsCount;
        }
        resolution.nodesToRoute.clear();
        resolution.arcsToRoute.clear();
        resolution.nodesIDsToKill.clear();
        resolution.arcsIDsToKill.clear();
        resolution.unroutedToAdd.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Snapshot commit() {
        ImmutableArcInst[] newArcs;
        ImmutableNodeInst[] newNodes;
        SeaOfGatesCellBuilder seaOfGatesCellBuilder = this;
        synchronized (seaOfGatesCellBuilder) {
            ImmutableArcInst a2;
            newNodes = new ImmutableNodeInst[this.curNodesCount];
            int oldNodeIndex = 0;
            int newNodeIndex = 0;
            for (MaxNodeSuffix maxSuffix : this.maxNodeSuffixesOrdered.values()) {
                while (oldNodeIndex < maxSuffix.insertionPoint) {
                    ImmutableNodeInst n = this.oldCellRevision.nodes.get(oldNodeIndex++);
                    if (!this.curNodes.get(n.nodeId)) continue;
                    newNodes[newNodeIndex++] = n;
                }
                for (ImmutableNodeInst n : maxSuffix.addedNodes) {
                    assert (this.curNodes.get(n.nodeId));
                    newNodes[newNodeIndex++] = n;
                }
            }
            while (oldNodeIndex < this.oldCellRevision.nodes.size()) {
                ImmutableNodeInst n = this.oldCellRevision.nodes.get(oldNodeIndex++);
                if (!this.curNodes.get(n.nodeId)) continue;
                newNodes[newNodeIndex++] = n;
            }
            assert (newNodeIndex == newNodes.length);
            newArcs = new ImmutableArcInst[this.curArcsCount];
            int newArcIndex = 0;
            for (int oldArcIndex = 0; oldArcIndex < this.arcInsertionPoint; ++oldArcIndex) {
                a2 = this.oldCellRevision.arcs.get(oldArcIndex);
                if (!this.curArcs.get(a2.arcId)) continue;
                newArcs[newArcIndex++] = a2;
            }
            for (ImmutableArcInst a2 : this.addedArcs) {
                assert (this.curArcs.get(a2.arcId));
                newArcs[newArcIndex++] = a2;
            }
            for (int oldArcIndex = this.arcInsertionPoint; oldArcIndex < this.oldCellRevision.arcs.size(); ++oldArcIndex) {
                a2 = this.oldCellRevision.arcs.get(oldArcIndex);
                if (!this.curArcs.get(a2.arcId)) continue;
                newArcs[newArcIndex++] = a2;
            }
            assert (newArcIndex == newArcs.length);
        }
        this.curCellBackups[this.cellId.cellIndex] = this.curCellBackup = this.curCellBackup.with(this.oldCell, newNodes, newArcs, null, this.oldTechPool);
        this.curSnapshot = this.curSnapshot.with(this.oldTool, this.oldEnvironment, this.curCellBackups, null);
        return this.curSnapshot;
    }

    private int searchNodeInsertionPoint(String basename) {
        assert (basename.endsWith("@0"));
        char nextChar = (char)(basename.charAt(basename.length() - 2) + '\u0001');
        String nextName = basename.substring(0, basename.length() - 2) + nextChar;
        int index = this.oldCellRevision.nodes.searchByName(nextName);
        return index >= 0 ? index : -(index + 1);
    }

    private int searchArcInsertionPoint(String basename) {
        assert (basename.endsWith("@0"));
        char nextChar = (char)(basename.charAt(basename.length() - 2) + '\u0001');
        String nextName = basename.substring(0, basename.length() - 2) + nextChar;
        int index = this.oldCellRevision.arcs.searchByName(nextName);
        return index >= 0 ? index : -(index + 1);
    }

    private static class MaxNodeSuffix {
        final Name basename;
        final int insertionPoint;
        int maxSuffix;
        List<ImmutableNodeInst> addedNodes = new ArrayList<ImmutableNodeInst>();

        private MaxNodeSuffix(SeaOfGatesCellBuilder b, Name basename) {
            Name name;
            this.basename = basename;
            this.insertionPoint = b.searchNodeInsertionPoint(basename.toString());
            this.maxSuffix = -1;
            if (this.insertionPoint > 0 && (name = ((SeaOfGatesCellBuilder)b).oldCellRevision.nodes.get((int)(this.insertionPoint - 1)).name).isTempname() && name.getBasename() == basename) {
                this.maxSuffix = name.getNumSuffix();
            }
        }

        private Name getNextName() {
            return this.basename.findSuffixed(this.maxSuffix + 1);
        }

        private void add(ImmutableNodeInst n) {
            assert (n.name.getBasename() == this.basename);
            assert (n.name.getNumSuffix() == ++this.maxSuffix);
            this.addedNodes.add(n);
        }
    }
}

