/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.sctiming;

import com.sun.electric.tool.simulation.sctiming.LibData;
import com.sun.electric.tool.simulation.sctiming.SCTimingException;
import com.sun.electric.util.TextUtils;
import java.util.ArrayList;

public class SCSettings {
    String simulator = "hspice";
    public String libName = "sclib";
    public String commonHeaderFile = "";
    String bufferCell = null;
    String bufferCellStrengthParam = null;
    String bufferCellInputPort = null;
    String bufferCellOutputPort = null;
    String bufferCellSweep = null;
    String bufferCellSweepMinTime = null;
    String bufferCellSweepExcludeFromAveraging = null;
    String loadCell = null;
    String loadCellStrengthParam = null;
    String loadCellPort = null;
    String loadCellSweepExcludeFromAveraging = null;
    String loadCellSweep = null;
    String loadCellSweepMinTime = null;
    String loadCellSweepForSetupHold = null;
    String loadCellSweepForSetupHoldMinTime = null;
    String clkBufferCell = null;
    String clkBufferCellStrengthParam = null;
    String clkBufferCellInputPort = null;
    String clkBufferCellOutputPort = null;
    String clkBufferCellSweep = null;
    String clkBufferCellSweepMinTime = null;
    String operatingPointName = null;
    public double vdd = 0.0;
    double temp = 25.0;
    double tech = 1.0;
    double inputRampTimePS = 50.0;
    double simResolutionPS = 1.0;
    double simTimePS = 10000.0;
    double timeStartPS = 200.0;
    double periodPS = 1000.0;
    double inputLow = 0.2;
    double inputHigh = 0.8;
    double inputDelayThresh = 0.5;
    double outputLow = 0.2;
    double outputHigh = 0.8;
    double outputDelayThresh = 0.5;
    double edgePercentForCapStart = 0.05;
    double edgePercentForCapEnd = 0.55;
    double holdGlitchHighPercent = 0.8;
    double holdGlitchLowPercent = 0.2;
    double tmsetupMinGuessPS = 0.0;
    double tmsetupMaxGuessPS = 300.0;
    double tmsetupGuessPS = 100.0;
    double clk2qpushout = 20.0;
    double capUnit = 1.0E-12;
    double timeUnit = 1.0E-9;
    boolean simpleSequentialCharacterization = false;
    boolean scaleLoadCellSweepWithXSize = false;
    String tableSlewVsLoads = "tableInputSlewVsCLoad";
    String tableSetupHold = "tableInputSlewVsClkSlew";
    String tableClk2Q = "tableInputClkSlewVsCLoad";
    int numClkSlews = 0;

    public void setSimulator(String pathandname) {
        this.simulator = pathandname;
    }

    public void setCommonHeaderFile(String pathandname) {
        this.commonHeaderFile = pathandname;
    }

    public void setOperatingPoint(String name, double vdd, double temp) {
        this.operatingPointName = name;
        this.vdd = vdd;
        this.temp = temp;
    }

    public double getVdd() {
        return this.vdd;
    }

    public void setLibrary(String libName) {
        this.libName = libName;
    }

    public void setBufferCell(String cellname, String strengthParam, String inputPort, String outputPort) {
        this.bufferCell = cellname;
        this.bufferCellStrengthParam = strengthParam;
        this.bufferCellInputPort = inputPort;
        this.bufferCellOutputPort = outputPort;
    }

    public void setClkBufferCell(String cellname, String strengthParam, String inputPort, String outputPort) {
        this.clkBufferCell = cellname;
        this.clkBufferCellStrengthParam = strengthParam;
        this.clkBufferCellInputPort = inputPort;
        this.clkBufferCellOutputPort = outputPort;
    }

    public void setLoadCell(String cellname, String strengthParam, String loadPort) {
        this.loadCell = cellname;
        this.loadCellStrengthParam = strengthParam;
        this.loadCellPort = loadPort;
    }

    public void setSimulationTime(double resolutionPS, double durationPS) {
        this.simResolutionPS = resolutionPS;
        this.simTimePS = durationPS;
    }

    public void setInputBufferSweep(String sweep) {
        this.bufferCellSweep = sweep;
    }

    public void setInputBufferSweepMinTime(String sweep) {
        this.bufferCellSweepMinTime = sweep;
    }

    public void setLoadSweep(String sweep) {
        this.loadCellSweep = sweep;
        if (this.loadCellSweepForSetupHold == null) {
            this.loadCellSweepForSetupHold = sweep;
        }
    }

    public void setLoadSweepMinTime(String sweep) {
        this.loadCellSweepMinTime = sweep;
        if (this.loadCellSweepForSetupHoldMinTime == null) {
            this.loadCellSweepForSetupHoldMinTime = sweep;
        }
    }

    public void setLoadSweepForSetupHold(String sweep) {
        this.loadCellSweepForSetupHold = sweep;
    }

    public void setLoadSweepForSetupHoldMinTime(String sweep) {
        this.loadCellSweepForSetupHoldMinTime = sweep;
    }

    public void scaleLoadSweepWithXSize(boolean b) {
        this.scaleLoadCellSweepWithXSize = b;
    }

    public void setClkBufferSize(String size2) {
        this.clkBufferCellSweep = size2;
    }

    public void setClkBufferSizeMinTime(String size2) {
        this.clkBufferCellSweepMinTime = size2;
    }

    public void setInputThresholds(double low, double high, double delay2) {
        this.inputLow = low;
        this.inputHigh = high;
        this.inputDelayThresh = delay2;
    }

    public void setOutputThresholds(double low, double high, double delay2) {
        this.outputLow = low;
        this.outputHigh = high;
        this.outputDelayThresh = delay2;
    }

    public void setInputRampTimePS(double inputRampTimePS) {
        this.inputRampTimePS = inputRampTimePS;
    }

    public void setSetupTimeRangePS(double low, double guess, double high) {
        this.tmsetupGuessPS = guess;
        this.tmsetupMaxGuessPS = high;
        this.tmsetupMinGuessPS = low;
    }

    public void setInputBufferSweepExcludeFromAveraging(String values2) {
        this.bufferCellSweepExcludeFromAveraging = values2;
    }

    public void setLoadSweepExcludeFromAveraging(String values2) {
        this.loadCellSweepExcludeFromAveraging = values2;
    }

    public void setSimpleSequentialCharacterization(boolean b) {
        this.simpleSequentialCharacterization = b;
    }

    public void setClk2QPushOut(double ps) {
        this.clk2qpushout = ps;
    }

    public void setHoldTimeGlitchPercentages(double high, double low) {
        this.holdGlitchHighPercent = high;
        this.holdGlitchLowPercent = low;
    }

    void checkSettings(boolean sequentialTest) throws SCTimingException {
        this.err(this.libName == null, "Library name not specified");
        this.err(this.bufferCell == null, "Buffer cell not specified");
        this.err(this.bufferCellInputPort == null, "Buffer cell input port not specified");
        this.err(this.bufferCellOutputPort == null, "Buffer cell output port not specified");
        this.err(this.bufferCellStrengthParam == null, "Buffer strength param not specified");
        this.err(this.bufferCellSweep == null, "Sweep for input buffer cell not specified");
        this.err(this.loadCell == null, "Load cell not specified");
        this.err(this.loadCellPort == null, "Load cell load port not specified");
        this.err(this.loadCellStrengthParam == null, "Load cell strength param not specified");
        this.err(this.loadCellSweep == null, "Sweep for load cell not specified");
        this.err(this.loadCellSweepForSetupHold == null, "Sweep for load cell not specified for setup and hold");
        this.err(this.operatingPointName == null, "Operating point (vdd, temp) not specified");
        if (sequentialTest) {
            if (this.bufferCellSweepMinTime == null) {
                this.bufferCellSweepMinTime = this.bufferCellSweep;
            }
            if (this.loadCellSweepMinTime == null) {
                this.loadCellSweepMinTime = this.loadCellSweep;
            }
            if (this.clkBufferCellSweepMinTime == null) {
                this.clkBufferCellSweepMinTime = this.clkBufferCellSweep;
            }
            if (this.loadCellSweepForSetupHoldMinTime == null) {
                this.loadCellSweepForSetupHoldMinTime = this.loadCellSweepForSetupHold;
            }
            this.err(this.clkBufferCell == null, "Clock buffer cell not specified");
            this.err(this.clkBufferCellInputPort == null, "Clock buffer input port not specfieid");
            this.err(this.clkBufferCellOutputPort == null, "Clock buffer output port not specfieid");
            this.err(this.clkBufferCellStrengthParam == null, "Clock buffer strength param not specified");
            this.err(this.clkBufferCellSweep == null, "Sweep for clock buffer cell not specified");
            if (this.simpleSequentialCharacterization) {
                // empty if block
            }
        }
    }

    void err(boolean print, String msg) throws SCTimingException {
        if (print) {
            throw new SCTimingException(msg);
        }
    }

    public LibData.Group getLibrary() {
        LibData.Group library = new LibData.Group("library", this.libName, null);
        library.putAttributeComplex("technology", "cmos");
        library.putAttribute("delay_model", "table_lookup");
        ArrayList<LibData.Value> attrList = new ArrayList<LibData.Value>();
        attrList.add(new LibData.Value(LibData.ValueType.INT, new Integer(1)));
        attrList.add(new LibData.Value(LibData.ValueType.STRING, SCSettings.getUnitScale(this.capUnit) + "f"));
        LibData.Head h = new LibData.Head("capacitive_load_unit", attrList);
        library.putAttribute(new LibData.Attribute("capacitive_load_unit", h));
        library.putAttribute("time_unit", "\"1" + SCSettings.getUnitScale(this.timeUnit) + "s\"");
        library.putAttribute("voltage_unit", "\"1V\"");
        library.putAttribute("current_unit", "\"1A\"");
        library.putAttribute("input_threshold_pct_rise", this.inputDelayThresh * 100.0);
        library.putAttribute("input_threshold_pct_fall", this.inputDelayThresh * 100.0);
        library.putAttribute("output_threshold_pct_rise", this.outputDelayThresh * 100.0);
        library.putAttribute("output_threshold_pct_fall", this.outputDelayThresh * 100.0);
        library.putAttribute("slew_lower_threshold_pct_rise", this.inputLow * 100.0);
        library.putAttribute("slew_upper_threshold_pct_rise", this.inputHigh * 100.0);
        library.putAttribute("slew_lower_threshold_pct_fall", this.inputLow * 100.0);
        library.putAttribute("slew_upper_threshold_pct_fall", this.inputHigh * 100.0);
        library.putAttribute("pulling_resistance_unit", "\"1ohm\"");
        library.putAttribute("default_fanout_load", "1.0");
        library.putAttribute("default_inout_pin_cap", "1.0");
        library.putAttribute("default_input_pin_cap", "1.0");
        library.putAttribute("default_output_pin_cap", "0.0");
        LibData.Group op = new LibData.Group("operating_conditions", this.operatingPointName, library);
        op.putAttribute("voltage", this.vdd);
        op.putAttribute("temperature", this.temp);
        op.putAttribute("process", 1.0);
        int numSlews = this.bufferCellSweep.trim().split("\\s+").length;
        int numLoads = this.loadCellSweep.trim().split("\\s+").length;
        StringBuffer slewsCount = new StringBuffer("\"");
        for (int i = 1; i <= numSlews; ++i) {
            slewsCount.append(i + " ");
        }
        slewsCount.append("\"");
        StringBuffer loadsCount = new StringBuffer("\"");
        for (int i = 1; i <= numLoads; ++i) {
            loadsCount.append(i + " ");
        }
        loadsCount.append("\"");
        LibData.Group luTableSlewVsLoads = new LibData.Group("lu_table_template", this.tableSlewVsLoads, library);
        luTableSlewVsLoads.putAttribute("variable_1", "input_net_transition");
        luTableSlewVsLoads.putAttribute("variable_2", "total_output_net_capacitance");
        luTableSlewVsLoads.putAttributeComplex("index_1", slewsCount.toString());
        luTableSlewVsLoads.putAttributeComplex("index_2", loadsCount.toString());
        this.numClkSlews = this.clkBufferCellSweep.trim().split("\\s+").length;
        StringBuffer clksCount = new StringBuffer("\"");
        for (int i = 1; i <= this.numClkSlews; ++i) {
            clksCount.append(i + " ");
        }
        clksCount.append("\"");
        LibData.Group luTableSetupHold = new LibData.Group("lu_table_template", this.tableSetupHold, library);
        luTableSetupHold.putAttribute("variable_1", "constrained_pin_transition");
        if (this.numClkSlews > 1) {
            luTableSetupHold.putAttribute("variable_2", "related_pin_transition");
        }
        luTableSetupHold.putAttributeComplex("index_1", slewsCount.toString());
        if (this.numClkSlews > 1) {
            luTableSetupHold.putAttributeComplex("index_2", clksCount.toString());
        }
        LibData.Group luTableClk2Q = new LibData.Group("lu_table_template", this.tableClk2Q, library);
        if (this.numClkSlews > 1) {
            luTableClk2Q.putAttribute("variable_1", "input_net_transition");
            luTableClk2Q.putAttribute("variable_2", "total_output_net_capacitance");
            luTableClk2Q.putAttributeComplex("index_1", clksCount.toString());
            luTableClk2Q.putAttributeComplex("index_2", loadsCount.toString());
        } else {
            luTableClk2Q.putAttribute("variable_1", "total_output_net_capacitance");
            luTableClk2Q.putAttributeComplex("index_1", loadsCount.toString());
        }
        return library;
    }

    public void getSettingsFromLibData(LibData data2) {
        if (data2 == null) {
            return;
        }
        LibData.Group library = data2.getLibrary();
        if (library == null) {
            return;
        }
        this.inputDelayThresh = SCSettings.getDoubleAttribute(library, "input_threshold_pct_rise", this.inputDelayThresh * 100.0) / 100.0;
        this.outputDelayThresh = SCSettings.getDoubleAttribute(library, "output_threshold_pct_rise", this.outputDelayThresh * 100.0) / 100.0;
        this.inputLow = SCSettings.getDoubleAttribute(library, "slew_lower_threshold_rise", this.inputLow * 100.0) / 100.0;
        this.inputHigh = SCSettings.getDoubleAttribute(library, "slew_upper_threshold_rise", this.inputHigh * 100.0) / 100.0;
        this.simulator = SCSettings.getStringAttribute(library, "simulator", this.simulator);
        this.commonHeaderFile = SCSettings.getStringAttribute(library, "commonHeaderFile", this.commonHeaderFile);
        this.bufferCell = SCSettings.getStringAttribute(library, "bufferCell", this.bufferCell);
        this.bufferCellStrengthParam = SCSettings.getStringAttribute(library, "bufferCellStrengthParam", this.bufferCellStrengthParam);
        this.bufferCellInputPort = SCSettings.getStringAttribute(library, "bufferCellInputPort", this.bufferCellInputPort);
        this.bufferCellOutputPort = SCSettings.getStringAttribute(library, "bufferCellOutputPort", this.bufferCellOutputPort);
        this.bufferCellSweep = SCSettings.getStringAttribute(library, "bufferCellSweep", this.bufferCellSweep);
        this.loadCell = SCSettings.getStringAttribute(library, "loadCell", this.loadCell);
        this.loadCellStrengthParam = SCSettings.getStringAttribute(library, "loadCellStrengthParam", this.loadCellStrengthParam);
        this.loadCellPort = SCSettings.getStringAttribute(library, "loadCellPort", this.loadCellPort);
        this.loadCellSweep = SCSettings.getStringAttribute(library, "loadCellSweep", this.loadCellSweep);
        this.clkBufferCell = SCSettings.getStringAttribute(library, "clkBufferCell", this.clkBufferCell);
        this.clkBufferCellStrengthParam = SCSettings.getStringAttribute(library, "clkBufferCellStrengthParam", this.clkBufferCellStrengthParam);
        this.clkBufferCellInputPort = SCSettings.getStringAttribute(library, "clkBufferCellInputPort", this.clkBufferCellInputPort);
        this.clkBufferCellOutputPort = SCSettings.getStringAttribute(library, "clkBufferCellOutputPort", this.clkBufferCellOutputPort);
        this.clkBufferCellSweep = SCSettings.getStringAttribute(library, "clkBufferCellSweep", this.clkBufferCellSweep);
        this.vdd = SCSettings.getDoubleAttribute(library, "vdd", this.vdd);
        this.inputRampTimePS = SCSettings.getDoubleAttribute(library, "inputRampTimePS", this.inputRampTimePS);
        this.simTimePS = SCSettings.getDoubleAttribute(library, "simTimePS", this.simTimePS);
        this.simResolutionPS = SCSettings.getDoubleAttribute(library, "simResolutionPS", this.simResolutionPS);
        this.tmsetupGuessPS = SCSettings.getDoubleAttribute(library, "tmsetupGuessPS", this.tmsetupGuessPS);
        this.tmsetupMinGuessPS = SCSettings.getDoubleAttribute(library, "tmsetupMinGuessPS", this.tmsetupMinGuessPS);
        this.tmsetupMaxGuessPS = SCSettings.getDoubleAttribute(library, "tmsetupMaxGuessPS", this.tmsetupMaxGuessPS);
    }

    private static String getStringAttribute(LibData.Group group, String name, String defaultVal) {
        LibData.Attribute attr = group.getAttribute(name);
        if (attr == null) {
            return defaultVal;
        }
        String val = attr.getString();
        if (val == null) {
            return defaultVal;
        }
        return val;
    }

    private static double getDoubleAttribute(LibData.Group group, String name, double defaultVal) {
        LibData.Attribute attr = group.getAttribute(name);
        if (attr == null) {
            return defaultVal;
        }
        Double val = attr.getDouble();
        if (val == null) {
            String sval = attr.getString();
            if (sval == null) {
                return defaultVal;
            }
            try {
                return Double.parseDouble(sval);
            }
            catch (NumberFormatException e) {
                return defaultVal;
            }
        }
        return val;
    }

    private static String getUnitScale(double d) {
        String s = TextUtils.formatDoublePostFix(d);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isLetter(c)) continue;
            return String.valueOf(c);
        }
        return "";
    }
}

