/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ExportChanges;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ManipulateExports
extends EDialog
implements DatabaseChangeListener {
    private static final String[] columnNames = new String[]{"Check", "Name", "Layer", "Characteristic", "Body Only"};
    private static int sortColumn = 1;
    private static boolean sortAscending = true;
    private ExportsTable exportTable;
    private ColumnListener columnListener;
    private Map<JComboBox, Integer> lastIndices = new HashMap<JComboBox, Integer>();
    private JButton deleteExports;
    private JButton deselectAll;
    private JButton done;
    private JScrollPane exportPane;
    private JButton highlightExports;
    private JSeparator jSeparator1;
    private JButton reNumberExports;
    private JButton selectAll;
    private JButton showExports;
    private JLabel title;
    private JButton toggleSelection;

    public static void showDialog() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        new ManipulateExports((Frame)TopLevel.getCurrentJFrame(), cell);
    }

    private ManipulateExports(Frame parent, Cell cell) {
        super(parent, false);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.done);
        this.title.setText("Exports in cell " + cell.describe(false));
        this.exportTable = new ExportsTable(cell);
        JTableHeader header = this.exportTable.getTableHeader();
        this.columnListener = new ColumnListener();
        header.addMouseListener(this.columnListener);
        this.exportPane.setViewportView(this.exportTable);
        this.finishInitialization();
        this.setVisible(true);
        UserInterfaceMain.addDatabaseChangeListener(this);
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent e) {
        boolean reload = false;
        for (ExportEntry ee : this.exportTable.model.exports) {
            if (!e.objectChanged(ee.getExport())) continue;
            reload = true;
            break;
        }
        if (reload) {
            this.exportTable.loadExportTable();
        }
    }

    @Override
    protected void escapePressed() {
        this.doneActionPerformed(null);
    }

    private void initComponents() {
        this.done = new JButton();
        this.title = new JLabel();
        this.exportPane = new JScrollPane();
        this.selectAll = new JButton();
        this.deselectAll = new JButton();
        this.reNumberExports = new JButton();
        this.jSeparator1 = new JSeparator();
        this.deleteExports = new JButton();
        this.showExports = new JButton();
        this.toggleSelection = new JButton();
        this.highlightExports = new JButton();
        this.setTitle("Manipulate Exports");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ManipulateExports.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.done.setText("Done");
        this.done.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManipulateExports.this.doneActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.done, gridBagConstraints);
        this.title.setText("Exports in Cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.title, gridBagConstraints);
        this.exportPane.setMinimumSize(new Dimension(200, 200));
        this.exportPane.setPreferredSize(new Dimension(200, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.exportPane, gridBagConstraints);
        this.selectAll.setText("Check All Exports");
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManipulateExports.this.selectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.selectAll, gridBagConstraints);
        this.deselectAll.setText("Uncheck All Exports");
        this.deselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManipulateExports.this.deselectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.deselectAll, gridBagConstraints);
        this.reNumberExports.setText("Renumber Checked Numeric Export Names");
        this.reNumberExports.setToolTipText("Renames the selected exports so that trailing numbers are in order");
        this.reNumberExports.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManipulateExports.this.reNumberExportsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.reNumberExports, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.deleteExports.setText("Delete Checked Exports");
        this.deleteExports.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManipulateExports.this.deleteExportsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.deleteExports, gridBagConstraints);
        this.showExports.setText("Show Checked Exports");
        this.showExports.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManipulateExports.this.showExportsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.showExports, gridBagConstraints);
        this.toggleSelection.setText("Toggle Check");
        this.toggleSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManipulateExports.this.toggleSelectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.toggleSelection, gridBagConstraints);
        this.highlightExports.setText("Highlight Checked Exports");
        this.highlightExports.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManipulateExports.this.highlightExportsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.highlightExports, gridBagConstraints);
        this.pack();
    }

    private void toggleSelectionActionPerformed(ActionEvent evt) {
        this.exportTable.toggleChecks();
    }

    private void showExportsActionPerformed(ActionEvent evt) {
        this.exportTable.showChecked();
    }

    private void deleteExportsActionPerformed(ActionEvent evt) {
        this.exportTable.unExportChecked();
    }

    private void reNumberExportsActionPerformed(ActionEvent evt) {
        this.exportTable.renumberCheckedExports();
    }

    private void deselectAllActionPerformed(ActionEvent evt) {
        this.exportTable.uncheckAll();
    }

    private void selectAllActionPerformed(ActionEvent evt) {
        this.exportTable.checkAll();
    }

    private void doneActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        JTableHeader header = this.exportTable.getTableHeader();
        header.removeMouseListener(this.columnListener);
        UserInterfaceMain.removeDatabaseChangeListener(this);
        this.dispose();
    }

    private void highlightExportsActionPerformed(ActionEvent evt) {
        this.exportTable.highlightChecked();
    }

    public class CellComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            ExportsTable et = (ExportsTable)table;
            ExportTableModel etm = et.getModel();
            JComboBox cb = (JComboBox)etm.getValueAt(row, column);
            return cb;
        }
    }

    private class ExportEntry {
        private boolean selected;
        private boolean bodyOnly;
        private String name;
        private PortCharacteristic ch;
        private Export e;
        private JComboBox cb;
        private DefaultCellEditor dce;
        private boolean stateChanging = false;

        public ExportEntry(Export e, ExportTableModel etm) {
            this.e = e;
            this.name = e.getName();
            this.ch = e.getCharacteristic();
            this.bodyOnly = e.isBodyOnly();
            List<PortCharacteristic> chars = PortCharacteristic.getOrderedCharacteristics();
            PortCharacteristic[] charNames = new PortCharacteristic[chars.size()];
            for (int i = 0; i < chars.size(); ++i) {
                charNames[i] = chars.get(i);
            }
            this.cb = new JComboBox<PortCharacteristic>(charNames);
            this.cb.addItemListener(new ComboBoxItemListener(this.cb, etm));
            this.cb.setSelectedItem((Object)this.ch);
            this.dce = new DefaultCellEditor(this.cb);
        }

        public Export getExport() {
            return this.e;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean s) {
            this.selected = s;
        }

        public boolean isBodyOnly() {
            return this.bodyOnly;
        }

        public void setBodyOnly(boolean b) {
            this.bodyOnly = b;
        }

        private class ComboBoxItemListener
        implements ItemListener {
            private JComboBox cb;
            private ExportTableModel etm;

            public ComboBoxItemListener(JComboBox cb, ExportTableModel etm) {
                this.cb = cb;
                this.etm = etm;
            }

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (ExportEntry.this.stateChanging) {
                    return;
                }
                if (evt.getStateChange() == 1) {
                    Integer lastIndex = (Integer)ManipulateExports.this.lastIndices.get(this.cb);
                    if (lastIndex == null) {
                        lastIndex = new Integer(this.cb.getSelectedIndex());
                        ManipulateExports.this.lastIndices.put(this.cb, lastIndex);
                    }
                    if (lastIndex.intValue() != this.cb.getSelectedIndex()) {
                        ExportEntry thisEE = null;
                        for (ExportEntry ee : this.etm.exports) {
                            if (ee.cb != this.cb) continue;
                            thisEE = ee;
                            break;
                        }
                        if (thisEE.isSelected()) {
                            ExportEntry.this.stateChanging = true;
                            for (ExportEntry ee : this.etm.exports) {
                                if (ee == thisEE || !ee.isSelected()) continue;
                                ee.cb.setSelectedIndex(this.cb.getSelectedIndex());
                            }
                            ExportEntry.this.stateChanging = false;
                        }
                        this.etm.fireTableDataChanged();
                    }
                    ManipulateExports.this.lastIndices.put(this.cb, new Integer(this.cb.getSelectedIndex()));
                }
            }
        }
    }

    private class ExportTableModel
    extends AbstractTableModel {
        private Cell cell;
        private List<ExportEntry> exports;
        private boolean hasBodyOnly;

        private ExportTableModel(Cell cell, boolean hasBodyOnly) {
            this.cell = cell;
            this.hasBodyOnly = hasBodyOnly;
            this.exports = new ArrayList<ExportEntry>();
        }

        public void clearAll() {
            this.exports.clear();
        }

        public void newVar(Export e) {
            ExportEntry ve = new ExportEntry(e, this);
            this.exports.add(ve);
        }

        public void sortTable() {
            Collections.sort(this.exports, new ExportEntrySort());
            this.fireTableDataChanged();
        }

        public void checkAll() {
            int i = 0;
            for (ExportEntry pe : this.exports) {
                pe.setSelected(true);
                this.fireTableCellUpdated(i++, 0);
            }
        }

        public void uncheckAll() {
            int i = 0;
            for (ExportEntry pe : this.exports) {
                pe.setSelected(false);
                this.fireTableCellUpdated(i++, 0);
            }
        }

        public void renumberCheckedExports() {
            ArrayList<Export> queuedExports = new ArrayList<Export>();
            for (ExportEntry pe : this.exports) {
                if (!pe.isSelected()) continue;
                queuedExports.add(pe.getExport());
            }
            new ExportChanges.RenumberNumericExports(queuedExports);
        }

        public void unExportChecked() {
            ArrayList<Export> queuedExports = new ArrayList<Export>();
            for (ExportEntry pe : this.exports) {
                if (!pe.isSelected()) continue;
                queuedExports.add(pe.getExport());
            }
            ExportChanges.deleteExports(this.cell, queuedExports);
        }

        public void showChecked() {
            ArrayList<Export> exportList = new ArrayList<Export>();
            for (ExportEntry pe : this.exports) {
                if (!pe.isSelected()) continue;
                exportList.add(pe.getExport());
            }
            ExportChanges.showExports(exportList);
        }

        public void highlightChecked() {
            UserInterface ui = Job.getUserInterface();
            EditWindow_ wnd = ui.getCurrentEditWindow_();
            if (wnd == null) {
                return;
            }
            wnd.clearHighlighting();
            for (ExportEntry pe : this.exports) {
                if (!pe.isSelected()) continue;
                wnd.addHighlightText(pe.getExport(), this.cell, Export.EXPORT_NAME);
            }
            wnd.finishedHighlighting();
        }

        @Override
        public int getColumnCount() {
            return this.hasBodyOnly ? 5 : 4;
        }

        @Override
        public int getRowCount() {
            return this.exports.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ExportEntry pe = this.exports.get(rowIndex);
            if (pe == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return pe.isSelected();
                }
                case 1: {
                    return pe.name;
                }
                case 2: {
                    return this.getLayer(pe.getExport());
                }
                case 3: {
                    return pe.cb;
                }
                case 4: {
                    return pe.isBodyOnly();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            String colName = columnNames[col];
            if (col == sortColumn) {
                colName = sortAscending ? colName + " \u21d3" : colName + " \u21d1";
            }
            return colName;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0 || col == 1 || col == 3 || col == 4;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            ExportEntry ve = this.exports.get(row);
            if (ve == null) {
                return;
            }
            if (col == 0) {
                Boolean b = (Boolean)aValue;
                if (ve.isSelected() != b.booleanValue()) {
                    ve.setSelected(b);
                    this.fireTableCellUpdated(row, col);
                }
            } else if (col == 1) {
                ve.name = (String)aValue;
                new ExportChanges.RenameExport(ve.getExport(), ve.name);
            } else if (col == 3) {
                ve.ch = (PortCharacteristic)((Object)aValue);
                new ExportChanges.ChangeExportCharacteristic(ve.getExport(), ve.ch);
            } else if (col == 4) {
                Boolean b = (Boolean)aValue;
                if (ve.isBodyOnly() != b.booleanValue()) {
                    ve.setBodyOnly(b);
                    new ExportChanges.ChangeExportBodyOnly(ve.getExport(), b);
                    this.fireTableCellUpdated(row, col);
                }
            }
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 0 || col == 4) {
                return Boolean.class;
            }
            return String.class;
        }

        private String getLayer(Export e) {
            ArcProto[] arcs = e.getBasePort().getConnections();
            String layers = "";
            ArcProto firstGeneric = null;
            for (int i = 0; i < arcs.length; ++i) {
                ArcProto ap = arcs[i];
                if (ap.getTechnology() == Generic.tech()) {
                    if (firstGeneric != null) continue;
                    firstGeneric = ap;
                    continue;
                }
                if (layers.length() > 0) {
                    layers = layers + ", ";
                }
                layers = layers + ap.getLayer(0).getName();
            }
            if (layers.length() == 0 && firstGeneric != null) {
                layers = firstGeneric.getLayer(0).getName();
            }
            return layers;
        }

        private class ExportEntrySort
        implements Comparator<ExportEntry> {
            private ExportEntrySort() {
            }

            @Override
            public int compare(ExportEntry p1, ExportEntry p2) {
                if (!sortAscending) {
                    ExportEntry swap = p1;
                    p1 = p2;
                    p2 = swap;
                }
                String s1 = null;
                String s2 = null;
                switch (sortColumn) {
                    case 0: {
                        boolean b1 = p1.isSelected();
                        boolean b2 = p2.isSelected();
                        if (b1 == b2) {
                            return 0;
                        }
                        if (b1) {
                            return 1;
                        }
                        return -1;
                    }
                    case 1: {
                        s1 = p1.name;
                        s2 = p2.name;
                        break;
                    }
                    case 2: {
                        s1 = ExportTableModel.this.getLayer(p1.getExport());
                        s2 = ExportTableModel.this.getLayer(p2.getExport());
                        break;
                    }
                    case 3: {
                        s1 = p1.ch.getName();
                        s2 = p2.ch.getName();
                        return s1.compareTo(s2);
                    }
                    case 4: {
                        boolean b1 = p1.isBodyOnly();
                        boolean b2 = p2.isBodyOnly();
                        if (b1 == b2) {
                            return 0;
                        }
                        if (b1) {
                            return 1;
                        }
                        return -1;
                    }
                }
                return TextUtils.STRING_NUMBER_ORDER.compare(s1, s2);
            }
        }
    }

    private class ExportsTable
    extends JTable {
        private ExportTableModel model;
        private Cell cell;

        public ExportsTable(Cell cell) {
            this.cell = cell;
            boolean hasBodyOnly = cell.getView() == View.SCHEMATIC;
            this.model = new ExportTableModel(cell, hasBodyOnly);
            this.setModel(this.model);
            TableColumn tc = this.getColumn(this.getColumnName(0));
            if (tc != null) {
                tc.setPreferredWidth(40);
            }
            if ((tc = this.getColumn(this.getColumnName(1))) != null) {
                tc.setPreferredWidth(120);
            }
            if ((tc = this.getColumn(this.getColumnName(2))) != null) {
                tc.setPreferredWidth(100);
            }
            if ((tc = this.getColumn(this.getColumnName(3))) != null) {
                tc.setPreferredWidth(80);
                tc.setCellRenderer(new CellComboBoxRenderer());
            }
            if (hasBodyOnly && (tc = this.getColumn(this.getColumnName(4))) != null) {
                tc.setPreferredWidth(60);
            }
            this.loadExportTable();
        }

        public void loadExportTable() {
            this.model.clearAll();
            Iterator<Export> it = this.cell.getExports();
            while (it.hasNext()) {
                Export e = it.next();
                this.model.newVar(e);
            }
            this.model.sortTable();
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col != 3) {
                return super.getCellEditor(row, col);
            }
            ExportEntry ee = (ExportEntry)this.model.exports.get(row);
            return ee.dce;
        }

        public void toggleChecks() {
            int[] rows = this.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                Boolean b = (Boolean)this.model.getValueAt(rows[i], 0);
                this.model.setValueAt(b == false, rows[i], 0);
            }
        }

        @Override
        public ExportTableModel getModel() {
            return this.model;
        }

        public void checkAll() {
            this.model.checkAll();
        }

        public void uncheckAll() {
            this.model.uncheckAll();
        }

        public void renumberCheckedExports() {
            this.model.renumberCheckedExports();
        }

        public void unExportChecked() {
            this.model.unExportChecked();
        }

        public void showChecked() {
            this.model.showChecked();
        }

        public void highlightChecked() {
            this.model.highlightChecked();
        }
    }

    private class ColumnListener
    extends MouseAdapter {
        private ColumnListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int colNumber;
            TableColumnModel colModel = ManipulateExports.this.exportTable.getColumnModel();
            int modelIndex = colModel.getColumn(colNumber = colModel.getColumnIndexAtX(e.getX())).getModelIndex();
            if (modelIndex < 0) {
                return;
            }
            if (sortColumn == modelIndex) {
                sortAscending = !sortAscending;
            } else {
                sortColumn = modelIndex;
                sortAscending = true;
            }
            ExportTableModel model = ManipulateExports.this.exportTable.getModel();
            model.sortTable();
            model.fireTableStructureChanged();
        }
    }
}

