/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.util.math.AbstractFixpPoint;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.ECoord;
import com.sun.electric.util.math.GenMath;
import java.awt.geom.Point2D;
import java.io.Serializable;

public class EPoint
extends AbstractFixpPoint
implements Serializable {
    public static final EPoint ORIGIN = new EPoint(0L, 0L);
    private final int gridX;
    private final int gridY;
    private static int createdEPoints;

    public EPoint(double lambdaX, double lambdaY) {
        this(DBMath.lambdaToGrid(lambdaX), DBMath.lambdaToGrid(lambdaY));
    }

    private EPoint(long gridX, long gridY) {
        this.gridX = (int)gridX;
        this.gridY = (int)gridY;
        if ((long)this.gridX != gridX || (long)this.gridY != gridY) {
            throw new IllegalArgumentException("Too large coordinates (" + gridX + "," + gridY + ")");
        }
        ++createdEPoints;
    }

    @Override
    public void setFixpLocation(long fixpX, long fixpY) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected AbstractFixpPoint create(long fixpX, long fixpY) {
        return EPoint.fromFixp(fixpX, fixpY);
    }

    public static EPoint fromLambda(double lambdaX, double lambdaY) {
        return lambdaX == 0.0 && lambdaY == 0.0 ? ORIGIN : EPoint.fromGrid(DBMath.lambdaToGrid(lambdaX), DBMath.lambdaToGrid(lambdaY));
    }

    public static EPoint fromFixp(long fixpX, long fixpY) {
        long gridX = GenMath.roundToMultiple(fixpX, 0x100000L) >> 20;
        long gridY = GenMath.roundToMultiple(fixpY, 0x100000L) >> 20;
        return EPoint.fromGrid(gridX, gridY);
    }

    public static EPoint fromGrid(long gridX, long gridY) {
        int intX = (int)gridX;
        int intY = (int)gridY;
        return gridX == 0L && gridY == 0L ? ORIGIN : ((long)intX == gridX && (long)intY == gridY ? new EPoint(gridX, gridY) : new EPointLong(intX, intY));
    }

    public static EPoint snap(Point2D p) {
        return p instanceof EPoint ? (EPoint)p : EPoint.fromLambda(p.getX(), p.getY());
    }

    @Override
    public double getX() {
        return DBMath.gridToLambda(this.getGridX());
    }

    @Override
    public double getY() {
        return DBMath.gridToLambda(this.getGridY());
    }

    public ECoord getCoordX() {
        return ECoord.fromGrid(this.getGridX());
    }

    public ECoord getCoordY() {
        return ECoord.fromGrid(this.getGridX());
    }

    public double getLambdaX() {
        return this.getX();
    }

    public double getLambdaY() {
        return this.getY();
    }

    @Override
    public long getFixpX() {
        return (long)this.gridX << 20;
    }

    @Override
    public long getFixpY() {
        return (long)this.gridY << 20;
    }

    public long getGridX() {
        return this.gridX;
    }

    public long getGridY() {
        return this.gridY;
    }

    @Override
    public void setLocation(double x2, double y) {
        throw new UnsupportedOperationException();
    }

    public Point2D.Double lambdaMutable() {
        return new Point2D.Double(this.getLambdaX(), this.getLambdaY());
    }

    public Point2D.Double gridMutable() {
        return new Point2D.Double(this.getGridX(), this.getGridY());
    }

    public double lambdaDistance(EPoint pt) {
        return DBMath.gridToLambda(this.gridDistance(pt));
    }

    public double gridDistance(EPoint pt) {
        long PX = pt.getGridX() - this.getGridX();
        long PY = pt.getGridY() - this.getGridY();
        return PY == 0L ? (double)Math.abs(PX) : (PX == 0L ? (double)Math.abs(PY) : Math.hypot(PX, PY));
    }

    public double fixpDistance(EPoint pt) {
        return this.gridDistance(pt) * 1048576.0;
    }

    public boolean equals(EPoint that) {
        return this.getGridX() == that.getGridX() && this.getGridY() == that.getGridY();
    }

    public static void printStatistics() {
        System.out.println(createdEPoints + " EPoints created");
    }

    private static class EPointLong
    extends EPoint {
        private final long gridX;
        private final long gridY;

        private EPointLong(long gridX, long gridY) {
            super(Integer.MIN_VALUE, Integer.MIN_VALUE);
            this.gridX = gridX;
            this.gridY = gridY;
        }

        @Override
        public long getFixpX() {
            return this.gridX << 20;
        }

        @Override
        public long getFixpY() {
            return this.gridY << 20;
        }

        @Override
        public long getGridX() {
            return this.gridX;
        }

        @Override
        public long getGridY() {
            return this.gridY;
        }
    }
}

