/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.extract;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.extract.ExtractedPBucket;
import com.sun.electric.tool.extract.NetPBucket;
import com.sun.electric.tool.extract.ParasiticGenerator;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.util.ElapseTimer;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ParasiticTool
extends Tool {
    private static ParasiticTool tool = new ParasiticTool();
    private static ErrorLogger errorLogger = ErrorLogger.newInstance("Parasitics Extraction");
    private static Pref cacheMaxDistance = Pref.makeDoublePref("MaximumDistance", ParasiticTool.tool.prefs, 20.0);

    private ParasiticTool() {
        super("parasitic");
    }

    @Override
    public void init() {
    }

    public static ParasiticTool getParasiticTool() {
        return tool;
    }

    public static ErrorLogger getParasiticErrorLogger() {
        return errorLogger;
    }

    public static double getAreaScale(double scale) {
        return scale * scale / 1000000.0;
    }

    public static double getPerimScale(double scale) {
        return scale / 1000.0;
    }

    public void netwokParasitic(Network network, Cell cell) {
        new AnalyzeParasitic(network, cell);
    }

    public static List<Object> calculateParasistic(ParasiticGenerator tool, Cell cell, VarContext context) {
        errorLogger.clearLogs(cell);
        if (context == null) {
            context = VarContext.globalContext;
        }
        ParasiticVisitor visitor = new ParasiticVisitor(tool, context);
        HierarchyEnumerator.enumerateCell(cell, context, (HierarchyEnumerator.Visitor)visitor);
        List<Object> list2 = visitor.getParasitics();
        return list2;
    }

    public static double getMaxDistance() {
        return cacheMaxDistance.getDouble();
    }

    public static void setMaxDistance(double value2) {
        cacheMaxDistance.setDouble(value2);
    }

    public static double getFactoryMaxDistance() {
        return cacheMaxDistance.getDoubleFactoryValue();
    }

    public static class ParasiticCellInfo
    extends HierarchyEnumerator.CellInfo {
        private float mFactor;

        protected void extInit() {
            HierarchyEnumerator.CellInfo parent = this.getParentInfo();
            this.mFactor = parent == null ? 1.0f : ((ParasiticCellInfo)parent).getMFactor();
            Nodable ni = this.getContext().getNodable();
            if (ni == null) {
                return;
            }
            Variable mvar = ni.getVar(SimulationTool.M_FACTOR_KEY);
            if (mvar == null) {
                return;
            }
            Object mval = this.getContext().evalVar(mvar, null);
            if (mval == null) {
                return;
            }
            this.mFactor *= VarContext.objectToFloat(mval, 1.0f);
        }

        public float getMFactor() {
            return this.mFactor;
        }
    }

    private static class AnalyzeParasitic
    extends Job {
        Cell cell;
        Network net;

        protected AnalyzeParasitic(Network network, Cell cell) {
            super("Analyze " + network, tool, Job.Type.SERVER_EXAMINE, null, cell, Job.Priority.USER);
            this.net = network;
            this.cell = cell;
            this.startJob();
        }

        private List<ParasiticValue> getClosestPolys(Cell cell, Geometric geom, Technology tech, Poly poly, Rectangle2D bounds) {
            ArrayList<ParasiticValue> polyList = new ArrayList<ParasiticValue>();
            Iterator<Geometric> it = cell.searchIterator(bounds);
            while (it.hasNext()) {
                Geometric nGeom = it.next();
                if (nGeom == geom || nGeom.isConnected(geom)) continue;
                if (nGeom instanceof NodeInst) {
                    NodeInst ni = (NodeInst)nGeom;
                    NodeProto np = ni.getProto();
                    if (np == Generic.tech().cellCenterNode || np.getFunction().isPin() || np.getTechnology() != tech) continue;
                    if (ni.isCellInstance()) {
                        System.out.println("Skipping case for now");
                        continue;
                    }
                    System.out.println("Found node " + nGeom + " for " + geom);
                    FixpTransform trans = ni.rotateOut();
                    Poly[] nodeInstPolyList = tech.getShapeOfNode(ni);
                    for (int i = 0; i < nodeInstPolyList.length; ++i) {
                        Poly nPoly = nodeInstPolyList[i];
                        Layer layer = nPoly.getLayer();
                        if (!layer.getFunction().isMetal()) continue;
                        nPoly.transform(trans);
                        polyList.addAll(ParasiticValue.initParasiticValues(poly, nPoly));
                    }
                    continue;
                }
                ArcInst ai = (ArcInst)nGeom;
                ArcProto ap = ai.getProto();
                if (ap.getTechnology() != tech) continue;
                System.out.println("Found arc " + nGeom + " for " + geom);
                Poly[] arcInstPolyList = tech.getShapeOfArc(ai);
                for (int i = 0; i < arcInstPolyList.length; ++i) {
                    Poly nPoly = arcInstPolyList[i];
                    Layer layer = nPoly.getLayer();
                    if (!layer.getFunction().isMetal() || (nPoly = ai.cropPerLayer(nPoly)) == null) continue;
                    polyList.addAll(ParasiticValue.initParasiticValues(poly, nPoly));
                }
            }
            return polyList;
        }

        @Override
        public boolean doIt() throws JobException {
            ElapseTimer timer = ElapseTimer.createInstance().start();
            System.out.println("Extracting Parasitic for " + this.cell + " " + this.net);
            Rectangle2D.Double bounds = new Rectangle2D.Double();
            double maxDistance = ParasiticTool.getMaxDistance();
            ArrayList<ParasiticValue> polyToCheckList = new ArrayList<ParasiticValue>();
            Iterator<ArcInst> it = this.net.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                Technology tech = ai.getProto().getTechnology();
                Poly[] arcInstPolyList = tech.getShapeOfArc(ai);
                for (int i = 0; i < arcInstPolyList.length; ++i) {
                    Poly poly = arcInstPolyList[i];
                    Layer layer = poly.getLayer();
                    if (!layer.getFunction().isMetal()) continue;
                    poly = ai.cropPerLayer(poly);
                    FixpRectangle bnd = poly.getBounds2D();
                    ((Rectangle2D)bounds).setRect(((RectangularShape)bnd).getMinX() - maxDistance, ((RectangularShape)bnd).getMinY() - maxDistance, ((RectangularShape)bnd).getWidth() + maxDistance * 2.0, ((RectangularShape)bnd).getHeight() + maxDistance * 2.0);
                    polyToCheckList.addAll(this.getClosestPolys(this.cell, ai, tech, poly, bounds));
                }
            }
            HashMap<NodeInst, NodeInst> nodeMap = new HashMap<NodeInst, NodeInst>();
            Iterator<PortInst> it2 = this.net.getPorts();
            while (it2.hasNext()) {
                PortInst pi = it2.next();
                NodeInst ni = pi.getNodeInst();
                if (nodeMap.get(ni) != null) continue;
                FixpTransform trans = ni.rotateOut();
                NodeProto np = ni.getProto();
                nodeMap.put(ni, ni);
                if (!ni.isCellInstance()) {
                    PrimitiveNode pNp = (PrimitiveNode)np;
                    Technology tech = pNp.getTechnology();
                    Poly[] nodeInstPolyList = tech.getShapeOfNode(ni);
                    for (int i = 0; i < nodeInstPolyList.length; ++i) {
                        Layer layer;
                        Poly poly = nodeInstPolyList[i];
                        if (poly.isPseudoLayer() || !(layer = poly.getLayer()).getFunction().isMetal()) continue;
                        poly.transform(trans);
                        FixpRectangle bnd = poly.getBounds2D();
                        ((Rectangle2D)bounds).setRect(((RectangularShape)bnd).getMinX() - maxDistance, ((RectangularShape)bnd).getMinY() - maxDistance, ((RectangularShape)bnd).getWidth() + maxDistance * 2.0, ((RectangularShape)bnd).getHeight() + maxDistance * 2.0);
                        polyToCheckList.addAll(this.getClosestPolys(this.cell, ni, tech, poly, bounds));
                    }
                    continue;
                }
                System.out.println("Not implemented");
            }
            for (ParasiticValue val : polyToCheckList) {
                System.out.println("Value " + val + " Layer " + ((ParasiticValue)val).elements[1].poly.getLayer());
            }
            timer.end();
            System.out.println("Done (took " + timer + ")");
            errorLogger.sortLogs();
            return true;
        }
    }

    private static class ParasiticValue {
        private ParasiticBucket[] elements = new ParasiticBucket[2];

        private ParasiticValue() {
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < 2; ++i) {
                buf.append("Poly " + i + ":" + this.elements[i].poly.getBounds2D() + "(area=" + this.elements[i].area + ", length=" + this.elements[i].length + ") ");
            }
            return buf.toString();
        }

        public static List<ParasiticValue> initParasiticValues(Poly p1, Poly p2) {
            FixpRectangle thisBounds = p1.getBox();
            FixpRectangle otherBounds = p2.getBox();
            ArrayList<ParasiticValue> values2 = new ArrayList<ParasiticValue>();
            if (thisBounds == null || otherBounds == null) {
                return null;
            }
            int dir = -1;
            double[][] points1 = new double[][]{{((RectangularShape)thisBounds).getMinX(), ((RectangularShape)thisBounds).getMinY()}, {((RectangularShape)thisBounds).getMaxX(), ((RectangularShape)thisBounds).getMaxY()}};
            double[][] points2 = new double[][]{{((RectangularShape)otherBounds).getMinX(), ((RectangularShape)otherBounds).getMinY()}, {((RectangularShape)otherBounds).getMaxX(), ((RectangularShape)otherBounds).getMaxY()}};
            double pdx = Math.max(points2[0][0] - points1[1][0], points1[0][0] - points2[1][0]);
            double pdy = Math.max(points2[0][1] - points1[1][1], points1[0][1] - points2[1][1]);
            double area1 = 0.0;
            double area2 = 0.0;
            double over1 = 0.0;
            double over2 = 0.0;
            double length1 = 0.0;
            double length2 = 0.0;
            double thickP1 = p1.getLayer().getThickness();
            double thickP2 = p1.getLayer().getThickness();
            thickP2 = 1.0;
            thickP1 = 1.0;
            if (pdx > 0.0 && pdy > 0.0) {
                ParasiticValue newValue1 = new ParasiticValue();
                ParasiticValue newValue2 = new ParasiticValue();
                length1 = p1.getBox().getWidth();
                length2 = p2.getBox().getHeight();
                area1 = thickP1 * p1.getBox().getHeight();
                area2 = thickP2 * p2.getBox().getWidth();
                newValue1.elements[0] = new ParasiticBucket(p1, area1, length1);
                newValue1.elements[1] = new ParasiticBucket(p2, area2, length2);
                length1 = p1.getBox().getHeight();
                length2 = p2.getBox().getWidth();
                area1 = thickP1 * p1.getBox().getWidth();
                area2 = thickP2 * p2.getBox().getHeight();
                newValue2.elements[0] = new ParasiticBucket(p1, area1, length1);
                newValue2.elements[1] = new ParasiticBucket(p2, area2, length2);
                values2.add(newValue1);
                values2.add(newValue2);
            } else {
                if (pdx == 0.0 || pdy == 0.0) {
                    System.out.println("How do I treat this?");
                }
                ParasiticValue newValue = new ParasiticValue();
                if (pdx > pdy) {
                    dir = 0;
                    length1 = p1.getBox().getWidth();
                    length2 = p2.getBox().getWidth();
                } else {
                    dir = 1;
                    length1 = p1.getBox().getHeight();
                    length2 = p2.getBox().getHeight();
                }
                int oppDir = (dir + 1) % 2;
                over1 = over2 = Math.min(points1[1][oppDir], points2[1][oppDir]) - Math.max(points1[0][oppDir], points2[0][oppDir]);
                area1 = thickP1 * over1;
                area2 = thickP2 * over2;
                newValue.elements[0] = new ParasiticBucket(p1, area1, length1);
                newValue.elements[1] = new ParasiticBucket(p2, area2, length2);
                values2.add(newValue);
            }
            return values2;
        }
    }

    private static class ParasiticBucket {
        public Poly poly;
        public double area;
        public double length;

        protected ParasiticBucket(Poly p, double a, double l) {
            this.poly = p;
            this.area = a;
            this.length = l;
        }
    }

    private static class ParasiticVisitor
    extends HierarchyEnumerator.Visitor {
        private Map<Network, NetPBucket> netMap;
        private List<Object> transAndRCList = new ArrayList<Object>();
        private ParasiticGenerator tool;
        private VarContext context;

        public List<Object> getParasitics() {
            ArrayList<Object> list2 = new ArrayList<Object>(this.transAndRCList);
            for (Network net : this.netMap.keySet()) {
                NetPBucket value2 = this.netMap.get(net);
                if (value2 == null) continue;
                list2.add(value2);
            }
            return list2;
        }

        @Override
        public HierarchyEnumerator.CellInfo newCellInfo() {
            return new ParasiticCellInfo();
        }

        public ParasiticVisitor(ParasiticGenerator tool, VarContext context) {
            this.tool = tool;
            this.netMap = new HashMap<Network, NetPBucket>();
            this.context = context;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            if (info.getParentInfo() == null) {
                for (Network net : this.netMap.keySet()) {
                    NetPBucket bucket = this.netMap.get(net);
                    bucket.postProcess(false);
                }
            }
        }

        private NetPBucket getNetParasiticsBucket(Network net, HierarchyEnumerator.CellInfo info) {
            NetPBucket parasiticNet = this.netMap.get(net);
            int numRemoveParents = this.context.getNumLevels();
            if (parasiticNet == null) {
                String name = info.getUniqueNetNameProxy(net, "/").toString(numRemoveParents);
                parasiticNet = new NetPBucket(name);
                this.netMap.put(net, parasiticNet);
            }
            return parasiticNet;
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            ParasiticCellInfo iinfo = (ParasiticCellInfo)info;
            iinfo.extInit();
            int numRemoveParents = this.context.getNumLevels();
            Iterator<ArcInst> aIt = info.getCell().getArcs();
            while (aIt.hasNext()) {
                Network net;
                ArcInst ai = aIt.next();
                if (ai.getProto().getFunction() == ArcProto.Function.NONELEC || (net = info.getNetlist().getNetwork(ai, 0)) == null) continue;
                PortInst tailP = ai.getTailPortInst();
                PortInst headP = ai.getHeadPortInst();
                NetPBucket parasiticNet = this.getNetParasiticsBucket(net, info);
                if (parasiticNet == null) continue;
                String netName = info.getUniqueNetNameProxy(net, "/").toString(numRemoveParents);
                String net1Name = netName + "_" + tailP.getNodeInst().getName();
                String net2Name = netName + "_" + headP.getNodeInst().getName();
                boolean isDiffArc = ai.isDiffusionArc();
                Technology tech = ai.getProto().getTechnology();
                for (Poly poly : tech.getShapeOfArc(ai)) {
                    Layer layer;
                    if (poly.getStyle().isText() || poly.isPseudoLayer() || (layer = poly.getLayer()).getTechnology() != Technology.getCurrent()) continue;
                    if (isDiffArc || layer.getCapacitance() > 0.0) {
                        parasiticNet.addCapacitance(layer, poly);
                    }
                    if (!(layer.getResistance() > 0.0)) continue;
                    parasiticNet.modifyResistance(layer, poly, new String[]{net1Name, net2Name}, true);
                }
            }
            return true;
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeInst ni = no.getNodeInst();
            if (ni.isCellInstance()) {
                return true;
            }
            if (NodeInst.isSpecialNode(ni)) {
                return false;
            }
            Technology tech = ni.getProto().getTechnology();
            FixpTransform trans = ni.rotateOut();
            ExtractedPBucket parasitic = this.tool.createBucket(ni, (ParasiticCellInfo)info);
            if (parasitic != null) {
                this.transAndRCList.add(parasitic);
            }
            int numRemoveParents = this.context.getNumLevels();
            PrimitiveNode.Function function = ni.getFunction();
            boolean add = !function.isContact();
            for (Poly poly : tech.getShapeOfNode(ni, true, true, null)) {
                boolean gateLayer;
                NetPBucket parasiticNet;
                PortProto pp;
                if (poly.isPseudoLayer() || (pp = poly.getPort()) == null) continue;
                Network net = info.getNetlist().getNetwork(ni, pp, 0);
                Layer layer = poly.getLayer();
                if (layer.getTechnology() != Technology.getCurrent() || !layer.isDiffusionLayer() && net == null || (parasiticNet = this.getNetParasiticsBucket(net, info)) == null) continue;
                boolean isDiffLayer = layer.isDiffusionLayer();
                if (function.isTransistor() && isDiffLayer) {
                    parasiticNet.addTransistor(parasitic);
                }
                poly.transform(trans);
                boolean bl = gateLayer = layer.getFunction() == Layer.Function.GATE;
                if (isDiffLayer || !gateLayer && layer.getCapacitance() > 0.0) {
                    parasiticNet.addCapacitance(layer, poly);
                }
                if (gateLayer && !tech.isGateIncluded()) continue;
                String netName = info.getUniqueNetNameProxy(net, "/").toString(numRemoveParents) + "_" + ni.getName();
                if (!(layer.getResistance() > 0.0)) continue;
                parasiticNet.modifyResistance(layer, poly, new String[]{netName, netName}, add);
            }
            return true;
        }
    }
}

