/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.metrics;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.routing.metrics.RoutingMetric;
import java.util.HashMap;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackedViasAmountMetric
extends RoutingMetric<Integer> {
    private static Logger logger = LoggerFactory.getLogger(StackedViasAmountMetric.class);

    @Override
    public Integer calculate(Cell cell) {
        Integer result2 = 0;
        Iterator<Network> it = cell.getNetlist().getNetworks();
        while (it.hasNext()) {
            Network net = it.next();
            HashMap<Integer, Boolean> visitedPairs = new HashMap<Integer, Boolean>();
            Iterator<NodeInst> nodes = net.getNodes();
            while (nodes.hasNext()) {
                NodeInst node = nodes.next();
                if (!node.getFunction().isContact()) continue;
                int countPorts = 0;
                NodeProto np = node.getProto();
                Iterator<PortInst> portIt = node.getPortInsts();
                while (portIt.hasNext()) {
                    PortInst port = portIt.next();
                    ++countPorts;
                    EPoint center = port.getCenter();
                    result2 = result2 + this.isPortStacked(node, np, port, center, visitedPairs);
                }
                assert (countPorts == 1);
            }
        }
        return result2;
    }

    private int isPortStacked(NodeInst ni, NodeProto np, PortInst port, EPoint center, HashMap<Integer, Boolean> visitedPairs) {
        int count2 = 0;
        int index1 = ni.hashCode();
        Iterator<Connection> connIt = port.getConnections();
        while (connIt.hasNext()) {
            int index;
            Connection con = connIt.next();
            int thatEndIndex = 1 - con.getEndIndex();
            PortInst p = con.getArc().getConnection(thatEndIndex).getPortInst();
            NodeInst otherNi = p.getNodeInst();
            if (otherNi.getProto() == np) continue;
            int index2 = otherNi.hashCode();
            int n = index = index1 < index2 ? index1 ^ index2 : index2 ^ index1;
            if (!otherNi.getFunction().isContact() || visitedPairs.get(index) != null) continue;
            visitedPairs.put(index, true);
            EPoint cen = p.getCenter();
            if (!cen.equals(center)) continue;
            ++count2;
        }
        return count2;
    }
}

