/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.redisplay;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.tool.user.redisplay.TransparentRaster;

class PatternedTransparentRaster
extends TransparentRaster {
    final int[] pattern;
    final EGraphics.Outline outline;

    PatternedTransparentRaster(int[] layerBitMap, int intsPerRow, int[] pattern, EGraphics.Outline outline) {
        super(intsPerRow, layerBitMap);
        this.pattern = pattern;
        this.outline = outline;
    }

    @Override
    public void fillBox(int lX, int hX, int lY, int hY) {
        int baseIndex = lY * this.intsPerRow;
        int lIndex = baseIndex + (lX >> 5);
        int hIndex = baseIndex + (hX >> 5);
        if (lIndex == hIndex) {
            int mask = (2 << (hX & 0x1F)) - (1 << (lX & 0x1F));
            for (int y = lY; y < hY; ++y) {
                int pat = mask & this.pattern[y & 0xF];
                if (pat != 0) {
                    int n = lIndex;
                    this.layerBitMap[n] = this.layerBitMap[n] | pat;
                }
                lIndex += this.intsPerRow;
            }
        } else {
            int lMask = -(1 << (lX & 0x1F));
            int hMask = (2 << (hX & 0x1F)) - 1;
            for (int y = lY; y <= hY; ++y) {
                int pat = this.pattern[y & 0xF];
                if (pat != 0) {
                    int n = lIndex;
                    this.layerBitMap[n] = this.layerBitMap[n] | lMask & pat;
                    int index = lIndex + 1;
                    while (index < hIndex) {
                        int n2 = index++;
                        this.layerBitMap[n2] = this.layerBitMap[n2] | pat;
                    }
                    int n3 = hIndex;
                    this.layerBitMap[n3] = this.layerBitMap[n3] | hMask & pat;
                }
                lIndex += this.intsPerRow;
                hIndex += this.intsPerRow;
            }
        }
    }

    @Override
    public void fillHorLine(int y, int lX, int hX) {
        int pat = this.pattern[y & 0xF];
        if (pat == 0) {
            return;
        }
        int baseIndex = y * this.intsPerRow;
        int lIndex = baseIndex + (lX >> 5);
        int hIndex = baseIndex + (hX >> 5);
        if (lIndex == hIndex) {
            int mask = pat & (2 << (hX & 0x1F)) - (1 << (lX & 0x1F));
            if (mask != 0) {
                int n = lIndex;
                this.layerBitMap[n] = this.layerBitMap[n] | mask;
            }
        } else {
            int n = lIndex++;
            this.layerBitMap[n] = this.layerBitMap[n] | pat & -(1 << (lX & 0x1F));
            while (lIndex < hIndex) {
                int n2 = lIndex++;
                this.layerBitMap[n2] = this.layerBitMap[n2] | pat;
            }
            int n3 = hIndex;
            this.layerBitMap[n3] = this.layerBitMap[n3] | pat & (2 << (hX & 0x1F)) - 1;
        }
    }

    @Override
    public void fillVerLine(int x2, int lY, int hY) {
        int baseIndex = lY * this.intsPerRow + (x2 >> 5);
        int mask = 1 << (x2 & 0x1F);
        for (int y = lY; y <= hY; ++y) {
            if ((this.pattern[y & 0xF] & mask) != 0) {
                int n = baseIndex;
                this.layerBitMap[n] = this.layerBitMap[n] | mask;
            }
            baseIndex += this.intsPerRow;
        }
    }

    @Override
    public void fillPoint(int x2, int y) {
        int mask = 1 << (x2 & 0x1F) & this.pattern[y & 0xF];
        if (mask != 0) {
            int n = y * this.intsPerRow + (x2 >> 5);
            this.layerBitMap[n] = this.layerBitMap[n] | mask;
        }
    }

    @Override
    public EGraphics.Outline getOutline() {
        return this.outline;
    }

    @Override
    public void copyBits(TransparentRaster src, int minSrcX, int maxSrcX, int minSrcY, int maxSrcY, int dx, int dy) {
        int[] srcLayerBitMap = src.layerBitMap;
        assert ((minSrcY + dy) * this.intsPerRow + (minSrcX + dx >> 5) >= 0);
        assert ((maxSrcY + dy) * this.intsPerRow + (maxSrcX + dx >> 5) < this.layerBitMap.length);
        for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
            int destY = srcY + dy;
            int pat = this.pattern[destY & 0xF];
            if (pat == 0) continue;
            int srcBaseIndex = srcY * src.intsPerRow;
            int destBaseIndex = destY * this.intsPerRow;
            for (int srcX = minSrcX; srcX <= maxSrcX; ++srcX) {
                int destMask;
                int destX = srcX + dx;
                if ((srcLayerBitMap[srcBaseIndex + (srcX >> 5)] & 1 << (srcX & 0x1F)) == 0 || (pat & (destMask = 1 << (destX & 0x1F))) == 0) continue;
                int n = destBaseIndex + (destX >> 5);
                this.layerBitMap[n] = this.layerBitMap[n] | destMask;
            }
        }
    }
}

