/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.ECoord;
import java.io.Serializable;

public class EdgeH
implements Serializable {
    private final double multiplier;
    private final int multiplierInt;
    private final ECoord adder;

    public EdgeH(double multiplier, double adder) {
        this.multiplier = multiplier;
        this.multiplierInt = multiplier == 0.0 ? 0 : (multiplier == 0.5 ? 1 : (multiplier == -0.5 ? -1 : Integer.MIN_VALUE));
        this.adder = ECoord.fromLambdaRoundGrid(adder);
    }

    public boolean equals(Object other) {
        if (!(other instanceof EdgeH)) {
            return false;
        }
        EdgeH otherE = (EdgeH)other;
        return this.multiplier == otherE.multiplier && this.adder.equals(otherE.adder);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.multiplier) ^ Double.doubleToLongBits(this.multiplier) >>> 32);
        hash = 47 * hash + (this.adder != null ? this.adder.hashCode() : 0);
        return hash;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public ECoord getAdder() {
        return this.adder;
    }

    public long getFixpValue(EPoint size2) {
        long fixpAdder = this.adder.getFixp();
        switch (this.multiplierInt) {
            case -1: {
                return fixpAdder - (size2.getFixpX() >> 1);
            }
            case 0: {
                return fixpAdder;
            }
            case 1: {
                return fixpAdder + (size2.getFixpX() >> 1);
            }
        }
        return fixpAdder + (long)Math.rint(this.multiplier * (double)size2.getFixpX());
    }

    public long getGridValue(EPoint size2) {
        long gridAdder = this.adder.getGrid();
        switch (this.multiplierInt) {
            case -1: {
                return gridAdder - (size2.getGridX() >> 1);
            }
            case 0: {
                return gridAdder;
            }
            case 1: {
                return gridAdder + (size2.getGridX() >> 1);
            }
        }
        return gridAdder + (long)Math.rint(this.multiplier * (double)size2.getGridX());
    }

    public EdgeH withGridAdder(long gridAdder) {
        if (this.adder.getFixp() == gridAdder) {
            return this;
        }
        return new EdgeH(this.multiplier, DBMath.gridToLambda(gridAdder));
    }

    public static EdgeH l(double amt) {
        return new EdgeH(-0.5, amt);
    }

    public static EdgeH c(double amt) {
        return new EdgeH(0.0, amt);
    }

    public static EdgeH r(double amt) {
        return new EdgeH(0.5, amt);
    }

    public static EdgeH by(double width, double amt) {
        return new EdgeH(amt / 2.0, amt * width / 2.0);
    }

    public static EdgeH by0(double amt) {
        return EdgeH.by(0.0, amt);
    }

    public static EdgeH by2(double amt) {
        return EdgeH.by(2.0, amt);
    }

    public static EdgeH by3(double amt) {
        return EdgeH.by(3.0, amt);
    }

    public static EdgeH by4(double amt) {
        return EdgeH.by(4.0, amt);
    }

    public static EdgeH by6(double amt) {
        return EdgeH.by(6.0, amt);
    }

    public static EdgeH by8(double amt) {
        return EdgeH.by(8.0, amt);
    }

    public static EdgeH by10(double amt) {
        return EdgeH.by(10.0, amt);
    }

    public static EdgeH fromLeft(double amt) {
        return new EdgeH(-0.5, amt);
    }

    public static EdgeH fromRight(double amt) {
        return new EdgeH(0.5, -amt);
    }

    public static EdgeH fromCenter(double amt) {
        return new EdgeH(0.0, amt);
    }

    public static EdgeH makeCenter() {
        return EdgeH.fromCenter(0.0);
    }

    public String toString() {
        return "EdgeH(" + this.multiplier + "," + this.adder.getLambda() + ")";
    }
}

