/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.CellTree;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechPool;
import com.sun.electric.tool.Job;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.Orientation;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Iterator;

public class Poly
extends PolyBase {
    public static final Poly[] NULL_ARRAY = new Poly[0];
    public static final boolean NEWTEXTTREATMENT = true;
    private EGraphics graphicsOverride;
    private String string;
    private TextDescriptor descript;
    private DisplayedText dt;
    private static final int[] extendFactor = new int[]{0, 11459, 5729, 3819, 2864, 2290, 1908, 1635, 1430, 1271, 1143, 1039, 951, 878, 814, 760, 712, 669, 631, 598, 567, 540, 514, 492, 470, 451, 433, 417, 401, 387, 373, 361, 349, 338, 327, 317, 308, 299, 290, 282, 275, 267, 261, 254, 248, 241, 236, 230, 225, 219, 214, 210, 205, 201, 196, 192, 188, 184, 180, 177, 173, 170, 166, 163, 160, 157, 154, 151, 148, 146, 143, 140, 138, 135, 133, 130, 128, 126, 123, 121, 119, 117, 115, 113, 111, 109, 107, 105, 104, 102, 100};
    private static ThreadLocal<Builder> threadLocalLambdaBuilder = new ThreadLocal<Builder>(){

        @Override
        protected Builder initialValue() {
            return new Builder(false);
        }
    };

    public Poly(PolyBase.Point ... points) {
        super(points);
    }

    public Poly(EPoint ... points) {
        this(Poly.convertPoints(points));
    }

    private static PolyBase.Point[] convertPoints(EPoint[] points) {
        PolyBase.Point[] newPoints = new PolyBase.Point[points.length];
        for (int i = 0; i < points.length; ++i) {
            EPoint p = points[i];
            newPoints[i] = p instanceof PolyBase.Point ? (PolyBase.Point)((Object)p) : Poly.from(p);
        }
        return newPoints;
    }

    public Poly(double cX, double cY, double width, double height) {
        super(cX, cY, width, height);
    }

    public Poly(Rectangle2D rect) {
        super(rect);
    }

    public EGraphics getGraphicsOverride() {
        return this.graphicsOverride;
    }

    public void setGraphicsOverride(EGraphics graphics) {
        this.graphicsOverride = graphics;
    }

    public String getString() {
        return this.string;
    }

    public void setString(String string2) {
        this.string = string2;
    }

    public TextDescriptor getTextDescriptor() {
        return this.descript;
    }

    public void setTextDescriptor(TextDescriptor descript) {
        this.descript = descript;
    }

    public DisplayedText getDisplayedText() {
        return this.dt;
    }

    public void setDisplayedText(DisplayedText dt) {
        this.dt = dt;
    }

    @Override
    public void transform(FixpTransform af) {
        if (af.getType() == 0) {
            return;
        }
        if (this.getStyle().isText() && this.descript != null) {
            this.setStyle(this.getStyle().transformAnchorOfType(af));
        }
        super.transform(af);
    }

    public static double getExtendFactor(double width, int extend) {
        return extend <= 0 || extend >= 90 ? width * 0.5 : width * 50.0 / (double)extendFactor[extend];
    }

    public static Poly makeEndPointPoly(double len, double wid, int angle, Point2D endH, double extendH, Point2D endT, double extendT, Type style) {
        double temp;
        double w2 = wid / 2.0;
        double x1 = endH.getX();
        double y1 = endH.getY();
        double x2 = endT.getX();
        double y2 = endT.getY();
        PolyBase.Point[] points = null;
        if (angle == 900 || angle == 2700) {
            if (angle == 900) {
                temp = y1;
                y1 = y2;
                y2 = temp;
                temp = extendH;
                extendH = extendT;
                extendT = temp;
            }
            points = new PolyBase.Point[]{Poly.fromLambda(x1 - w2, y1 - extendH), Poly.fromLambda(x1 + w2, y1 - extendH), Poly.fromLambda(x2 + w2, y2 + extendT), Poly.fromLambda(x2 - w2, y2 + extendT)};
        } else if (angle == 0 || angle == 1800) {
            if (angle == 0) {
                temp = x1;
                x1 = x2;
                x2 = temp;
                temp = extendH;
                extendH = extendT;
                extendT = temp;
            }
            points = new PolyBase.Point[]{Poly.fromLambda(x1 - extendH, y1 - w2), Poly.fromLambda(x1 - extendH, y1 + w2), Poly.fromLambda(x2 + extendT, y2 + w2), Poly.fromLambda(x2 + extendT, y2 - w2)};
        } else {
            double yextra;
            double xextra;
            double ye2;
            double xe2;
            double ye1;
            double xe1;
            if (len == 0.0) {
                len = endH.distance(endT);
            }
            if (len == 0.0) {
                double sa = DBMath.sin(angle);
                double ca = DBMath.cos(angle);
                xe1 = x1 - ca * extendH;
                ye1 = y1 - sa * extendH;
                xe2 = x2 + ca * extendT;
                ye2 = y2 + sa * extendT;
                xextra = ca * w2;
                yextra = sa * w2;
            } else {
                xe1 = x1 - extendH * (x2 - x1) / len;
                ye1 = y1 - extendH * (y2 - y1) / len;
                xe2 = x2 + extendT * (x2 - x1) / len;
                ye2 = y2 + extendT * (y2 - y1) / len;
                xextra = w2 * (x2 - x1) / len;
                yextra = w2 * (y2 - y1) / len;
            }
            points = new PolyBase.Point[]{Poly.fromLambda(yextra + xe1, ye1 - xextra), Poly.fromLambda(xe1 - yextra, xextra + ye1), Poly.fromLambda(xe2 - yextra, xextra + ye2), Poly.fromLambda(yextra + xe2, ye2 - xextra)};
        }
        if (wid != 0.0 && style.isOpened()) {
            points = new PolyBase.Point[]{points[0], points[1], points[2], points[3], points[0]};
        }
        Poly poly = new Poly(points);
        poly.setStyle(style);
        return poly;
    }

    public boolean setExactTextBounds(EditWindow0 wnd, ElectricObject eObj) {
        Font font;
        Variable var;
        if (this.getString() == null) {
            return true;
        }
        String theString = this.getString().trim();
        if (theString.length() == 0) {
            return true;
        }
        int numLines = 1;
        if (this.dt != null && (var = this.dt.getVariable()) != null && (numLines = var.getLength()) > 1) {
            Object[] objList = (Object[])var.getObject();
            for (int i = 0; i < numLines; ++i) {
                String str;
                if (objList[i] == null || (str = objList[i].toString()).length() <= theString.length()) continue;
                theString = str;
            }
        }
        Type style = this.getStyle();
        style = Poly.rotateType(style, eObj);
        Font font2 = font = this.descript != null ? this.descript.getFont(wnd, 0) : TextDescriptor.getDefaultFont(wnd);
        if (font == null) {
            UserInterface ui = Job.getUserInterface();
            double size2 = ui.getDefaultTextSize();
            if (this.descript != null) {
                size2 = this.descript.getTrueSize(wnd);
            }
            if ((size2 /= wnd.getScale()) <= 0.0) {
                size2 = 1.0;
            }
            double cX = this.getBounds2D().getCenterX();
            double cY = this.getBounds2D().getCenterY();
            double sizeIndent = size2 / 4.0;
            double fakeWidth = (double)theString.length() * size2 * 0.75;
            Point2D pt = this.getTextCorner(style, cX, cY, fakeWidth, size2);
            cX = pt.getX();
            cY = pt.getY();
            this.points = new PolyBase.Point[]{Poly.fromLambda(cX, cY + sizeIndent), Poly.fromLambda(cX + fakeWidth, cY + sizeIndent), Poly.fromLambda(cX + fakeWidth, cY + size2 - sizeIndent), Poly.fromLambda(cX, cY + size2 - sizeIndent)};
            this.bounds = null;
            return false;
        }
        FixpRectangle bounds = this.getBounds2D();
        double lX = ((RectangularShape)bounds).getMinX();
        double hX = ((RectangularShape)bounds).getMaxX();
        double lY = ((RectangularShape)bounds).getMinY();
        double hY = ((RectangularShape)bounds).getMaxY();
        Rectangle2D glyphBounds = wnd.getGlyphBounds(theString, font);
        double textScale = this.getTextScale(wnd, glyphBounds, style, lX, hX, lY, hY);
        double screenWidth = glyphBounds == null ? 1.0 : glyphBounds.getWidth();
        double screenHeight = font.getSize();
        if (screenHeight == 1.0) {
            UserInterface ui = Job.getUserInterface();
            double size3 = ui.getDefaultTextSize();
            if (this.descript != null) {
                size3 = this.descript.getTrueSize(wnd);
            }
            if (size3 <= 0.0) {
                size3 = 1.0;
            }
            screenWidth = (double)theString.length() * size3 * 0.75;
        }
        double dbWidth = screenWidth * textScale;
        double dbHeight = screenHeight * textScale;
        double cX = (lX + hX) / 2.0;
        double cY = (lY + hY) / 2.0;
        Point2D corner = this.getTextCorner(style, cX, cY, dbWidth, dbHeight);
        cX = corner.getX();
        cY = corner.getY();
        dbHeight *= (double)numLines;
        switch (this.descript.getRotation().getIndex()) {
            case 1: {
                double saveWidth = dbWidth;
                dbWidth = -dbHeight;
                dbHeight = saveWidth;
                break;
            }
            case 2: {
                dbWidth = -dbWidth;
                dbHeight = -dbHeight;
                break;
            }
            case 3: {
                double saveHeight = dbHeight;
                dbHeight = -dbWidth;
                dbWidth = saveHeight;
            }
        }
        this.points = new PolyBase.Point[]{Poly.fromLambda(cX, cY), Poly.fromLambda(cX + dbWidth, cY), Poly.fromLambda(cX + dbWidth, cY + dbHeight), Poly.fromLambda(cX, cY + dbHeight)};
        this.bounds = null;
        return false;
    }

    private Point2D getTextCorner(Type style, double cX, double cY, double scaledWidth, double scaledHeight) {
        double offX = 0.0;
        double offY = 0.0;
        if (style == Type.TEXTCENT || style == Type.TEXTBOX) {
            offX = -scaledWidth / 2.0;
            offY = -scaledHeight / 2.0;
        } else if (style == Type.TEXTTOP) {
            offX = -scaledWidth / 2.0;
            offY = -scaledHeight;
        } else if (style == Type.TEXTBOT) {
            offX = -scaledWidth / 2.0;
        } else if (style == Type.TEXTLEFT) {
            offY = -scaledHeight / 2.0;
        } else if (style == Type.TEXTRIGHT) {
            offX = -scaledWidth;
            offY = -scaledHeight / 2.0;
        } else if (style == Type.TEXTTOPLEFT) {
            offY = -scaledHeight;
        } else if (style != Type.TEXTBOTLEFT) {
            if (style == Type.TEXTTOPRIGHT) {
                offX = -scaledWidth;
                offY = -scaledHeight;
            } else if (style == Type.TEXTBOTRIGHT) {
                offX = -scaledWidth;
            }
        }
        int rotation = this.getTextDescriptor().getRotation().getIndex();
        if (rotation != 0) {
            double saveOffX = offX;
            switch (rotation) {
                case 1: {
                    offX = -offY;
                    offY = saveOffX;
                    break;
                }
                case 2: {
                    offX = -offX;
                    offY = -offY;
                    break;
                }
                case 3: {
                    offX = offY;
                    offY = -saveOffX;
                }
            }
        }
        return new Point2D.Double(cX + offX, cY + offY);
    }

    public static Builder newLambdaBuilder() {
        return new Builder(true);
    }

    public static Builder threadLocalLambdaBuilder() {
        return threadLocalLambdaBuilder.get();
    }

    public static enum Type {
        FILLED("filled", false),
        CLOSED("closed", false),
        CROSSED("crossed", false),
        OPENED("opened", false),
        OPENEDT1("opened-dotted", false),
        OPENEDT2("opened-dashed", false),
        OPENEDT3("opened-thick", false),
        VECTORS("vectors", false),
        CIRCLE("circle", false),
        THICKCIRCLE("thick-circle", false),
        DISC("disc", false),
        CIRCLEARC("circle-arc", false),
        THICKCIRCLEARC("thick-circle-arc", false),
        TEXTCENT("text-center", true),
        TEXTTOP("text-top", true),
        TEXTBOT("text-bottom", true),
        TEXTLEFT("text-left", true),
        TEXTRIGHT("text-right", true),
        TEXTTOPLEFT("text-topleft", true),
        TEXTBOTLEFT("text-botleft", true),
        TEXTTOPRIGHT("text-topright", true),
        TEXTBOTRIGHT("text-botright", true),
        TEXTBOX("text-box", true),
        CROSS("cross", false),
        BIGCROSS("big-cross", false);

        private final String name;
        private final boolean isText;

        private Type(String name, boolean isText) {
            this.name = name;
            this.isText = isText;
        }

        public boolean isText() {
            return this.isText;
        }

        public String toString() {
            return "Poly.Type " + this.name;
        }

        public boolean isOpened() {
            return this == OPENED || this == OPENEDT1 || this == OPENEDT2 || this == OPENEDT3 || this == VECTORS;
        }

        public int getTextAngle() {
            if (this == TEXTLEFT) {
                return 0;
            }
            if (this == TEXTBOTLEFT) {
                return 450;
            }
            if (this == TEXTBOT) {
                return 900;
            }
            if (this == TEXTBOTRIGHT) {
                return 1350;
            }
            if (this == TEXTRIGHT) {
                return 1800;
            }
            if (this == TEXTTOPRIGHT) {
                return 2250;
            }
            if (this == TEXTTOP) {
                return 2700;
            }
            if (this == TEXTTOPLEFT) {
                return 3150;
            }
            return 0;
        }

        public static Type getTextTypeFromAngle(int angle) {
            switch (angle) {
                case 0: {
                    return TEXTLEFT;
                }
                case 450: {
                    return TEXTBOTLEFT;
                }
                case 900: {
                    return TEXTBOT;
                }
                case 1350: {
                    return TEXTBOTRIGHT;
                }
                case 1800: {
                    return TEXTRIGHT;
                }
                case 2250: {
                    return TEXTTOPRIGHT;
                }
                case 2700: {
                    return TEXTTOP;
                }
                case 3150: {
                    return TEXTTOPLEFT;
                }
            }
            return TEXTCENT;
        }

        public Type cycleTextAnchorHoriz() {
            switch (this) {
                case TEXTLEFT: {
                    return TEXTCENT;
                }
                case TEXTCENT: {
                    return TEXTRIGHT;
                }
                case TEXTRIGHT: {
                    return TEXTLEFT;
                }
                case TEXTBOTLEFT: {
                    return TEXTBOT;
                }
                case TEXTBOT: {
                    return TEXTBOTRIGHT;
                }
                case TEXTBOTRIGHT: {
                    return TEXTBOTLEFT;
                }
                case TEXTTOPLEFT: {
                    return TEXTTOP;
                }
                case TEXTTOP: {
                    return TEXTTOPRIGHT;
                }
                case TEXTTOPRIGHT: {
                    return TEXTTOPLEFT;
                }
            }
            return this;
        }

        public Type cycleTextAnchorVert() {
            switch (this) {
                case TEXTTOPLEFT: {
                    return TEXTLEFT;
                }
                case TEXTLEFT: {
                    return TEXTBOTLEFT;
                }
                case TEXTBOTLEFT: {
                    return TEXTTOPLEFT;
                }
                case TEXTTOP: {
                    return TEXTCENT;
                }
                case TEXTCENT: {
                    return TEXTBOT;
                }
                case TEXTBOT: {
                    return TEXTTOP;
                }
                case TEXTTOPRIGHT: {
                    return TEXTRIGHT;
                }
                case TEXTRIGHT: {
                    return TEXTBOTRIGHT;
                }
                case TEXTBOTRIGHT: {
                    return TEXTTOPRIGHT;
                }
            }
            return this;
        }

        public Type rotateTextAnchorIn(AbstractTextDescriptor.Rotation rot) {
            Type newStyle = this;
            if (rot != AbstractTextDescriptor.Rotation.ROT0) {
                int angle = this.getTextAngle();
                if (rot == AbstractTextDescriptor.Rotation.ROT90) {
                    angle += 2700;
                } else if (rot == AbstractTextDescriptor.Rotation.ROT180) {
                    angle += 1800;
                } else if (rot == AbstractTextDescriptor.Rotation.ROT270) {
                    angle += 900;
                }
                newStyle = Type.getTextTypeFromAngle(angle % 3600);
            }
            return newStyle;
        }

        public Type rotateTextAnchorOut(AbstractTextDescriptor.Rotation rot) {
            Type newStyle = this;
            if (rot != AbstractTextDescriptor.Rotation.ROT0) {
                int angle = this.getTextAngle();
                if (rot == AbstractTextDescriptor.Rotation.ROT90) {
                    angle += 900;
                } else if (rot == AbstractTextDescriptor.Rotation.ROT180) {
                    angle += 1800;
                } else if (rot == AbstractTextDescriptor.Rotation.ROT270) {
                    angle += 2700;
                }
                newStyle = Type.getTextTypeFromAngle(angle % 3600);
            }
            return newStyle;
        }

        public Type mirrorType(boolean horizontal) {
            if (horizontal) {
                switch (this) {
                    case TEXTLEFT: {
                        return TEXTRIGHT;
                    }
                    case TEXTRIGHT: {
                        return TEXTLEFT;
                    }
                    case TEXTBOTLEFT: {
                        return TEXTBOTRIGHT;
                    }
                    case TEXTBOTRIGHT: {
                        return TEXTBOTLEFT;
                    }
                    case TEXTTOPLEFT: {
                        return TEXTTOPRIGHT;
                    }
                    case TEXTTOPRIGHT: {
                        return TEXTTOPLEFT;
                    }
                }
                return this;
            }
            switch (this) {
                case TEXTBOTLEFT: {
                    return TEXTTOPLEFT;
                }
                case TEXTBOT: {
                    return TEXTTOP;
                }
                case TEXTBOTRIGHT: {
                    return TEXTTOPRIGHT;
                }
                case TEXTTOPLEFT: {
                    return TEXTBOTLEFT;
                }
                case TEXTTOP: {
                    return TEXTBOT;
                }
                case TEXTTOPRIGHT: {
                    return TEXTBOTRIGHT;
                }
            }
            return this;
        }

        public Type transformAnchorOfType(AffineTransform af) {
            if (this == TEXTCENT || this == TEXTBOX) {
                return this;
            }
            double m00 = af.getScaleX();
            double m01 = af.getShearX();
            double m11 = af.getScaleY();
            double m10 = af.getShearY();
            Type ret = this;
            boolean mirrorH = false;
            if (m00 < 0.0 & m11 > 0.0 || m00 > 0.0 & m11 < 0.0 || m10 < 0.0 & m01 < 0.0 || m10 > 0.0 & m01 > 0.0) {
                mirrorH = true;
                m00 *= -1.0;
                m01 *= -1.0;
            }
            if (m10 < m01) {
                ret = Type.getTextTypeFromAngle((ret.getTextAngle() + 2700) % 3600);
            } else if (m01 < m10) {
                ret = Type.getTextTypeFromAngle((ret.getTextAngle() + 900) % 3600);
            } else if (m00 < 0.0 && m11 < 0.0) {
                ret = Type.getTextTypeFromAngle((ret.getTextAngle() + 1800) % 3600);
            }
            if (mirrorH) {
                ret = ret.mirrorType(true);
            }
            return ret;
        }

        public Type transformAnchorOfType(Orientation orient) {
            if (this == TEXTCENT || this == TEXTBOX) {
                return this;
            }
            Type ret = this;
            ret = Type.getTextTypeFromAngle((ret.getTextAngle() + orient.getAngle()) % 3600);
            if (orient.isXMirrored()) {
                ret = ret.mirrorType(true);
            }
            if (orient.isYMirrored()) {
                ret = ret.mirrorType(false);
            }
            return ret;
        }
    }

    public static class Builder
    extends AbstractShapeBuilder {
        private boolean isChanging;
        private final ArrayList<Poly> lastPolys = new ArrayList();

        private Builder(boolean rotateNodes) {
            super(rotateNodes);
        }

        public Iterator<Poly> getShape(NodeInst ni) {
            this.isChanging = true;
            this.setup(ni.getCellBackup(), null, false, true, false, null);
            this.lastPolys.clear();
            ((PrimitiveNode)ni.getProto()).genShape(this, ni.getD());
            this.isChanging = false;
            return this.lastPolys.iterator();
        }

        public Poly[] getShapeArray(NodeInst ni, boolean electrical, boolean reasonable, Layer.Function.Set onlyTheseLayers) {
            this.isChanging = true;
            this.setup(ni.getCellBackup(), null, electrical, !electrical, reasonable, onlyTheseLayers);
            this.lastPolys.clear();
            ((PrimitiveNode)ni.getProto()).genShape(this, ni.getD());
            if (this.lastPolys.isEmpty()) {
                this.isChanging = false;
                return NULL_ARRAY;
            }
            Poly[] polys = this.lastPolys.toArray(new Poly[this.lastPolys.size()]);
            this.isChanging = false;
            return polys;
        }

        public Poly getShape(NodeInst ni, PrimitivePort pp) {
            this.isChanging = true;
            this.setup((TechPool)null);
            this.lastPolys.clear();
            this.genShapeOfPort(ni.getD(), pp);
            assert (this.lastPolys.size() == 1);
            Poly poly = this.lastPolys.get(0);
            this.isChanging = false;
            poly.setLayer(null);
            return poly;
        }

        public Poly getShape(ImmutableNodeInst n, PrimitivePort pp) {
            this.isChanging = true;
            this.setup((TechPool)null);
            this.lastPolys.clear();
            this.genShapeOfPort(n, pp);
            assert (this.lastPolys.size() == 1);
            Poly poly = this.lastPolys.get(0);
            this.isChanging = false;
            poly.setLayer(null);
            return poly;
        }

        public Poly getShape(CellTree cellTree, ImmutableNodeInst n, PrimitivePort pp, Point2D selectPt) {
            this.isChanging = true;
            this.setup(cellTree, null, false, true, false, null);
            this.lastPolys.clear();
            this.genShapeOfPort(n, pp, selectPt);
            assert (this.lastPolys.size() == 1);
            Poly poly = this.lastPolys.get(0);
            this.isChanging = false;
            poly.setLayer(null);
            return poly;
        }

        public Iterator<Poly> getShape(ArcInst ai) {
            this.isChanging = true;
            this.setup(ai.getParent());
            this.lastPolys.clear();
            this.genShapeOfArc(ai.getD());
            this.isChanging = false;
            return this.lastPolys.iterator();
        }

        public Poly[] getShapeArray(ArcInst ai, Layer.Function.Set onlyTheseLayers) {
            this.isChanging = true;
            this.setup(ai.getParent().backup(), null, false, true, false, onlyTheseLayers);
            this.lastPolys.clear();
            this.genShapeOfArc(ai.getD());
            if (this.lastPolys.isEmpty()) {
                this.isChanging = false;
                return NULL_ARRAY;
            }
            Poly[] polys = this.lastPolys.toArray(new Poly[this.lastPolys.size()]);
            this.isChanging = false;
            return polys;
        }

        public Poly makePoly(ImmutableArcInst a, long gridWidth, Type style) {
            this.isChanging = true;
            this.lastPolys.clear();
            this.getTechPool().getArcProto(a.protoId).makeGridPoly(this, a, gridWidth, style, null, null);
            this.isChanging = false;
            if (this.lastPolys.isEmpty()) {
                return null;
            }
            Poly poly = this.lastPolys.get(0);
            return poly;
        }

        @Override
        public void addPoly(int numPoints, Type style, Layer layer, EGraphics graphicsOverride, PrimitivePort pp) {
            assert (this.isChanging);
            PolyBase.Point[] points = new PolyBase.Point[numPoints];
            for (int i = 0; i < numPoints; ++i) {
                points[i] = PolyBase.fromFixp(this.coords[i * 2], this.coords[i * 2 + 1]);
            }
            Poly poly = new Poly(points);
            poly.setStyle(style);
            poly.setLayer(layer);
            poly.setGraphicsOverride(graphicsOverride);
            poly.setPort(pp);
            this.lastPolys.add(poly);
        }

        @Override
        public void addTextPoly(int numPoints, Type style, Layer layer, PrimitivePort pp, String message, TextDescriptor descriptor) {
            assert (this.isChanging);
            PolyBase.Point[] points = new PolyBase.Point[numPoints];
            for (int i = 0; i < numPoints; ++i) {
                points[i] = PolyBase.fromFixp(this.coords[i * 2], this.coords[i * 2 + 1]);
            }
            Poly poly = new Poly(points);
            poly.setStyle(style);
            poly.setLayer(layer);
            poly.setPort(pp);
            poly.setString(message);
            poly.setTextDescriptor(descriptor);
            this.lastPolys.add(poly);
        }

        @Override
        public void addBox(Layer layer) {
            assert (this.isChanging);
            long xl = this.coords[0];
            long yl = this.coords[1];
            long xh = this.coords[2];
            long yh = this.coords[3];
            Poly poly = new Poly(PolyBase.fromFixp(xl, yl), PolyBase.fromFixp(xh, yl), PolyBase.fromFixp(xh, yh), PolyBase.fromFixp(xl, yh));
            poly.setStyle(Type.FILLED);
            poly.setLayer(layer);
            this.lastPolys.add(poly);
        }
    }
}

