/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.CellUsageInfo;
import com.sun.electric.database.EquivPorts;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.technology.TechPool;
import com.sun.electric.util.collections.ImmutableArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class CellTree {
    public static final CellTree[] NULL_ARRAY = new CellTree[0];
    public static final ImmutableArrayList<CellTree> EMPTY_LIST = ImmutableArrayList.of(new CellTree[0]);
    public final CellBackup top;
    final CellTree[] subTrees;
    public final TechPool techPool;
    public final Set<CellId> allCells;
    private ERectangle bounds;
    private EquivPorts equivPorts;

    private CellTree(CellBackup top, CellTree[] subTrees, TechPool techPool, Set<CellId> allCells) {
        this.top = top;
        this.subTrees = subTrees;
        this.techPool = techPool;
        this.allCells = allCells;
    }

    public static CellTree newInst(ImmutableCell d, TechPool techPool) {
        CellBackup top = CellBackup.newInst(d, techPool);
        assert (top.cellRevision.cellUsages.length == 0);
        return new CellTree(top, NULL_ARRAY, top.techPool, Collections.singleton(top.cellRevision.d.cellId));
    }

    public CellTree with(CellBackup top, CellTree[] subTrees, TechPool superPool) {
        if (Arrays.equals(this.subTrees, subTrees)) {
            subTrees = this.subTrees;
        } else {
            int l;
            subTrees = (CellTree[])subTrees.clone();
            for (l = subTrees.length; l > 0 && subTrees[l - 1] == null; --l) {
            }
            if (l == 0) {
                subTrees = NULL_ARRAY;
            } else if (l != subTrees.length) {
                CellTree[] newSubTrees = null;
                if (l == this.subTrees.length) {
                    newSubTrees = this.subTrees;
                    for (int i = 0; i < l; ++i) {
                        if (newSubTrees[i] == subTrees[i]) continue;
                        newSubTrees = null;
                        break;
                    }
                }
                if (newSubTrees == null) {
                    newSubTrees = new CellTree[l];
                    System.arraycopy(subTrees, 0, newSubTrees, 0, l);
                }
                subTrees = newSubTrees;
            }
        }
        if (this.top == top && this.subTrees == subTrees) {
            return this;
        }
        CellRevision cellRevision = top.cellRevision;
        CellId cellId = cellRevision.d.cellId;
        BitSet techUsages = new BitSet();
        if (top.techPool != superPool.restrict(cellRevision.techUsages, top.techPool)) {
            throw new IllegalArgumentException();
        }
        techUsages.or(cellRevision.techUsages);
        HashSet<CellId> allCellsAccum = new HashSet<CellId>();
        for (int i = 0; i < cellRevision.cellUsages.length; ++i) {
            CellUsageInfo cui = cellRevision.cellUsages[i];
            CellTree subTree = subTrees[i];
            if (cui == null) {
                if (subTree == null) continue;
                throw new IllegalArgumentException();
            }
            BitSet subTechUsages = subTree.techPool.getTechUsages();
            if (subTree.techPool != superPool.restrict(subTechUsages, subTree.techPool)) {
                throw new IllegalArgumentException();
            }
            techUsages.or(subTechUsages);
            allCellsAccum.addAll(subTree.allCells);
            CellRevision subCellRevision = subTree.top.cellRevision;
            if (subCellRevision.d.cellId != cellId.getUsageIn((int)i).protoId) {
                throw new IllegalArgumentException();
            }
            cui.checkUsage(subCellRevision);
        }
        if (allCellsAccum.contains(cellId)) {
            throw new IllegalArgumentException("Recursive " + cellId);
        }
        allCellsAccum.add(cellId);
        Set<CellId> allCells = allCellsAccum.equals(this.allCells) ? this.allCells : (allCellsAccum.size() == 1 ? Collections.singleton(cellId) : Collections.unmodifiableSet(allCellsAccum));
        assert (allCellsAccum.equals(allCells));
        TechPool techPool = superPool.restrict(techUsages, this.techPool);
        CellTree newCellTree = new CellTree(top, subTrees, techPool, allCells);
        if (this.top == top) {
            CellTree oldSubTree;
            if (this.bounds != null) {
                assert (newCellTree.subTrees.length == this.subTrees.length);
                ERectangle cellBounds = this.bounds;
                for (int i = 0; i < this.subTrees.length; ++i) {
                    oldSubTree = this.subTrees[i];
                    if (oldSubTree == null) continue;
                    assert (oldSubTree.bounds != null);
                    if (newCellTree.subTrees[i].getBounds().equals(oldSubTree.bounds)) continue;
                    cellBounds = null;
                    break;
                }
                if (cellBounds != null) {
                    newCellTree.bounds = cellBounds;
                }
            }
            if (this.equivPorts != null) {
                assert (newCellTree.subTrees.length == this.subTrees.length);
                EquivPorts netCell = this.equivPorts;
                for (int i = 0; i < this.subTrees.length; ++i) {
                    oldSubTree = this.subTrees[i];
                    if (oldSubTree == null) continue;
                    assert (oldSubTree.equivPorts != null);
                    if (newCellTree.subTrees[i].getEquivPorts().equalsPorts(oldSubTree.equivPorts)) continue;
                    netCell = null;
                    break;
                }
                if (netCell != null) {
                    newCellTree.equivPorts = netCell;
                }
            }
        }
        return newCellTree;
    }

    public boolean sameNetlist(CellTree that) {
        if (this.top != that.top) {
            return false;
        }
        for (int i = 0; i < this.subTrees.length; ++i) {
            CellTree thisSubTree = this.subTrees[i];
            if (thisSubTree == null || this.subTrees[i].getEquivPorts().equalsPorts(that.subTrees[i].getEquivPorts())) continue;
            return false;
        }
        return true;
    }

    public CellTree[] getSubTrees() {
        return (CellTree[])this.subTrees.clone();
    }

    public CellTree getSubTree(CellId cellId) {
        CellUsage cu = this.top.cellRevision.d.cellId.getUsageIn(cellId);
        return this.subTrees[cu.indexInParent];
    }

    public ERectangle getBounds() {
        if (this.bounds == null) {
            this.bounds = this.computeBounds(null);
        }
        return this.bounds;
    }

    private ERectangle computeBounds(ERectangle candidateBounds) {
        long gridMaxY;
        long gridMaxX;
        long gridMinY;
        long gridMinX;
        CellRevision cellRevision = this.top.cellRevision;
        IdentityHashMap<CellId, ERectangle> subCellBounds = new IdentityHashMap<CellId, ERectangle>(cellRevision.cellUsages.length);
        for (CellTree subTree : this.subTrees) {
            if (subTree == null) continue;
            subCellBounds.put(subTree.top.cellRevision.d.cellId, subTree.getBounds());
        }
        long fixpMinX = Long.MAX_VALUE;
        long fixpMinY = Long.MAX_VALUE;
        long fixpMaxX = Long.MIN_VALUE;
        long fixpMaxY = Long.MIN_VALUE;
        long[] fixpCoord = new long[4];
        for (ImmutableNodeInst n : this.top.cellRevision.nodes) {
            if (!(n.protoId instanceof CellId)) continue;
            ERectangle b = (ERectangle)subCellBounds.get((CellId)n.protoId);
            fixpCoord[0] = b.getFixpMinX();
            fixpCoord[1] = b.getFixpMinY();
            fixpCoord[2] = b.getFixpMaxX();
            fixpCoord[3] = b.getFixpMaxY();
            n.orient.rectangleBounds(fixpCoord);
            long fixpAnchorX = n.anchor.getFixpX();
            long fixpAnchorY = n.anchor.getFixpY();
            fixpMinX = Math.min(fixpMinX, fixpAnchorX + fixpCoord[0]);
            fixpMinY = Math.min(fixpMinY, fixpAnchorY + fixpCoord[1]);
            fixpMaxX = Math.max(fixpMaxX, fixpAnchorX + fixpCoord[2]);
            fixpMaxY = Math.max(fixpMaxY, fixpAnchorY + fixpCoord[3]);
        }
        ERectangle primitiveBounds = this.top.getPrimitiveBounds();
        if (fixpMinX <= fixpMaxX) {
            gridMinX = fixpMinX >> 20;
            gridMinY = fixpMinY >> 20;
            gridMaxX = fixpMaxX + 20L >> 20;
            gridMaxY = fixpMaxY + 20L >> 20;
            if (primitiveBounds != null) {
                gridMinX = Math.min(gridMinX, primitiveBounds.getGridMinX());
                gridMinY = Math.min(gridMinY, primitiveBounds.getGridMinY());
                gridMaxX = Math.max(gridMaxX, primitiveBounds.getGridMaxX());
                gridMaxY = Math.max(gridMaxY, primitiveBounds.getGridMaxY());
            }
        } else if (primitiveBounds != null) {
            gridMinX = primitiveBounds.getGridMinX();
            gridMinY = primitiveBounds.getGridMinY();
            gridMaxX = primitiveBounds.getGridMaxX();
            gridMaxY = primitiveBounds.getGridMaxY();
        } else {
            gridMaxY = 0L;
            gridMaxX = 0L;
            gridMinY = 0L;
            gridMinX = 0L;
        }
        if (candidateBounds != null && gridMinX == candidateBounds.getGridMinX() && gridMinY == candidateBounds.getGridMinY() && gridMaxX == candidateBounds.getGridMaxX() && gridMaxY == candidateBounds.getGridMaxY()) {
            return candidateBounds;
        }
        return ERectangle.fromGrid(gridMinX, gridMinY, gridMaxX - gridMinX, gridMaxY - gridMinY);
    }

    public ERectangle getElibBounds(Map<CellId, ERectangle> elibBoundsCache) {
        ERectangle elibBounds = elibBoundsCache.get(this.top.cellRevision.d.cellId);
        if (elibBounds != null) {
            return elibBounds;
        }
        CellRevision cellRevision = this.top.cellRevision;
        IdentityHashMap<CellId, ERectangle> subCellBounds = new IdentityHashMap<CellId, ERectangle>(cellRevision.cellUsages.length);
        for (CellTree subTree : this.subTrees) {
            if (subTree == null) continue;
            subCellBounds.put(subTree.top.cellRevision.d.cellId, subTree.getElibBounds(elibBoundsCache));
        }
        long gridMinX = Long.MAX_VALUE;
        long gridMinY = Long.MAX_VALUE;
        long gridMaxX = Long.MIN_VALUE;
        long gridMaxY = Long.MIN_VALUE;
        long[] gridCoords = new long[4];
        for (ImmutableNodeInst n : this.top.cellRevision.nodes) {
            if (!(n.protoId instanceof CellId)) continue;
            ERectangle b = (ERectangle)subCellBounds.get((CellId)n.protoId);
            gridCoords[0] = b.getGridMinX();
            gridCoords[1] = b.getGridMinY();
            gridCoords[2] = b.getGridMaxX();
            gridCoords[3] = b.getGridMaxY();
            n.orient.rectangleBounds(gridCoords);
            long gridAnchorX = n.anchor.getGridX();
            long gridAnchorY = n.anchor.getGridY();
            gridMinX = Math.min(gridMinX, gridAnchorX + gridCoords[0]);
            gridMinY = Math.min(gridMinY, gridAnchorY + gridCoords[1]);
            gridMaxX = Math.max(gridMaxX, gridAnchorX + gridCoords[2]);
            gridMaxY = Math.max(gridMaxY, gridAnchorY + gridCoords[3]);
        }
        ERectangle elibPrimitiveBounds = this.top.getElibPrimitiveBounds();
        if (gridMinX > gridMaxX || gridMinY > gridMaxY) {
            return elibPrimitiveBounds;
        }
        if (elibPrimitiveBounds != null) {
            gridMinX = Math.min(gridMinX, elibPrimitiveBounds.getGridMinX());
            gridMaxX = Math.max(gridMaxX, elibPrimitiveBounds.getGridMaxX());
            gridMinY = Math.min(gridMinY, elibPrimitiveBounds.getGridMinY());
            gridMaxY = Math.max(gridMaxY, elibPrimitiveBounds.getGridMaxY());
        }
        elibBounds = ERectangle.fromGrid(gridMinX, gridMinY, gridMaxX - gridMinX, gridMaxY - gridMinY);
        elibBoundsCache.put(this.top.cellRevision.d.cellId, elibBounds);
        return elibBounds;
    }

    public EquivPorts getEquivPorts() {
        if (this.equivPorts == null) {
            this.equivPorts = new EquivPorts(this);
        }
        return this.equivPorts;
    }

    public EquivPorts computeEquivPorts() {
        return new EquivPorts(this);
    }

    public void check() {
        this.top.check();
        CellId cellId = this.top.cellRevision.d.cellId;
        BitSet techUsages = new BitSet();
        techUsages.or(this.top.cellRevision.techUsages);
        assert (this.subTrees.length == this.top.cellRevision.cellUsages.length);
        HashSet<CellId> allCells = new HashSet<CellId>();
        for (int i = 0; i < this.subTrees.length; ++i) {
            CellTree subTree = this.subTrees[i];
            CellUsageInfo cui = this.top.cellRevision.cellUsages[i];
            if (cui == null) {
                assert (subTree == null);
                continue;
            }
            CellRevision subCellRevision = subTree.top.cellRevision;
            CellUsage cu = cellId.getUsageIn(i);
            assert (subCellRevision.d.cellId == cu.protoId);
            cui.checkUsage(subCellRevision);
            BitSet subTechUsage = subTree.techPool.getTechUsages();
            assert (subTree.techPool == this.techPool.restrict(subTechUsage, subTree.techPool));
            techUsages.or(subTechUsage);
            allCells.addAll(subTree.allCells);
        }
        assert (this.top.techPool == this.techPool.restrict(this.top.cellRevision.techUsages, this.top.techPool));
        assert (techUsages.equals(this.techPool.getTechUsages()));
        assert (!allCells.contains(cellId));
        allCells.add(cellId);
        assert (allCells.equals(this.allCells));
        if (this.bounds != null) assert (this.bounds == this.computeBounds(this.bounds));
    }

    public String toString() {
        return this.top.toString();
    }
}

