/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.svex.funs;

import com.sun.electric.tool.simulation.acl2.svex.BigIntegerUtil;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexFunction;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.tool.simulation.acl2.svex.SvexQuote;
import com.sun.electric.tool.simulation.acl2.svex.Vec2;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import com.sun.electric.tool.simulation.acl2.svex.funs.FunctionSyms;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Concat;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Rsh;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;

public class Vec4RevBlocks<N extends SvarName>
extends SvexCall<N> {
    public static final Function FUNCTION = new Function();
    public final Svex<N> width;
    public final Svex<N> bsz;
    public final Svex<N> x;

    private Vec4RevBlocks(Svex<N> width, Svex<N> bsz, Svex<N> x) {
        super(FUNCTION, width, bsz, x);
        this.width = width;
        this.bsz = bsz;
        this.x = x;
    }

    @Override
    public Svex<N> lhsPreproc(SvexManager<N> sm) {
        if (this.width instanceof SvexQuote && this.bsz instanceof SvexQuote) {
            Vec4 wval = ((SvexQuote)this.width).val;
            Vec4 bval = ((SvexQuote)this.bsz).val;
            if (wval.isVec2() && bval.isVec2()) {
                int wv = ((Vec2)wval).getVal().intValueExact();
                int bv = ((Vec2)wval).getVal().intValueExact();
                if (wv >= 0 && bv > 0) {
                    int nbits;
                    Svex zero = SvexQuote.valueOf(0);
                    ArrayList<SvexCall<N>> stackX = new ArrayList<SvexCall<N>>();
                    SvexCall<N> x = this.x;
                    for (nbits = wv; nbits >= bv; nbits -= bv) {
                        stackX.add(x);
                        x = sm.newCall(Vec4Rsh.FUNCTION, this.bsz, x);
                    }
                    SvexCall<N> rest = sm.newCall(Vec4Concat.FUNCTION, SvexQuote.valueOf(nbits), x, zero);
                    while (!stackX.isEmpty()) {
                        x = (SvexCall<N>)stackX.remove(stackX.size() - 1);
                        x = sm.newCall(Vec4Concat.FUNCTION, this.bsz, x, zero);
                        rest = sm.newCall(Vec4Concat.FUNCTION, SvexQuote.valueOf(nbits += bv), rest, x);
                    }
                    return rest;
                }
            }
        }
        return super.lhsPreproc(sm);
    }

    public static class Function
    extends SvexFunction {
        private Function() {
            super(FunctionSyms.SV_BLKREV, 3, "4vec-rev-blocks");
        }

        public <N extends SvarName> Vec4RevBlocks<N> build(Svex<N>[] args) {
            return new Vec4RevBlocks<N>(args[0], args[1], args[2]);
        }

        @Override
        public Vec4 apply(Vec4 ... args) {
            Vec4 nbits = args[0];
            Vec4 blocksz = args[1];
            Vec4 x = args[1];
            if (nbits.isVec2() && blocksz.isVec2()) {
                int nbitsVal = ((Vec2)nbits).getVal().intValueExact();
                int blockszVal = ((Vec2)nbits).getVal().intValueExact();
                if (nbitsVal >= 0 && blockszVal > 0) {
                    return Vec4.valueOf(this.revBlocks(nbitsVal, blockszVal, x.getUpper()), this.revBlocks(nbitsVal, blockszVal, x.getLower()));
                }
            }
            return Vec4.X;
        }

        private BigInteger revBlocks(int nbits, int blocksz, BigInteger x) {
            BigInteger mask = BigIntegerUtil.logheadMask(blocksz);
            BigInteger result = BigInteger.ZERO;
            while (nbits >= blocksz) {
                result = result.shiftLeft(blocksz).or(x.and(mask));
                x = x.shiftRight(blocksz);
                nbits -= blocksz;
            }
            if (nbits > 0) {
                mask = BigInteger.ONE.shiftLeft(nbits).subtract(BigInteger.ONE);
                result = result.shiftLeft(nbits).or(x.and(mask));
            }
            return result;
        }

        @Override
        protected <N extends SvarName> BigInteger[] svmaskFor(BigInteger mask, Svex<N>[] args, Map<Svex<N>, Vec4> xevalMemoize) {
            if (mask.signum() == 0) {
                return new BigInteger[]{BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO};
            }
            Svex<N> n = args[0];
            Svex<N> b = args[1];
            Vec4 nVal = n.xeval(xevalMemoize);
            Vec4 bVal = b.xeval(xevalMemoize);
            if (nVal.isVec2() && bVal.isVec2()) {
                int nv = ((Vec2)nVal).getVal().intValueExact();
                int bv = ((Vec2)bVal).getVal().intValueExact();
                if (nv >= 0 && bv > 0) {
                    return new BigInteger[]{BigIntegerUtil.MINUS_ONE, BigIntegerUtil.MINUS_ONE, this.unrevBlocks(this.arity, bv, mask)};
                }
            }
            return new BigInteger[]{BigIntegerUtil.MINUS_ONE, BigIntegerUtil.MINUS_ONE, BigIntegerUtil.MINUS_ONE};
        }

        private BigInteger unrevBlocks(int nbits, int blcksz, BigInteger x) {
            BigInteger result = BigIntegerUtil.loghead(nbits % blcksz, x);
            for (int n = nbits / blcksz; n >= 0; --n) {
                result = BigIntegerUtil.logapp(blcksz, BigIntegerUtil.loghead(blcksz, x), result);
                x = x.shiftRight(blcksz);
            }
            return result;
        }
    }
}

