/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.util.ClientOS;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import javax.swing.KeyStroke;

public class KeyStrokePair {
    private KeyStroke prefixStroke;
    private KeyStroke stroke;
    private static HashMap<KeyStrokePair, KeyStrokePair> cache = new HashMap();
    private static final String sep = ", ";
    private static int[] specialKeyStrokes = new int[]{150, 155, 36, 33, 127, 35, 34, 45, 61, 8, 91, 93, 47, 92, 59, 222, 10, 46, 44, 47, 62, 60, 192, 37, 39, 38, 40};

    private KeyStrokePair() {
    }

    public static KeyStrokePair getKeyStrokePair(KeyStroke prefixStroke, KeyStroke stroke) {
        return KeyStrokePair.getCachedKeyStrokePair(prefixStroke, stroke);
    }

    public static KeyStrokePair getKeyStrokePair(String keyString) {
        KeyStroke prefixStroke = null;
        KeyStroke stroke = null;
        String[] strokes = keyString.split(sep);
        if (strokes.length == 1) {
            stroke = KeyStrokePair.stringToKeyStroke(strokes[0]);
            return KeyStrokePair.getCachedKeyStrokePair(prefixStroke, stroke);
        }
        if (strokes.length == 2) {
            prefixStroke = KeyStrokePair.stringToKeyStroke(strokes[0]);
            stroke = KeyStrokePair.stringToKeyStroke(strokes[1]);
            return KeyStrokePair.getCachedKeyStrokePair(prefixStroke, stroke);
        }
        return null;
    }

    public String toString() {
        if (this.stroke == null) {
            return "";
        }
        if (this.prefixStroke == null) {
            return KeyStrokePair.keyStrokeToString(this.stroke);
        }
        return KeyStrokePair.keyStrokeToString(this.prefixStroke) + sep + KeyStrokePair.keyStrokeToString(this.stroke);
    }

    public static String getStringFromKeyStroke(KeyStroke key) {
        String id = "";
        id = key.getKeyCode() == 0 ? String.valueOf(key.getKeyChar()) : KeyEvent.getKeyText(key.getKeyCode());
        return id;
    }

    public static String keyStrokeToString(KeyStroke key) {
        if (key == null) {
            return "";
        }
        String mods = KeyEvent.getModifiersExText(key.getModifiers());
        String id = KeyStrokePair.getStringFromKeyStroke(key);
        if (mods.equals("")) {
            return id;
        }
        mods = mods.replace('+', ' ');
        mods = mods.toLowerCase();
        return mods + " " + id;
    }

    public static KeyStroke stringToKeyStroke(String str) {
        if ((str = str.replaceAll("NumPad\\-", "NUMPAD")).length() > 0 && ClientOS.isOSMac()) {
            KeyStroke key;
            char ctl = '\u2303';
            char command = '\u2318';
            char shift = '\u21e7';
            boolean hasCtl = false;
            boolean hasCmd = false;
            boolean hasShift = false;
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (!hasCtl && c == ctl) {
                    hasCtl = true;
                }
                if (!hasCmd && c == command) {
                    hasCmd = true;
                }
                if (!hasShift && c == shift) {
                    hasShift = true;
                }
                if (hasCtl && hasCmd && hasShift) break;
            }
            if (hasCtl) {
                str = str.replace(ctl, ' ');
            }
            if (hasCmd) {
                str = str.replace(command, ' ');
            }
            if (hasShift) {
                str = str.replace(shift, ' ');
            }
            if ((key = KeyStroke.getKeyStroke(str = str.trim())) != null) {
                int val = key.getModifiers();
                if (hasCtl) {
                    val |= 0x80;
                }
                if (hasShift) {
                    val |= 0x40;
                }
                if (hasCmd) {
                    val |= 0x100;
                }
                key = KeyStroke.getKeyStroke(key.getKeyCode(), val);
                return key;
            }
        }
        if (str.matches(".*?command.*")) {
            str = str.replaceAll("command", "");
            str = str.trim();
            KeyStroke key = KeyStroke.getKeyStroke(str);
            int command_mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
            if (key != null) {
                key = KeyStroke.getKeyStroke(key.getKeyCode(), key.getModifiers() | command_mask);
                return key;
            }
            return null;
        }
        KeyStroke key = KeyStroke.getKeyStroke(str);
        if (key == null) {
            for (int i = 0; i < specialKeyStrokes.length; ++i) {
                KeyStroke k = KeyStroke.getKeyStroke(specialKeyStrokes[i], 0);
                if (str.equals(KeyStrokePair.keyStrokeToString(k))) {
                    key = k;
                    break;
                }
                k = KeyStroke.getKeyStroke(specialKeyStrokes[i], 64);
                if (str.equals(KeyStrokePair.keyStrokeToString(k))) {
                    key = k;
                    break;
                }
                k = KeyStroke.getKeyStroke(specialKeyStrokes[i], 128);
                if (str.equals(KeyStrokePair.keyStrokeToString(k))) {
                    key = k;
                    break;
                }
                k = KeyStroke.getKeyStroke(specialKeyStrokes[i], 256);
                if (str.equals(KeyStrokePair.keyStrokeToString(k))) {
                    key = k;
                    break;
                }
                k = KeyStroke.getKeyStroke(specialKeyStrokes[i], 512);
                if (!str.equals(KeyStrokePair.keyStrokeToString(k))) continue;
                key = k;
                break;
            }
        }
        return key;
    }

    public KeyStroke getPrefixStroke() {
        return this.prefixStroke;
    }

    public KeyStroke getStroke() {
        return this.stroke;
    }

    public int hashCode() {
        int prefixCode = this.prefixStroke == null ? 0 : this.prefixStroke.hashCode();
        int strokeCode = this.stroke == null ? 0 : this.stroke.hashCode();
        return (prefixCode + 1) * strokeCode;
    }

    private static KeyStrokePair getCachedKeyStrokePair(KeyStroke prefixStroke, KeyStroke stroke) {
        if (prefixStroke == null && stroke == null) {
            return null;
        }
        KeyStrokePair k = new KeyStrokePair();
        k.prefixStroke = prefixStroke;
        k.stroke = stroke;
        if (!cache.containsKey(k)) {
            cache.put(k, k);
        } else {
            k = cache.get(k);
        }
        return k;
    }
}

