import QtQuick
import QtQuick.Controls
import QtQuick.Studio.Components 1.0
import QtQuick.Shapes 1.0
import QtQuick.Studio.DesignEffects 1.0

Rectangle {
    id: dialBlack
    width: 98
    height: 100
    color: "transparent"

    ArcItem {
        id: dialBottom
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.bottomMargin: 0
        strokeWidth: 0
        strokeStyle: 0
        strokeColor: "transparent"
        outlineArc: true
        fillColor: "#313131"
        end: 450.00001
        DesignEffect {
            id: dialBottom_DesignEffect
            visible: true
            effects: [
                DesignDropShadow {
                    id: dialBottom_DesignDropShadow_0
                    visible: true
                    color: "#47000000"
                    spread: 0
                    offsetY: 4
                    offsetX: 2
                    blur: 4
                },
                DesignInnerShadow {
                    id: dialBottom_DesignInnerShadow_1
                    visible: true
                    color: "#94ffffff"
                    spread: 0
                    offsetY: 2
                    offsetX: 1
                    blur: 3
                }
            ]
        }
        begin: 90
        arcWidth: 49
        antialiasing: true
    }

    ArcItem {
        id: dialTop
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 25
        anchors.rightMargin: 24
        anchors.topMargin: 25
        anchors.bottomMargin: 25
        strokeWidth: 0
        strokeStyle: 0
        strokeColor: "transparent"
        outlineArc: true
        fillColor: "#2b2b2b"
        end: 450.00001
        DesignEffect {
            id: dialTop_DesignEffect
            visible: true
            effects: [
                DesignDropShadow {
                    id: dialTop_DesignDropShadow_0
                    visible: true
                    color: "#59000000"
                    spread: 0
                    offsetY: 28
                    offsetX: 18
                    blur: 18.3
                },
                DesignDropShadow {
                    id: dialTop_DesignDropShadow_1
                    visible: true
                    color: "#61525252"
                    spread: 0
                    offsetY: 1
                    offsetX: 1
                    blur: 2
                },
                DesignInnerShadow {
                    id: dialTop_DesignInnerShadow_2
                    visible: true
                    color: "#6b000000"
                    spread: 0
                    offsetY: -2
                    offsetX: -1
                    blur: 2
                },
                DesignInnerShadow {
                    id: dialTop_DesignInnerShadow_3
                    visible: true
                    color: "#99ffffff"
                    spread: 0
                    offsetY: 2
                    offsetX: 2
                    blur: 2
                }
            ]
        }
        begin: 90
        arcWidth: 24.5
        antialiasing: true
    }
}

/*##^##
Designer {
    D{i:0;uuid:"d2e2c9dc-62e3-5d35-abd9-d5e05051925e"}D{i:1;uuid:"65546802-3a87-5dc7-b46a-5a6f71a71b50"}
D{i:2;uuid:"65546802-3a87-5dc7-b46a-5a6f71a71b50_DesignEffect"}D{i:3;uuid:"65546802-3a87-5dc7-b46a-5a6f71a71b50_DesignDropShadow_0"}
D{i:4;uuid:"65546802-3a87-5dc7-b46a-5a6f71a71b50_DesignInnerShadow_1"}D{i:5;uuid:"8bae4964-1c8c-5f32-9d0b-805c03c02524"}
D{i:6;uuid:"8bae4964-1c8c-5f32-9d0b-805c03c02524_DesignEffect"}D{i:7;uuid:"8bae4964-1c8c-5f32-9d0b-805c03c02524_DesignDropShadow_0"}
D{i:8;uuid:"8bae4964-1c8c-5f32-9d0b-805c03c02524_DesignDropShadow_1"}D{i:9;uuid:"8bae4964-1c8c-5f32-9d0b-805c03c02524_DesignInnerShadow_2"}
D{i:10;uuid:"8bae4964-1c8c-5f32-9d0b-805c03c02524_DesignInnerShadow_3"}
}
##^##*/

