import QtQuick
import QtQuick.Controls
import QtQuick.Studio.DesignEffects 1.0

Rectangle {
    id: neuSearchBar
    width: 398
    height: 81
    color: "transparent"
    property alias searchtextText: searchtext.text
    state: "v_longSquare"

    Rectangle {
        id: bigBack
        color: "#e5eaee"
        radius: 15
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.topMargin: 1
        DesignEffect {
            id: bigBack_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 1
            effects: [
                DesignDropShadow {
                    id: bigBack_DesignDropShadow_0
                    visible: true
                    color: "#40e18383"
                    spread: 0
                    offsetY: -1
                    offsetX: 0
                    blur: 12
                },
                DesignDropShadow {
                    id: bigBack_DesignDropShadow_1
                    visible: true
                    color: "#ffffffff"
                    spread: 0
                    offsetY: -4
                    offsetX: -4
                    blur: 7
                },
                DesignDropShadow {
                    id: bigBack_DesignDropShadow_2
                    visible: true
                    color: "#2b100f2e"
                    spread: 0
                    offsetY: 6
                    offsetX: 3
                    blur: 8
                }
            ]
        }
    }

    Rectangle {
        id: smallBack
        visible: false
        color: "#e5eaee"
        radius: 15
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 318
        anchors.bottomMargin: 1
        DesignEffect {
            id: smallBack_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 1
            effects: [
                DesignDropShadow {
                    id: smallBack_DesignDropShadow_0
                    visible: true
                    color: "#40e18383"
                    spread: 0
                    offsetY: -1
                    offsetX: 0
                    blur: 12
                },
                DesignDropShadow {
                    id: smallBack_DesignDropShadow_1
                    visible: true
                    color: "#ffffffff"
                    spread: 0
                    offsetY: -4
                    offsetX: -4
                    blur: 7
                },
                DesignDropShadow {
                    id: smallBack_DesignDropShadow_2
                    visible: true
                    color: "#2b100f2e"
                    spread: 0
                    offsetY: 6
                    offsetX: 3
                    blur: 8
                }
            ]
        }
    }

    Text {
        id: searchtext
        color: "#848893"
        text: qsTr("Search...")
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 26
        anchors.rightMargin: 99
        anchors.topMargin: 1
        font.pixelSize: 18
        horizontalAlignment: Text.AlignLeft
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.Wrap
        font.weight: Font.Normal
        font.family: "Inter"
    }

    SearchIcon {
        id: searchIcon
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 349
        anchors.rightMargin: 28
        anchors.topMargin: 30
        anchors.bottomMargin: 29
    }
    states: [
        State {
            name: "v_shortRound"

            PropertyChanges {
                target: bigBack
                radius: 45
                anchors.rightMargin: 106
            }

            PropertyChanges {
                target: smallBack
                visible: true
                radius: 45
            }
        },
        State {
            name: "v_longRound"

            PropertyChanges {
                target: bigBack
                radius: 45
            }

            PropertyChanges {
                target: smallBack
                visible: false
                radius: 15
            }
        },
        State {
            name: "v_shortSquare"

            PropertyChanges {
                target: bigBack
                radius: 15
                anchors.rightMargin: 106
            }

            PropertyChanges {
                target: smallBack
                visible: true
                radius: 15
            }
        },
        State {
            name: "v_longSquare"

            PropertyChanges {
                target: bigBack
                radius: 15
            }

            PropertyChanges {
                target: smallBack
                visible: false
                radius: 15
            }
        }
    ]
}

/*##^##
Designer {
    D{i:0;uuid:"e0c024a5-f771-564b-b447-701af720d7c7"}D{i:1;uuid:"13aaeb10-d1ea-5068-bcd2-95ec4ac1ee7c"}
D{i:2;uuid:"13aaeb10-d1ea-5068-bcd2-95ec4ac1ee7c_DesignEffect"}D{i:3;uuid:"13aaeb10-d1ea-5068-bcd2-95ec4ac1ee7c_DesignDropShadow_0"}
D{i:4;uuid:"13aaeb10-d1ea-5068-bcd2-95ec4ac1ee7c_DesignDropShadow_1"}D{i:5;uuid:"13aaeb10-d1ea-5068-bcd2-95ec4ac1ee7c_DesignDropShadow_2"}
D{i:6;uuid:"f3562d46-a009-519c-8a66-aadb73e7d87f"}D{i:7;uuid:"f3562d46-a009-519c-8a66-aadb73e7d87f_DesignEffect"}
D{i:8;uuid:"f3562d46-a009-519c-8a66-aadb73e7d87f_DesignDropShadow_0"}D{i:9;uuid:"f3562d46-a009-519c-8a66-aadb73e7d87f_DesignDropShadow_1"}
D{i:10;uuid:"f3562d46-a009-519c-8a66-aadb73e7d87f_DesignDropShadow_2"}D{i:11;uuid:"3eda56a3-80ba-5a1f-a4a5-48519e8145d6"}
D{i:12;uuid:"fb8b3a9d-e186-5a77-8ea8-a537cb6738cd"}
}
##^##*/

