import QtQuick
import QtQuick.Controls
import QtQuick.Studio.Components 1.0
import QtQuick.Shapes 1.0
import QtQuick.Studio.DesignEffects 1.0

Rectangle {
    id: skeuoDial
    width: 250
    height: 250
    color: "transparent"

    ArcItem {
        id: under
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        strokeWidth: 0
        strokeStyle: 0
        strokeColor: "transparent"
        outlineArc: true
        gradient: LinearGradient {
            id: under_LinearGradient
            y2: 250
            y1: 0
            x2: 125
            x1: 125
            GradientStop {
                id: under_GradientStop_0
                position: 0
                color: "#ff8e8e8e"
            }

            GradientStop {
                id: under_GradientStop_1
                position: 1
                color: "#ffafafaf"
            }
        }
        end: 450.00001
        DesignEffect {
            id: under_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 1
            effects: [
                DesignInnerShadow {
                    id: under_DesignInnerShadow_0
                    visible: true
                    color: "#99ffffff"
                    spread: 0
                    offsetY: 0
                    offsetX: -1
                    blur: 2
                },
                DesignInnerShadow {
                    id: under_DesignInnerShadow_1
                    visible: true
                    color: "#33262626"
                    spread: 0
                    offsetY: 10
                    offsetX: 0
                    blur: 7
                }
            ]
        }
        begin: 90
        arcWidth: 125
        antialiasing: true
    }

    ArcItem {
        id: outer
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 21
        anchors.rightMargin: 20
        anchors.topMargin: 20
        anchors.bottomMargin: 21
        strokeWidth: 1
        strokeStyle: 1
        strokeColor: "#333333"
        outlineArc: true
        fillColor: "#505050"
        end: 450.00001
        DesignEffect {
            id: outer_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 1
            effects: [
                DesignInnerShadow {
                    id: outer_DesignInnerShadow_0
                    visible: true
                    color: "#ff0b0b0b"
                    spread: 0
                    offsetY: 1
                    offsetX: 0
                    blur: 1
                }
            ]
        }
        begin: 90
        arcWidth: 104.5
        antialiasing: true
    }

    ArcItem {
        id: inner
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 30
        anchors.rightMargin: 29
        anchors.topMargin: 29
        anchors.bottomMargin: 30
        strokeWidth: 1
        strokeStyle: 1
        strokeColor: "#4d8a8a8a"
        outlineArc: true
        gradient: LinearGradient {
            id: inner_LinearGradient
            y2: 191
            y1: 0
            x2: 96
            x1: 96
            GradientStop {
                id: inner_GradientStop_0
                position: 0
                color: "#ff383335"
            }

            GradientStop {
                id: inner_GradientStop_1
                position: 1
                color: "#ff7c7c7c"
            }
        }
        end: 450.00001
        DesignEffect {
            id: inner_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 1
            effects: [
                DesignInnerShadow {
                    id: inner_DesignInnerShadow_0
                    visible: true
                    color: "#e5c3c3c3"
                    spread: 0
                    offsetY: 0
                    offsetX: 0
                    blur: 4
                },
                DesignDropShadow {
                    id: inner_DesignDropShadow_1
                    visible: true
                    color: "#80000000"
                    spread: 0
                    offsetY: 55
                    offsetX: 0
                    blur: 26
                },
                DesignInnerShadow {
                    id: inner_DesignInnerShadow_2
                    visible: true
                    color: "#66373737"
                    spread: 0
                    offsetY: 14
                    offsetX: 2
                    blur: 6
                },
                DesignInnerShadow {
                    id: inner_DesignInnerShadow_3
                    visible: true
                    color: "#40848484"
                    spread: 0
                    offsetY: -30
                    offsetX: 0
                    blur: 11
                }
            ]
        }
        begin: 90
        arcWidth: 95.5
        antialiasing: true
    }

    Rectangle {
        id: handle
        color: "#00ffe3"
        radius: 8
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 121
        anchors.rightMargin: 120
        anchors.topMargin: 41
        anchors.bottomMargin: 179
        rotation: -180
        DesignEffect {
            id: handle_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 1
            effects: [
                DesignDropShadow {
                    id: handle_DesignDropShadow_0
                    visible: true
                    color: "#8c0ef7d4"
                    spread: 0
                    offsetY: 0
                    offsetX: 0
                    blur: 5
                },
                DesignInnerShadow {
                    id: handle_DesignInnerShadow_1
                    visible: true
                    color: "#ffffffff"
                    spread: 0
                    offsetY: 0
                    offsetX: 0
                    blur: 3
                }
            ]
        }
    }
}

/*##^##
Designer {
    D{i:0;uuid:"a33c7053-c46e-5e59-a42c-c0caab9c98ad"}D{i:1;uuid:"e47361b3-b24e-56a5-b5f9-758e5fae5e61"}
D{i:5;uuid:"e47361b3-b24e-56a5-b5f9-758e5fae5e61_DesignEffect"}D{i:6;uuid:"e47361b3-b24e-56a5-b5f9-758e5fae5e61_DesignInnerShadow_0"}
D{i:7;uuid:"e47361b3-b24e-56a5-b5f9-758e5fae5e61_DesignInnerShadow_1"}D{i:2;uuid:"e47361b3-b24e-56a5-b5f9-758e5fae5e61_LinearGradient"}
D{i:3;uuid:"e47361b3-b24e-56a5-b5f9-758e5fae5e61_GradientStop_0"}D{i:4;uuid:"e47361b3-b24e-56a5-b5f9-758e5fae5e61_GradientStop_1"}
D{i:8;uuid:"a68c18df-1e01-5ea9-a86c-c9c332d04993"}D{i:9;uuid:"a68c18df-1e01-5ea9-a86c-c9c332d04993_DesignEffect"}
D{i:10;uuid:"a68c18df-1e01-5ea9-a86c-c9c332d04993_DesignInnerShadow_0"}D{i:11;uuid:"26232122-7f35-52f8-962b-c4f8b29210a5"}
D{i:15;uuid:"26232122-7f35-52f8-962b-c4f8b29210a5_DesignEffect"}D{i:16;uuid:"26232122-7f35-52f8-962b-c4f8b29210a5_DesignInnerShadow_0"}
D{i:17;uuid:"26232122-7f35-52f8-962b-c4f8b29210a5_DesignDropShadow_1"}D{i:18;uuid:"26232122-7f35-52f8-962b-c4f8b29210a5_DesignInnerShadow_2"}
D{i:19;uuid:"26232122-7f35-52f8-962b-c4f8b29210a5_DesignInnerShadow_3"}D{i:12;uuid:"26232122-7f35-52f8-962b-c4f8b29210a5_LinearGradient"}
D{i:13;uuid:"26232122-7f35-52f8-962b-c4f8b29210a5_GradientStop_0"}D{i:14;uuid:"26232122-7f35-52f8-962b-c4f8b29210a5_GradientStop_1"}
D{i:20;uuid:"226527e7-516e-5e8f-ab36-c4588585e9af"}D{i:21;uuid:"226527e7-516e-5e8f-ab36-c4588585e9af_DesignEffect"}
D{i:22;uuid:"226527e7-516e-5e8f-ab36-c4588585e9af_DesignDropShadow_0"}D{i:23;uuid:"226527e7-516e-5e8f-ab36-c4588585e9af_DesignInnerShadow_1"}
}
##^##*/

