import QtQuick
import QtQuick.Controls
import QtQuick.Templates as T
import QtQuick.Studio.DesignEffects

T.Dial {
    id: root
    width: 100
    height: root.width
    property color highlightBack: "#DEDAD7"
    property color highlightFront: "#E9E5E2"
    property color angleIndicatorDot: "#FFFFFF"
    property color shadeTone: "#000000"
    property real shadeFactor: 1
    property real shadowDepth: 1
    property real blurFactor: 1
    property real spreadFactor: 1
    property bool effectsOn: true
    background: dialBack
    handle: emptyHandle

    Rectangle {
        id: dialBack
        color: root.highlightBack
        width: 100
        height: 100
        radius: dialBack.width / 2
        anchors.fill: parent
        DesignEffect {
            id: designEffectDialBack
            visible: root.effectsOn
            layerBlurRadius: 0

            effects: [
                DesignDropShadow {
                    id: designDropShadowDialBack
                    blur: 4 * root.blurFactor
                    offsetX: 2 * root.shadowDepth
                    offsetY: 4 * root.shadowDepth
                    color: "#48000000"
                },

                DesignInnerShadow {
                    id: designInnerShadowDialBack
                    blur: 3 * root.blurFactor
                    offsetX: 1 * root.shadowDepth
                    offsetY: 2 * root.shadowDepth
                    color: "#93ffffff"
                }
            ]
        }
    }

    Rectangle {
        id: dialFront
        x: 25
        y: 25
        width: dialBack.width / 2
        height: dialBack.height / 2
        color: root.highlightFront
        radius: dialBack.width / 2
        anchors.verticalCenter: parent.verticalCenter
        anchors.horizontalCenter: parent.horizontalCenter

        DesignEffect {
            id: designEffectDialFront
            visible: root.effectsOn
            layerBlurRadius: 0

            effects: [
                DesignDropShadow {
                    id: designDropShadowDialFront
                    blur: 18.3 * root.blurFactor
                    offsetX: 18 * root.shadowDepth
                    offsetY: 28 * root.shadowDepth
                    color: "#59000000"
                    spread: 1 * root.spreadFactor
                },

                DesignDropShadow {
                    id: designDropShadowDialFron1
                    blur: 2 * root.blurFactor
                    offsetX: 1 * root.shadowDepth
                    offsetY: 1 * root.shadowDepth
                    color: "#61525252"
                },

                DesignInnerShadow {
                    id: designInnerShadowDialFront
                    blur: 2 * root.blurFactor
                    offsetX: -1 * root.shadowDepth
                    offsetY: -2 * root.shadowDepth
                    color: "#6c000000"
                },

                DesignInnerShadow {
                    id: designInnerShadowDialFront1
                    blur: 2 * root.blurFactor
                    offsetX: 2 * root.shadowDepth
                    offsetY: 2 * root.shadowDepth
                    color: "#9affffff"
                }
            ]
        }
    }

    Rectangle {
        id: emptyHandle
        width: dialFront.width
        height: dialFront.height
        color: "#00ffffff"
        anchors.verticalCenter: parent.verticalCenter
        anchors.horizontalCenter: parent.horizontalCenter
    }

    Item {
        id: rotationPivot
        anchors.fill: parent
        rotation: root.angle

        Rectangle {
            id: angleIndicator
            width: 5
            height: 5
            color: root.angleIndicatorDot
            radius: 10
            anchors.top: parent.top
            anchors.topMargin: 8
            anchors.horizontalCenterOffset: 0
            anchors.horizontalCenter: parent.horizontalCenter
        }
    }

    Rectangle {
        id: hoverPressShade
        opacity: 0
        color: root.shadeTone
        radius: dialBack.radius
        anchors.fill: parent
    }

    states: [
        State {
            name: "idle"
            when: !root.hovered && !root.pressed
        },
        State {
            name: "hover"
            when: root.hovered && !root.pressed

            PropertyChanges {
                target: hoverPressShade
                opacity: 0.05 * root.shadeFactor
            }
        },
        State {
            name: "press"
            when: root.pressed

            PropertyChanges {
                target: hoverPressShade
                opacity: 0.1 * root.shadeFactor
            }
        }
    ]
}
