import QtQuick
import QtQuick.Controls
import QtQuick.Layouts
import QtQuick.Studio.Components
import QtQuick.Studio.DesignEffects
import DesignEffectsDemo

Item {
    id: root
    width: 1032
    height: 1080

    property list<string> numbers: []
    property list<string> inputArray1: []
    property list<string> inputArray2: []
    property string operator: ""
    property real blurFactor: blurDial.value
    property real spreadFactor: spreadDial.value
    property bool effectsOn: effectsSwitch.checked
    property bool isDark: false
    focus: true

    Rectangle {
        id: mainBackground
        color: themeEngine.mainBackground
        anchors.fill: parent
        anchors.leftMargin: 0
        anchors.rightMargin: 0
        anchors.topMargin: 0
        anchors.bottomMargin: 0

        CalcDial {
            id: blurDial
            x: 38
            y: 361
            value: 1
            effectsOn: effectsSwitch.checked
            shadowDepth: shadowDepthControl.value
            stepSize: 0.1
            to: 2
            from: 0
            highlightFront: themeEngine.highButton1
            highlightBack: themeEngine.highButton2
            angleIndicatorDot: themeEngine.angleIndicatorDotHigh
            blurFactor: blurDial.value
            spreadFactor: spreadDial.value

            Connections {
                target: blurDial
                function onValueChanged() {
                    soundBox.source = "../../sounds/roll.wav"
                    soundBox.play()
                }
            }
        }

        ActiveIndicator {
            id: aciveIndicatorBlur
            y: 36
            anchors.bottom: blurDial.top
            anchors.bottomMargin: 10
            isActive: blurDial.pressed
            anchors.horizontalCenter: blurDial.horizontalCenter
        }

        Text {
            id: blurLabel
            color: themeEngine.surfaceText
            text: qsTr("BLUR")
            anchors.top: blurDial.bottom
            anchors.topMargin: 10
            font.pixelSize: 18
            anchors.horizontalCenter: blurDial.horizontalCenter
            font.family: "Victor Mono"
            DesignEffect {
                id: designEffectSL1
                visible: root.effectsOn
                layerBlurRadius: 1.5 * root.blurFactor

                effects: [
                    DesignDropShadow {
                        id: designDropShadowSL1
                        blur: 1 * root.blurFactor
                        offsetX: 0
                        offsetY: 0
                        color: themeEngine.surfaceText
                    }
                ]
            }
        }

        CalcDial {
            id: spreadDial
            x: 723
            y: 361
            value: 2.5
            highlightBack: themeEngine.mainHighlight1
            shadeFactor: 1.5
            stepSize: 0.1
            to: 10
            from: 0
            highlightFront: themeEngine.mainHighlight2
            angleIndicatorDot: themeEngine.angleIndicatorDotTone
            effectsOn: effectsSwitch.checked
            shadowDepth: shadowDepthControl.value
            blurFactor: blurDial.value
            spreadFactor: spreadDial.value
        }

        CalcDial {
            id: volumeDial
            x: 855
            y: 361
            value: 0.5
            stepSize: 0.1
            to: 1
            shadeFactor: 2.5
            //these values don't change so i didn't theme them.
            highlightBack: "#313131"
            highlightFront: "#2b2b2b"
            angleIndicatorDot: "#4E4E4E"
            effectsOn: effectsSwitch.checked
            shadowDepth: shadowDepthControl.value
            blurFactor: blurDial.value
            spreadFactor: spreadDial.value
        }

        CalcButton {
            id: kickButton
            x: 723
            y: 783
            buttonKeyText: "KCK"
            highlightFrontBottom: themeEngine.mainHighlight1
            highlightFrontTop: themeEngine.mainHighlight2
            buttonKeyColor: themeEngine.lowButtonText
            effectsOn: effectsSwitch.checked
            spreadFactor: spreadDial.value
            blurFactor: blurDial.value
            shadowDepth: shadowDepthControl.value

            Connections {
                target: kickButton
                function onPressed() {
                    soundBox.source = "../../sounds/kick.wav"
                    soundBox.play()
                }
                function onReleased() {
                    soundBox.stop()
                }
            }
        }

        CalcButton {
            id: clearButton
            x: 855
            y: 911
            buttonKeyText: "CLR"
            effectsOn: effectsSwitch.checked
            spreadFactor: spreadDial.value
            blurFactor: blurDial.value
            highlightFrontTop: themeEngine.lowButton1
            highlightFrontBottom: themeEngine.lowButton2
            buttonKeyColor: themeEngine.lowButtonText
            shadowDepth: shadowDepthControl.value

            Connections {
                target: clearButton
                function onClicked() {
                    clearHandler.clearCalc()
                }
            }
        }

        ActiveIndicator {
            id: aciveIndicatorTheme
            y: 36
            anchors.bottom: shadowDepthControl.top
            anchors.bottomMargin: 10
            isActive: shadowDepthControl.pressed
            anchors.horizontalCenter: shadowDepthControl.horizontalCenter
        }

        CalcButton {
            id: themeSwitch
            x: 855
            y: 274
            width: 100
            height: 49
            buttonKeyFontpixelSize: 22
            checkable: true
            buttonKeyText: "DARK"
            effectsOn: effectsSwitch.checked
            buttonKeyColor: themeEngine.midButtonText
            highlightFrontBottom: themeEngine.midButton2
            highlightFrontTop: themeEngine.midButton1
            spreadFactor: spreadDial.value
            blurFactor: blurDial.value
            shadowDepth: shadowDepthControl.value

            Connections {
                target: themeSwitch
                function onClicked() {
                    if (chordsSwitch.checked || dubSwitch.checked
                            || techSwitch.checked) {
                        //console.log("before signal")
                        Constants.stopAni()
                        root.isDark = !root.isDark
                        Constants.startAni()
                        //console.log("after signal")
                    } else
                        root.isDark = !root.isDark
                }
            }
        }

        ActiveIndicator {
            id: aciveIndicatorShadow
            y: 36
            anchors.bottom: themeSwitch.top
            anchors.bottomMargin: 10
            isActive: (themeSwitch.pressed || themeSwitch.checked)
            anchors.horizontalCenter: themeSwitch.horizontalCenter
        }

        CalcSlider {
            id: shadowDepthControl
            x: 43
            y: 534
            value: 1
            stepSize: 0.01
            orientation: Qt.Vertical
            to: 1.25
            from: -1
            effectsOn: effectsSwitch.checked
            aSpread: spreadDial.value
            shadowDepth: shadowDepthControl.value
        }

        Text {
            id: blurLabel1
            color: themeEngine.surfaceText
            text: qsTr("SHADOW DIR")
            anchors.top: shadowDepthControl.bottom
            anchors.topMargin: 10
            font.pixelSize: 18
            font.family: "Victor Mono"
            anchors.horizontalCenter: shadowDepthControl.horizontalCenter
            DesignEffect {
                id: designEffectSL2
                visible: root.effectsOn
                layerBlurRadius: 1.5 * root.blurFactor

                effects: [
                    DesignDropShadow {
                        id: designDropShadowSL2
                        blur: 1 * root.blurFactor
                        offsetX: 0
                        offsetY: 0
                        color: themeEngine.surfaceText
                    }
                ]
            }
        }

        RowLayout {
            x: 177
            y: 534
            spacing: 32
            ColumnLayout {
                spacing: 25
                CalcButton {
                    id: percentButton
                    buttonKeyColor: themeEngine.highButtonText
                    buttonKeyText: "%"
                    highlightFrontTop: themeEngine.highButton1
                    highlightFrontBottom: themeEngine.highButton2
                    effectsOn: effectsSwitch.checked
                    spreadFactor: spreadDial.value
                    blurFactor: blurDial.value
                    shadowDepth: shadowDepthControl.value

                    Connections {
                        target: percentButton
                        function onClicked() {
                            opsHandler.sendOps("%")
                        }
                    }
                }

                CalcButton {
                    id: divideButton
                    buttonKeyText: "/"
                    effectsOn: effectsSwitch.checked
                    spreadFactor: spreadDial.value
                    blurFactor: blurDial.value
                    highlightFrontTop: themeEngine.highButton1
                    highlightFrontBottom: themeEngine.highButton2
                    buttonKeyColor: themeEngine.highButtonText
                    shadowDepth: shadowDepthControl.value

                    Connections {
                        target: divideButton
                        function onClicked() {
                            opsHandler.sendOps("/")
                        }
                    }
                }

                CalcButton {
                    id: multButton
                    buttonKeyText: "*"
                    effectsOn: effectsSwitch.checked
                    spreadFactor: spreadDial.value
                    blurFactor: blurDial.value
                    highlightFrontTop: themeEngine.highButton1
                    highlightFrontBottom: themeEngine.highButton2
                    buttonKeyColor: themeEngine.highButtonText
                    shadowDepth: shadowDepthControl.value

                    Connections {
                        target: multButton
                        function onClicked() {
                            opsHandler.sendOps("*")
                        }
                    }
                }

                CalcButton {
                    id: minusButton
                    buttonKeyText: "-"
                    effectsOn: effectsSwitch.checked
                    spreadFactor: spreadDial.value
                    blurFactor: blurDial.value
                    highlightFrontTop: themeEngine.highButton1
                    highlightFrontBottom: themeEngine.highButton2
                    buttonKeyColor: themeEngine.highButtonText
                    shadowDepth: shadowDepthControl.value

                    Connections {
                        target: minusButton
                        function onClicked() {
                            opsHandler.sendOps("-")
                        }
                    }
                }
            }

            ColumnLayout {
                spacing: 25
                CalcButton {
                    id: num1
                    buttonKeyColor: themeEngine.midButtonText
                    highlightFrontBottom: themeEngine.midButton2
                    highlightFrontTop: themeEngine.midButton1
                    buttonKeyText: "1"
                    effectsOn: effectsSwitch.checked
                    spreadFactor: spreadDial.value
                    blurFactor: blurDial.value
                    shadowDepth: shadowDepthControl.value

                    Connections {
                        target: num1
                        function onClicked() {
                            digitHandler.sendDigit(1)
                        }
                    }
                }

                CalcButton {
                    id: num4
                    buttonKeyText: "4"
                    buttonKeyColor: themeEngine.midButtonText
                    highlightFrontBottom: themeEngine.midButton2
                    highlightFrontTop: themeEngine.midButton1
                    effectsOn: effectsSwitch.checked
                    spreadFactor: spreadDial.value
                    blurFactor: blurDial.value
                    shadowDepth: shadowDepthControl.value
                    Connections {
                        target: num4
                        function onClicked() {
                            digitHandler.sendDigit(4)
                        }
                    }
                }

                CalcButton {
                    id: num7
                    buttonKeyText: "7"
                    buttonKeyColor: themeEngine.midButtonText
                    highlightFrontBottom: themeEngine.midButton2
                    highlightFrontTop: themeEngine.midButton1
                    effectsOn: effectsSwitch.checked
                    spreadFactor: spreadDial.value
                    blurFactor: blurDial.value
                    shadowDepth: shadowDepthControl.value
                    Connections {
                        target: num7
                        function onClicked() {
                            digitHandler.sendDigit(7)
                        }
                    }
                }

                CalcButton {
                    id: plusButton
                    buttonKeyText: "+"
                    effectsOn: effectsSwitch.checked
                    spreadFactor: spreadDial.value
                    blurFactor: blurDial.value
                    highlightFrontTop: themeEngine.highButton1
                    highlightFrontBottom: themeEngine.highButton2
                    buttonKeyColor: themeEngine.highButtonText
                    shadowDepth: shadowDepthControl.value
                }
                Connections {
                    target: plusButton
                    function onClicked() {
                        opsHandler.sendOps("+")
                    }
                }
            }

            ColumnLayout {
                spacing: 25
                CalcButton {
                    id: num2
                    buttonKeyText: "2"
                    buttonKeyColor: themeEngine.midButtonText
                    highlightFrontBottom: themeEngine.midButton2
                    highlightFrontTop: themeEngine.midButton1
                    effectsOn: effectsSwitch.checked
                    spreadFactor: spreadDial.value
                    blurFactor: blurDial.value
                    shadowDepth: shadowDepthControl.value
                    Connections {
                        target: num2
                        function onClicked() {
                            digitHandler.sendDigit(2)
                        }
                    }
                }

                CalcButton {
                    id: num5
                    buttonKeyText: "5"
                    buttonKeyColor: themeEngine.midButtonText
                    highlightFrontBottom: themeEngine.midButton2
                    highlightFrontTop: themeEngine.midButton1
                    effectsOn: effectsSwitch.checked
                    spreadFactor: spreadDial.value
                    blurFactor: blurDial.value
                    shadowDepth: shadowDepthControl.value
                    Connections {
                        target: num5
                        function onClicked() {
                            digitHandler.sendDigit(5)
                        }
                    }
                }

                CalcButton {
                    id: num8
                    buttonKeyText: "8"
                    buttonKeyColor: themeEngine.midButtonText
                    highlightFrontBottom: themeEngine.midButton2
                    highlightFrontTop: themeEngine.midButton1
                    effectsOn: effectsSwitch.checked
                    spreadFactor: spreadDial.value
                    blurFactor: blurDial.value
                    shadowDepth: shadowDepthControl.value
                    Connections {
                        target: num8
                        function onClicked() {
                            digitHandler.sendDigit(8)
                        }
                    }
                }

                CalcButton {
                    id: num0
                    buttonKeyText: "0"
                    effectsOn: effectsSwitch.checked
                    highlightFrontTop: themeEngine.highButton1
                    highlightFrontBottom: themeEngine.highButton2
                    buttonKeyColor: themeEngine.highButtonText
                    spreadFactor: spreadDial.value
                    blurFactor: blurDial.value
                    shadowDepth: shadowDepthControl.value

                    Connections {
                        target: num0
                        function onClicked() {
                            digitHandler.sendDigit(0)
                        }
                    }
                }
            }

            ColumnLayout {
                spacing: 25
                CalcButton {
                    id: num3
                    buttonKeyText: "3"
                    buttonKeyColor: themeEngine.midButtonText
                    highlightFrontBottom: themeEngine.midButton2
                    highlightFrontTop: themeEngine.midButton1
                    effectsOn: effectsSwitch.checked
                    spreadFactor: spreadDial.value
                    blurFactor: blurDial.value
                    shadowDepth: shadowDepthControl.value
                    Connections {
                        target: num3
                        function onClicked() {
                            digitHandler.sendDigit(3)
                        }
                    }
                }

                CalcButton {
                    id: num6
                    buttonKeyText: "6"
                    buttonKeyColor: themeEngine.midButtonText
                    highlightFrontBottom: themeEngine.midButton2
                    highlightFrontTop: themeEngine.midButton1
                    effectsOn: effectsSwitch.checked
                    spreadFactor: spreadDial.value
                    blurFactor: blurDial.value
                    shadowDepth: shadowDepthControl.value
                    Connections {
                        target: num6
                        function onClicked() {
                            digitHandler.sendDigit(6)
                        }
                    }
                }

                CalcButton {
                    id: num9
                    buttonKeyText: "9"
                    buttonKeyColor: themeEngine.midButtonText
                    highlightFrontBottom: themeEngine.midButton2
                    highlightFrontTop: themeEngine.midButton1
                    effectsOn: effectsSwitch.checked
                    spreadFactor: spreadDial.value
                    blurFactor: blurDial.value
                    shadowDepth: shadowDepthControl.value
                    Connections {
                        target: num9
                        function onClicked() {
                            digitHandler.sendDigit(9)
                        }
                    }
                }

                CalcButton {
                    id: happy
                    buttonKeyText: ":)"
                    effectsOn: effectsSwitch.checked
                    spreadFactor: spreadDial.value
                    blurFactor: blurDial.value
                    highlightFrontTop: themeEngine.highButton1
                    highlightFrontBottom: themeEngine.highButton2
                    buttonKeyColor: themeEngine.highButtonText
                    shadowDepth: shadowDepthControl.value

                    Connections {
                        target: happy
                        function onClicked() {
                            soundBox.source = "../../sounds/laugh.wav"
                            soundBox.play()
                            console.log("happy says be happy")
                        }
                    }
                }
            }
        }

        CalcButton {
            id: sumButton
            x: 723
            y: 911
            buttonKeyText: "="
            effectsOn: effectsSwitch.checked
            spreadFactor: spreadDial.value
            blurFactor: blurDial.value
            highlightFrontTop: themeEngine.mainHighlight2
            highlightFrontBottom: themeEngine.mainHighlight1
            buttonKeyColor: themeEngine.lowButtonText
            shadowDepth: shadowDepthControl.value

            Connections {
                target: sumButton
                function onClicked() {
                    sumHandler.sumTotal()
                }
            }
        }

        CalcButton {
            id: wompButton
            x: 855
            y: 783
            buttonKeyText: "WMP"
            effectsOn: effectsSwitch.checked
            spreadFactor: spreadDial.value
            blurFactor: blurDial.value
            highlightFrontTop: themeEngine.lowButton1
            highlightFrontBottom: themeEngine.lowButton2
            buttonKeyColor: themeEngine.lowButtonText
            shadowDepth: shadowDepthControl.value

            Connections {
                target: wompButton
                function onPressed() {
                    soundBox.source = "../../sounds/wompus.wav"
                    soundBox.play()
                }

                function onReleased() {
                    soundBox.stop()
                }
            }
        }

        ActiveIndicator {
            id: aciveIndicatorFX
            y: 36
            anchors.bottom: effectsSwitch.top
            anchors.bottomMargin: 10
            isActive: effectsSwitch.pressed || effectsSwitch.checked
            anchors.horizontalCenter: effectsSwitch.horizontalCenter
        }

        CalcButton {
            id: effectsSwitch
            x: 723
            y: 274
            width: 100
            height: 49
            checked: true
            effectsOn: effectsSwitch.checked
            checkable: true
            buttonKeyText: "FX"
            buttonKeyFontpixelSize: 22
            buttonKeyColor: themeEngine.midButtonText
            highlightFrontBottom: themeEngine.midButton2
            highlightFrontTop: themeEngine.midButton1
            spreadFactor: spreadDial.value
            blurFactor: blurDial.value
            shadowDepth: shadowDepthControl.value
        }

        CalcButton {
            id: muteSwitch
            x: 723
            y: 536
            width: 100
            height: 49
            checkable: true
            checked: true
            buttonKeyText: "MUTE"
            buttonKeyFontpixelSize: 22
            effectsOn: effectsSwitch.checked
            spreadFactor: spreadDial.value
            blurFactor: blurDial.value
            shadowDepth: shadowDepthControl.value
            buttonKeyColor: themeEngine.highButtonText
            highlightFrontBottom: themeEngine.highButton2
            highlightFrontTop: themeEngine.highButton1
        }

        ActiveIndicator {
            id: aciveIndicatorSobel
            y: 36
            visible: false
            anchors.bottom: sobelSwitch.top
            anchors.bottomMargin: 10
            isActive: sobelSwitch.pressed || sobelSwitch.checked
            anchors.horizontalCenter: sobelSwitch.horizontalCenter
        }

        CalcButton {
            id: orthoSwitch
            x: 855
            y: 536
            width: 100
            height: 49
            visible: false
            checkable: true
            buttonKeyText: "ORTHO"
            buttonKeyFontpixelSize: 22
            effectsOn: effectsSwitch.checked
            spreadFactor: spreadDial.value
            blurFactor: blurDial.value
            highlightFrontTop: themeEngine.lowButton1
            highlightFrontBottom: themeEngine.lowButton2
            buttonKeyColor: themeEngine.lowButtonText
            shadowDepth: shadowDepthControl.value
        }

        CalcButton {
            id: chordsSwitch
            x: 855
            y: 536
            width: 100
            height: 49
            checkable: true
            buttonKeyText: "CHRD"
            buttonKeyFontpixelSize: 22
            effectsOn: effectsSwitch.checked
            spreadFactor: spreadDial.value
            blurFactor: blurDial.value
            highlightFrontTop: themeEngine.lowButton1
            highlightFrontBottom: themeEngine.lowButton2
            buttonKeyColor: themeEngine.lowButtonText
            shadowDepth: shadowDepthControl.value

            Connections {
                target: chordsSwitch
                function onToggled() {
                    if (chordsSwitch.checked) {
                        dubSwitch.checked = false
                        techSwitch.checked = false
                        musicBox.source = "../../sounds/chords.wav"
                        musicBox.play()
                    } else if (!chordsSwitch.checked) {
                        musicBox.stop()
                    }
                }
            }
        }

        ActiveIndicator {
            id: aciveIndicatorOrtho
            y: 36
            visible: false
            anchors.bottom: orthoSwitch.top
            anchors.bottomMargin: 10
            isActive: orthoSwitch.pressed || orthoSwitch.checked
            anchors.horizontalCenter: orthoSwitch.horizontalCenter
        }

        CalcButton {
            id: sobelSwitch
            x: 723
            y: 536
            width: 100
            height: 49
            visible: false
            highlightFrontTop: themeEngine.highButton1
            highlightFrontBottom: themeEngine.highButton2
            effectsOn: effectsSwitch.checked
            spreadFactor: spreadDial.value
            blurFactor: blurDial.value
            checkable: true
            buttonKeyText: "SOBEL"
            buttonKeyFontpixelSize: 22
            buttonKeyColor: themeEngine.highButtonText
            shadowDepth: shadowDepthControl.value
        }

        Text {
            id: spreadLabel
            color: themeEngine.surfaceText
            text: qsTr("SPREAD")
            anchors.top: spreadDial.bottom
            anchors.topMargin: 10
            font.pixelSize: 18
            font.family: "Victor Mono"
            anchors.horizontalCenter: spreadDial.horizontalCenter
            DesignEffect {
                id: designEffectSL3
                visible: root.effectsOn
                layerBlurRadius: 1.5 * root.blurFactor

                effects: [
                    DesignDropShadow {
                        id: designDropShadowSL3
                        blur: 1 * root.blurFactor
                        offsetX: 0
                        offsetY: 0
                        color: themeEngine.surfaceText
                    }
                ]
            }
        }

        ActiveIndicator {
            id: aciveIndicatorSpread
            y: 36
            anchors.bottom: volumeDial.top
            anchors.bottomMargin: 10
            isActive: volumeDial.pressed
            anchors.horizontalCenter: volumeDial.horizontalCenter
        }

        STOIC {
            id: stoic
            x: 195
            y: 240
            effectsOn: effectsSwitch.checked
            blurFactor: blurDial.value
            dark: themeSwitch.checked
        }

        Text {
            id: volumeLabel
            color: themeEngine.surfaceText
            text: qsTr("VOLUME")
            anchors.top: volumeDial.bottom
            anchors.topMargin: 10
            font.pixelSize: 18
            anchors.horizontalCenter: volumeDial.horizontalCenter
            font.family: "Victor Mono"
            DesignEffect {
                id: designEffectSL4
                visible: root.effectsOn
                layerBlurRadius: 1.5 * root.blurFactor
                effects: [
                    DesignDropShadow {
                        id: designDropShadowSL4
                        offsetY: 0
                        blur: 1 * root.blurFactor
                        offsetX: 0
                        color: themeEngine.surfaceText
                    }
                ]
            }
        }

        ActiveIndicator {
            id: aciveIndicatorMute
            y: 36
            anchors.bottom: muteSwitch.top
            anchors.bottomMargin: 10
            isActive: muteSwitch.pressed || muteSwitch.checked
            anchors.horizontalCenter: muteSwitch.horizontalCenter
        }

        ActiveIndicator {
            id: aciveIndicatorChord
            y: 36
            anchors.bottom: chordsSwitch.top
            anchors.bottomMargin: 10
            isActive: chordsSwitch.pressed || chordsSwitch.checked
            anchors.horizontalCenter: chordsSwitch.horizontalCenter
        }

        ActiveIndicator {
            id: aciveIndicatorVolume
            y: 36
            anchors.bottom: spreadDial.top
            anchors.bottomMargin: 10
            isActive: spreadDial.pressed
            anchors.horizontalCenter: spreadDial.horizontalCenter
        }

        CalcButton {
            id: dubSwitch
            x: 855
            y: 657
            width: 100
            height: 49
            spreadFactor: spreadDial.value
            highlightFrontTop: themeEngine.lowButton1
            highlightFrontBottom: themeEngine.lowButton2
            effectsOn: effectsSwitch.checked
            checkable: true
            buttonKeyText: "DUB"
            buttonKeyFontpixelSize: 22
            buttonKeyColor: themeEngine.lowButtonText
            blurFactor: blurDial.value
            shadowDepth: shadowDepthControl.value

            Connections {
                target: dubSwitch
                function onToggled() {
                    if (dubSwitch.checked) {
                        chordsSwitch.checked = false
                        techSwitch.checked = false
                        musicBox.source = "../../sounds/dubwob.wav"
                        musicBox.play()
                    } else if (!dubSwitch.checked) {
                        musicBox.stop()
                    }
                }
            }
        }

        ActiveIndicator {
            id: aciveIndicatorDub
            y: 36
            anchors.bottom: dubSwitch.top
            anchors.bottomMargin: 10
            isActive: dubSwitch.pressed || dubSwitch.checked
            anchors.horizontalCenter: dubSwitch.horizontalCenter
        }

        CalcButton {
            id: techSwitch
            x: 723
            y: 657
            width: 100
            height: 49
            spreadFactor: spreadDial.value
            highlightFrontTop: themeEngine.lowButton1
            highlightFrontBottom: themeEngine.lowButton2
            effectsOn: effectsSwitch.checked
            shadowDepth: shadowDepthControl.value

            Connections {
                target: techSwitch
                function onToggled() {
                    if (techSwitch.checked) {
                        chordsSwitch.checked = false
                        dubSwitch.checked = false
                        musicBox.source = "../../sounds/tech.wav"
                        musicBox.play()
                    } else if (!techSwitch.checked) {
                        musicBox.stop()
                    }
                }
            }
            checkable: true
            buttonKeyText: "TECH"
            buttonKeyFontpixelSize: 22
            buttonKeyColor: themeEngine.lowButtonText
            blurFactor: blurDial.value
        }

        ActiveIndicator {
            id: aciveIndicatorTech
            x: -132
            y: 36
            anchors.bottom: techSwitch.top
            anchors.bottomMargin: 10
            isActive: (techSwitch.pressed || techSwitch.checked)
            anchors.horizontalCenter: techSwitch.horizontalCenter
        }
    }

    Rectangle {
        id: displayPanel
        height: 230
        color: "#000000"
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.leftMargin: 0
        anchors.topMargin: 0

        DesignEffect {
            id: designEffectDisplayPanel
            visible: effectsSwitch.checked
            layerBlurRadius: 1

            effects: [
                DesignDropShadow {
                    id: designDropShadowPanel
                    blur: 10
                    offsetX: 0
                    offsetY: 9
                    color: "#7e000000"
                    spread: 0
                }
            ]
        }
    }

    Glass {
        id: glass
        x: 177
        y: 286
        highlightFront: themeEngine.mainHighlight1
        pulse: (chordsSwitch.checked || dubSwitch.checked || techSwitch.checked)
        timing: 600
        effectsOn: effectsSwitch.checked
    }

    Item {
        id: dialReadouts
        x: 0
        y: 0
        width: 219
        height: 230

        DialReadout {
            id: blurDiaReadout
            x: 36
            y: 5
            progress: blurDial.value * 50
            labelText: "BLUR"
            highlightColor1: themeEngine.mainHighlight1
            readoutLabelColor: "#46a0f9"
            blurFactor: blurDial.value
            effectsOn: effectsSwitch.checked
        }

        DialReadout {
            id: spreadDialReadout
            x: 36
            y: 80
            readoutLabelColor: "#46a0f9"
            progress: spreadDial.value * 10
            labelText: "SPREAD"
            highlightColor1: themeEngine.mainHighlight1
            blurFactor: blurDial.value
            effectsOn: effectsSwitch.checked
        }

        DialReadout {
            id: volumeDialReadout
            x: 36
            y: 153
            readoutLabelColor: "#46a0f9"
            progress: volumeDial.value * 100
            labelText: "VOLUME"
            highlightColor1: themeEngine.mainHighlight1
            blurFactor: blurDial.value
            effectsOn: effectsSwitch.checked
        }
    }

    Row {
        id: segDisplayGhost
        x: 250
        y: 60
        opacity: 0.153

        SevenSegChar {
            id: sevenSegChar1
            highlight: "#fcfcfc"
        }

        SevenSegChar {
            id: sevenSegChar2
            highlight: "#fcfcfc"
        }

        SevenSegChar {
            id: sevenSegChar3
            highlight: "#fcfcfc"
        }

        SevenSegChar {
            id: sevenSegChar4
            highlight: "#fcfcfc"
        }

        SevenSegChar {
            id: sevenSegChar5
            highlight: "#fcfcfc"
        }

        SevenSegChar {
            id: sevenSegChar6
            highlight: "#fcfcfc"
        }

        SevenSegChar {
            id: sevenSegChar7
            highlight: "#fcfcfc"
        }

        SevenSegChar {
            id: sevenSegChar8
            highlight: "#fcfcfc"
        }
    }

    Row {
        id: segmentDisplay
        x: 250
        y: 60
        Repeater {
            id: myrep
            model: root.numbers
            SevenSegChar {
                id: sevenSegChar
                highlight: themeEngine.mainHighlight1
                segState: modelData
                blurFactor: blurDial.value
            }
        }
    }

    Row {
        id: operatorSymbols
        x: 268
        y: 150
        spacing: 10
        Text {
            id: plus
            visible: false
            color: themeEngine.mainHighlight1
            text: "+"
            font.pixelSize: 30
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            DesignEffect {
                id: designEffectDisplayReadoutTheme3
                visible: effectsSwitch.checked
                layerBlurRadius: 2 * root.blurFactor
                effects: [
                    DesignDropShadow {
                        id: designDropShadowReadoutTheme3
                        offsetY: 0
                        blur: 3 * root.blurFactor
                        offsetX: 0
                        color: themeEngine.mainHighlight1
                    }
                ]
            }
        }

        Text {
            id: minus
            visible: minusButton.pressed
            color: themeEngine.mainHighlight1
            text: "-"
            font.pixelSize: 30
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            DesignEffect {
                id: designEffectDisplayReadoutTheme5
                visible: effectsSwitch.checked
                layerBlurRadius: 2 * root.blurFactor
                effects: [
                    DesignDropShadow {
                        id: designDropShadowReadoutTheme5
                        offsetY: 0
                        blur: 3 * root.blurFactor
                        offsetX: 0
                        color: themeEngine.mainHighlight1
                    }
                ]
            }
        }

        Text {
            id: mult
            visible: false
            color: themeEngine.mainHighlight1
            text: "*"
            font.pixelSize: 30
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            DesignEffect {
                id: designEffectDisplayReadoutTheme9
                visible: effectsSwitch.checked
                layerBlurRadius: 2 * root.blurFactor
                effects: [
                    DesignDropShadow {
                        id: designDropShadowReadoutTheme9
                        offsetY: 0
                        blur: 3 * root.blurFactor
                        offsetX: 0
                        color: themeEngine.mainHighlight1
                    }
                ]
            }
        }

        Text {
            id: div
            visible: false
            color: themeEngine.mainHighlight1
            text: "/"
            font.pixelSize: 30
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            DesignEffect {
                id: designEffectDisplayReadoutTheme10
                visible: effectsSwitch.checked
                layerBlurRadius: 2 * root.blurFactor
                effects: [
                    DesignDropShadow {
                        id: designDropShadowReadoutTheme10
                        offsetY: 0
                        blur: 3 * root.blurFactor
                        offsetX: 0
                        color: themeEngine.mainHighlight1
                    }
                ]
            }
        }

        Text {
            id: percent
            visible: false
            color: themeEngine.mainHighlight1
            text: "%"
            font.pixelSize: 30
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            DesignEffect {
                id: designEffectDisplayReadoutTheme11
                visible: effectsSwitch.checked
                layerBlurRadius: 2 * root.blurFactor
                effects: [
                    DesignDropShadow {
                        id: designDropShadowReadoutTheme11
                        offsetY: 0
                        blur: 3 * root.blurFactor
                        offsetX: 0
                        color: themeEngine.mainHighlight1
                    }
                ]
            }
        }
    }

    Item {
        id: calcOpsPanel
        x: 572
        y: 154
        width: 200
        height: 40

        Text {
            id: clear
            x: -64
            visible: false
            color: themeEngine.mainHighlight1
            text: "CLEAR"
            anchors.verticalCenter: parent.verticalCenter
            anchors.right: maxOps.left
            anchors.rightMargin: 10
            font.pixelSize: 18
            DesignEffect {
                id: designEffectDisplayReadoutTheme8
                visible: effectsSwitch.checked
                layerBlurRadius: 2 * root.blurFactor
                effects: [
                    DesignDropShadow {
                        id: designDropShadowReadoutTheme8
                        offsetY: 0
                        blur: 3 * root.blurFactor
                        offsetX: 0
                        color: themeEngine.mainHighlight1
                    }
                ]
            }
        }

        Text {
            id: maxOps
            x: -64
            visible: false
            color: themeEngine.mainHighlight1
            text: "MAX OPS"
            anchors.verticalCenter: parent.verticalCenter
            anchors.right: limit.left
            anchors.rightMargin: 10
            font.pixelSize: 18
            DesignEffect {
                id: designEffectDisplayReadoutTheme7
                visible: effectsSwitch.checked
                layerBlurRadius: 2 * root.blurFactor
                effects: [
                    DesignDropShadow {
                        id: designDropShadowReadoutTheme7
                        offsetY: 0
                        blur: 3 * root.blurFactor
                        offsetX: 0
                        color: themeEngine.mainHighlight1
                    }
                ]
            }
        }

        Text {
            id: limit
            x: -64
            visible: root.numbers.length === 8
            color: themeEngine.mainHighlight1
            text: "LIMIT"
            anchors.verticalCenter: parent.verticalCenter
            anchors.right: parent.right
            font.pixelSize: 18
            DesignEffect {
                id: designEffectDisplayReadoutTheme2
                visible: effectsSwitch.checked
                layerBlurRadius: 2 * root.blurFactor
                effects: [
                    DesignDropShadow {
                        id: designDropShadowReadoutTheme2
                        offsetY: 0
                        blur: 3 * root.blurFactor
                        offsetX: 0
                        color: themeEngine.mainHighlight1
                    }
                ]
            }
        }
    }

    DataReadout {
        id: rightReadout
        x: 832
        y: 0
        effectsOn: effectsSwitch.checked
        blurFactor: blurDial.value
        themeString: themeEngine.themeString
        sobelOn: sobelSwitch.checked
        orthoOn: orthoSwitch.checked
        muted: muteSwitch.checked
        fps: fPS.fps
        fpsA: fPS.fpsAvg
        highlightColor: themeEngine.mainHighlight1
    }

    Item {
        id: functionalComponents

        FPS {
            id: fPS
            x: 863
            y: 192
        }

        ThemeEngine {
            id: themeEngine
            dark: root.isDark
        }

        Calculator {
            id: calculator
        }

        SoundBox {
            id: soundBox
            muted: muteSwitch.checked
            volume: volumeDial.value
        }

        MusicBox {
            id: musicBox
            muted: muteSwitch.checked
            volume: volumeDial.value / 4
        }
    }

    Text {
        id: womplabel
        x: 806
        y: 1035
        opacity: 0.243
        color: themeEngine.surfaceText
        text: qsTr("WOMPULATOR 1.0")
        font.pixelSize: 18
        font.family: "Victor Mono"
        DesignEffect {
            id: designEffectSL5
            visible: root.effectsOn
            layerBlurRadius: 1.5 * root.blurFactor
            effects: [
                DesignDropShadow {
                    id: designDropShadowSL5
                    offsetY: 0
                    blur: 1 * root.blurFactor
                    offsetX: 0
                    color: themeEngine.surfaceText
                }
            ]
        }
    }

    // KEY HANDLER AND CALC INPUT CONNECTIONS
    Connections {
        id: digitHandler
        target: root.Keys

        // main function for sending digits to the seg display
        function sendDigit(digit) {
            let d = digit
            if (root.numbers.length < 8 && clear.visible === false) {
                root.numbers.push(d)
                soundBox.source = "../../sounds/click.wav"
                soundBox.play()
            } else if ((root.numbers.length === 8)
                       || (clear.visible === true)) {
                soundBox.source = "../../sounds/thud.wav"
                soundBox.play()
                return
            }
        }

        //end function

        //key sends
        function onPressed(event) {
            let n
            if (event.key === Qt.Key_1) {
                n = 1
                num1.numPressed = true
                digitHandler.sendDigit(n)
            } else if (event.key === Qt.Key_2) {
                n = 2
                num2.numPressed = true
                digitHandler.sendDigit(n)
            } else if (event.key === Qt.Key_3) {
                n = 3
                num3.numPressed = true
                digitHandler.sendDigit(n)
            } else if (event.key === Qt.Key_4) {
                n = 4
                num4.numPressed = true
                digitHandler.sendDigit(n)
            } else if (event.key === Qt.Key_5) {
                n = 5
                num5.numPressed = true
                digitHandler.sendDigit(n)
            } else if (event.key === Qt.Key_6) {
                n = 6
                num6.numPressed = true
                digitHandler.sendDigit(n)
            } else if (event.key === Qt.Key_7) {
                n = 7
                num7.numPressed = true
                digitHandler.sendDigit(n)
            } else if (event.key === Qt.Key_8) {
                n = 8
                num8.numPressed = true
                digitHandler.sendDigit(n)
            } else if (event.key === Qt.Key_9) {
                n = 9
                num9.numPressed = true
                digitHandler.sendDigit(n)
            } else if (event.key === Qt.Key_0) {
                n = 0
                num0.numPressed = true
                digitHandler.sendDigit(n)
            } else
                return
        }

        function onReleased(event) {
            if (event.key === Qt.Key_1) {
                num1.numPressed = false
            } else if (event.key === Qt.Key_2) {
                num2.numPressed = false
            } else if (event.key === Qt.Key_3) {
                num3.numPressed = false
            } else if (event.key === Qt.Key_4) {
                num4.numPressed = false
            } else if (event.key === Qt.Key_5) {
                num5.numPressed = false
            } else if (event.key === Qt.Key_6) {
                num6.numPressed = false
            } else if (event.key === Qt.Key_7) {
                num7.numPressed = false
            } else if (event.key === Qt.Key_8) {
                num8.numPressed = false
            } else if (event.key === Qt.Key_9) {
                num9.numPressed = false
            } else if (event.key === Qt.Key_0) {
                num0.numPressed = false
            } else
                return
        }
    }

    Connections {
        id: opsHandler
        target: root.Keys

        //function for getting the operator
        function onPressed(event) {
            let o = ""
            if (event.key === Qt.Key_Plus) {
                o = "+"
                plusButton.numPressed = true
                sendOps(o)
            } else if (event.key === Qt.Key_Minus) {
                o = "-"
                minusButton.numPressed = true
                sendOps(o)
            } else if (event.key === Qt.Key_Asterisk) {
                o = "*"
                multButton.numPressed = true
                sendOps(o)
            } else if (event.key === Qt.Key_Slash) {
                o = "/"
                divideButton.numPressed = true
                sendOps(o)
            } else if (event.key === Qt.Key_Percent) {
                o = "%"
                percentButton.numPressed = true
                sendOps(o)
            } else
                return
        }

        function onReleased(event) {
            if (event.key === Qt.Key_Plus)
                plusButton.numPressed = false
            else if (event.key === Qt.Key_Minus)
                minusButton.numPressed = false
            else if (event.key === Qt.Key_Asterisk)
                multButton.numPressed = false
            else if (event.key === Qt.Key_Slash)
                divideButton.numPressed = false
            else if (event.key === Qt.Key_Percent)
                percentButton.numPressed = false
            else
                return
        }

        //main function for sending operations to the main display
        function sendOps(op) {
            if (root.numbers.length !== 0 && root.operator === ""
                    && root.inputArray1.length === 0) {

                maxOps.visible = true

                if (op === "+") {
                    plus.visible = true
                }
                if (op === "-") {
                    minus.visible = true
                }
                if (op === "*") {
                    mult.visible = true
                }
                if (op === "/") {
                    div.visible = true
                }
                if (op === "%") {
                    percent.visible = true
                }

                root.operator = op
                root.inputArray1 = root.numbers
                //console.log("first add " + root.inputArray1)
                root.numbers = []
                //console.log("after reset " + root.inputArray1)
                soundBox.source = "../../sounds/kaching.wav"
                soundBox.play()
            } else {
                soundBox.source = "../../sounds/thud.wav"
                soundBox.play()
                return
            }
        }
        // end function
    }

    Connections {
        id: sumHandler
        target: root.Keys
        function onPressed(event) {
            if (event.key === Qt.Key_Return) {
                sumButton.numPressed = true
                sumHandler.sumTotal()
            } else if (event.key === Qt.Key_Enter) {
                sumButton.numPressed = true
                sumHandler.sumTotal()
            } else
                return
        }

        function onReleased(event) {
            if (event.key === Qt.Key_Return) {
                sumButton.numPressed = false
            } else if (event.key === Qt.Key_Enter) {
                sumButton.numPressed = false
            } else
                return
        }

        // sum function
        function sumTotal() {
            console.log("foo")
            if (root.inputArray1.length !== 0 && root.numbers !== 0
                    && root.operator !== "") {
                //console.log("add this " + root.inputArray1)
                root.inputArray2 = root.numbers
                //console.log("to this " + root.inputArray2)
                root.numbers = calculator.main(root.inputArray1,
                                               root.inputArray2, root.operator)
                //console.log(root.inputArray1 + ' + '
                //           + root.inputArray2 + ' + ' + root.numbers)
                console.log("in if")
                maxOps.visible = false
                plus.visible = false
                minus.visible = false
                mult.visible = false
                div.visible = false
                percent.visible = false
                root.operator = ""
                clear.visible = true
                soundBox.source = "../../sounds/yeah.wav"
                soundBox.play()
            } else {
                soundBox.source = "../../sounds/no.wav"
                soundBox.play()
                return
            }
        }
        //end function
    }

    Connections {
        id: clearHandler
        target: root.Keys
        function onPressed(event) {
            if (event.key === Qt.Key_Backspace) {
                clearButton.numPressed = true
                clearHandler.clearCalc()
            } else if (event.key === Qt.Key_Delete) {
                clearButton.numPressed = true
                clearHandler.clearCalc()
            } else
                return
        }

        function onReleased(event) {
            if (event.key === Qt.Key_Backspace) {
                clearButton.numPressed = false
            } else if (event.key === Qt.Key_Delete) {
                clearButton.numPressed = false
            } else
                return
        }

        //clear display function
        function clearCalc() {
            root.numbers = []
            root.inputArray1 = []
            root.inputArray2 = []
            root.operator = ""
            maxOps.visible = false
            plus.visible = false
            minus.visible = false
            clear.visible = false
            soundBox.source = "../../sounds/swip.wav"
            soundBox.play()
        }
    }
}
