/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Design Studio Material Bundle.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

import QtQuick
import QtQuick3D

CustomMaterial {
    id: carpaint
    property color baseColor: "#3137fd"
    property color secondaryColor: "#035096"
    property real roughness: 0.1
    property real clearcoat: 1
    property real metalness: 0
    property real specular: 0
    property real flakes: 1
    property real vcoloron: 1
    property real opacity: 1
    property TextureInput flakesNormal: flaketexture

    cullMode: Material.NoCulling
    fragmentShader: Qt.resolvedUrl("shaders/carmat_simple_nf.frag")
    vertexShader: Qt.resolvedUrl("shaders/carmat_simple_nf.vert")
    depthDrawMode: Material.AlwaysDepthDraw
    objectName: "Car Paint"

    TextureInput {
        id: flaketexture
        texture: noiseMap
        enabled: true
    }

    Texture {
        id: noiseMap
        source: "images/LDR_RGB1_3.png"
        mipFilter: Texture.None
        magFilter: Texture.None
        scaleV: 10
        generateMipmaps: false
        scaleU: 10
        minFilter: Texture.None
    }
}
