import QtQuick
import QtQuick3D
import QtQuick 2.15
Model {
    property color daycolor: "#666666"
    property color nightcolor: "#969696"
    property color greencolor: "#60da38"
    property bool night: false
    property bool highlight: false
    property bool lkasmode: false

    id: roadLine
    source: "#Rectangle"
    z: 5478.92969
    scale.z: 1
    scale.y: 300
    scale.x: 0.15
    eulerRotation.x: -90
    materials: rectMaterial
    DefaultMaterial {
        id: rectMaterial
        diffuseColor: daycolor
    }
    states: [
        State {
            name: "day"
            when: night == false && lkasmode != true

            PropertyChanges {
                target: rectMaterial
                diffuseColor: daycolor
            }
        },
        State {
            name: "night"
            when: night == true && lkasmode != true

            PropertyChanges {
                target: rectMaterial
                diffuseColor: nightcolor
            }
        },
        State {
            name: "highlight"
            when: highlight == true && lkasmode == true

            PropertyChanges {
                target: rectMaterial
                diffuseColor: greencolor
            }
        }
    ]
    transitions: Transition {
        SequentialAnimation {
            PauseAnimation {
                duration: mainScreen.preventTransitionPause ? 0 : 6800
            }
            ColorAnimation {
                properties: "diffuseColor"
                easing.type: Easing.InOutQuad
                duration: 1200
            }
        }
    }
}
