import QtQuick
import QtQuick.Controls
import QtQuick3D
import QtQuick.Layouts

Rectangle {
    id: demoUI
    property real menuWidth: menu.width
    property real menuphase: 0
    property bool menuOpen: openMenu.checked
    property string demoName: "Demo Name"
    property string category3Icon: "DemoUI/CloseBtn_X.png"
    property string category3Text: "Category 3"
    property string category2Icon: "DemoUI/CloseBtn_X.png"
    property string category2Text: "Category 2"
    property string category1Icon: "DemoUI/CloseBtn_X.png"
    property string category1Text: "Category 1"
    property string selection1: list1.selection
    property string selection2: list2.selection
    property string selection3: list3.selection
    property string mainSelection: "No effect"
    property bool singleElement: true
    property bool altScene: sceneToggle.checked

    anchors.fill: parent
    color: "#00000000"
    border.color: "#00000000"

    Button {
        id: openMenu
        width: 311
        height: 80
        text: qsTr("Open effect library")
        anchors.left: parent.left
        anchors.bottom: parent.bottom
        anchors.leftMargin: 28
        anchors.bottomMargin: 31
        display: AbstractButton.TextOnly
        font.family: "Archivo"
        scale: 1.0 - demoUI.menuphase * 0.5
        opacity: 1 - demoUI.menuphase
        checkable: true
        background: Rectangle {
            color: openMenu.pressed ? "#B8B8B9" : (openMenu.hovered ? "#5C5C5D" : "#222222")
            radius: 8
            border.width: 0
        }

        contentItem: Item {
            Label {
                color: "#ffffff"
                text: openMenu.text
                anchors.left: parent.left
                anchors.verticalCenter: parent.verticalCenter
                font.pixelSize: 20
                verticalAlignment: Text.AlignVCenter
                anchors.leftMargin: 28
            }

            Image {
                anchors.verticalCenter: parent.verticalCenter
                anchors.right: parent.right
                horizontalAlignment: Image.AlignRight
                source: "DemoUI/Arrow.png"
                fillMode: Image.Pad
                anchors.rightMargin: 36
            }
        }

        Connections {
            target: openMenu
            onClicked: menuTransition.start()
        }

        Connections {
            target: openMenu
            onClicked: categories.activeCategory = categories.activeCategory
                       == "" ? "Elements" : categories.activeCategory
        }
    }

    Rectangle {
        id: menu
        width: 636
        color: "#222222"
        opacity: demoUI.menuphase
        anchors.left: parent.left
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: -636 * (1.0 - demoUI.menuphase)

        Text {
            id: text1
            color: "#ffffff"
            text: demoUI.demoName
            anchors.left: parent.left
            anchors.top: parent.top
            font.pixelSize: 30
            anchors.leftMargin: 28
            anchors.topMargin: 32
            font.family: "Archivo"
        }

        RowLayout {
            id: categories
            property string activeCategory: ""

            height: 160
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.top: parent.top
            anchors.topMargin: 100
            anchors.rightMargin: 28
            anchors.leftMargin: 28

            CategoryBtn {
                id: categoryBtn
                width: 188
                height: 160
                checked: categories.activeCategory == demoUI.category1Text
                icon.source: demoUI.category1Icon
                text: demoUI.category1Text

                Connections {
                    target: categoryBtn
                    onClicked: categories.activeCategory = demoUI.category1Text
                }
            }

            CategoryBtn {
                id: categoryBtn1
                width: 188
                height: 160
                checked: categories.activeCategory == demoUI.category2Text
                icon.source: demoUI.category2Icon
                text: demoUI.category2Text

                Connections {
                    target: categoryBtn1
                    onClicked: categories.activeCategory = demoUI.category2Text
                }
            }

            CategoryBtn {
                id: categoryBtn2
                width: 188
                height: 160
                checked: categories.activeCategory == demoUI.category3Text
                icon.source: demoUI.category3Icon
                text: demoUI.category3Text

                Connections {
                    target: categoryBtn2
                    onClicked: categories.activeCategory = demoUI.category3Text
                }
            }
        }

        Button {
            id: closeBtn
            text: qsTr("Button")
            anchors.right: parent.right
            anchors.top: parent.top
            icon.height: 28
            icon.width: 28
            anchors.topMargin: 38
            anchors.rightMargin: 38
            icon.color: "#ffffff"
            icon.source: "DemoUI/CloseBtn_X.png"
            display: AbstractButton.IconOnly
            background: Rectangle {
                opacity: 1
                color: closeBtn.pressed ? "#B8B8B9" : (closeBtn.hovered ? "#5C5C5D" : "#222222")
            }

            Connections {
                target: closeBtn
                onClicked: menuTransition_close.start()
            }
        }

        Item {
            id: group
            anchors.fill: parent
            anchors.rightMargin: 28
            anchors.leftMargin: 28
            anchors.bottomMargin: 0
            anchors.topMargin: 288

            ColumnLayout {
                id: list1
                property string selection: ""

                spacing: 0
                visible: categories.activeCategory == category1Text
                anchors.fill: parent
                anchors.bottomMargin: 224

                SelectionBtn {
                    id: selectionBtn
                    text: "Bubbles"
                    icon.source: "images/BubblesIcon.png"
                    Layout.maximumHeight: 88
                    Layout.maximumWidth: 580
                    Layout.preferredHeight: 88
                    Layout.preferredWidth: 580
                    selection: demoUI.singleElement ? demoUI.mainSelection : list1.selection

                    Connections {
                        target: selectionBtn
                        onClicked: demoUI.singleElement ? demoUI.mainSelection
                                                          = selectionBtn.text : list1.selection
                                                          = selectionBtn.text
                    }
                }

                SelectionBtn {
                    id: selectionBtn1
                    text: "Cloud"
                    icon.source: "images/CloudsIcon.png"
                    Layout.maximumHeight: 88
                    Layout.maximumWidth: 580
                    Layout.preferredHeight: 88
                    Layout.preferredWidth: 580
                    selection: demoUI.singleElement ? demoUI.mainSelection : list1.selection

                    Connections {
                        target: selectionBtn1
                        onClicked: demoUI.singleElement ? demoUI.mainSelection
                                                          = selectionBtn1.text : list1.selection
                                                          = selectionBtn1.text
                    }
                }

                SelectionBtn {
                    id: selectionBtn2
                    text: "Fire"
                    icon.source: "images/FlameIcon.png"
                    Layout.maximumHeight: 88
                    Layout.maximumWidth: 580
                    Layout.preferredHeight: 88
                    Layout.preferredWidth: 580
                    selection: demoUI.singleElement ? demoUI.mainSelection : list1.selection

                    Connections {
                        target: selectionBtn2
                        onClicked: demoUI.singleElement ? demoUI.mainSelection
                                                          = selectionBtn2.text : list1.selection
                                                          = selectionBtn2.text
                    }
                }

                SelectionBtn {
                    id: selectionBtn3
                    text: "Rain"
                    icon.source: "images/RainIcon.png"
                    Layout.maximumHeight: 88
                    Layout.maximumWidth: 580
                    Layout.preferredHeight: 88
                    Layout.preferredWidth: 580
                    selection: demoUI.singleElement ? demoUI.mainSelection : list1.selection
                    Connections {
                        target: selectionBtn3
                        onClicked: demoUI.singleElement ? demoUI.mainSelection
                                                          = selectionBtn3.text : list1.selection
                                                          = selectionBtn3.text
                    }
                }

                SelectionBtn {
                    id: selectionBtn4
                    text: "Smoke"
                    icon.source: "images/SmokeIcon.png"
                    Layout.maximumHeight: 88
                    Layout.maximumWidth: 580
                    Layout.preferredHeight: 88
                    Layout.preferredWidth: 580
                    selection: demoUI.singleElement ? demoUI.mainSelection : list1.selection

                    Connections {
                        target: selectionBtn4
                        onClicked: demoUI.singleElement ? demoUI.mainSelection
                                                          = selectionBtn4.text : list1.selection
                                                          = selectionBtn4.text
                    }
                }

                SelectionBtn {
                    id: selectionBtn5
                    text: "Snow"
                    icon.source: "images/SnowIcon.png"
                    Layout.maximumHeight: 88
                    Layout.maximumWidth: 580
                    Layout.preferredHeight: 88
                    Layout.preferredWidth: 580
                    selection: demoUI.singleElement ? demoUI.mainSelection : list1.selection

                    Connections {
                        target: selectionBtn5
                        onClicked: demoUI.singleElement ? demoUI.mainSelection
                                                          = selectionBtn5.text : list1.selection
                                                          = selectionBtn5.text
                    }
                }
            }

            ColumnLayout {
                id: list2
                property string selection: ""

                anchors.fill: parent
                visible: categories.activeCategory == category2Text
                anchors.bottomMargin: 416

                SelectionBtn {
                    id: selectionBtn_l2
                    text: "Particles"
                    icon.source: "images/ParticleIcon.png"
                    Layout.maximumHeight: 88
                    Layout.maximumWidth: 580
                    Layout.preferredHeight: 88
                    Layout.preferredWidth: 580
                    selection: demoUI.singleElement ? demoUI.mainSelection : list2.selection

                    Connections {
                        target: selectionBtn_l2
                        onClicked: demoUI.singleElement ? demoUI.mainSelection
                                                          = selectionBtn_l2.text : list2.selection
                                                          = selectionBtn_l2.text
                    }
                }

                SelectionBtn {
                    id: selectionBtn1_l2
                    text: "Dust"
                    icon.source: "images/DustIcon.png"
                    Layout.maximumHeight: 88
                    Layout.maximumWidth: 580
                    Layout.preferredHeight: 88
                    Layout.preferredWidth: 580
                    selection: demoUI.singleElement ? demoUI.mainSelection : list2.selection

                    Connections {
                        target: selectionBtn1_l2
                        onClicked: demoUI.singleElement ? demoUI.mainSelection
                                                          = selectionBtn1_l2.text : list2.selection
                                                          = selectionBtn1_l2.text
                    }
                }

                SelectionBtn {
                    id: selectionBtn2_l2
                    text: "Heatwave"
                    icon.source: "images/HeatwaveIcon.png"
                    Layout.maximumHeight: 88
                    Layout.maximumWidth: 580
                    Layout.preferredHeight: 88
                    Layout.preferredWidth: 580
                    selection: demoUI.singleElement ? demoUI.mainSelection : list2.selection

                    Connections {
                        target: selectionBtn2_l2
                        onClicked: demoUI.singleElement ? demoUI.mainSelection
                                                          = selectionBtn2_l2.text : list2.selection
                                                          = selectionBtn2_l2.text
                    }
                }

                SelectionBtn {
                    id: selectionBtn3_l2
                    text: "Steam"
                    icon.source: "images/SteamIcon.png"
                    Layout.maximumHeight: 88
                    Layout.maximumWidth: 580
                    Layout.preferredHeight: 88
                    Layout.preferredWidth: 580
                    selection: demoUI.singleElement ? demoUI.mainSelection : list2.selection

                    Connections {
                        target: selectionBtn3_l2
                        onClicked: demoUI.singleElement ? demoUI.mainSelection
                                                          = selectionBtn3_l2.text : list2.selection
                                                          = selectionBtn3_l2.text
                    }
                }

                SelectionBtn {
                    id: selectionBtn4_l2
                    visible: false
                    text: "Smoke"
                    icon.source: "images/SmokeIcon.png"
                    Layout.maximumHeight: 88
                    Layout.maximumWidth: 580
                    Layout.preferredHeight: 88
                    Layout.preferredWidth: 580
                    selection: demoUI.singleElement ? demoUI.mainSelection : list2.selection

                    Connections {
                        target: selectionBtn4_l2
                        onClicked: demoUI.singleElement ? demoUI.mainSelection
                                                          = selectionBtn4_l2.text : list2.selection
                                                          = selectionBtn4_l2.text
                    }
                }

                SelectionBtn {
                    id: selectionBtn5_l2
                    visible: false
                    text: "Snow"
                    icon.source: "images/SnowIcon.png"
                    Layout.maximumHeight: 88
                    Layout.maximumWidth: 580
                    Layout.preferredHeight: 88
                    Layout.preferredWidth: 580
                    selection: demoUI.singleElement ? demoUI.mainSelection : list2.selection

                    Connections {
                        target: selectionBtn5_l2
                        onClicked: demoUI.singleElement ? demoUI.mainSelection
                                                          = selectionBtn5_l2.text : list2.selection
                                                          = selectionBtn5_l2.text
                    }
                }
            }

            ColumnLayout {
                id: list3
                property string selection: ""

                anchors.fill: parent
                visible: categories.activeCategory == category3Text
                anchors.bottomMargin: 320

                SelectionBtn {
                    id: selectionBtn_l3
                    text: "Explosion"
                    icon.source: "images/ExplosionIcon.png"
                    Layout.maximumHeight: 88
                    Layout.maximumWidth: 580
                    Layout.preferredHeight: 88
                    Layout.preferredWidth: 580
                    selection: demoUI.singleElement ? demoUI.mainSelection : list3.selection

                    Connections {
                        target: selectionBtn_l3
                        onClicked: demoUI.singleElement ? demoUI.mainSelection
                                                          = selectionBtn_l3.text : list3.selection
                                                          = selectionBtn_l3.text
                    }
                }

                SelectionBtn {
                    id: selectionBtn1_l3
                    text: "Flash"
                    icon.source: "images/FlashIcon.png"
                    Layout.maximumHeight: 88
                    Layout.maximumWidth: 580
                    Layout.preferredHeight: 88
                    Layout.preferredWidth: 580
                    selection: demoUI.singleElement ? demoUI.mainSelection : list3.selection

                    Connections {
                        target: selectionBtn1_l3
                        onClicked: demoUI.singleElement ? demoUI.mainSelection
                                                          = selectionBtn1_l3.text : list3.selection
                                                          = selectionBtn1_l3.text
                    }
                }

                SelectionBtn {
                    id: selectionBtn2_l3
                    text: "Light Trails"
                    icon.source: "images/LighttrailIcon.png"
                    Layout.maximumHeight: 88
                    Layout.maximumWidth: 580
                    Layout.preferredHeight: 88
                    Layout.preferredWidth: 580
                    selection: demoUI.singleElement ? demoUI.mainSelection : list3.selection

                    Connections {
                        target: selectionBtn2_l3
                        onClicked: demoUI.singleElement ? demoUI.mainSelection
                                                          = selectionBtn2_l3.text : list3.selection
                                                          = selectionBtn2_l3.text
                    }
                }

                SelectionBtn {
                    id: selectionBtn3_l3
                    text: "Shockwave"
                    icon.source: "images/ShockwaveIcon.png"
                    Layout.maximumHeight: 88
                    Layout.maximumWidth: 580
                    Layout.preferredHeight: 88
                    Layout.preferredWidth: 580
                    selection: demoUI.singleElement ? demoUI.mainSelection : list3.selection

                    Connections {
                        target: selectionBtn3_l3
                        onClicked: demoUI.singleElement ? demoUI.mainSelection
                                                          = selectionBtn3_l3.text : list3.selection
                                                          = selectionBtn3_l3.text
                    }
                }

                SelectionBtn {
                    id: selectionBtn4_l3
                    text: "Spark"
                    icon.source: "images/SparkIcon.png"
                    Layout.maximumHeight: 88
                    Layout.maximumWidth: 580
                    Layout.preferredHeight: 88
                    Layout.preferredWidth: 580
                    selection: demoUI.singleElement ? demoUI.mainSelection : list3.selection

                    Connections {
                        target: selectionBtn4_l3
                        onClicked: demoUI.singleElement ? demoUI.mainSelection
                                                          = selectionBtn4_l3.text : list3.selection
                                                          = selectionBtn4_l3.text
                    }
                }

                SelectionBtn {
                    id: selectionBtn5_l3
                    visible: false
                    text: "Snow"
                    icon.source: "images/SnowIcon.png"
                    Layout.maximumHeight: 88
                    Layout.maximumWidth: 580
                    Layout.preferredHeight: 88
                    Layout.preferredWidth: 580
                    selection: demoUI.singleElement ? demoUI.mainSelection : list3.selection

                    Connections {
                        target: selectionBtn5_l3
                        onClicked: demoUI.singleElement ? demoUI.mainSelection
                                                          = selectionBtn5_l3.text : list3.selection
                                                          = selectionBtn5_l3.text
                    }
                }
            }
        }

        SelectionBtn {
            id: selectionBtn6
            x: 28
            y: 992
            height: 88
            text: "No effect"
            anchors.bottom: parent.bottom
            icon.source: "images/NoneIcon.png"
            anchors.bottomMargin: 28
            selection: demoUI.singleElement ? demoUI.mainSelection : list1.selection
            checked: demoUI.singleElement ? demoUI.mainSelection === selectionBtn6.text : (list1.selection === selectionBtn6.text && list2.selection === selectionBtn6.text && list3.selection === selectionBtn6.text)
            Layout.maximumHeight: 88
            Layout.maximumWidth: 580
            Layout.preferredWidth: 580
            Layout.preferredHeight: 88

            Connections {
                onClicked: list1.selection = selectionBtn6.text
            }

            Connections {
                onClicked: demoUI.mainSelection = selectionBtn6.text
            }

            Connections {
                onClicked: list2.selection = selectionBtn6.text
            }

            Connections {
                onClicked: list3.selection = selectionBtn6.text
            }
        }

        NumberAnimation {
            id: menuTransition
            target: demoUI
            property: "menuphase"
            to: 1
            from: 0
        }

        NumberAnimation {
            id: menuTransition_close
            target: demoUI
            property: "menuphase"
            to: 0
            from: 1
        }
    }

    Button {
        id: sceneToggle
        width: 240
        height: 80
        text: qsTr("")
        anchors.bottom: parent.bottom
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.bottomMargin: 31
        checkable: true
        padding: 0
        background: Rectangle {
            color: sceneToggle.pressed ? "#B8B8B9" : (sceneToggle.hovered ? "#5C5C5D" : "#222222")
            radius: 8
            border.width: 0
        }

        Rectangle {
            id: rectangle
            width: 120
            height: 80
            color: "#3d3d3e"
            radius: 8
            border.color: "#3d3d3e"
            border.width: 0
            anchors.left: parent.left
            z: 10
            anchors.leftMargin: sceneToggle.checked ? sceneToggle.width / 2 : 0
        }

        Image {
            anchors.verticalCenter: parent.verticalCenter
            anchors.left: parent.left
            horizontalAlignment: Image.AlignLeft
            source: "DemoUI/day.png"
            anchors.leftMargin: 41
            z: 20
            fillMode: Image.Pad
        }

        Image {
            anchors.verticalCenter: parent.verticalCenter
            anchors.right: parent.right
            horizontalAlignment: Image.AlignRight
            source: "DemoUI/night.png"
            z: 20
            fillMode: Image.Pad
            anchors.rightMargin: 46
        }
    }

    Button {
        id: qtlogo
        width: 265
        height: 80
        text: qsTr("Built with Qt")
        font.family: "Archivo"
        anchors.right: parent.right
        anchors.bottom: parent.bottom
        anchors.rightMargin: 28
        anchors.bottomMargin: 31
        checkable: true
        background: Rectangle {
            color: qtlogo.pressed ? "#B8B8B9" : (qtlogo.hovered ? "#5C5C5D" : (qtlogo.checked ? "#3D3D3E" : "#222222"))
            radius: 8
        }

        contentItem: Item {
            Label {
                color: "#ffffff"
                text: qtlogo.text
                anchors.left: parent.left
                anchors.top: parent.top
                anchors.bottom: parent.bottom
                anchors.leftMargin: 28
                font.pixelSize: 20
                verticalAlignment: Text.AlignVCenter
            }

            Image {
                anchors.verticalCenter: parent.verticalCenter
                anchors.right: parent.right
                horizontalAlignment: Image.AlignRight
                source: "DemoUI/qtlogo.png"
                fillMode: Image.Pad
                anchors.rightMargin: 36
            }
        }

        DebugBox {
            id: debugBox
            visible: qtlogo.checked
            width: qtlogo.width
            color: "#ca000000"
            radius: 8
            anchors.right: parent.right
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 103
        }
    }
}

/*##^##
Designer {
    D{i:0}D{i:1;cameraSpeed3d:25;cameraSpeed3dMultiplier:1}
}
##^##*/
