/*
This is a UI file (.ui.qml) that is intended to be edited in Qt Design Studio only.
It is supposed to be strictly declarative and only uses a subset of QML. If you edit
this file manually, you might introduce QML code that is not supported by Qt Design Studio.
Check out https://doc.qt.io/qtcreator/creator-quick-ui-forms.html for details on .ui.qml files.
*/

import QtQuick
import QtQuick.Controls
import QtQuick3D
import ParticleEffects
import QtQuick3D.Particles3D
import QtQuick3D.Helpers
import Generated.QtQuick3D.Zen_SceneTest
import QtQml
import QtQuick3D.Effects

Rectangle {
    id: rectangle1
    width: Constants.width
    height: Constants.height
    color: "#000000"
    border.color: "#000000"
    layer.format: ShaderEffectSource.RGB

    View3D {
        id: view3D
        anchors.fill: parent
        anchors.leftMargin: demoUI.menuphase * demoUI.menuWidth
        environment: sceneEnvironment
        layer.format: ShaderEffectSource.RGB

        SceneEnvironment {
            id: sceneEnvironment
            probeHorizon: 0
            specularAAEnabled: true
            probeExposure: 1
            depthPrePassEnabled: false
            tonemapMode: SceneEnvironment.TonemapModeLinear
            backgroundMode: SceneEnvironment.Color
            antialiasingMode: SceneEnvironment.MSAA
            antialiasingQuality: SceneEnvironment.High
        }

        Node {
            id: scene
            visible: true

            Model {
                id: sky
                source: "#Sphere"
                scale.z: 100
                scale.y: 100
                scale.x: 100
                materials: skyMaterial
            }

            DirectionalLight {
                id: directionalLight
                visible: true
                color: demoUI.altScene ? "#66aaff" : "#fffcee"
                ambientColor.r: color.r * 0.6
                ambientColor.g: color.g * 0.8
                ambientColor.b: color.b * 1.0
                eulerRotation.z: 180
                eulerRotation.y: 134.53545
                eulerRotation.x: -17.51563
                shadowMapQuality: Light.ShadowMapQualityVeryHigh
                shadowFactor: 99
                castsShadow: true
                brightness: 1
            }

            Node {
                id: windSource
                property vector3d direction: Qt.vector3d(0.5, 0, -1)
                property real intensity: 10.0
                property real speed: 3.0
                property real gust: 0.0
                property real noiseResolution: 100.0
            }

            Model {
                id: shockSource
                property vector3d sourceposition: Qt.vector3d(shockSource.x,
                                                              shockSource.y,
                                                              shockSource.z)
                property real sourcescale: 50.0 * phase
                property real intensity: 100.0 * (1.0 - phase) * phase
                property real speed: .10 * (1.0 - phase) * phase
                property real gust: 50.0 * (1.0 - phase) * phase
                property real noiseResolution: 1000.0
                property real length: 5000.0 * phase + (5000.0 * phase)
                property real phase: 1.0

                scale: Qt.vector3d(sourcescale, sourcescale, sourcescale)
                x: 0
                y: 0
                z: 0
                visible: false
                source: "#Sphere"
                castsReflections: false
                receivesShadows: false
                castsShadows: false
                materials: defaultMaterial

                NumberAnimation {
                    id: shockAnimator
                    target: shockSource
                    property: "phase"
                    alwaysRunToEnd: false
                    from: 0
                    to: 1
                    duration: 1500
                    onFinished: shockSource.phase = 1.0
                }
            }

            Node {
                id: cameraRoot
                eulerRotation.z: -0.00001
                eulerRotation.y: -155.10498
                eulerRotation.x: -1.02189

                PerspectiveCamera {
                    id: sceneCamera
                    x: -0
                    y: 95.285
                    z: 530.90942
                }
            }

            Node {
                id: effects

                Node {
                    id: sparkroot
                    y: 40

                    SparksEffect {
                        id: sparks
                        visible: demoUI.mainSelection == "Spark"
                        eulerRotation.z: -90
                        y: 0
                        z: 0
                    }
                }

                FlashEffect {
                    id: flash
                    visible: demoUI.mainSelection == "Flash"
                }

                ExplosionEffect {
                    id: explosion
                    visible: demoUI.mainSelection == "Explosion"

                    Connections {
                        target: explosion.timerVar
                        onTriggered: shockAnimator.restart()
                    }
                }

                BubblesEffect {
                    id: bubbles
                    x: 0
                    y: 60
                    z: 0
                    visible: demoUI.mainSelection == "Bubbles"
                    staticFlags: 0
                }

                CloudEffect {
                    id: cloud
                    y: 100
                    visible: demoUI.mainSelection == "Cloud"
                    staticFlags: 0
                }

                LineparticleEffect {
                    id: lineparticleEffect
                    visible: demoUI.mainSelection == "Light Trails"
                }

                AmbientEffect {
                    id: ambientparticles
                    visible: demoUI.mainSelection == "Particles"
                }

                HeatwaveEffect {
                    id: heatwave
                    visible: demoUI.mainSelection == "Heatwave"
                    staticFlags: 0
                }

                RainEffect {
                    id: rain
                    y: -100
                    visible: demoUI.mainSelection == "Rain"
                }

                SmokeEffect {
                    id: smoke
                    y: 50
                    visible: demoUI.mainSelection == "Smoke"
                    staticFlags: 0
                }

                SteamEffect {
                    id: steam
                    y: 30
                    visible: demoUI.mainSelection == "Steam"
                    z: 0
                }

                SnowEffect {
                    id: snow
                    visible: demoUI.mainSelection == "Snow"
                }

                FireEffect {
                    id: fire
                    y: 50
                    visible: demoUI.mainSelection == "Fire"
                    staticFlags: 0
                }

                ShockwaveEffect {
                    id: shockwave
                    y: 10
                    visible: demoUI.mainSelection == "Shockwave"

                    Connections {
                        target: shockwave.timerVar
                        onTriggered: shockAnimator.restart()
                    }
                }

                DustEffect {
                    id: dust
                    visible: demoUI.mainSelection == "Dust"
                    staticFlags: 0
                }
            }

            Zen_SceneTest {
                id: zen_SceneTest
                y: 0
                scale.z: 100
                scale.y: 100
                scale.x: 100
            }
        }

        MouseRotatorAndWASD {
            id: mouseRotatorAndWASD
        }

        MouseArea {
            id: mouseArea
            anchors.fill: parent

            Connections {
                target: mouseArea
                onWheel: sceneCamera.fieldOfView += wheel.angleDelta.y * 0.04
                         * (sceneCamera.fieldOfView + wheel.angleDelta.y * 0.04 > 0.0)
                         * (sceneCamera.fieldOfView + wheel.angleDelta.y * 0.04 < 90.0)
            }

            PinchArea {
                id: pinchArea
                anchors.fill: parent

                Connections {
                    target: pinchArea
                    onPinchUpdated: if (pinch.previousScale - pinch.scale > 0.008
                                            || pinch.previousScale - pinch.scale < -1 * 0.008) {
                                        let velocity = (pinch.previousScale
                                                        - pinch.scale) > 0 ? 1.25 : -1.25
                                        sceneCamera.fieldOfView += velocity
                                                * (sceneCamera.fieldOfView + velocity > 0.0)
                                                * (sceneCamera.fieldOfView + velocity < 90.0)
                                    }
                }
            }
        }
    }

    Item {
        id: __materialLibrary__

        CustomMaterial {
            id: skyMaterial
            cullMode: Material.FrontFaceCulling
            shadingMode: CustomMaterial.Shaded
            fragmentShader: "shaders/dynamicsky.frag"
            vertexShader: "shaders/dynamicsky.vert"
            property real turbidity: demoUI.altScene ? 2 : 1
            property real exposure: demoUI.altScene ? 0.0015 : 0.05
            property real brightness: directionalLight.brightness
            property color skyColor: directionalLight.ambientColor
            property bool stars: true
            property TextureInput starMap: TextureInput {
                texture: Texture {
                    source: "images/LDR_RGBA_0.png"
                    mipFilter: Texture.Linear
                    generateMipmaps: true
                }
            }

            PropertyAnimation {
                target: skyMaterial
                property: "timeOfDay"
                duration: 2500
            }
        }

        DefaultMaterial {
            id: defaultMaterial
            cullMode: Material.NoCulling
            vertexColorsEnabled: true
            objectName: "Default Material"
            diffuseColor: "#4aee45"
        }
    }

    DemoUI {
        id: demoUI
        demoName: "Particle effect library"
        category1Icon: "DemoUI/Elements.png"
        category1Text: "Elements"
        category2Icon: "DemoUI/Ambient.png"
        category2Text: "Ambient"
        category3Icon: "DemoUI/Dynamic.png"
        category3Text: "Dynamic"
    }

    TimeSource {
        id: timeSource
        sourceView: view3D
    }
}

/*##^##
Designer {
    D{i:0;matPrevEnvDoc:"SkyBox";matPrevEnvValueDoc:"preview_studio";matPrevModelDoc:"#Sphere"}
D{i:3;cameraSpeed3d:25;cameraSpeed3dMultiplier:1}D{i:63;cameraSpeed3d:25;cameraSpeed3dMultiplier:1}
}
##^##*/
