
// Created with Qt Design Studio (version 4.7.0), Thu Nov 14 16:08:23 2024
// Do not manually edit this file, it will be overwritten if effect is modified in Qt Design Studio.

import QtQuick

Item {
    id: rootItem

    // Use visible property to show and hide the effect.
    visible: true

    // This is an internal property used by tooling to identify effect items. Do not modify.
    property bool _isEffectItem

    // This is an internal property used to manage the effect. Do not modify.
    property Item _oldParent: null

    // This is the main source for the effect. Set internally to the current parent item. Do not modify.
    property Item source: null
    // Enable this to animate iTime property
    property bool timeRunning: true
    // When timeRunning is false, this can be used to control iTime manually
    property real animatedTime: frameAnimation.elapsedTime

    function setupParentLayer()
    {
        if (_oldParent && _oldParent !== parent) {
            _oldParent.layer.enabled = false
            _oldParent.layer.effect = null
            
            source = null
            _oldParent.update()
            _oldParent = null
        }
        if (parent) {
            _oldParent = parent
            if (visible) {
                parent.layer.enabled = true
                parent.layer.effect = effectComponent
                
                source = parent
            } else {
                parent.layer.enabled = false
                parent.layer.effect = null
                
                source = null
            }
            parent.update()
        }

    }

    onParentChanged: setupParentLayer()

    onVisibleChanged: setupParentLayer()

    // When this is true, the noise affects all RGB color channels separately. Otherwise, noise affects all channels similarly.
    property bool noiseUseRgb: true
    // When this is true, noise animates randomly. Otherwise, noise remains static.
    property bool noiseRandomize: true
    // The amount of noise applied to the source.
    property real noiseAmount: 0.64

    FrameAnimation {
        id: frameAnimation
        running: rootItem.timeRunning
    }

    Component {
        id: effectComponent
        ShaderEffect {
            property Item source: null
            readonly property Item iSource: rootItem.source
            readonly property real iTime: rootItem.animatedTime
            readonly property bool noiseUseRgb: rootItem.noiseUseRgb
            readonly property bool noiseRandomize: rootItem.noiseRandomize
            readonly property real noiseAmount: rootItem.noiseAmount

            vertexShader: 'noiseeffect.vert.qsb'
            fragmentShader: 'noiseeffect.frag.qsb'
            anchors.fill: rootItem.source
        }
    }
}
