
// Created with Qt Design Studio (version 4.7.0), Thu Nov 14 16:08:23 2024
// Do not manually edit this file, it will be overwritten if effect is modified in Qt Design Studio.

import QtQuick
import QtQuick.Layouts
import HelperWidgets
import StudioTheme as StudioTheme

Column {

    Section {
        caption: "Animation"
        width: parent.width

        SectionLayout {
            PropertyLabel {
                text: "Running"
                tooltip: "Set this property to animate the effect."
            }

            SecondColumnLayout {
                CheckBox {
                    text: backendValues.timeRunning.valueToString
                    backendValue: backendValues.timeRunning
                    implicitWidth: StudioTheme.Values.twoControlColumnWidth
                                + StudioTheme.Values.actionIndicatorWidth
                }
                ExpandingSpacer {}
            }

            PropertyLabel {
                text: "Time"
                tooltip: "This property allows explicit control of current animation time."
            }

            SecondColumnLayout {
                SpinBox {
                    minimumValue: 0
                    maximumValue: 9999999
                    decimals: 2
                    stepSize: .01
                    backendValue: backendValues.animatedTime
                    implicitWidth: StudioTheme.Values.singleControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }
                ExpandingSpacer {}
            }
        }
    }

    Section {
        caption: "Noise"
        width: parent.width

        SectionLayout {

            PropertyLabel {
                text: "Use RGB"
                tooltip: "When this is true, the noise affects all RGB color channels separately. Otherwise, noise affects all channels similarly."
            }

            SecondColumnLayout {

                CheckBox {
                    text: backendValues.noiseUseRgb.valueToString
                    backendValue: backendValues.noiseUseRgb
                    implicitWidth: StudioTheme.Values.twoControlColumnWidth
                                + StudioTheme.Values.actionIndicatorWidth
                }

                ExpandingSpacer {}
            }

            PropertyLabel {
                text: "Randomize"
                tooltip: "When this is true, noise animates randomly. Otherwise, noise remains static."
            }

            SecondColumnLayout {

                CheckBox {
                    text: backendValues.noiseRandomize.valueToString
                    backendValue: backendValues.noiseRandomize
                    implicitWidth: StudioTheme.Values.twoControlColumnWidth
                                + StudioTheme.Values.actionIndicatorWidth
                }

                ExpandingSpacer {}
            }

            PropertyLabel {
                text: "Amount"
                tooltip: "The amount of noise applied to the source."
            }

            SecondColumnLayout {

                SpinBox {
                    minimumValue: 0
                    maximumValue: 1
                    decimals: 2
                    stepSize: .01
                    sliderIndicatorVisible: true
                    backendValue: backendValues.noiseAmount
                    implicitWidth: StudioTheme.Values.singleControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }

                ExpandingSpacer {}
            }
        }
    }
}
