
// Created with Qt Design Studio (version 4.7.0), Thu Nov 14 16:07:34 2024
// Do not manually edit this file, it will be overwritten if effect is modified in Qt Design Studio.

import QtQuick
import QtQuick.Layouts
import HelperWidgets
import StudioTheme as StudioTheme

Column {

    Section {
        caption: "Animation"
        width: parent.width

        SectionLayout {
            PropertyLabel {
                text: "Running"
                tooltip: "Set this property to animate the effect."
            }

            SecondColumnLayout {
                CheckBox {
                    text: backendValues.timeRunning.valueToString
                    backendValue: backendValues.timeRunning
                    implicitWidth: StudioTheme.Values.twoControlColumnWidth
                                + StudioTheme.Values.actionIndicatorWidth
                }
                ExpandingSpacer {}
            }

            PropertyLabel {
                text: "Time"
                tooltip: "This property allows explicit control of current animation time."
            }

            SecondColumnLayout {
                SpinBox {
                    minimumValue: 0
                    maximumValue: 9999999
                    decimals: 2
                    stepSize: .01
                    backendValue: backendValues.animatedTime
                    implicitWidth: StudioTheme.Values.singleControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }
                ExpandingSpacer {}
            }
        }
    }

    Section {
        caption: "Thunder"
        width: parent.width

        SectionLayout {

            PropertyLabel {
                text: "Color"
                tooltip: "Color used for the thunder strikes."
            }

            SecondColumnLayout {

                ColorEditor {
                    backendValue: backendValues.thunderColor
                    supportGradient: false
                }

                ExpandingSpacer {}
            }

            PropertyLabel {
                text: "Strike Occurrence"
                tooltip: "Defines how often the strikes occur. Values are between 0 (never) and 1 (every time)."
            }

            SecondColumnLayout {

                SpinBox {
                    minimumValue: 0
                    maximumValue: 1
                    decimals: 2
                    stepSize: .01
                    sliderIndicatorVisible: true
                    backendValue: backendValues.thunderStrikeOccurrence
                    implicitWidth: StudioTheme.Values.singleControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }

                ExpandingSpacer {}
            }
        }
    }

    Section {
        caption: "Rain"
        width: parent.width

        SectionLayout {

            PropertyLabel {
                text: "Texture"
                tooltip: "Texture for the rain effect. This should support seamless tiling."
            }

            SecondColumnLayout {

                UrlChooser {
                    backendValue: backendValues.rainTextureUrl
                    enabled: comboBox_rainTextureUrl.currentIndex === 0
                }
                ExpandingSpacer {}
            }

            PropertyLabel {
                text: "Texture Item"
                tooltip: "Set this to use an item in the scene as Texture instead of the above image."
            }

            SecondColumnLayout {
                ItemFilterComboBox {
                    id: comboBox_rainTextureUrl
                    backendValue: backendValues.rainTexture
                }

                ExpandingSpacer {}
            }

            PropertyLabel {
                text: "Layers"
                tooltip: "The amount of rain layers. Increasing the layers adds variation to the rain effect but also requires more processing power. The default value is 4 and practical range is between 1 and 10."
            }

            SecondColumnLayout {

                SpinBox {
                    minimumValue: 1
                    maximumValue: 10
                    decimals: 0
                    stepSize: 1
                    sliderIndicatorVisible: true
                    backendValue: backendValues.rainLayers
                    implicitWidth: StudioTheme.Values.singleControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }
    
                ExpandingSpacer {}
            }

            PropertyLabel {
                text: "Texture Scale"
                tooltip: "Scaling of the rain texture. Values of x and y define scaling of the first rain layer and values z and w define the scaling step size of each following rain layer. So if values of z and w are 0.0, all rain layers have the same size."
            }

            SecondColumnLayout {

                SpinBox {
                    minimumValue: 0.1
                    maximumValue: 2
                    decimals: 2
                    stepSize: .01
                    backendValue: backendValues.rainTextureScale_x
                    implicitWidth: StudioTheme.Values.twoControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }

                Spacer { implicitWidth: StudioTheme.Values.controlLabelGap }

                ControlLabel {
                    text: "X"
                }
                Spacer { implicitWidth: StudioTheme.Values.controlGap }

                SpinBox {
                    minimumValue: 0.1
                    maximumValue: 2
                    decimals: 2
                    stepSize: .01
                    backendValue: backendValues.rainTextureScale_y
                    implicitWidth: StudioTheme.Values.twoControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }

                Spacer { implicitWidth: StudioTheme.Values.controlLabelGap }

                ControlLabel {
                    text: "Y"
                }

                ExpandingSpacer {}
            }

            PropertyLabel {}

            SecondColumnLayout {

                SpinBox {
                    minimumValue: 0
                    maximumValue: 1
                    decimals: 2
                    stepSize: .01
                    backendValue: backendValues.rainTextureScale_z
                    implicitWidth: StudioTheme.Values.twoControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }

                Spacer { implicitWidth: StudioTheme.Values.controlLabelGap }

                ControlLabel {
                    text: "Z"
                }
                Spacer { implicitWidth: StudioTheme.Values.controlGap }

                SpinBox {
                    minimumValue: 0
                    maximumValue: 1
                    decimals: 2
                    stepSize: .01
                    backendValue: backendValues.rainTextureScale_w
                    implicitWidth: StudioTheme.Values.twoControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }

                Spacer { implicitWidth: StudioTheme.Values.controlLabelGap }

                ControlLabel {
                    text: "W"
                }

                ExpandingSpacer {}
            }

            PropertyLabel {
                text: "Wind"
                tooltip: "Defines wind direction for the rain. The default value is 0.0 and practical range is between -1.0 and 1.0."
            }

            SecondColumnLayout {

                SpinBox {
                    minimumValue: -1
                    maximumValue: 1
                    decimals: 2
                    stepSize: .01
                    sliderIndicatorVisible: true
                    backendValue: backendValues.rainWind
                    implicitWidth: StudioTheme.Values.singleControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }

                ExpandingSpacer {}
            }

            PropertyLabel {
                text: "Color"
                tooltip: "Defines the color of the rain. The default value is light blue (0.8, 0.8, 1.0, 1.0)."
            }

            SecondColumnLayout {

                ColorEditor {
                    backendValue: backendValues.rainColor
                    supportGradient: false
                }

                ExpandingSpacer {}
            }
        }
    }
}
