/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.server;

import com.sun.applet2.AppletParameters;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.JfxRuntime;
import com.sun.deploy.config.Platform;
import com.sun.deploy.config.PluginServerConfig;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import com.sun.javaws.jnl.DefaultMatchJRE;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import sun.plugin2.liveconnect.RemoteJavaObject;
import sun.plugin2.main.server.AppletID;
import sun.plugin2.main.server.ClientJVMSelectionParameters;
import sun.plugin2.main.server.JVMInstance;
import sun.plugin2.main.server.Plugin;
import sun.plugin2.message.AppletMessage;
import sun.plugin2.message.Conversation;
import sun.plugin2.util.SystemUtil;

public class JVMManager {
    static boolean DEBUG = SystemUtil.getenv("JPI_PLUGIN2_DEBUG") != null;
    static boolean VERBOSE = SystemUtil.getenv("JPI_PLUGIN2_VERBOSE") != null;
    private static final String JPI_VM_OPTIONS = "_JPI_VM_OPTIONS";
    private static final String JAVA_EXT_DIRS = "-Djava.ext.dirs=";
    private static final String TRUSTED_DIR = File.separator + "lib" + File.separator + "trusted";
    private static final String JPI_USER_PROFILE = "javaplugin.user.profile";
    private static JVMManager soleInstance;
    private static final int RETRY_COUNT = 2;
    private static int browserType;
    private String userJPIProfile;
    private Map activeJVMs = new HashMap();
    private int curJVMID;
    private final List javaPlatformList = new ArrayList();
    private Map javaParamMap = new IdentityHashMap();
    private int curAppletID;
    private Map appletToJVMMap = new HashMap();
    private Map appletMessageQueue = new HashMap();

    private JVMManager() {
        this.userJPIProfile = SystemUtil.getenv("USER_JPI_PROFILE");
        if (this.userJPIProfile != null) {
            System.setProperty(JPI_USER_PROFILE, this.userJPIProfile);
        }
        Config.setInstance((Config)new PluginServerConfig());
        this.processJREInfo();
        Platform.get().getAutoUpdater().checkForUpdate(null);
    }

    public static void setBrowserType(int n) {
        browserType = n;
    }

    public static int getBrowserType() {
        return browserType;
    }

    public static synchronized JVMManager getManager() {
        if (soleInstance == null) {
            soleInstance = new JVMManager();
        }
        return soleInstance;
    }

    public boolean instanceExited(int n) {
        return this.getJVMInstance(n) == null;
    }

    public boolean appletExited(AppletID appletID) {
        Iterator iterator = this.activeJVMs.values().iterator();
        while (iterator.hasNext()) {
            JVMInstance jVMInstance = (JVMInstance)iterator.next();
            if (!jVMInstance.appletRunning(appletID)) continue;
            return false;
        }
        return true;
    }

    public AppletID startApplet(AppletParameters appletParameters, Plugin plugin, long l, String string, boolean bl) {
        return this.startApplet(appletParameters, plugin, l, string, bl, (String)appletParameters.get((Object)"java_version"));
    }

    public AppletID startApplet(AppletParameters appletParameters, Plugin plugin, long l, String string, boolean bl, String string2) {
        return this.startAppletImpl(SystemUtils.microTime(), appletParameters, plugin, l, string, bl, string2, false, this.nextAppletID(), false);
    }

    public AppletID startDummyApplet(AppletParameters appletParameters, Plugin plugin) {
        return this.startAppletImpl(SystemUtils.microTime(), appletParameters, plugin, 0L, null, false, (String)appletParameters.get((Object)"java_version"), true, this.nextAppletID(), false);
    }

    public AppletID relaunchApplet(long l, AppletParameters appletParameters, Plugin plugin, long l2, String string, boolean bl, String string2, int n, boolean bl2) {
        if (bl2) {
            this.processJREInfo();
        }
        return this.startAppletImpl(l, appletParameters, plugin, l2, string, bl, string2, false, n, true);
    }

    private void maintainCurrentArchFlag(JVMParameters jVMParameters, JREInfo jREInfo) {
        if (SystemUtil.getOSType() == 3 && !jVMParameters.contains("-d32") && !jVMParameters.contains("-d64")) {
            if ("x86_64".equals(jREInfo.getOSArch()) || "amd64".equals(jREInfo.getOSArch())) {
                jVMParameters.addInternalArgument("-d64");
            } else {
                jVMParameters.addInternalArgument("-d32");
            }
        }
    }

    private static void scopeJVMInstanceByHost(Plugin plugin, JVMParameters jVMParameters) {
        try {
            String string;
            String string2 = null;
            String string3 = plugin.getDocumentBase();
            if (string3 != null) {
                URI uRI = new URI(string3);
                string2 = uRI.getHost();
            }
            if (string2 != null) {
                jVMParameters.addInternalArgument("-Djava.applet.host=" + string2);
                string = ResourceManager.getFormattedMessage((String)"applet.host.app.title", (Object[])new String[]{string2});
            } else {
                string = ResourceManager.getMessage((String)"applet.host.app.title.nohost");
            }
            jVMParameters.addInternalArgument("-Xdock:name=" + string);
            jVMParameters.addInternalArgument("-Xdock:icon=" + Platform.get().getDefaultIconPath());
        }
        catch (URISyntaxException uRISyntaxException) {
            Trace.printException((Throwable)uRISyntaxException);
        }
    }

    VersionString getVersionStringToRunAndSetSsvVersion(String string, AppletParameters appletParameters) {
        VersionString versionString = new VersionString(string);
        String string2 = JVMManager.noDash(this.getBestJREInfo(versionString).getProduct());
        if (versionString.contains(string2)) {
            if (SecurityBaseline.satisfiesSecurityBaseline((String)string2)) {
                return new VersionString(string2);
            }
            appletParameters.put((Object)"__applet_ssv_version", (Object)string2);
        } else {
            appletParameters.put((Object)"__applet_request_version", (Object)string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppletID startAppletImpl(long l, AppletParameters appletParameters, Plugin plugin, long l2, String string, boolean bl, String string2, boolean bl2, int n, boolean bl3) {
        VersionString versionString = null;
        if (string2 != null) {
            versionString = bl3 ? new VersionString(string2) : this.getVersionStringToRunAndSetSsvVersion(string2, appletParameters);
        }
        JVMParameters jVMParameters = new JVMParameters();
        jVMParameters.parseBootClassPath(JVMParameters.getPlugInDependentJars());
        jVMParameters.addInternalArgument("-Djava.class.path=" + Config.getJREHome() + File.separator + "classes");
        jVMParameters.setDefault(true);
        String string3 = (String)appletParameters.get((Object)"java_arguments");
        if (string3 != null) {
            jVMParameters.setHtmlJavaArgs(true);
            jVMParameters.parse(string3, !bl3);
        } else {
            jVMParameters.setHtmlJavaArgs(false);
        }
        if (SystemUtil.getOSType() == 3) {
            JVMManager.scopeJVMInstanceByHost(plugin, jVMParameters);
        }
        int n2 = 0;
        ClientJVMSelectionParameters clientJVMSelectionParameters = ClientJVMSelectionParameters.extract((Map)appletParameters);
        do {
            JVMInstance jVMInstance;
            if (null == (jVMInstance = this.getOrCreateBestJVMInstance(l, versionString, jVMParameters, clientJVMSelectionParameters))) {
                plugin.startupStatus(3);
                return null;
            }
            if (!jVMInstance.exited() && jVMInstance.startApplet(appletParameters, plugin, l2, string, bl, n, bl2, bl3)) {
                AppletID appletID = new AppletID(n);
                this.appletToJVMMap.put(appletID, jVMInstance);
                Map map = this.appletMessageQueue;
                synchronized (map) {
                    if (null == this.appletMessageQueue.get(appletID)) {
                        this.appletMessageQueue.put(appletID, new ArrayList());
                    }
                }
                if (DEBUG) {
                    System.out.println("JVMManager: applet launch (ID " + appletID + ") succeeded");
                }
                return appletID;
            }
            if (!DEBUG || !jVMInstance.errorOccurred()) continue;
            System.out.println("Error occurred during launch of JVM");
        } while (++n2 < 2);
        return null;
    }

    public void setAppletSize(AppletID appletID, int n, int n2) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return;
        }
        int[] nArray = new int[]{n, n2};
        jVMInstance.setAppletSize(appletID.getID(), n, n2);
    }

    public void sendStopApplet(AppletID appletID) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return;
        }
        jVMInstance.sendStopApplet(appletID.getID());
    }

    public boolean receivedStopAcknowledgment(AppletID appletID) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return false;
        }
        return jVMInstance.receivedStopAcknowledgment(appletID.getID());
    }

    public void recycleAppletID(AppletID appletID) {
        JVMInstance jVMInstance = this.removeJVMInstance(appletID);
        if (jVMInstance != null) {
            jVMInstance.recycleAppletID(appletID.getID());
        }
        this.removeAppletMessageQueue(appletID);
    }

    public void sendGetApplet(AppletID appletID, int n) throws IOException {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            throw new IOException("No active JVM instance for applet ID " + appletID);
        }
        jVMInstance.sendGetApplet(appletID.getID(), n);
    }

    public void sendGetNameSpace(AppletID appletID, String string, int n) throws IOException {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            throw new IOException("No active JVM instance for applet ID " + appletID);
        }
        jVMInstance.sendGetNameSpace(appletID.getID(), string, n);
    }

    public void sendRemoteJavaObjectOp(Conversation conversation, RemoteJavaObject remoteJavaObject, String string, int n, Object[] objectArray, int n2) throws IOException {
        JVMInstance jVMInstance = this.getJVMInstance(new AppletID(remoteJavaObject.getAppletID()));
        if (jVMInstance == null) {
            throw new IOException("No active JVM instance for applet ID " + remoteJavaObject.getAppletID() + ", JVM ID " + remoteJavaObject.getJVMID());
        }
        jVMInstance.sendRemoteJavaObjectOp(conversation, remoteJavaObject, string, n, objectArray, n2);
    }

    public void releaseRemoteJavaObject(RemoteJavaObject remoteJavaObject) {
        JVMInstance jVMInstance = this.getJVMInstance(remoteJavaObject.getJVMID());
        if (jVMInstance == null) {
            return;
        }
        jVMInstance.releaseRemoteJavaObject(remoteJavaObject.getObjectID());
    }

    public void sendWindowActivation(AppletID appletID, boolean bl) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return;
        }
        jVMInstance.synthesizeWindowActivation(appletID.getID(), bl);
    }

    public void sendGotFocus(AppletID appletID, boolean bl) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return;
        }
        jVMInstance.sendGotFocus(appletID.getID(), bl);
    }

    public void sendOverlayWindowMove(AppletID appletID, double d, double d2) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return;
        }
        jVMInstance.sendOverlayWindowMove(appletID.getID(), d, d2);
    }

    public void sendMouseEvent(AppletID appletID, int n, int n2, double d, double d2, int n3, int n4) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return;
        }
        jVMInstance.sendMouseEvent(appletID.getID(), n, n2, d, d2, n3, n4);
    }

    public void sendKeyEvent(AppletID appletID, int n, int n2, String string, String string2, boolean bl, int n3, boolean bl2) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return;
        }
        jVMInstance.sendKeyEvent(appletID.getID(), n, n2, string, string2, bl, n3, bl2);
    }

    public void sendScrollEvent(AppletID appletID, double d, double d2, int n, double d3, double d4, double d5) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return;
        }
        jVMInstance.sendScrollEvent(appletID.getID(), d, d2, n, d3, d4, d5);
    }

    public void sendTextEvent(AppletID appletID, String string) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return;
        }
        jVMInstance.sendTextEvent(appletID.getID(), string);
    }

    public boolean printApplet(AppletID appletID, long l, int n, int n2, int n3, int n4) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return false;
        }
        return jVMInstance.printApplet(appletID.getID(), l, n, n2, n3, n4);
    }

    public boolean isMoreRecentJVMAvailable(JREInfo jREInfo) {
        Iterator iterator = this.javaPlatformList.iterator();
        while (iterator.hasNext()) {
            JREInfo jREInfo2 = (JREInfo)iterator.next();
            if (DEBUG) {
                System.out.println("isMoreRecentJVMAvailable considering " + jREInfo2.getProductVersion() + " JVM for relaunch");
            }
            if (!jREInfo2.getProductVersion().isGreaterThan(jREInfo.getProductVersion())) continue;
            if (DEBUG) {
                System.out.println("  isMoreRecentJVMAvailable (chosen)");
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean spoolAppletMessage(AppletMessage appletMessage) {
        Map map = this.appletMessageQueue;
        synchronized (map) {
            List list = (List)this.appletMessageQueue.get(new AppletID(appletMessage.getAppletID()));
            if (list != null) {
                if (DEBUG && VERBOSE) {
                    System.out.println("Spool AppletMessage: " + appletMessage);
                }
                list.add(appletMessage);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drainAppletMessages(AppletID appletID) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null && DEBUG) {
            System.out.println("JVMManager.drainAppletMessages: no JVM instance for applet ID " + appletID);
            return;
        }
        Map map = this.appletMessageQueue;
        synchronized (map) {
            List list = (List)this.appletMessageQueue.remove(appletID);
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    try {
                        AppletMessage appletMessage = (AppletMessage)iterator.next();
                        if (DEBUG && VERBOSE) {
                            System.out.println("Drain AppletMessage: " + appletMessage);
                        }
                        jVMInstance.sendMessageDirect(appletMessage);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAppletMessageQueue(AppletID appletID) {
        Map map = this.appletMessageQueue;
        synchronized (map) {
            this.appletMessageQueue.remove(appletID);
        }
    }

    protected synchronized int getJVMIDForApplet(AppletID appletID) {
        JVMInstance jVMInstance = (JVMInstance)this.appletToJVMMap.get(appletID);
        return null != jVMInstance ? jVMInstance.getID() : -1;
    }

    private synchronized JVMInstance getJVMInstance(AppletID appletID) {
        return (JVMInstance)this.appletToJVMMap.get(appletID);
    }

    private synchronized JVMInstance getJVMInstance(int n) {
        return (JVMInstance)this.activeJVMs.get(new Integer(n));
    }

    private synchronized JVMInstance removeJVMInstance(AppletID appletID) {
        return (JVMInstance)this.appletToJVMMap.remove(appletID);
    }

    private synchronized int nextJVMID() {
        int n;
        while (this.activeJVMs.get(new Integer(n = ++this.curJVMID)) != null) {
        }
        return n;
    }

    private synchronized void processJREInfo() {
        Vector vector;
        Config.get().refreshIfNeeded();
        this.javaPlatformList.clear();
        if (DEBUG && VERBOSE) {
            System.out.println("JREInfos (1)");
            JREInfo.printJREs();
        }
        if ((vector = Platform.get().getInstalledJREList()) != null) {
            Config.get().storeInstalledJREs(vector);
        }
        if (DEBUG && VERBOSE) {
            System.out.println("JREInfos (2)");
            JREInfo.printJREs();
        }
        this.javaPlatformList.addAll(Arrays.asList(JREInfo.getAll()));
        JVMManager.filterJavaPlatformList(this.javaPlatformList);
        Collections.sort(this.javaPlatformList, new Comparator(){

            public int compare(Object object, Object object2) {
                VersionID versionID = ((JREInfo)object).getProductVersion();
                VersionID versionID2 = ((JREInfo)object2).getProductVersion();
                return -versionID.compareTo((Object)versionID2);
            }

            public boolean equals(Object object) {
                return false;
            }
        });
        JVMManager.filterDisabledJREs(this.javaPlatformList);
        this.updateJavaParamMap();
    }

    private void updateJavaParamMap() {
        Iterator iterator = this.javaPlatformList.iterator();
        while (iterator.hasNext()) {
            JREInfo jREInfo = (JREInfo)iterator.next();
            JVMParameters jVMParameters = new JVMParameters();
            jVMParameters.parseTrustedOptions(JVMManager.getVmArgs(jREInfo));
            jVMParameters.setDefault(true);
            this.javaParamMap.put(jREInfo, jVMParameters);
        }
    }

    JREInfo getBestJREInfo(VersionString versionString) {
        return this.getBestJREInfo(versionString, null);
    }

    synchronized JREInfo getBestJREInfo(VersionString versionString, VersionString versionString2) {
        boolean bl = false;
        if (versionString == null && this.javaPlatformList.size() > 0) {
            return (JREInfo)this.javaPlatformList.get(0);
        }
        while (true) {
            if (bl) {
                Config.get().refreshIfNeeded();
                this.processJREInfo();
            }
            Iterator iterator = this.javaPlatformList.iterator();
            while (iterator.hasNext()) {
                JREInfo jREInfo = (JREInfo)iterator.next();
                if (!versionString.contains(jREInfo.getProductVersion())) continue;
                if (versionString2 != null && !versionString2.toString().equals("")) {
                    if (jREInfo.getFXVersion() == null || !DefaultMatchJRE.isFXVersionMatch((String)jREInfo.getFXVersion().toString(), (VersionString)versionString2)) continue;
                    return jREInfo;
                }
                return jREInfo;
            }
            if (bl) break;
            bl = true;
        }
        return (JREInfo)this.javaPlatformList.get(0);
    }

    synchronized JVMInstance getOrCreateBestJVMInstance(long l, VersionString versionString, JVMParameters jVMParameters, ClientJVMSelectionParameters clientJVMSelectionParameters) {
        Object object;
        JVMInstance jVMInstance = null;
        if (!clientJVMSelectionParameters.isSeparateJVM()) {
            jVMInstance = this.getBestJVMInstance(versionString, jVMParameters, clientJVMSelectionParameters);
            if (jVMInstance != null) {
                if (DEBUG) {
                    System.out.println("JVMManager reusing JVMInstance for product version " + jVMInstance.getProductVersion());
                    System.out.println("\t Set AppletLaunchTime: " + l);
                }
                jVMInstance.setAppletLaunchTime(l);
                return jVMInstance;
            }
            object = this.getBestJREInfo(versionString);
            jVMInstance = this.getBestJVMInstance(new VersionString(object.getProductVersion()), jVMParameters, clientJVMSelectionParameters);
            if (jVMInstance != null) {
                if (DEBUG) {
                    System.out.println("JVMManager reusing JVMInstance for product version " + jVMInstance.getProductVersion());
                    System.out.println("\t Set AppletLaunchTime: " + l);
                }
                jVMInstance.setAppletLaunchTime(l);
                return jVMInstance;
            }
        }
        if ((jVMInstance = this.createJVMInstance(l, versionString, jVMParameters, clientJVMSelectionParameters)) == null) {
            if (DEBUG) {
                System.out.print("Cannot find a suitable JRE.");
            }
            return null;
        }
        if (DEBUG) {
            System.out.println("JVMManager starting JVMInstance for product version " + jVMInstance.getProductVersion());
            object = jVMInstance.getParameters().getCommandLineArguments(SystemUtil.isWindowsVista(), false);
            if (object.size() > 0) {
                System.out.println("  Command-line arguments: ");
                for (int i = 0; i < object.size(); ++i) {
                    System.out.println("    Argument " + i + ": " + object.get(i));
                }
            }
        }
        try {
            jVMInstance.start();
            return jVMInstance;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        catch (Error error) {
            error.printStackTrace();
            throw error;
        }
    }

    synchronized JVMInstance getBestJVMInstance(VersionString versionString, JVMParameters jVMParameters, ClientJVMSelectionParameters clientJVMSelectionParameters) {
        Object object;
        Object object2;
        if (clientJVMSelectionParameters.isSeparateJVM()) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Object object3 = this.activeJVMs.values().iterator();
        while (object3.hasNext()) {
            object2 = (JVMInstance)object3.next();
            if (!((JVMInstance)object2).exited()) continue;
            arrayList.add(new Integer(((JVMInstance)object2).getID()));
        }
        object3 = arrayList.iterator();
        while (object3.hasNext()) {
            this.activeJVMs.remove(object3.next());
        }
        if (DEBUG) {
            System.out.println("Seeking suitable JRE for version IDs: " + versionString);
            System.out.println("and JVMParameters: " + jVMParameters);
            System.out.println(this.activeJVMs.values().size() + " active JVM(s)");
        }
        object3 = null;
        object2 = this.activeJVMs.values().iterator();
        while (object2.hasNext()) {
            object = (JVMInstance)object2.next();
            if (DEBUG) {
                System.out.println("Considering for reuse: " + object);
            }
            if (((JVMInstance)object).isExclusive()) {
                if (!DEBUG) continue;
                System.out.println("\tRejected by exclusive instance");
                continue;
            }
            if (!((JVMInstance)object).isHealthy()) {
                if (!DEBUG) continue;
                System.out.println("\tRejected by unhealthy: " + ((JVMInstance)object).getHealthData());
                continue;
            }
            if (!clientJVMSelectionParameters.match((JVMInstance)object)) {
                if (!DEBUG) continue;
                System.out.println("\tRejected by targetJVMSelectionPreferences: " + clientJVMSelectionParameters);
                continue;
            }
            if (versionString != null && !versionString.contains(((JVMInstance)object).getProductVersion())) {
                if (!DEBUG) continue;
                System.out.println("\tRejected by unmatch version: " + ((JVMInstance)object).getProductVersion());
                continue;
            }
            if (!((JVMInstance)object).getParameters().satisfies(jVMParameters)) {
                if (!DEBUG) continue;
                System.out.println("\tRejected by unsatisfied parameters: " + ((JVMInstance)object).getParameters());
                continue;
            }
            if (object3 != null && !((JVMInstance)object).getProductVersion().isGreaterThan(((JVMInstance)object3).getProductVersion())) {
                if (!DEBUG) continue;
                System.out.println("\tRejected, not later than current best: " + ((JVMInstance)object3).getProductVersion());
                continue;
            }
            object3 = object;
            if (!DEBUG) continue;
            System.out.println("  Selected: " + ((JVMInstance)object3).getProductVersion());
        }
        if (DEBUG) {
            System.out.println("Selecting a matched JREInfo...");
        }
        object2 = null;
        object = this.javaPlatformList.iterator();
        while (object.hasNext()) {
            JREInfo jREInfo = (JREInfo)object.next();
            if (DEBUG) {
                System.out.println("Considering " + jREInfo.getProductVersion() + " JVM for launch");
            }
            if ((versionString == null || versionString.contains(jREInfo.getProductVersion())) && (object2 == null || jREInfo.getProductVersion().isGreaterThan(object2.getProductVersion()))) {
                object2 = jREInfo;
                if (!DEBUG) continue;
                System.out.println("  (chosen)");
                continue;
            }
            if (!DEBUG) continue;
            System.out.println("  (rejected)");
        }
        if (object3 != null) {
            if (object2 == null) {
                throw new InternalError("Should not find a running JVM instance but no matching JRE platform");
            }
            if (((JVMInstance)object3).getProductVersion().isGreaterThanOrEqual(object2.getProductVersion())) {
                if (DEBUG) {
                    System.out.println("Reusing JVM instance with product version " + ((JVMInstance)object3).getProductVersion() + "; best available product version " + object2.getProductVersion());
                }
                return object3;
            }
            if (DEBUG) {
                System.out.println("NOT reusing JVM instance with product version " + ((JVMInstance)object3).getProductVersion() + "; best available product version " + object2.getProductVersion());
            }
        } else if (DEBUG) {
            System.out.println("No suitable JVM instance to reuse");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JVMInstance createJVMInstance(long l, VersionString versionString, JVMParameters jVMParameters, ClientJVMSelectionParameters clientJVMSelectionParameters) {
        JREInfo jREInfo = this.getBestJREInfo(versionString, new VersionString(clientJVMSelectionParameters.getJfxRequirement()));
        if (jREInfo == null) {
            return null;
        }
        JVMParameters jVMParameters2 = new JVMParameters();
        VersionID versionID = clientJVMSelectionParameters.getJfxRequirement();
        boolean bl = false;
        JfxRuntime jfxRuntime = null;
        if (null != versionID) {
            if (DEBUG && VERBOSE) {
                System.out.println("Need JavaFX version: " + versionID);
            }
            if (!jREInfo.getProductVersion().isGreaterThanOrEqual(ClientJVMSelectionParameters.JFX_JRE_MINIMUM_VER)) {
                if (DEBUG && VERBOSE) {
                    System.out.println("JavaFX requires minimum JRE version: " + ClientJVMSelectionParameters.JFX_JRE_MINIMUM_VER);
                }
                return null;
            }
            jfxRuntime = jREInfo.getJfxRuntime();
            if (jfxRuntime == null) {
                System.out.println("Launching in a vanilla JVM to install JavaFX and relaunch.");
            } else {
                if (!clientJVMSelectionParameters.useJfxToolkit()) {
                    jVMParameters2.addInternalArgument("-Djnlp.tk=awt");
                } else {
                    bl = true;
                }
                jVMParameters2.addInternalArgument("-Djnlp.fx=" + jfxRuntime.getProductVersion().toString());
            }
        }
        if (DEBUG && VERBOSE) {
            System.out.println("    JVMManager.createJVMInstance passing along JVM parameters from deployment.properties");
        }
        jVMParameters2.addArguments((JVMParameters)this.javaParamMap.get(jREInfo));
        if (DEBUG && VERBOSE) {
            System.out.println("    JVMManager.createJVMInstance passing along JVM parameters from this applet instance");
        }
        jVMParameters2.addArguments(jVMParameters);
        jVMParameters2.setHtmlJavaArgs(jVMParameters.isHtmlJavaArgs());
        this.maintainCurrentArchFlag(jVMParameters2, jREInfo);
        JVMManager.addJavaExtDirsOption(jVMParameters2);
        JVMManager.addXToolkitOption(jVMParameters2, jREInfo.getProductVersion());
        JVMManager.addUIElementOption(jVMParameters2);
        if (!bl) {
            jVMParameters2.addInternalArgument("-Dsun.awt.warmup=true");
        }
        if (this.userJPIProfile != null) {
            jVMParameters2.addInternalArgument("-Djavaplugin.user.profile=" + this.userJPIProfile);
        }
        if (DEBUG) {
            System.out.println("JVMManager creating JVMInstance for product version " + jREInfo.getProductVersion());
        }
        int n = this.nextJVMID();
        JVMInstance jVMInstance = new JVMInstance(l, n, jREInfo, jVMParameters2, clientJVMSelectionParameters.isSeparateJVM());
        jVMInstance.setJfxSupport(jfxRuntime);
        jVMInstance.setUseJfxToolkit(bl);
        JVMManager jVMManager = this;
        synchronized (jVMManager) {
            this.activeJVMs.put(new Integer(n), jVMInstance);
        }
        return jVMInstance;
    }

    private synchronized int nextAppletID() {
        return ++this.curAppletID;
    }

    private static void filterJavaPlatformList(List list) {
        VersionID versionID = new VersionID("1.4+");
        VersionID versionID2 = new VersionID("1.5+");
        boolean bl = SystemUtil.getOSType() == 2;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JREInfo jREInfo = (JREInfo)iterator.next();
            if (!versionID.match(jREInfo.getProductVersion()) || bl && !versionID2.match(jREInfo.getProductVersion())) {
                iterator.remove();
                continue;
            }
            if (!jREInfo.isOsInfoMatch(Config.getOSName(), Config.getOSArch())) {
                iterator.remove();
                continue;
            }
            File file = new File(jREInfo.getPath());
            if (file.exists()) continue;
            iterator.remove();
        }
    }

    private static void filterDisabledJREs(List list) {
        String string = SystemUtil.getJavaHome();
        JREInfo jREInfo = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JREInfo jREInfo2 = (JREInfo)iterator.next();
            if (jREInfo2.getJREPath().startsWith(string)) {
                jREInfo = jREInfo2;
            }
            if (jREInfo2.isEnabled()) continue;
            iterator.remove();
        }
        if (list.isEmpty() && jREInfo != null) {
            list.add(jREInfo);
        }
    }

    private static void addXToolkitOption(JVMParameters jVMParameters, VersionID versionID) {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("sunos") && new VersionID("1.5*").match(versionID)) {
            jVMParameters.addInternalArgument("-Dawt.toolkit=sun.awt.X11.XToolkit");
        }
    }

    private static void addUIElementOption(JVMParameters jVMParameters) {
        if (SystemUtil.getOSType() == 3) {
            jVMParameters.addInternalArgument("-Dapple.awt.UIElement=true");
        }
    }

    private static String getVmArgs(JREInfo jREInfo) {
        String string = SystemUtil.getenv("FORCED_CLIENTVM_ARGS");
        if (DEBUG && string != null) {
            System.out.println("JVMManager: using override from FORCED_CLIENTVM_ARGS" + string);
        }
        if (string == null) {
            string = SystemUtil.getenv(JPI_VM_OPTIONS);
        }
        if (string != null) {
            return string;
        }
        return jREInfo.getVmArgs();
    }

    private static String getJavaExtDirsProp(JVMParameters jVMParameters) {
        String string;
        String string2;
        File file;
        boolean bl;
        if (jVMParameters.containsPrefix(JAVA_EXT_DIRS)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(JAVA_EXT_DIRS);
        stringBuffer.append(Config.getJREHome() + File.separator + "lib" + File.separator + "ext");
        String string3 = stringBuffer.toString();
        boolean bl2 = bl = JVMManager.getBrowserType() == 3;
        if (bl && (file = new File(string2 = Platform.get().getBrowserHomePath() + File.separator + "jss")).exists()) {
            stringBuffer.append(File.pathSeparator);
            stringBuffer.append(string2);
        }
        string2 = Config.getSystemHome() + TRUSTED_DIR;
        file = new File(string2);
        if (SystemUtil.getOSType() == 1 && file.exists()) {
            stringBuffer.append(File.pathSeparator);
            stringBuffer.append(string2);
        }
        if ((string = stringBuffer.toString()).equals(string3)) {
            return null;
        }
        return string;
    }

    private static void addJavaExtDirsOption(JVMParameters jVMParameters) {
        String string = JVMManager.getJavaExtDirsProp(jVMParameters);
        if (null != string) {
            jVMParameters.addInternalArgument(string);
        }
    }

    void setJavaPlatformListForTest(List list) {
        this.javaPlatformList.clear();
        this.javaPlatformList.addAll(list);
        this.updateJavaParamMap();
    }

    static void resetInstanceForTest() {
        soleInstance = null;
    }

    private static String noDash(String string) {
        int n = string.indexOf("-");
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }
}

