/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.controlli;

import finanze.IDTE.studi2002.campi.GericoModel;
import finanze.IDTE.studi2002.campi.NonCoerenzaException;
import finanze.IDTE.studi2002.controlli.ControlloAnnotazioneDistinta;
import finanze.IDTE.studi2002.controlli.ControlloCF;
import finanze.IDTE.studi2002.controlli.ControlloCFF;
import finanze.IDTE.studi2002.controlli.ControlloCoerenzaNG;
import finanze.IDTE.studi2002.controlli.ControlloCondizionato;
import finanze.IDTE.studi2002.controlli.ControlloCondizionato3;
import finanze.IDTE.studi2002.controlli.ControlloEsclusione;
import finanze.IDTE.studi2002.controlli.ControlloEsistenza;
import finanze.IDTE.studi2002.controlli.ControlloEsistenzaBlocco;
import finanze.IDTE.studi2002.controlli.ControlloNaturaGiuridica;
import finanze.IDTE.studi2002.controlli.ControlloNumeroPosizioni;
import finanze.IDTE.studi2002.controlli.ControlloPercentuale;
import finanze.IDTE.studi2002.controlli.ControlloPercentuale2;
import finanze.IDTE.studi2002.controlli.ControlloPercentualeCampoSingolo;
import finanze.IDTE.studi2002.controlli.ControlloPersonaleContabile;
import finanze.IDTE.studi2002.controlli.ControlloPersonaleContabile2;
import finanze.IDTE.studi2002.controlli.ControlloPersonalePercentuale;
import finanze.IDTE.studi2002.controlli.ControlloPresenzaCodiceStudio;
import finanze.IDTE.studi2002.controlli.ControlloRange;
import finanze.IDTE.studi2002.controlli.ControlloRicaviProventi;
import finanze.IDTE.studi2002.controlli.ControlloRicaviRicag;
import finanze.IDTE.studi2002.controlli.ControlloRigheUguali;
import finanze.IDTE.studi2002.controlli.ControlloTemplate;
import finanze.IDTE.studi2002.controlli.ControlloUguaglianza;
import finanze.IDTE.studi2002.controlli.ControlloUnitaOperativa;
import finanze.IDTE.studi2002.controlli.ControlloUsoParametri1;
import finanze.IDTE.studi2002.controlli.ControlloValiditaCodiceStudio;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class GericoControllo {
    protected Vector listaModel = new Vector();
    protected int codErrore = 0;
    protected boolean esito = false;
    protected Vector campiMsg = new Vector();
    protected String messaggio = "";
    protected String nomeQuadro = null;
    protected String errore = "";
    protected String gravitaErrore = "";

    protected void addModel(GericoModel gm) {
        this.listaModel.addElement(gm);
    }

    protected abstract void creaMessaggioErrore();

    public String[] getCampiControllati() {
        String[] arr = new String[this.listaModel.size()];
        int j = 0;
        int size = this.listaModel.size();
        while (j < size) {
            arr[j] = ((GericoModel)this.listaModel.elementAt(j)).getCode();
            ++j;
        }
        return arr;
    }

    public Vector getCampiErrati() {
        Vector<String> v = new Vector<String>();
        String[] campiControllati = this.getCampiControllati();
        int j = 0;
        int size = campiControllati.length;
        while (j < size) {
            v.addElement(campiControllati[j]);
            ++j;
        }
        return v;
    }

    public Vector getCampiMsg() {
        return this.campiMsg;
    }

    public int getCodErrore() {
        return this.codErrore;
    }

    public String getErrore() {
        return this.errore;
    }

    public boolean getEsito() {
        return this.esito;
    }

    public String getGravitaErrore() {
        return this.gravitaErrore;
    }

    public static GericoControllo getIstanza(String[] spec_ctrl, Hashtable componentiModel) throws NonCoerenzaException {
        String spec_line = spec_ctrl[0];
        StringTokenizer strTok = new StringTokenizer(spec_line, "*");
        String type = strTok.nextToken();
        if (type.equalsIgnoreCase("CE")) {
            return new ControlloEsistenza(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CEB")) {
            return new ControlloEsistenzaBlocco(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CNG")) {
            return new ControlloNaturaGiuridica(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CCNG")) {
            return new ControlloCoerenzaNG(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CVCS")) {
            return new ControlloValiditaCodiceStudio(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CP")) {
            return new ControlloPercentuale(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CP2")) {
            return new ControlloPercentuale2(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CPP")) {
            return new ControlloPersonalePercentuale(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CPC")) {
            return new ControlloPersonaleContabile(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CPC2")) {
            return new ControlloPersonaleContabile2(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CR")) {
            return new ControlloRange(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CRP")) {
            return new ControlloRicaviProventi(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CU")) {
            return new ControlloUguaglianza(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("C2")) {
            return new ControlloCondizionato(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CC3")) {
            return new ControlloCondizionato3(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CT")) {
            return new ControlloTemplate(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CF")) {
            return new ControlloCF(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CFF")) {
            return new ControlloCFF(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CRU")) {
            return new ControlloRigheUguali(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CPCS")) {
            return new ControlloPercentualeCampoSingolo(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CPCS2")) {
            return new ControlloPresenzaCodiceStudio(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CAD")) {
            return new ControlloAnnotazioneDistinta(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CESC")) {
            return new ControlloEsclusione(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CUP1")) {
            return new ControlloUsoParametri1(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CUO")) {
            return new ControlloUnitaOperativa(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CNP")) {
            return new ControlloNumeroPosizioni(spec_line, componentiModel, spec_ctrl[1]);
        }
        if (type.equalsIgnoreCase("CRR")) {
            return new ControlloRicaviRicag(spec_line, componentiModel, spec_ctrl[1]);
        }
        return null;
    }

    public String getMessaggio() {
        return this.messaggio;
    }

    public String getNomeQuadro() {
        return this.nomeQuadro;
    }

    protected abstract void impostaErrore();

    public void setNomeQuadro(String nomeQuadro) {
        this.nomeQuadro = nomeQuadro;
    }

    public abstract boolean verifica();
}

