/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.resourcescreator;

import it.sogei.rcp.filesystemutil.FileSystemUtil;
import it.sogei.rcp.interfaces.IRelativePath;
import it.sogei.rcp.resourcescreator.utils.NewProjectHelper;
import it.sogei.rcp.util.RelativePath;
import it.sogei.utilities.log4j.LogUtil;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IStartup;

public class Startup
implements IStartup {
    private static final String NAME_ATTR_KEY = "Nome";
    private static final String DATASTRUCT_ATTR_KEY = "StrutturaDati";
    private static final String FOLDER_ATTR_KEY = "Folder";
    private static final String RESOURCE_ATTR_KEY = "Risorsa";
    private static final String FILE_ATTR_KEY = "File";
    private static final String OVERWRITE_ATTR_KEY = "Overwrite";
    private static final String PROJECTNAME_ATTR_KEY = "NomeProgetto";
    private static final String NATUREID_ATTR_KEY = "natureId";
    private FileSystemUtil fsu = null;

    public void earlyStartup() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = reg.getConfigurationElementsFor("it.sogei.rcp.resourcescreator");
        this.fsu = new FileSystemUtil();
        this.createResource(extensions, null, null);
    }

    private void createResource(IConfigurationElement[] extensions, IProject project, String parentFolder) {
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement element = extensions[i];
            String contributor = element.getContributor().getName();
            try {
                String nome;
                String elementName = element.getName();
                if (elementName.equals(DATASTRUCT_ATTR_KEY)) {
                    nome = element.getAttribute(PROJECTNAME_ATTR_KEY);
                    String natureId = element.getAttribute(NATUREID_ATTR_KEY);
                    IProject newProject = NewProjectHelper.createApplicationProject(nome);
                    IConfigurationElement[] children = element.getChildren();
                    if (children.length > 0) {
                        this.createResource(children, newProject, null);
                    }
                    NewProjectHelper.addNatureToProject(newProject, natureId);
                } else if (elementName.equals(FOLDER_ATTR_KEY)) {
                    nome = element.getAttribute(NAME_ATTR_KEY);
                    if (parentFolder != null) {
                        nome = String.valueOf(parentFolder) + File.separator + nome;
                    }
                    NewProjectHelper.addFolderToProject(project, nome);
                    LogUtil.log((Object)this, (int)1, (String)("creata cartella: " + nome));
                    IConfigurationElement[] children = element.getChildren();
                    if (children.length > 0) {
                        this.createResource(children, project, nome);
                    }
                } else if (elementName.equals(FILE_ATTR_KEY)) {
                    nome = element.getAttribute(NAME_ATTR_KEY);
                    boolean overwrite = new Boolean(element.getAttribute(OVERWRITE_ATTR_KEY));
                    String risorsa = element.getAttribute(RESOURCE_ATTR_KEY);
                    String nomefile = nome != null ? nome : risorsa.substring(risorsa.lastIndexOf("/") + 1);
                    if (parentFolder != null) {
                        nomefile = String.valueOf(parentFolder) + File.separator + nomefile;
                    }
                    URL url = Platform.getBundle((String)contributor).getResource(risorsa);
                    InputStream inputStream = url.openStream();
                    RelativePath relativePath = new RelativePath(String.valueOf(project.getName()) + File.separator + nomefile);
                    this.fsu.createFile(inputStream, (IRelativePath)relativePath, overwrite);
                    LogUtil.log((Object)this, (int)1, (String)("creato file: " + nomefile));
                }
            }
            catch (Exception e) {
                String msg = "";
                if (element != null) {
                    msg = element.getName();
                    if (element.getAttribute(NAME_ATTR_KEY) != null) {
                        msg = String.valueOf(msg) + " - " + element.getAttribute(NAME_ATTR_KEY);
                    } else if (element.getAttribute(DATASTRUCT_ATTR_KEY) != null) {
                        msg = String.valueOf(msg) + " - " + element.getAttribute(DATASTRUCT_ATTR_KEY);
                    } else if (element.getAttribute(RESOURCE_ATTR_KEY) != null) {
                        msg = String.valueOf(msg) + " - " + element.getAttribute(RESOURCE_ATTR_KEY).substring(element.getAttribute(RESOURCE_ATTR_KEY).lastIndexOf("/") + 1);
                    }
                }
                LogUtil.log((Object)this, (int)4, (String)("Errore durante la creazione della risorsa: " + msg), (Throwable)e);
            }
            ++i;
        }
    }
}

