/*
 * Decompiled with CFR 0.152.
 */
package iaik.tsp;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import java.math.BigInteger;

public class PKIStatus {
    private int a = 2;
    private static final int c = 5;
    private static final int b = 0;
    public static final String REVOCATION_NOTIFICATION_TEXT = "revocationNotification, notification that a revocation has occurred";
    public static final String REVOCATION_WARNING_TEXT = "revocationWarning, this message contains a warning that a revocation is imminent";
    public static final String WAITING_TEXT = "waiting";
    public static final String REJECTION_TEXT = "rejection";
    public static final String GRANTED_WITH_MODS_TEXT = "granted with mods, when the PKIStatus contains the value one a Time Stamp Token, with modifications, is present";
    public static final String GRANTED_TEXT = "granted, when the PKIStatus contains the value zero a Time Stamp Token, as requested, is present";
    public static final int REVOCATION_NOTIFICATION = 5;
    public static final int REVOCATION_WARNING = 4;
    public static final int WAITING = 3;
    public static final int REJECTION = 2;
    public static final int GRANTED_WITH_MODS = 1;
    public static final int GRANTED = 0;

    private void a(ASN1Object aSN1Object) throws CodingException {
        if (!aSN1Object.isA(ASN.INTEGER)) {
            throw new CodingException("No PKIStatus!");
        }
        int n = ((BigInteger)((INTEGER)aSN1Object).getValue()).intValue();
        try {
            this.testStatusBounds(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CodingException("Wrong status field value: " + String.valueOf(n));
        }
        this.a = n;
    }

    protected void testStatusBounds(int n) throws IllegalArgumentException {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("Status must be between " + String.valueOf(0) + " and " + String.valueOf(5));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<PKIStatus>\n\t" + String.valueOf(this.a) + "\n\t");
        switch (this.a) {
            case 0: {
                stringBuffer.append(GRANTED_TEXT);
                break;
            }
            case 1: {
                stringBuffer.append(GRANTED_WITH_MODS_TEXT);
                break;
            }
            case 2: {
                stringBuffer.append(REJECTION_TEXT);
                break;
            }
            case 3: {
                stringBuffer.append(WAITING_TEXT);
                break;
            }
            case 4: {
                stringBuffer.append(REVOCATION_WARNING_TEXT);
                break;
            }
            case 5: {
                stringBuffer.append(REVOCATION_NOTIFICATION_TEXT);
            }
        }
        stringBuffer.append("\n</PKIStatus>");
        return stringBuffer.toString();
    }

    public int getStatus() {
        return this.a;
    }

    public void setStatus(int n) throws IllegalArgumentException {
        this.testStatusBounds(n);
        this.a = n;
    }

    public ASN1Object toASN1Object() {
        return new INTEGER(this.a);
    }

    public byte[] getEncoded() {
        return DerCoder.encode((ASN1Object)this.toASN1Object());
    }

    public PKIStatus(ASN1Object aSN1Object) throws CodingException {
        this.a(aSN1Object);
    }

    public PKIStatus(int n) throws IllegalArgumentException {
        this.testStatusBounds(n);
        this.a = n;
    }
}

