/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.cipher;

import iaik.xml.crypto.alg.cipher.ProxyCipher;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public abstract class RSAProxyCipher
extends ProxyCipher {
    ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        this.buffer.write(byArray, n, n2);
        return 0;
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        this.buffer.write(byArray, n, n2);
        return null;
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof RSAPublicKey) {
            return ((RSAPublicKey)key).getModulus().bitLength();
        }
        if (key instanceof RSAPrivateKey) {
            return ((RSAPrivateKey)key).getModulus().bitLength();
        }
        throw new InvalidKeyException("Not a RSA key!");
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException {
        if (this.buffer.size() > 0) {
            this.buffer.write(byArray, n, n2);
            int n4 = super.engineDoFinal(this.buffer.toByteArray(), 0, this.buffer.size(), byArray2, n3);
            this.buffer.reset();
            return n4;
        }
        return super.engineDoFinal(byArray, n, n2, byArray2, n3);
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws BadPaddingException, IllegalBlockSizeException {
        if (this.buffer.size() > 0) {
            if (n2 != 0) {
                this.buffer.write(byArray, n, n2);
            }
            byte[] byArray2 = super.engineDoFinal(this.buffer.toByteArray(), 0, this.buffer.size());
            this.buffer.reset();
            return byArray2;
        }
        return super.engineDoFinal(byArray, n, n2);
    }
}

