/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.resources;

import finanze.IDTE.generale2014.Util;
import finanze.IDTE.resources.ControlliCampo;
import finanze.IDTE.resources.ResourceLoader;

public class Controlli
extends ResourceLoader {
    private static final long serialVersionUID = -6992336800311307998L;
    public static final char DELIMITER = '*';
    public static final int FORMATO_AN = 1;
    public static final int FORMATO_CF = 2;
    public static final int FORMATO_PI = 3;
    public static final int FORMATO_PR = 4;
    public static final int FORMATO_DA = 5;
    public static final int FORMATO_PC = 6;
    public static final int FORMATO_QU = 7;
    public static final int FORMATO_FA = 8;
    public static final int FORMATO_FN = 9;
    public static final int FORMATO_NP = 10;
    public static final int FORMATO_DN = 11;
    public static final int FORMATO_CN = 12;
    public static final int FORMATO_VP = 13;
    public static final int FORMATO_VN = 14;
    public static final int FORMATO_PN = 15;
    public static final int FORMATO_NU = 100;
    public static final int FORMATO_NN = 199;
    public static final int FORMATO_DT = 200;
    public static final int FORMATO_D4 = 204;
    public static final int FORMATO_D6 = 206;
    public static final int FORMATO_CB = 300;
    public static final boolean BOOLEAN_NOT_FOUND = false;
    public static final int INT_NOT_FOUND = -1;
    public static final int QUADRO_POS = 0;
    public static final int RIGA_POS = 2;
    public static final int COLONNA_POS = 5;
    public static final String STRING_NOT_FOUND = new String();
    public static final String GENERIC_ROW = "XXX";

    public Controlli(Object resourceData) {
        super(resourceData);
    }

    protected Object createValue(String value) {
        boolean monomudulo;
        int formato;
        int i;
        String[] valTkns = new String[4];
        int currIndex = 0;
        int j = 0;
        for (i = 0; i < 4 && j >= 0; ++i) {
            j = value.indexOf(42, currIndex);
            valTkns[i] = j == -1 ? value.substring(currIndex) : value.substring(currIndex, j);
            currIndex = j + 1;
        }
        if (i < 3) {
            throw new RuntimeException("Impossibile costruire l'oggetto\tControlliCampo: parametri insufficienti");
        }
        int n = formato = Util.isNumericoAssoluto(valTkns[0]) ? Integer.parseInt(valTkns[0]) : -1;
        int rcVincoli = Util.isNumericoAssoluto(valTkns[2]) ? Integer.parseInt(valTkns[2]) : (valTkns[2].length() > 0 ? -1 : 0);
        boolean bl = monomudulo = valTkns[3] == null ? false : valTkns[3].trim().equals("Y");
        if (formato < 0 || rcVincoli < 0) {
            throw new RuntimeException("Impossibile costruire l'oggetto ControlliCampo: parametri non numerici");
        }
        return new ControlliCampo(formato, valTkns[1], rcVincoli, monomudulo);
    }

    public ControlliCampo getCampo(String codCampo) {
        if (this.getValue(codCampo) != null) {
            return (ControlliCampo)this.getValue(codCampo);
        }
        String key2 = codCampo.substring(0, 2) + GENERIC_ROW + codCampo.substring(5, codCampo.length());
        return (ControlliCampo)this.getValue(key2);
    }

    public int getFormato(String key) {
        Object retObj = this.getValue(key);
        if (retObj != null) {
            return ((ControlliCampo)retObj).formato;
        }
        String riga = key.substring(2, 5);
        if (riga.trim().length() != 0 && !riga.equals(GENERIC_ROW) && !Util.isNumericoAssoluto(riga)) {
            return -1;
        }
        String key2 = key.substring(0, 2) + GENERIC_ROW + key.substring(5, key.length());
        retObj = this.getValue(key2);
        if (retObj != null) {
            return ((ControlliCampo)retObj).formato;
        }
        return -1;
    }

    public int getFormatoAt(int dataIndex) {
        return this.getValueAt(dataIndex) != null ? ((ControlliCampo)this.getValueAt((int)dataIndex)).formato : -1;
    }

    public boolean getMonomodulo(String key) {
        Object retObj = this.getValue(key);
        if (retObj != null) {
            return ((ControlliCampo)retObj).monomodulo;
        }
        String key2 = key.substring(0, 2) + GENERIC_ROW + key.substring(5, key.length());
        retObj = this.getValue(key2);
        if (retObj != null) {
            return ((ControlliCampo)retObj).monomodulo;
        }
        return false;
    }

    public boolean getMonomoduloAt(int dataIndex) {
        return this.getValueAt(dataIndex) != null ? ((ControlliCampo)this.getValueAt((int)dataIndex)).monomodulo : false;
    }

    public int getRcVincoli(String key) {
        Object retObj = this.getValue(key);
        if (retObj != null) {
            return ((ControlliCampo)retObj).rcVincoli;
        }
        String key2 = key.substring(0, 2) + GENERIC_ROW + key.substring(5, key.length());
        retObj = this.getValue(key2);
        if (retObj != null) {
            return ((ControlliCampo)retObj).rcVincoli;
        }
        return -1;
    }

    public int getRcVincoliAt(int dataIndex) {
        return this.getValueAt(dataIndex) != null ? ((ControlliCampo)this.getValueAt((int)dataIndex)).rcVincoli : -1;
    }

    public String getVincoli(String key) {
        Object retObj = this.getValue(key);
        if (retObj != null) {
            return ((ControlliCampo)retObj).vincoli;
        }
        String key2 = key.substring(0, 2) + GENERIC_ROW + key.substring(5, key.length());
        retObj = this.getValue(key2);
        if (retObj != null) {
            return ((ControlliCampo)retObj).vincoli;
        }
        return STRING_NOT_FOUND;
    }

    public String getVincoliAt(int dataIndex) {
        return this.getValueAt(dataIndex) != null ? ((ControlliCampo)this.getValueAt((int)dataIndex)).vincoli : STRING_NOT_FOUND;
    }
}

