/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.utility;

import finanze.IDTE.resources.ResourceLoader;
import java.io.IOException;
import java.util.Hashtable;

public class UtilizzaRisorsa {
    private RisorsaDescrizioni risorsa = new RisorsaDescrizioni();

    public UtilizzaRisorsa(String nomeRisorsa) {
        try {
            this.risorsa.load(nomeRisorsa + ".res");
        }
        catch (IOException e) {
            System.out.println("Non sono riuscito a caricare la risorsa:" + nomeRisorsa + "con la classe UtilizzaRisorsa");
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            System.out.println("RuntimeException con la classe UtilizzaRisorsa");
            e.printStackTrace();
        }
    }

    public String getDescrizione(String codice) {
        return this.risorsa.getDescrizione(codice);
    }

    public int getIndice(String codice) {
        return this.risorsa.getIndice(codice);
    }

    public boolean esisteCodice(String codice) {
        return this.risorsa.getDescrizione(codice).trim().length() != 0;
    }

    private class RisorsaDescrizioni
    extends ResourceLoader {
        private static final long serialVersionUID = 6711624707191644035L;

        public RisorsaDescrizioni() {
            super(new Hashtable());
        }

        protected Object createValue(String value) {
            return value;
        }

        public String getDescrizione(String codErrore) {
            String retDescrizione = (String)this.getValue(codErrore);
            return retDescrizione == null ? "" : retDescrizione;
        }

        public int getIndice(String codErrore) {
            String retDescrizione = (String)this.getValue(codErrore);
            return retDescrizione == null ? 0 : Integer.parseInt(retDescrizione);
        }
    }
}

